/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.daemon;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.opennms.core.utils.ThreadCategory;

public class DaemonUtils {
    private DaemonUtils() {
    }

    public static String getLocalHostAddress() {
        try {
            return InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e) {
            ThreadCategory.getInstance(DaemonUtils.class).warn((Object)("getLocalHostAddress: Could not lookup the host address for the local host machine, address set to 127.0.0.1: " + e), (Throwable)e);
            return "127.0.0.1";
        }
    }

    public static String getLocalHostName() {
        String localhost;
        try {
            localhost = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            ThreadCategory.getInstance(DaemonUtils.class).warn((Object)("getLocalHostName: Could not lookup the host name for the local host machine, name set to 'localhost': " + e), (Throwable)e);
            localhost = "localhost";
        }
        return localhost;
    }
}

