/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Category;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.ConfigFileConstants;
import org.opennms.netmgt.config.threshd.Basethresholddef;
import org.opennms.netmgt.config.threshd.Group;
import org.opennms.netmgt.config.threshd.ThresholdingConfig;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ThresholdingConfigFactory {
    private static ThresholdingConfigFactory m_singleton = null;
    private ThresholdingConfig m_config;
    private static boolean m_loaded = false;
    private Map<String, Group> m_groupMap;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ThresholdingConfigFactory(String configFile) throws IOException, MarshalException, ValidationException {
        FileReader cfgIn = new FileReader(configFile);
        try {
            this.parseXML(cfgIn);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            try {
                cfgIn.close();
            }
            catch (IOException e) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            cfgIn.close();
        }
        catch (IOException e) {}
    }

    public ThresholdingConfigFactory(Reader reader) throws MarshalException, ValidationException {
        this.parseXML(reader);
    }

    private void parseXML(Reader cfgIn) throws MarshalException, ValidationException {
        this.m_config = (ThresholdingConfig)Unmarshaller.unmarshal(ThresholdingConfig.class, (Reader)cfgIn);
        this.initGroupMap();
    }

    private void initGroupMap() {
        HashMap<String, Group> groupMap = new HashMap<String, Group>();
        for (Group group : this.m_config.getGroupCollection()) {
            groupMap.put(group.getName(), group);
        }
        this.m_groupMap = groupMap;
    }

    public static synchronized void init() throws IOException, MarshalException, ValidationException {
        if (m_loaded) {
            return;
        }
        File cfgFile = ConfigFileConstants.getFile((int)ConfigFileConstants.THRESHOLDING_CONF_FILE_NAME);
        if (ThresholdingConfigFactory.log().isDebugEnabled()) {
            ThresholdingConfigFactory.log().debug((Object)("init: config file path: " + cfgFile.getPath()));
        }
        m_singleton = new ThresholdingConfigFactory(cfgFile.getPath());
        m_loaded = true;
    }

    public static synchronized void reload() throws IOException, MarshalException, ValidationException {
        m_singleton = null;
        m_loaded = false;
        ThresholdingConfigFactory.init();
    }

    public static synchronized ThresholdingConfigFactory getInstance() {
        if (!m_loaded) {
            throw new IllegalStateException("The factory has not been initialized");
        }
        return m_singleton;
    }

    public static synchronized void setInstance(ThresholdingConfigFactory instance) {
        m_loaded = true;
        m_singleton = instance;
    }

    public String getRrdRepository(String groupName) {
        return this.getGroup(groupName).getRrdRepository();
    }

    public Group getGroup(String groupName) {
        Group group = this.m_groupMap.get(groupName);
        if (group == null) {
            throw new IllegalArgumentException("Thresholding group " + groupName + " does not exist.");
        }
        return group;
    }

    public Collection<Basethresholddef> getThresholds(String groupName) {
        Group group = this.getGroup(groupName);
        ArrayList<Basethresholddef> result = new ArrayList<Basethresholddef>();
        result.addAll(group.getThresholdCollection());
        result.addAll(group.getExpressionCollection());
        return result;
    }

    public Collection<String> getGroupNames() {
        return this.m_groupMap.keySet();
    }

    public synchronized void saveCurrent() throws MarshalException, IOException, ValidationException {
        StringWriter stringWriter = new StringWriter();
        Marshaller.marshal((Object)this.m_config, (Writer)stringWriter);
        String xmlString = stringWriter.toString();
        if (xmlString != null) {
            File cfgFile = ConfigFileConstants.getFile((int)ConfigFileConstants.THRESHOLDING_CONF_FILE_NAME);
            FileWriter fileWriter = new FileWriter(cfgFile);
            fileWriter.write(xmlString);
            fileWriter.flush();
            fileWriter.close();
        }
        this.update();
    }

    public void update() throws IOException, MarshalException, ValidationException {
        File cfgFile = ConfigFileConstants.getFile((int)ConfigFileConstants.THRESHOLDING_CONF_FILE_NAME);
        FileReader r = new FileReader(cfgFile);
        this.parseXML(r);
        ((Reader)r).close();
    }

    private static Category log() {
        return ThreadCategory.getInstance(ThresholdingConfigFactory.class);
    }
}

