/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.log4j.Category;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.EventConstants;
import org.opennms.netmgt.config.NotifdConfigManager;
import org.opennms.netmgt.config.common.Header;
import org.opennms.netmgt.config.notifications.Notification;
import org.opennms.netmgt.config.notifications.Notifications;
import org.opennms.netmgt.config.notifications.Parameter;
import org.opennms.netmgt.eventd.EventUtil;
import org.opennms.netmgt.filter.FilterDaoFactory;
import org.opennms.netmgt.filter.FilterParseException;
import org.opennms.netmgt.utils.Querier;
import org.opennms.netmgt.utils.RowProcessor;
import org.opennms.netmgt.utils.SingleResultQuerier;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.netmgt.xml.event.Tticket;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class NotificationManager {
    public Notifications m_notifications;
    private Header oldHeader;
    public static final String PARAM_TYPE = "-t";
    public static final String PARAM_DESTINATION = "-d";
    public static final String PARAM_TEXT_MSG = "-tm";
    public static final String PARAM_NUM_MSG = "-nm";
    public static final String PARAM_RESPONSE = "-r";
    public static final String PARAM_NODE = "-nodeid";
    public static final String PARAM_INTERFACE = "-interface";
    public static final String PARAM_SERVICE = "-service";
    public static final String PARAM_SUBJECT = "-subject";
    public static final String PARAM_EMAIL = "-email";
    public static final String PARAM_PAGER_EMAIL = "-pemail";
    public static final String PARAM_XMPP_ADDRESS = "-xmpp";
    public static final String PARAM_TEXT_PAGER_PIN = "-tp";
    public static final String PARAM_NUM_PAGER_PIN = "-np";
    NotifdConfigManager m_configManager;
    private DataSource m_dataSource;

    protected NotificationManager(NotifdConfigManager configManager, DataSource dcf) {
        this.m_configManager = configManager;
        this.m_dataSource = dcf;
    }

    public synchronized void parseXML(Reader reader) throws MarshalException, ValidationException {
        this.m_notifications = (Notifications)Unmarshaller.unmarshal(Notifications.class, (Reader)reader);
        this.oldHeader = this.m_notifications.getHeader();
    }

    public boolean hasUei(String uei) throws IOException, MarshalException, ValidationException {
        this.update();
        for (Notification notif : this.m_notifications.getNotificationCollection()) {
            if (uei.equals(notif.getUei()) || "MATCH-ANY-UEI".equals(notif.getUei())) {
                return true;
            }
            if (notif.getUei().charAt(0) != '~' || !uei.matches(notif.getUei().substring(1))) continue;
            return true;
        }
        return false;
    }

    public Notification[] getNotifForEvent(Event event) throws IOException, MarshalException, ValidationException {
        this.update();
        ArrayList<Notification> notifList = new ArrayList<Notification>();
        Notification[] notif = null;
        boolean matchAll = this.getConfigManager().getNotificationMatch();
        Category log = ThreadCategory.getInstance(this.getClass());
        if (event == null) {
            log.warn((Object)"unable to get notification for null event!");
        }
        if (event.getLogmsg() != null && !event.getLogmsg().getNotify()) {
            log.debug((Object)("Event " + event.getUei() + " is configured to supress notifications."));
            return notif;
        }
        for (Notification curNotif : this.m_notifications.getNotificationCollection()) {
            boolean curHasUei = false;
            boolean curHasSeverity = false;
            log.debug((Object)("Checking " + event.getUei() + " against " + curNotif.getUei()));
            if (event.getUei().equals(curNotif.getUei()) || "MATCH-ANY-UEI".equals(curNotif.getUei())) {
                curHasUei = true;
            } else if (curNotif.getUei().charAt(0) == '~' && event.getUei().matches(curNotif.getUei().substring(1))) {
                curHasUei = true;
            }
            log.debug((Object)("Checking event severity: " + event.getSeverity() + " against notification severity: " + curNotif.getEventSeverity()));
            if (curNotif.getEventSeverity() == null) {
                curHasSeverity = true;
            } else if (event.getSeverity().toLowerCase().matches(curNotif.getEventSeverity().toLowerCase())) {
                curHasSeverity = true;
            }
            if (!curNotif.getStatus().equals("on") || !curHasSeverity || !curHasUei || !this.nodeInterfaceServiceValid(curNotif, event)) continue;
            boolean parmsmatched = this.getConfigManager().matchNotificationParameters(event, curNotif);
            if (!parmsmatched) {
                this.log().debug((Object)("Event " + event.getUei() + " did not match parameters for notice " + curNotif.getName()));
                continue;
            }
            notifList.add(curNotif);
            this.log().debug((Object)("Event " + event.getUei() + " matched notice " + curNotif.getName()));
            if (matchAll) continue;
            break;
        }
        if (!notifList.isEmpty()) {
            notif = notifList.toArray(new Notification[0]);
        }
        return notif;
    }

    private Category log() {
        return ThreadCategory.getInstance(this.getClass());
    }

    protected NotifdConfigManager getConfigManager() {
        return this.m_configManager;
    }

    protected boolean nodeInterfaceServiceValid(Notification notif, Event event) {
        Assert.notNull((Object)notif, (String)"notif argument must not be null");
        Assert.notNull((Object)event, (String)"event argument must not be null");
        Assert.notNull((Object)notif.getRule(), (String)"getRule() on notif argument must not return null");
        if (event.getNodeid() == 0L && event.getInterface() == null && event.getService() == null) {
            if ("MATCH-ANY-UEI".equals(notif.getUei())) {
                return "ipaddr != '0.0.0.0'".equals(notif.getRule().toLowerCase()) || "ipaddr iplike *.*.*.*".equals(notif.getRule().toLowerCase());
            }
            return true;
        }
        StringBuffer constraints = new StringBuffer();
        if (event.getNodeid() != 0L) {
            constraints.append(" & (nodeId == " + event.getNodeid() + ")");
        }
        if (event.getInterface() != null && !"0.0.0.0".equals(event.getInterface())) {
            constraints.append(" & (ipAddr == '" + event.getInterface() + "')");
            if (event.getService() != null) {
                constraints.append(" & (serviceName == '" + event.getService() + "')");
            }
        }
        String rule = "((" + notif.getRule() + ")" + constraints + ")";
        return this.isRuleMatchingFilter(notif, rule);
    }

    private boolean isRuleMatchingFilter(Notification notif, String rule) {
        try {
            return FilterDaoFactory.getInstance().isRuleMatching(rule);
        }
        catch (FilterParseException e) {
            this.log().error((Object)("Invalid filter rule for notification " + notif.getName() + ": " + notif.getRule()), (Throwable)e);
            return true;
        }
        catch (Throwable t) {
            this.log().error((Object)("Filter query threw exception: " + notif.getName() + ": " + notif.getRule()), t);
            return true;
        }
    }

    private Connection getConnection() throws SQLException {
        return this.m_dataSource.getConnection();
    }

    public int getNoticeId() throws SQLException, IOException, MarshalException, ValidationException {
        return this.getNxtId(this.m_configManager.getNextNotifIdSql());
    }

    public int getUserNotifId() throws SQLException, IOException, MarshalException, ValidationException {
        return this.getNxtId(this.m_configManager.getNextUserNotifIdSql());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int getNxtId(String sql) throws SQLException {
        int id = 0;
        Connection connection = null;
        try {
            connection = this.getConnection();
            Statement stmt = connection.createStatement();
            ResultSet results = stmt.executeQuery(sql);
            results.next();
            id = results.getInt(1);
            stmt.close();
            results.close();
            Object var7_6 = null;
            if (connection == null) return id;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (connection == null) throw throwable;
            try {
                connection.close();
                throw throwable;
            }
            catch (SQLException e) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            connection.close();
            return id;
        }
        catch (SQLException e) {}
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean noticeOutstanding(int noticeId) throws IOException, MarshalException, ValidationException {
        boolean outstanding = false;
        Connection connection = null;
        connection = this.getConnection();
        PreparedStatement statement = connection.prepareStatement(this.getConfigManager().getConfiguration().getOutstandingNoticesSql());
        statement.setInt(1, noticeId);
        ResultSet results = statement.executeQuery();
        int count = 0;
        while (results.next()) {
            ++count;
        }
        if (count == 0) {
            outstanding = true;
        }
        statement.close();
        results.close();
        Object var8_8 = null;
        if (connection == null) return outstanding;
        try {
            connection.close();
            return outstanding;
        }
        catch (SQLException e2) {}
        return outstanding;
        {
            catch (SQLException e) {
                this.log().error((Object)("Error getting notice status: " + e.getMessage()), (Throwable)e);
                Object var8_9 = null;
                if (connection == null) return outstanding;
                try {
                    connection.close();
                    return outstanding;
                }
                catch (SQLException e2) {}
                return outstanding;
            }
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            if (connection == null) throw throwable;
            try {
                connection.close();
                throw throwable;
            }
            catch (SQLException e2) {
                // empty catch block
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Collection<Integer> acknowledgeNotice(Event event, String uei, String[] matchList) throws SQLException, IOException, MarshalException, ValidationException {
        Connection connection = null;
        LinkedList<Integer> notifIDs = new LinkedList<Integer>();
        try {
            connection = this.getConnection();
            int eventID = 0;
            boolean wasAcked = false;
            StringBuffer sql = new StringBuffer("SELECT eventid FROM notifications WHERE eventuei=? ");
            for (int i = 0; i < matchList.length; ++i) {
                sql.append("AND ").append(matchList[i]).append("=? ");
            }
            sql.append("ORDER BY eventid desc limit 1");
            PreparedStatement statement = connection.prepareStatement(sql.toString());
            statement.setString(1, uei);
            for (int i = 0; i < matchList.length; ++i) {
                if (matchList[i].equals("nodeid")) {
                    statement.setLong(i + 2, event.getNodeid());
                }
                if (matchList[i].equals("interfaceid")) {
                    statement.setString(i + 2, event.getInterface());
                }
                if (!matchList[i].equals("serviceid")) continue;
                statement.setInt(i + 2, this.getServiceId(event.getService()));
            }
            ResultSet results = statement.executeQuery();
            if (results != null && results.next()) {
                eventID = results.getInt(1);
                this.log().debug((Object)("EventID for notice(s) to be acked: " + eventID));
                sql = new StringBuffer("SELECT notifyid, answeredby, respondtime FROM notifications WHERE eventID=?");
                statement = connection.prepareStatement(sql.toString());
                statement.setInt(1, eventID);
                results = statement.executeQuery();
                if (results != null) {
                    while (results.next()) {
                        int notifID = results.getInt(1);
                        String ansBy = results.getString(2);
                        Timestamp ts = results.getTimestamp(3);
                        if (ansBy == null) {
                            ansBy = "auto-acknowledged";
                            ts = new Timestamp(new Date().getTime());
                        } else {
                            if (ansBy.indexOf("auto-acknowledged") > -1) {
                                this.log().debug((Object)"Notice has previously been auto-acknowledged. Skipping...");
                                continue;
                            }
                            wasAcked = true;
                            ansBy = ansBy + "/auto-acknowledged";
                        }
                        this.log().debug((Object)("Matching DOWN notifyID = " + notifID + ", was acked by user = " + wasAcked + ", ansBy = " + ansBy));
                        PreparedStatement update = connection.prepareStatement(this.getConfigManager().getConfiguration().getAcknowledgeUpdateSql());
                        update.setString(1, ansBy);
                        update.setTimestamp(2, ts);
                        update.setInt(3, notifID);
                        update.executeUpdate();
                        update.close();
                        if (wasAcked) {
                            notifIDs.add(new Integer(-1 * notifID));
                            continue;
                        }
                        notifIDs.add(new Integer(notifID));
                    }
                }
            } else {
                this.log().debug((Object)"No matching DOWN eventID found");
            }
            statement.close();
            results.close();
            Object var16_17 = null;
            if (connection == null) return notifIDs;
        }
        catch (Throwable throwable) {
            Object var16_18 = null;
            if (connection == null) throw throwable;
            try {
                connection.close();
                throw throwable;
            }
            catch (SQLException e) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            connection.close();
            return notifIDs;
        }
        catch (SQLException e) {}
        return notifIDs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Integer> getActiveNodes() throws SQLException {
        ArrayList<Integer> arrayList;
        block7: {
            String NODE_QUERY = "SELECT   n.nodeid FROM     node n WHERE    n.nodetype != 'D' ORDER BY n.nodelabel";
            Connection connection = null;
            ArrayList<Integer> allNodes = new ArrayList<Integer>();
            try {
                connection = this.getConnection();
                Statement stmt = connection.createStatement();
                ResultSet rset = stmt.executeQuery(NODE_QUERY);
                if (rset != null) {
                    while (rset.next()) {
                        int nodeID = rset.getInt(1);
                        allNodes.add(new Integer(nodeID));
                    }
                }
                arrayList = allNodes;
                Object var8_8 = null;
                if (connection == null) break block7;
            }
            catch (Throwable throwable) {
                block8: {
                    Object var8_9 = null;
                    if (connection == null) break block8;
                    try {
                        connection.close();
                    }
                    catch (SQLException e) {}
                }
                throw throwable;
            }
            try {
                connection.close();
            }
            catch (SQLException e) {
                // empty catch block
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getServiceNoticeStatus(String nodeID, String ipaddr, String service) throws SQLException {
        String string;
        block6: {
            String notify = "Y";
            String query = "SELECT notify FROM ifservices, service WHERE nodeid=? AND ipaddr=? AND ifservices.serviceid=service.serviceid AND service.servicename=?";
            Connection connection = null;
            try {
                connection = this.getConnection();
                PreparedStatement statement = connection.prepareStatement(query);
                statement.setInt(1, Integer.parseInt(nodeID));
                statement.setString(2, ipaddr);
                statement.setString(3, service);
                ResultSet rs = statement.executeQuery();
                if (rs.next() && rs.getString("notify") != null && (notify = rs.getString("notify")) == null) {
                    notify = "Y";
                }
                string = notify;
                Object var11_10 = null;
                if (connection == null) break block6;
            }
            catch (Throwable throwable) {
                block7: {
                    Object var11_11 = null;
                    if (connection == null) break block7;
                    try {
                        connection.close();
                    }
                    catch (SQLException e) {}
                }
                throw throwable;
            }
            try {
                connection.close();
            }
            catch (SQLException e) {
                // empty catch block
            }
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void updateNoticeWithUserInfo(String userId, int noticeId, String media, String contactInfo, String autoNotify) throws SQLException, MarshalException, ValidationException, IOException {
        Category log = this.log();
        if (noticeId < 0) {
            return;
        }
        int userNotifId = this.getUserNotifId();
        if (log.isDebugEnabled()) {
            log.debug((Object)("updating usersnotified: ID = " + userNotifId + " User = " + userId + ", notice ID = " + noticeId + ", conctactinfo = " + contactInfo + ", media = " + media + ", autoNotify = " + autoNotify));
        }
        Connection connection = null;
        try {
            connection = this.getConnection();
            PreparedStatement insert = connection.prepareStatement("INSERT INTO usersNotified (id, userid, notifyid, notifytime, media, contactinfo, autonotify) values (?,?,?,?,?,?,?)");
            insert.setInt(1, userNotifId);
            insert.setString(2, userId);
            insert.setInt(3, noticeId);
            insert.setTimestamp(4, new Timestamp(new Date().getTime()));
            insert.setString(5, media);
            insert.setString(6, contactInfo);
            insert.setString(7, autoNotify);
            insert.executeUpdate();
            insert.close();
            Object var11_10 = null;
            if (connection == null) return;
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            if (connection == null) throw throwable;
            try {
                connection.close();
                throw throwable;
            }
            catch (SQLException e) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            connection.close();
            return;
        }
        catch (SQLException e) {}
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void insertNotice(int notifyId, Map<String, String> params, String queueID, Notification notification) throws SQLException {
        Connection connection = null;
        try {
            connection = this.getConnection();
            PreparedStatement statement = connection.prepareStatement("INSERT INTO notifications (textmsg, numericmsg, notifyid, pagetime, nodeid, interfaceid, serviceid, eventid, eventuei, subject, queueID, notifConfigName) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
            String textMsg = params.get(PARAM_TEXT_MSG);
            if (textMsg != null && textMsg.length() > 4000) {
                this.log().warn((Object)"textmsg too long, it will be truncated");
                textMsg = textMsg.substring(0, 4000);
            }
            statement.setString(1, textMsg);
            String numMsg = params.get(PARAM_NUM_MSG);
            if (numMsg != null && numMsg.length() > 256) {
                this.log().warn((Object)"numericmsg too long, it will be truncated");
                numMsg = numMsg.substring(0, 256);
            }
            statement.setString(2, numMsg);
            statement.setInt(3, notifyId);
            statement.setTimestamp(4, new Timestamp(new Date().getTime()));
            String node = params.get(PARAM_NODE);
            if (!(node == null || node.trim().equals("") || node.toLowerCase().equals("null") || node.toLowerCase().equals("%nodeid%"))) {
                statement.setInt(5, Integer.parseInt(node));
            } else {
                statement.setNull(5, 4);
            }
            String ipaddr = params.get(PARAM_INTERFACE);
            if (!(ipaddr == null || ipaddr.trim().equals("") || ipaddr.toLowerCase().equals("null") || ipaddr.toLowerCase().equals("%interface%"))) {
                statement.setString(6, ipaddr);
            } else {
                statement.setString(6, null);
            }
            String service = params.get(PARAM_SERVICE);
            if (!(service == null || service.trim().equals("") || service.toLowerCase().equals("null") || service.toLowerCase().equals("%service%"))) {
                statement.setInt(7, this.getServiceId(service));
            } else {
                statement.setNull(7, 4);
            }
            String eventID = params.get("eventID");
            statement.setInt(8, Integer.parseInt(eventID));
            statement.setString(9, params.get("eventUEI"));
            statement.setString(10, params.get(PARAM_SUBJECT));
            statement.setString(11, queueID);
            statement.setString(12, notification.getName());
            statement.executeUpdate();
            statement.close();
            Object var14_13 = null;
            if (connection == null) return;
        }
        catch (Throwable throwable) {
            Object var14_14 = null;
            if (connection == null) throw throwable;
            try {
                connection.close();
                throw throwable;
            }
            catch (SQLException e) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            connection.close();
            return;
        }
        catch (SQLException e) {}
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getServiceId(String service) throws SQLException {
        int n;
        block5: {
            int serviceID = 0;
            Connection connection = null;
            try {
                connection = this.getConnection();
                PreparedStatement statement = connection.prepareStatement("SELECT serviceID from service where serviceName = ?");
                statement.setString(1, service);
                ResultSet results = statement.executeQuery();
                results.next();
                serviceID = results.getInt(1);
                results.close();
                statement.close();
                n = serviceID;
                Object var8_7 = null;
                if (connection == null) break block5;
            }
            catch (Throwable throwable) {
                block6: {
                    Object var8_8 = null;
                    if (connection == null) break block6;
                    try {
                        connection.close();
                    }
                    catch (SQLException e) {}
                }
                throw throwable;
            }
            try {
                connection.close();
            }
            catch (SQLException e) {
                // empty catch block
            }
        }
        return n;
    }

    public Map<String, Notification> getNotifications() throws IOException, MarshalException, ValidationException {
        this.update();
        HashMap<String, Notification> newMap = new HashMap<String, Notification>();
        Notification[] notices = this.m_notifications.getNotification();
        for (int i = 0; i < notices.length; ++i) {
            newMap.put(notices[i].getName(), notices[i]);
        }
        return newMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public List<String> getServiceNames() throws SQLException {
        Connection connection = null;
        ArrayList<String> services = new ArrayList<String>();
        try {
            connection = this.getConnection();
            Statement stmt = connection.createStatement();
            ResultSet rset = stmt.executeQuery("SELECT servicename FROM service");
            if (rset != null) {
                while (rset.next()) {
                    services.add(rset.getString(1));
                }
            }
            Object var6_5 = null;
            if (connection == null) return services;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (connection == null) throw throwable;
            try {
                connection.close();
                throw throwable;
            }
            catch (SQLException e) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            connection.close();
            return services;
        }
        catch (SQLException e) {}
        return services;
    }

    public Notification getNotification(String name) throws IOException, MarshalException, ValidationException {
        this.update();
        return this.getNotifications().get(name);
    }

    public List<String> getNotificationNames() throws IOException, MarshalException, ValidationException {
        this.update();
        ArrayList<String> notificationNames = new ArrayList<String>();
        for (Notification curNotif : this.m_notifications.getNotificationCollection()) {
            notificationNames.add(curNotif.getName());
        }
        return notificationNames;
    }

    public synchronized void removeNotification(String name) throws MarshalException, ValidationException, IOException, ClassNotFoundException {
        this.m_notifications.removeNotification(this.getNotification(name));
        this.saveCurrent();
    }

    public synchronized void addNotification(Notification notice) throws MarshalException, ValidationException, IOException, ClassNotFoundException {
        this.m_notifications.removeNotification(this.getNotification(notice.getName()));
        this.m_notifications.addNotification(notice);
        this.saveCurrent();
    }

    public synchronized void replaceNotification(String oldName, Notification newNotice) throws MarshalException, ValidationException, IOException, ClassNotFoundException {
        Notification notice = this.getNotification(oldName);
        if (notice != null) {
            notice.setWriteable(newNotice.getWriteable());
            notice.setDescription(newNotice.getDescription());
            notice.setUei(newNotice.getUei());
            notice.setRule(newNotice.getRule());
            notice.setDestinationPath(newNotice.getDestinationPath());
            notice.setNoticeQueue(newNotice.getNoticeQueue());
            notice.setTextMessage(newNotice.getTextMessage());
            notice.setSubject(newNotice.getSubject());
            notice.setNumericMessage(newNotice.getNumericMessage());
            notice.setStatus(newNotice.getStatus());
            notice.setVarbind(newNotice.getVarbind());
            Parameter[] parameters = newNotice.getParameter();
            for (int i = 0; i < parameters.length; ++i) {
                Parameter newParam = new Parameter();
                newParam.setName(parameters[i].getName());
                newParam.setValue(parameters[i].getValue());
                notice.addParameter(newParam);
            }
            this.saveCurrent();
        } else {
            this.addNotification(newNotice);
        }
    }

    public synchronized void updateStatus(String name, String status) throws MarshalException, ValidationException, IOException, ClassNotFoundException {
        if (!"on".equals(status) && !"off".equals(status)) {
            throw new IllegalArgumentException("Status must be on|off, not " + status);
        }
        Notification notice = this.getNotification(name);
        notice.setStatus(status);
        this.saveCurrent();
    }

    public synchronized void saveCurrent() throws MarshalException, ValidationException, IOException, ClassNotFoundException {
        this.m_notifications.setHeader(this.rebuildHeader());
        StringWriter stringWriter = new StringWriter();
        Marshaller.marshal((Object)this.m_notifications, (Writer)stringWriter);
        String xmlString = stringWriter.toString();
        this.saveXML(xmlString);
        this.update();
    }

    protected abstract void saveXML(String var1) throws IOException;

    private Header rebuildHeader() {
        Header header = this.oldHeader;
        header.setCreated(EventConstants.formatToString((Date)new Date()));
        return header;
    }

    protected abstract void update() throws IOException, MarshalException, ValidationException;

    public Map<String, String> rebuildParameterMap(int notifId, final String resolutionPrefix, final boolean skipNumericPrefix) throws Exception {
        final HashMap<String, String> parmMap = new HashMap<String, String>();
        Querier querier = new Querier(this.m_dataSource, "select notifications.*, service.* from notifications left outer join service on notifications.serviceID = service.serviceID  where notifyId = ?"){

            public void processRow(ResultSet rs) throws SQLException {
                parmMap.put(NotificationManager.PARAM_TEXT_MSG, resolutionPrefix + rs.getString("textMsg"));
                if (skipNumericPrefix) {
                    parmMap.put(NotificationManager.PARAM_NUM_MSG, rs.getString("numericMsg"));
                } else {
                    parmMap.put(NotificationManager.PARAM_NUM_MSG, resolutionPrefix + rs.getString("numericMsg"));
                }
                parmMap.put(NotificationManager.PARAM_SUBJECT, resolutionPrefix + rs.getString("subject"));
                parmMap.put(NotificationManager.PARAM_NODE, rs.getString("nodeID"));
                parmMap.put(NotificationManager.PARAM_INTERFACE, rs.getString("interfaceID"));
                parmMap.put(NotificationManager.PARAM_SERVICE, rs.getString("serviceName"));
                parmMap.put("noticeid", rs.getString("notifyID"));
                parmMap.put("eventID", rs.getString("eventID"));
                parmMap.put("eventUEI", rs.getString("eventUEI"));
                Notification notification = null;
                try {
                    notification = NotificationManager.this.getNotification(rs.getObject("notifConfigName").toString());
                }
                catch (MarshalException e) {
                }
                catch (ValidationException e) {
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (notification != null) {
                    NotificationManager.addNotificationParams(parmMap, notification);
                }
            }
        };
        querier.execute(new Integer(notifId));
        return parmMap;
    }

    public static void addNotificationParams(Map<String, String> paramMap, Notification notification) {
        List parameters = notification.getParameterCollection();
        for (Parameter parameter : parameters) {
            paramMap.put(parameter.getName(), parameter.getValue());
        }
    }

    public void forEachUserNotification(int notifId, RowProcessor rp) {
        Querier querier = new Querier(this.m_dataSource, "select * from usersNotified where notifyId = ? order by notifytime", rp);
        querier.execute(new Integer(notifId));
    }

    public String getQueueForNotification(int notifId) {
        SingleResultQuerier querier = new SingleResultQuerier(this.m_dataSource, "select queueID from notifications where notifyId = ?");
        querier.execute(new Integer(notifId));
        return (String)querier.getResult();
    }

    public static void expandMapValues(Map<String, String> map, Event event) {
        for (String key : map.keySet()) {
            String mapValue = map.get(key);
            if (mapValue == null) continue;
            String expandedValue = EventUtil.expandParms(map.get(key), event);
            map.put(key, expandedValue != null ? expandedValue : map.get(key));
        }
    }

    public Event getEvent(int eventid) {
        final Event event = new Event();
        Querier querier = new Querier(this.m_dataSource, "select * from events where eventid = ?", new RowProcessor(){

            public void processRow(ResultSet rs) throws SQLException {
                event.setDbid(rs.getInt("eventid"));
                event.setUei(rs.getString("eventuei"));
                event.setNodeid((long)rs.getInt("nodeid"));
                event.setTime(rs.getString("eventtime"));
                event.setHost(rs.getString("eventhost"));
                event.setInterface(rs.getString("ipaddr"));
                event.setSnmphost(rs.getString("eventsnmphost"));
                event.setService(this.getServiceName(rs.getInt("serviceid")));
                event.setCreationTime(rs.getString("eventcreatetime"));
                event.setSeverity(rs.getString("eventseverity"));
                event.setPathoutage(rs.getString("eventpathoutage"));
                Tticket tticket = new Tticket();
                tticket.setContent(rs.getString("eventtticket"));
                tticket.setState(rs.getString("eventtticketstate"));
                event.setTticket(tticket);
                event.setSource(rs.getString("eventsource"));
            }

            private String getServiceName(int serviceid) {
                SingleResultQuerier querier = new SingleResultQuerier(NotificationManager.this.m_dataSource, "select servicename from service where serviceid = ?");
                return (String)querier.getResult();
            }
        });
        querier.execute(new Integer(eventid));
        return event;
    }
}

