/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.opennms.netmgt.EventConstants;
import org.opennms.netmgt.config.common.Header;
import org.opennms.netmgt.config.destinationPaths.DestinationPaths;
import org.opennms.netmgt.config.destinationPaths.Path;
import org.opennms.netmgt.config.destinationPaths.Target;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DestinationPathManager {
    private DestinationPaths allPaths;
    private Map<String, Path> m_destinationPaths;
    protected InputStream configIn;
    private Header oldHeader;

    protected void parseXML(Reader reader) throws MarshalException, ValidationException {
        this.allPaths = (DestinationPaths)Unmarshaller.unmarshal(DestinationPaths.class, (Reader)reader);
        this.oldHeader = this.allPaths.getHeader();
        this.m_destinationPaths = new TreeMap<String, Path>();
        for (Path curPath : this.allPaths.getPathCollection()) {
            this.m_destinationPaths.put(curPath.getName(), curPath);
        }
    }

    public Path getPath(String pathName) throws IOException, MarshalException, ValidationException {
        this.update();
        return this.m_destinationPaths.get(pathName);
    }

    public Map<String, Path> getPaths() throws IOException, MarshalException, ValidationException {
        this.update();
        return this.m_destinationPaths;
    }

    public Collection<String> getTargetCommands(Path path, int index, String target) throws IOException, MarshalException, ValidationException {
        this.update();
        Target[] targets = this.getTargetList(index, path);
        for (int i = 0; i < targets.length; ++i) {
            if (!targets[i].getName().equals(target)) continue;
            return targets[i].getCommandCollection();
        }
        return null;
    }

    public Target[] getTargetList(int index, Path path) throws IOException, MarshalException, ValidationException {
        this.update();
        Target[] targets = null;
        targets = index == -1 ? path.getTarget() : path.getEscalate(index).getTarget();
        return targets;
    }

    public boolean pathHasTarget(Path path, String target) throws IOException, MarshalException, ValidationException {
        this.update();
        List targets = path.getTargetCollection();
        for (Target curTarget : targets) {
            if (!curTarget.getName().equals(target)) continue;
            return true;
        }
        return false;
    }

    public synchronized void addPath(Path newPath) throws MarshalException, ValidationException, IOException {
        this.m_destinationPaths.put(newPath.getName(), newPath);
        this.saveCurrent();
    }

    public synchronized void replacePath(String oldName, Path newPath) throws MarshalException, ValidationException, IOException {
        if (this.m_destinationPaths.containsKey(oldName)) {
            this.m_destinationPaths.remove(oldName);
        }
        this.addPath(newPath);
    }

    public synchronized void removePath(Path path) throws MarshalException, ValidationException, IOException {
        this.m_destinationPaths.remove(path.getName());
        this.saveCurrent();
    }

    public synchronized void removePath(String name) throws MarshalException, ValidationException, IOException {
        this.m_destinationPaths.remove(name);
        this.saveCurrent();
    }

    public synchronized void saveCurrent() throws MarshalException, ValidationException, IOException {
        this.allPaths.removeAllPath();
        Iterator<String> i = this.m_destinationPaths.keySet().iterator();
        while (i.hasNext()) {
            this.allPaths.addPath(this.m_destinationPaths.get(i.next()));
        }
        this.allPaths.setHeader(this.rebuildHeader());
        StringWriter stringWriter = new StringWriter();
        Marshaller.marshal((Object)this.allPaths, (Writer)stringWriter);
        String writerString = stringWriter.toString();
        this.saveXML(writerString);
    }

    protected abstract void saveXML(String var1) throws IOException;

    private Header rebuildHeader() {
        Header header = this.oldHeader;
        header.setCreated(EventConstants.formatToString((Date)new Date()));
        return header;
    }

    public abstract void update() throws IOException, MarshalException, ValidationException, FileNotFoundException;
}

