/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.io.IOUtils;
import org.opennms.netmgt.config.EventConfDao;
import org.opennms.netmgt.config.EventConfiguration;
import org.opennms.netmgt.dao.castor.AbstractCastorConfigDao;
import org.opennms.netmgt.dao.castor.CastorUtils;
import org.opennms.netmgt.xml.eventconf.Event;
import org.opennms.netmgt.xml.eventconf.Events;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.orm.ObjectRetrievalFailureException;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultEventConfDao
extends AbstractCastorConfigDao<Events, EventConfiguration>
implements EventConfDao,
InitializingBean {
    private static final String DEFAULT_PROGRAMMATIC_STORE_RELATIVE_URL = "events/programmatic.events.xml";
    private final EventResourceLoader m_resourceLoader = new EventResourceLoader();
    private String m_programmaticStoreRelativeUrl = "events/programmatic.events.xml";
    private Resource m_programmaticStoreConfigResource;

    public DefaultEventConfDao() {
        super(Events.class, "event configuration");
    }

    protected String createLoadedLogMessage(EventConfiguration translatedConfig, long diffTime) {
        return "Loaded " + this.getDescription() + " with " + translatedConfig.getEventCount() + " events from " + translatedConfig.getEventFiles().size() + " files in " + diffTime + "ms";
    }

    @Override
    public void reload() throws DataAccessException {
        this.getContainer().reload();
    }

    public void afterPropertiesSet() throws DataAccessException {
        Assert.state((this.getConfigResource() != null ? 1 : 0) != 0, (String)"property configResource must be set and be non-null");
        super.afterPropertiesSet();
    }

    public EventConfiguration translateConfig(Events events) throws DataAccessException {
        EventConfiguration eventConfiguration = new EventConfiguration();
        this.processEvents(events, this.getConfigResource(), eventConfiguration, "root", false);
        if (events.getGlobal() != null && events.getGlobal().getSecurity() != null) {
            eventConfiguration.getSecureTags().addAll(events.getGlobal().getSecurity().getDoNotOverrideCollection());
        }
        for (String eventFilePath : events.getEventFileCollection()) {
            Resource childResource = this.m_resourceLoader.getResource(eventFilePath);
            this.loadAndProcessEvents(childResource, eventConfiguration, "included", true);
        }
        return eventConfiguration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Events loadAndProcessEvents(Resource rootResource, EventConfiguration eventConfiguration, String resourceDescription, boolean denyIncludes) {
        Events events;
        InputStream in;
        if (this.log().isDebugEnabled()) {
            this.log().debug((Object)("DefaultEventConfDao: Loading " + resourceDescription + " event configuration from " + rootResource));
        }
        try {
            in = rootResource.getInputStream();
        }
        catch (IOException e) {
            throw new DataAccessResourceFailureException("Could not get an input stream for resource '" + rootResource + "'; nested exception: " + e, (Throwable)e);
        }
        try {
            events = (Events)CastorUtils.unmarshalWithTranslatedExceptions(Events.class, (Reader)new InputStreamReader(in));
            Object var8_8 = null;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            IOUtils.closeQuietly((InputStream)in);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)in);
        this.processEvents(events, rootResource, eventConfiguration, resourceDescription, denyIncludes);
        return events;
    }

    private void processEvents(Events events, Resource resource, EventConfiguration eventConfiguration, String resourceDescription, boolean denyIncludes) {
        if (denyIncludes) {
            if (events.getGlobal() != null) {
                throw new ObjectRetrievalFailureException(Resource.class, (Object)resource, "The event resource " + resource + " included from the root event configuration file cannot have a 'global' element", null);
            }
            if (events.getEventFileCollection().size() > 0) {
                throw new ObjectRetrievalFailureException(Resource.class, (Object)resource, "The event resource " + resource + " included from the root event configuration file cannot include other configuration files: " + StringUtils.collectionToCommaDelimitedString((Collection)events.getEventFileCollection()), null);
            }
        }
        eventConfiguration.getEventFiles().put(resource, events);
        for (Event event : events.getEventCollection()) {
            eventConfiguration.getEventConfData().put(event);
        }
        this.log().info((Object)("DefaultEventConfDao: Loaded " + events.getEventCollection().size() + " events from " + resourceDescription + " event configuration resource: " + resource));
        eventConfiguration.incrementEventCount(events.getEventCount());
    }

    @Override
    public List<Event> getEvents(String uei) {
        ArrayList<Event> events = new ArrayList<Event>();
        for (Events fileEvents : this.getEventConfiguration().getEventFiles().values()) {
            for (Event event : fileEvents.getEventCollection()) {
                if (!event.getUei().equals(uei)) continue;
                events.add(event);
            }
        }
        if (events.size() > 0) {
            return events;
        }
        return null;
    }

    @Override
    public List<String> getEventUEIs() {
        ArrayList<String> eventUEIs = new ArrayList<String>();
        for (Events fileEvents : this.getEventConfiguration().getEventFiles().values()) {
            for (Event event : fileEvents.getEventCollection()) {
                eventUEIs.add(event.getUei());
            }
        }
        return eventUEIs;
    }

    @Override
    public Map<String, String> getEventLabels() {
        TreeMap<String, String> eventLabels = new TreeMap<String, String>();
        for (Events fileEvents : this.getEventConfiguration().getEventFiles().values()) {
            for (Event event : fileEvents.getEventCollection()) {
                eventLabels.put(event.getUei(), event.getEventLabel());
            }
        }
        return eventLabels;
    }

    @Override
    public String getEventLabel(String uei) {
        for (Events fileEvents : this.getEventConfiguration().getEventFiles().values()) {
            for (Event event : fileEvents.getEventCollection()) {
                if (!event.getUei().equals(uei)) continue;
                return event.getEventLabel();
            }
        }
        return "No label found for " + uei;
    }

    @Override
    public synchronized void saveCurrent() {
        File programmaticStoreFile;
        for (Map.Entry<Resource, Events> entry : this.getEventConfiguration().getEventFiles().entrySet()) {
            FileWriter fileWriter;
            File file;
            Resource resource = entry.getKey();
            Events fileEvents = entry.getValue();
            StringWriter stringWriter = new StringWriter();
            try {
                CastorUtils.marshalWithTranslatedExceptions((Object)fileEvents, (Writer)stringWriter);
            }
            catch (DataAccessException e) {
                throw new DataAccessResourceFailureException("Could not marshal configuration file for " + resource + ": " + (Object)((Object)e), (Throwable)e);
            }
            if (stringWriter.toString() == null) continue;
            try {
                file = resource.getFile();
            }
            catch (IOException e) {
                throw new DataAccessResourceFailureException("Event resource '" + resource + "' is not a file resource and cannot be saved.  Nested exception: " + e, (Throwable)e);
            }
            try {
                fileWriter = new FileWriter(file);
            }
            catch (IOException e) {
                throw new DataAccessResourceFailureException("Event file '" + file + "' could not be opened.  Nested exception: " + e, (Throwable)e);
            }
            try {
                fileWriter.write(stringWriter.toString());
            }
            catch (IOException e) {
                throw new DataAccessResourceFailureException("Event file '" + file + "' could not be written to.  Nested exception: " + e, (Throwable)e);
            }
            try {
                fileWriter.close();
            }
            catch (IOException e) {
                throw new DataAccessResourceFailureException("Event file '" + file + "' could not be closed.  Nested exception: " + e, (Throwable)e);
            }
        }
        try {
            programmaticStoreFile = this.getProgrammaticStoreConfigResource().getFile();
        }
        catch (IOException e) {
            this.log().info((Object)("Programmatic store resource '" + this.getProgrammaticStoreConfigResource() + "'; not attempting to delete an unused programmatic store file if it exists (since we can't test for it)."));
            programmaticStoreFile = null;
        }
        if (programmaticStoreFile != null && programmaticStoreFile.exists() && !this.getEventConfiguration().getEventFiles().containsKey(this.getProgrammaticStoreConfigResource())) {
            this.log().info((Object)("Deleting programmatic store configuration file because it is no longer referenced in the root config file " + this.getConfigResource()));
            programmaticStoreFile.delete();
        }
    }

    @Override
    public List<Event> getEventsByLabel() {
        ArrayList<Event> list = new ArrayList<Event>();
        for (Events fileEvents : this.getEventConfiguration().getEventFiles().values()) {
            list.addAll(fileEvents.getEventCollection());
        }
        Collections.sort(list, new EventLabelComparator());
        return list;
    }

    @Override
    public void addEvent(Event event) {
        Events events = this.getRootEvents();
        events.addEvent(event);
    }

    @Override
    public void addEventToProgrammaticStore(Event event) {
        Events root;
        if (!this.getEventConfiguration().getEventFiles().containsKey(this.getProgrammaticStoreConfigResource())) {
            this.getEventConfiguration().getEventFiles().put(this.getProgrammaticStoreConfigResource(), new Events());
        }
        if (!(root = this.getRootEvents()).getEventFileCollection().contains(this.getProgrammaticStoreRelativeUrl())) {
            root.addEventFile(this.getProgrammaticStoreRelativeUrl());
        }
        this.getProgrammaticStoreEvents().addEvent(event);
    }

    private Events getRootEvents() {
        return this.getEventConfiguration().getEventFiles().get(this.getConfigResource());
    }

    private Events getProgrammaticStoreEvents() {
        return this.getEventConfiguration().getEventFiles().get(this.getProgrammaticStoreConfigResource());
    }

    @Override
    public boolean removeEventFromProgrammaticStore(Event event) {
        if (!this.getEventConfiguration().getEventFiles().containsKey(this.getProgrammaticStoreConfigResource())) {
            return false;
        }
        Events events = this.getProgrammaticStoreEvents();
        boolean result = events.removeEvent(event);
        if (events.getEventCount() == 0) {
            this.getEventConfiguration().getEventFiles().remove(this.getProgrammaticStoreConfigResource());
            this.getRootEvents().removeEventFile(this.getProgrammaticStoreRelativeUrl());
        }
        return result;
    }

    @Override
    public boolean isSecureTag(String tag) {
        return this.getEventConfiguration().getSecureTags().contains(tag);
    }

    @Override
    public Event findByUei(String uei) {
        return this.getEventConfiguration().getEventConfData().getEventByUEI(uei);
    }

    @Override
    public Event findByEvent(org.opennms.netmgt.xml.event.Event matchingEvent) {
        return this.getEventConfiguration().getEventConfData().getEvent(matchingEvent);
    }

    private Resource getProgrammaticStoreConfigResource() {
        if (this.m_programmaticStoreConfigResource == null) {
            try {
                this.m_programmaticStoreConfigResource = this.getConfigResource().createRelative(this.getProgrammaticStoreRelativeUrl());
            }
            catch (IOException e) {
                this.log().warn((Object)("Could not get a relative resource for the programmatic store configuration file using relative URL '" + this.getProgrammaticStoreRelativeUrl() + "': " + e), (Throwable)e);
                throw new DataAccessResourceFailureException("Could not get a relative resource for the programmatic store configuration file using relative URL '" + this.getProgrammaticStoreRelativeUrl() + "': " + e, (Throwable)e);
            }
        }
        return this.m_programmaticStoreConfigResource;
    }

    public String getProgrammaticStoreRelativeUrl() {
        return this.m_programmaticStoreRelativeUrl;
    }

    public void setProgrammaticStoreRelativeUrl(String programmaticStoreRelativeUrl) {
        this.m_programmaticStoreRelativeUrl = programmaticStoreRelativeUrl;
    }

    private EventConfiguration getEventConfiguration() {
        return (EventConfiguration)this.getContainer().getObject();
    }

    private class EventResourceLoader
    extends DefaultResourceLoader {
        private EventResourceLoader() {
        }

        public Resource getResource(String location) {
            if (location.contains(":")) {
                return super.getResource(location);
            }
            File file = new File(location);
            if (file.isAbsolute()) {
                return new FileSystemResource(file);
            }
            try {
                return DefaultEventConfDao.this.getConfigResource().createRelative(location);
            }
            catch (IOException e) {
                throw new ObjectRetrievalFailureException(Resource.class, (Object)location, "Resource location has a relative path, however the configResource does not reference a file, so the relative path cannot be resolved.  The location is: " + location, null);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EventLabelComparator
    implements Comparator<Event> {
        private EventLabelComparator() {
        }

        @Override
        public int compare(Event e1, Event e2) {
            return e1.getEventLabel().compareToIgnoreCase(e2.getEventLabel());
        }
    }
}

