/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collectd;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.log4j.Category;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.collectd.Collectd;
import org.opennms.netmgt.collectd.CollectionAgent;
import org.opennms.netmgt.collectd.CollectionSet;
import org.opennms.netmgt.collectd.ServiceCollector;
import org.opennms.netmgt.config.CollectdPackage;
import org.opennms.netmgt.config.PollOutagesConfigFactory;
import org.opennms.netmgt.config.collectd.Parameter;
import org.opennms.netmgt.config.collectd.Service;
import org.opennms.netmgt.dao.CollectorConfigDao;
import org.opennms.netmgt.eventd.EventIpcManagerFactory;
import org.opennms.netmgt.model.RrdRepository;
import org.opennms.netmgt.model.events.EventProxy;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.netmgt.xml.event.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectionSpecification {
    private CollectdPackage m_package;
    private String m_svcName;
    private ServiceCollector m_collector;
    private Map<String, String> m_parameters;

    public CollectionSpecification(CollectdPackage wpkg, String svcName, ServiceCollector collector) {
        this.m_package = wpkg;
        this.m_svcName = svcName;
        this.m_collector = collector;
        this.initializeParameters();
    }

    public String getPackageName() {
        return this.m_package.getName();
    }

    private String storeByIfAlias() {
        return this.m_package.storeByIfAlias();
    }

    private String ifAliasComment() {
        return this.m_package.ifAliasComment();
    }

    private String storeFlagOverride() {
        return this.m_package.getStorFlagOverride();
    }

    private String ifAliasDomain() {
        return this.m_package.ifAliasDomain();
    }

    private String storeByNodeId() {
        return this.m_package.storeByNodeId();
    }

    private Service getService() {
        return this.m_package.getService(this.m_svcName);
    }

    public String getServiceName() {
        return this.m_svcName;
    }

    private void setPackage(CollectdPackage pkg) {
        this.m_package = pkg;
    }

    public long getInterval() {
        return this.getService().getInterval();
    }

    public String toString() {
        return this.m_svcName + '/' + this.m_package.getName();
    }

    private ServiceCollector getCollector() {
        return this.m_collector;
    }

    private Map<String, String> getPropertyMap() {
        return this.m_parameters;
    }

    public Map<String, String> getReadOnlyPropertyMap() {
        return Collections.unmodifiableMap(this.m_parameters);
    }

    private Category log() {
        return ThreadCategory.getInstance(this.getClass());
    }

    private boolean isTrue(String stg) {
        return stg.equalsIgnoreCase("yes") || stg.equalsIgnoreCase("on") || stg.equalsIgnoreCase("true");
    }

    private boolean isFalse(String stg) {
        return stg.equalsIgnoreCase("no") || stg.equalsIgnoreCase("off") || stg.equalsIgnoreCase("false");
    }

    private void initializeParameters() {
        StringBuffer sb;
        TreeMap<String, String> m = new TreeMap<String, String>();
        m.put("SERVICE", this.m_svcName);
        List params = this.getService().getParameterCollection();
        for (Parameter p : params) {
            if (this.log().isDebugEnabled()) {
                sb = new StringBuffer();
                sb.append("initializeParameters: adding service: ");
                sb.append(this.getServiceName());
                sb.append(" parameter: ");
                sb.append(p.getKey());
                sb.append(" of value ");
                sb.append(p.getValue());
                this.log().debug((Object)sb.toString());
            }
            m.put(p.getKey(), p.getValue());
        }
        if (this.storeByIfAlias() != null && this.isTrue(this.storeByIfAlias())) {
            m.put("storeByIfAlias", "true");
            if (this.storeByNodeId() != null) {
                if (this.isTrue(this.storeByNodeId())) {
                    m.put("storeByNodeID", "true");
                } else if (this.isFalse(this.storeByNodeId())) {
                    m.put("storeByNodeID", "false");
                } else {
                    m.put("storeByNodeID", "normal");
                }
            }
            if (this.ifAliasDomain() != null) {
                m.put("domain", this.ifAliasDomain());
            } else {
                m.put("domain", this.getPackageName());
            }
            if (this.storeFlagOverride() != null && this.isTrue(this.storeFlagOverride())) {
                m.put("storFlagOverride", "true");
            }
            m.put("ifAliasComment", this.ifAliasComment());
            if (this.log().isDebugEnabled()) {
                sb = new StringBuffer();
                sb.append("ifAliasDomain = ");
                sb.append(this.ifAliasDomain());
                sb.append(", storeByIfAlias = ");
                sb.append(this.storeByIfAlias());
                sb.append(", storeByNodeID = ");
                sb.append(this.storeByNodeId());
                sb.append(", storFlagOverride = ");
                sb.append(this.storeFlagOverride());
                sb.append(", ifAliasComment = ");
                sb.append(this.ifAliasComment());
                this.log().debug((Object)sb.toString());
            }
        }
        this.m_parameters = m;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize(CollectionAgent agent) {
        Collectd.instrumentation().beginCollectorInitialize(agent.getNodeId(), agent.getHostAddress(), this.m_svcName);
        try {
            this.m_collector.initialize(agent, this.getPropertyMap());
            Object var3_2 = null;
            Collectd.instrumentation().endCollectorInitialize(agent.getNodeId(), agent.getHostAddress(), this.m_svcName);
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            Collectd.instrumentation().endCollectorInitialize(agent.getNodeId(), agent.getHostAddress(), this.m_svcName);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(CollectionAgent agent) {
        Collectd.instrumentation().beginCollectorRelease(agent.getNodeId(), agent.getHostAddress(), this.m_svcName);
        try {
            this.m_collector.release(agent);
            Object var3_2 = null;
            Collectd.instrumentation().endCollectorRelease(agent.getNodeId(), agent.getHostAddress(), this.m_svcName);
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            Collectd.instrumentation().endCollectorRelease(agent.getNodeId(), agent.getHostAddress(), this.m_svcName);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CollectionSet collect(CollectionAgent agent) {
        Collectd.instrumentation().beginCollectorCollect(agent.getNodeId(), agent.getHostAddress(), this.m_svcName);
        try {
            CollectionSet collectionSet = this.getCollector().collect(agent, this.eventProxy(), this.getPropertyMap());
            Object var4_3 = null;
            Collectd.instrumentation().endCollectorCollect(agent.getNodeId(), agent.getHostAddress(), this.m_svcName);
            return collectionSet;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            Collectd.instrumentation().endCollectorCollect(agent.getNodeId(), agent.getHostAddress(), this.m_svcName);
            throw throwable;
        }
    }

    private EventProxy eventProxy() {
        return new EventProxy(){

            public void send(Event e) {
                EventIpcManagerFactory.getIpcManager().sendNow(e);
            }

            public void send(Log log) {
                EventIpcManagerFactory.getIpcManager().sendNow(log);
            }
        };
    }

    public boolean scheduledOutage(CollectionAgent agent) {
        boolean outageFound = false;
        PollOutagesConfigFactory outageFactory = PollOutagesConfigFactory.getInstance();
        for (String outageName : this.m_package.getPackage().getOutageCalendarCollection()) {
            if (!outageFactory.isCurTimeInOutage(outageName) || !outageFactory.isNodeIdInOutage((long)agent.getNodeId(), outageName) && !outageFactory.isInterfaceInOutage(agent.getHostAddress(), outageName)) continue;
            if (this.log().isDebugEnabled()) {
                this.log().debug((Object)("scheduledOutage: configured outage '" + outageName + "' applies, interface " + agent.getHostAddress() + " will not be collected for " + this));
            }
            outageFound = true;
            break;
        }
        return outageFound;
    }

    public void refresh(CollectorConfigDao collectorConfigDao) {
        CollectdPackage refreshedPackage = collectorConfigDao.getPackage(this.getPackageName());
        if (refreshedPackage != null) {
            this.setPackage(refreshedPackage);
        }
    }

    public RrdRepository getRrdRepository(String collectionName) {
        return this.m_collector.getRrdRepository(collectionName);
    }
}

