/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collectd;

import java.io.File;
import java.util.Collection;
import java.util.Iterator;
import org.opennms.netmgt.collectd.AliasedGroup;
import org.opennms.netmgt.collectd.AttributeGroup;
import org.opennms.netmgt.collectd.CollectionResource;
import org.opennms.netmgt.collectd.CollectionSetVisitor;
import org.opennms.netmgt.collectd.IfInfo;
import org.opennms.netmgt.collectd.ResourceType;
import org.opennms.netmgt.collectd.ServiceParameters;
import org.opennms.netmgt.collectd.SnmpCollectionResource;
import org.opennms.netmgt.model.RrdRepository;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AliasedResource
extends SnmpCollectionResource {
    private final IfInfo m_ifInfo;
    private final String m_ifAliasComment;
    private final String m_domain;
    private final String m_ifAlias;

    public AliasedResource(ResourceType resourceType, String domain, IfInfo ifInfo, String ifAliasComment, String ifAlias) {
        super(resourceType);
        this.m_domain = domain;
        this.m_ifInfo = ifInfo;
        this.m_ifAliasComment = ifAliasComment;
        this.m_ifAlias = ifAlias;
    }

    public IfInfo getIfInfo() {
        return this.m_ifInfo;
    }

    String getAliasDir() {
        return this.getIfInfo().getAliasDir(this.m_ifAlias, this.m_ifAliasComment);
    }

    public String getDomain() {
        return this.m_domain;
    }

    @Override
    public File getResourceDir(RrdRepository repository) {
        File domainDir = new File(repository.getRrdBaseDir(), this.getDomain());
        File aliasDir = new File(domainDir, this.getAliasDir());
        return aliasDir;
    }

    public String toString() {
        return this.getDomain() + '/' + this.getAliasDir() + " [" + this.m_ifInfo + ']';
    }

    @Override
    public boolean rescanNeeded() {
        boolean outOfDate = this.getIfInfo().currentAliasIsOutOfDate(this.m_ifAlias);
        if (outOfDate) {
            this.getIfInfo().setIfAlias(this.m_ifAlias);
        }
        return outOfDate;
    }

    public boolean isScheduledForCollection() {
        return this.getIfInfo().isScheduledForCollection();
    }

    @Override
    public boolean shouldPersist(ServiceParameters serviceParameters) {
        boolean shdPrsist;
        boolean bl = shdPrsist = serviceParameters.aliasesEnabled() && this.getAliasDir() != null && !this.getAliasDir().equals("") && (this.isScheduledForCollection() || serviceParameters.forceStoreByAlias(this.getAliasDir()));
        if (this.log().isDebugEnabled()) {
            this.log().debug((Object)("shouldPersist = " + shdPrsist));
        }
        return shdPrsist;
    }

    @Override
    public int getType() {
        return this.getIfInfo().getType();
    }

    @Override
    public void visit(CollectionSetVisitor visitor) {
        visitor.visitResource(this);
        Iterator<AttributeGroup> it = this.getGroups().iterator();
        while (it.hasNext()) {
            AliasedGroup aliased = new AliasedGroup((CollectionResource)this, it.next());
            ((AttributeGroup)aliased).visit(visitor);
        }
        visitor.completeResource(this);
    }

    @Override
    public Collection<AttributeGroup> getGroups() {
        return this.getIfInfo().getGroups();
    }

    @Override
    public String getResourceTypeName() {
        return "if";
    }

    @Override
    public String getInstance() {
        return null;
    }
}

