/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.capsd.plugins;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NoRouteToHostException;
import java.net.Socket;
import java.util.Map;
import org.apache.regexp.RE;
import org.apache.regexp.RESyntaxException;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.capsd.AbstractPlugin;
import org.opennms.netmgt.utils.ParameterMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TcpPlugin
extends AbstractPlugin {
    private static final String PROTOCOL_NAME = "TCP";
    private static final int DEFAULT_RETRY = 0;
    private static final int DEFAULT_TIMEOUT = 5000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isServer(InetAddress host, int port, int retries, int timeout, RE regex, StringBuffer bannerResult) {
        log = ThreadCategory.getInstance(this.getClass());
        isAServer = false;
        attempts = 0;
        while (attempts <= retries) {
            block29: {
                block27: {
                    if (isAServer != false) return isAServer;
                    socket = null;
                    try {
                        try {
                            socket = new Socket();
                            socket.connect(new InetSocketAddress(host, port), timeout);
                            socket.setSoTimeout(timeout);
                            log.debug((Object)("TcpPlugin: connected to host: " + host + " on port: " + port));
                            if (regex == null) {
                                isAServer = true;
                                break block27;
                            }
                            lineRdr = new BufferedReader(new InputStreamReader(socket.getInputStream()));
                            response = lineRdr.readLine();
                            if (regex.match(response)) {
                                if (log.isDebugEnabled()) {
                                    log.debug((Object)("isServer: matching response=" + response));
                                }
                                isAServer = true;
                                if (bannerResult != null) {
                                    bannerResult.append(response);
                                }
                                break block27;
                            }
                            isAServer = false;
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("isServer: NON-matching response=" + response));
                            }
                            var14_18 = null;
                        }
                        catch (ConnectException e) {
                            log.debug((Object)("TcpPlugin: Connection refused to " + host.getHostAddress() + ":" + port));
                            isAServer = false;
                            var14_18 = null;
                            try {
                                if (socket != null) {
                                    socket.close();
                                }
                                break block29;
                            }
                            catch (IOException e) {}
                            break block29;
                        }
                        catch (NoRouteToHostException e) {
                            e.fillInStackTrace();
                            log.info((Object)("TcpPlugin: Could not connect to host " + host.getHostAddress() + ", no route to host"), (Throwable)e);
                            isAServer = false;
                            throw new UndeclaredThrowableException(e);
                        }
                        catch (InterruptedIOException e) {
                            log.debug((Object)("TcpPlugin: did not connect to host within timeout: " + timeout + " attempt: " + attempts));
                            isAServer = false;
                            var14_18 = null;
                            try {}
                            catch (IOException e) {}
                            if (socket != null) {
                                socket.close();
                            }
                            break block29;
                        }
                        catch (IOException e) {
                            log.info((Object)("TcpPlugin: An expected I/O exception occured connecting to host " + host.getHostAddress() + " on port " + port), (Throwable)e);
                            isAServer = false;
                            var14_18 = null;
                            try {}
                            catch (IOException e) {}
                            if (socket != null) {
                                socket.close();
                            }
                            break block29;
                        }
                        catch (Throwable t) {
                            isAServer = false;
                            log.warn((Object)("TcpPlugin: An undeclared throwable exception was caught connecting to host " + host.getHostAddress() + " on port " + port), t);
                            var14_18 = null;
                            try {}
                            catch (IOException e) {}
                            if (socket != null) {
                                socket.close();
                            }
                            break block29;
                        }
                    }
                    catch (Throwable var13_20) {
                        var14_18 = null;
                        ** try [egrp 2[TRYBLOCK] [12 : 499->512)] { 
lbl90:
                        // 1 sources

                        if (socket == null) throw var13_20;
                        socket.close();
                        throw var13_20;
lbl93:
                        // 1 sources

                        catch (IOException e) {
                            // empty catch block
                        }
                        throw var13_20;
                    }
                    try {}
                    catch (IOException e) {
                        return isAServer;
                    }
                    if (socket == null) return isAServer;
                    socket.close();
                    return isAServer;
                }
                var14_18 = null;
                try {}
                catch (IOException e) {}
                if (socket != null) {
                    socket.close();
                }
            }
            ++attempts;
        }
        return isAServer;
    }

    @Override
    public String getProtocolName() {
        return PROTOCOL_NAME;
    }

    @Override
    public boolean isProtocolSupported(InetAddress address) {
        throw new UnsupportedOperationException("Undirected TCP checking not supported");
    }

    @Override
    public boolean isProtocolSupported(InetAddress address, Map<String, Object> qualifiers) {
        int retries = 0;
        int timeout = 5000;
        int port = -1;
        String banner = null;
        String match = null;
        if (qualifiers != null) {
            retries = ParameterMap.getKeyedInteger(qualifiers, "retry", 0);
            timeout = ParameterMap.getKeyedInteger(qualifiers, "timeout", 5000);
            port = ParameterMap.getKeyedInteger(qualifiers, "port", -1);
            banner = ParameterMap.getKeyedString(qualifiers, "banner", null);
            match = ParameterMap.getKeyedString(qualifiers, "match", null);
        }
        if (port == -1) {
            throw new IllegalArgumentException("The port must be specified when doing TCP discovery");
        }
        try {
            StringBuffer bannerResult = null;
            RE regex = null;
            if (match == null && (banner == null || banner.equals("*"))) {
                regex = null;
            } else if (match != null) {
                regex = new RE(match);
                bannerResult = new StringBuffer();
            } else if (banner != null) {
                regex = new RE(banner);
                bannerResult = new StringBuffer();
            }
            boolean result = this.isServer(address, port, retries, timeout, regex, bannerResult);
            if (result && qualifiers != null && bannerResult != null && bannerResult.length() > 0) {
                qualifiers.put("banner", bannerResult.toString());
            }
            return result;
        }
        catch (RESyntaxException e) {
            throw new UndeclaredThrowableException(e);
        }
    }
}

