/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.capsd.plugins;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NoRouteToHostException;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.regexp.RE;
import org.apache.regexp.RESyntaxException;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.capsd.AbstractPlugin;
import org.opennms.netmgt.utils.ParameterMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SmtpPlugin
extends AbstractPlugin {
    private static final RE MULTILINE_RESULT;
    private static final String PROTOCOL_NAME = "SMTP";
    private static final int DEFAULT_PORT = 25;
    private static final int DEFAULT_RETRY = 0;
    private static final int DEFAULT_TIMEOUT = 5000;
    private static String LOCALHOST_NAME;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isServer(InetAddress host, int port, int retries, int timeout) {
        log = ThreadCategory.getInstance(this.getClass());
        isAServer = false;
        attempts = 0;
        while (attempts <= retries) {
            block40: {
                block37: {
                    block39: {
                        block38: {
                            block36: {
                                if (isAServer != false) return isAServer;
                                socket = null;
                                try {
                                    try {
                                        socket = new Socket();
                                        socket.connect(new InetSocketAddress(host, port), timeout);
                                        socket.setSoTimeout(timeout);
                                        log.debug((Object)("SmtpPlugin: connected to host: " + host + " on port: " + port));
                                        lineRdr = new BufferedReader(new InputStreamReader(socket.getInputStream()));
                                        result = null;
                                        while ((result = lineRdr.readLine()) != null && result.length() > 0 && SmtpPlugin.MULTILINE_RESULT.match(result)) {
                                        }
                                        if (result == null || result.length() == 0) {
                                            log.info((Object)("Received truncated response from SMTP server " + host.getHostAddress()));
                                            var15_20 = null;
                                            break block36;
                                        }
                                        t = new StringTokenizer(result);
                                        rc = Integer.parseInt(t.nextToken());
                                        if (rc != 220) break block37;
                                        cmd = "HELO " + SmtpPlugin.LOCALHOST_NAME + "\r\n";
                                        socket.getOutputStream().write(cmd.getBytes());
                                        while ((result = lineRdr.readLine()) != null && result.length() > 0 && SmtpPlugin.MULTILINE_RESULT.match(result)) {
                                        }
                                        if (result == null || result.length() == 0) {
                                            log.info((Object)("Received truncated response from SMTP server " + host.getHostAddress()));
                                            break block38;
                                        }
                                        t = new StringTokenizer(result);
                                        rc = Integer.parseInt(t.nextToken());
                                        if (rc != 250) break block37;
                                        cmd = "QUIT\r\n";
                                        socket.getOutputStream().write(cmd.getBytes());
                                        while ((result = lineRdr.readLine()) != null && result.length() > 0 && SmtpPlugin.MULTILINE_RESULT.match(result)) {
                                        }
                                        if (result == null || result.length() == 0) {
                                            log.info((Object)("Received truncated response from SMTP server " + host.getHostAddress()));
                                            break block39;
                                        }
                                        t = new StringTokenizer(result);
                                        rc = Integer.parseInt(t.nextToken());
                                        if (rc != 221) break block37;
                                        isAServer = true;
                                        break block37;
                                    }
                                    catch (NumberFormatException e) {
                                        log.info((Object)("SmtpPlugin: received invalid result code from server " + host.getHostAddress()), (Throwable)e);
                                        isAServer = false;
                                        var15_20 = null;
                                        try {
                                            if (socket != null) {
                                                socket.close();
                                            }
                                            break block40;
                                        }
                                        catch (IOException e) {}
                                        break block40;
                                    }
                                    catch (ConnectException cE) {
                                        log.debug((Object)("SmtpPlugin: connection refused to " + host.getHostAddress() + ":" + port));
                                        isAServer = false;
                                        var15_20 = null;
                                        try {}
                                        catch (IOException e) {}
                                        if (socket != null) {
                                            socket.close();
                                        }
                                        break block40;
                                    }
                                    catch (NoRouteToHostException e) {
                                        e.fillInStackTrace();
                                        log.info((Object)("SmtpPlugin: Unable to test host " + host.getHostAddress() + ", no route available"), (Throwable)e);
                                        isAServer = false;
                                        throw new UndeclaredThrowableException(e);
                                    }
                                    catch (InterruptedIOException e) {
                                        log.debug((Object)("SmtpPlugin: did not connect to host within timeout: " + timeout + " attempt: " + attempts));
                                        isAServer = false;
                                        var15_20 = null;
                                        try {}
                                        catch (IOException e) {}
                                        if (socket != null) {
                                            socket.close();
                                        }
                                        break block40;
                                    }
                                    catch (IOException e) {
                                        log.info((Object)("SmtpPlugin: Error communicating with host " + host.getHostAddress()), (Throwable)e);
                                        isAServer = false;
                                        var15_20 = null;
                                        try {}
                                        catch (IOException e) {}
                                        if (socket != null) {
                                            socket.close();
                                        }
                                        break block40;
                                    }
                                    catch (Throwable t) {
                                        log.warn((Object)("SmtpPlugin: Undeclared throwable exception caught contacting host " + host.getHostAddress()), t);
                                        isAServer = false;
                                        var15_20 = null;
                                        try {}
                                        catch (IOException e) {}
                                        if (socket != null) {
                                            socket.close();
                                        }
                                        break block40;
                                    }
                                }
                                catch (Throwable var14_22) {
                                    var15_20 = null;
                                    ** try [egrp 2[TRYBLOCK] [34 : 781->794)] { 
lbl119:
                                    // 1 sources

                                    if (socket == null) throw var14_22;
                                    socket.close();
                                    throw var14_22;
lbl122:
                                    // 1 sources

                                    catch (IOException e) {
                                        // empty catch block
                                    }
                                    throw var14_22;
                                }
                            }
                            try {}
                            catch (IOException e) {}
                            if (socket != null) {
                                socket.close();
                            }
                            break block40;
                        }
                        var15_20 = null;
                        try {}
                        catch (IOException e) {}
                        if (socket != null) {
                            socket.close();
                        }
                        break block40;
                    }
                    var15_20 = null;
                    try {}
                    catch (IOException e) {}
                    if (socket != null) {
                        socket.close();
                    }
                    break block40;
                }
                var15_20 = null;
                try {}
                catch (IOException e) {}
                if (socket != null) {
                    socket.close();
                }
            }
            ++attempts;
        }
        return isAServer;
    }

    @Override
    public String getProtocolName() {
        return PROTOCOL_NAME;
    }

    @Override
    public boolean isProtocolSupported(InetAddress address) {
        return this.isServer(address, 25, 0, 5000);
    }

    @Override
    public boolean isProtocolSupported(InetAddress address, Map<String, Object> qualifiers) {
        boolean result;
        int retries = 0;
        int timeout = 5000;
        int port = 25;
        if (qualifiers != null) {
            retries = ParameterMap.getKeyedInteger(qualifiers, "retry", 0);
            timeout = ParameterMap.getKeyedInteger(qualifiers, "timeout", 5000);
            port = ParameterMap.getKeyedInteger(qualifiers, "port", 25);
        }
        if ((result = this.isServer(address, port, retries, timeout)) && qualifiers != null && !qualifiers.containsKey("port")) {
            qualifiers.put("port", new Integer(port));
        }
        return result;
    }

    static {
        try {
            LOCALHOST_NAME = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException uhE) {
            ThreadCategory.getInstance(SmtpPlugin.class).error((Object)"Failed to resolve localhost name, using localhost");
            LOCALHOST_NAME = "localhost";
        }
        try {
            MULTILINE_RESULT = new RE("^[1-5][0-9]{2}-");
        }
        catch (RESyntaxException re) {
            throw new UndeclaredThrowableException(re);
        }
    }
}

