/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.capsd.plugins;

import java.net.InetAddress;
import java.util.Map;
import org.opennms.netmgt.capsd.Plugin;
import org.opennms.netmgt.config.SnmpPeerFactory;
import org.opennms.netmgt.utils.ParameterMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoopPlugin
implements Plugin {
    private String m_protocolName = "LOOP";

    @Override
    public String getProtocolName() {
        return this.m_protocolName;
    }

    @Override
    public boolean isProtocolSupported(InetAddress address) {
        return this.isProtocolSupported(address, null);
    }

    @Override
    public boolean isProtocolSupported(InetAddress address, Map<String, Object> qualifiers) {
        if (qualifiers == null) {
            return false;
        }
        String ipMatch = this.getIpMatch(qualifiers);
        if (SnmpPeerFactory.verifyIpMatch((String)address.getHostAddress(), (String)ipMatch)) {
            return this.isSupported(qualifiers);
        }
        return false;
    }

    private boolean isSupported(Map<String, Object> parameters) {
        return ParameterMap.getKeyedString(parameters, "is-supported", "false").equalsIgnoreCase("true");
    }

    private String getIpMatch(Map<String, Object> parameters) {
        return ParameterMap.getKeyedString(parameters, "ip-match", "*.*.*.*");
    }
}

