/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.capsd.plugins;

import java.lang.reflect.UndeclaredThrowableException;
import java.net.InetAddress;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.log4j.Category;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.capsd.AbstractPlugin;
import org.opennms.netmgt.config.SnmpPeerFactory;
import org.opennms.netmgt.snmp.SnmpAgentConfig;
import org.opennms.netmgt.snmp.SnmpObjId;
import org.opennms.netmgt.snmp.SnmpUtils;
import org.opennms.netmgt.snmp.SnmpValue;
import org.opennms.netmgt.utils.ParameterMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DiskUsagePlugin
extends AbstractPlugin {
    private static final String PROTOCOL_NAME = "DiskUsage";
    private static final String DEFAULT_OID = ".1.3.6.1.2.1.1.2.0";
    private static final String hrStorageDescr = ".1.3.6.1.2.1.25.2.3.1.3";
    private static final int MATCH_TYPE_EXACT = 0;
    private static final int MATCH_TYPE_STARTSWITH = 1;
    private static final int MATCH_TYPE_ENDSWITH = 2;
    private static final int MATCH_TYPE_REGEX = 3;

    @Override
    public String getProtocolName() {
        return PROTOCOL_NAME;
    }

    @Override
    public boolean isProtocolSupported(InetAddress address) {
        try {
            SnmpAgentConfig agentConfig = SnmpPeerFactory.getInstance().getAgentConfig(address);
            return this.getValue(agentConfig, DEFAULT_OID) != null;
        }
        catch (Throwable t) {
            throw new UndeclaredThrowableException(t);
        }
    }

    private String getValue(SnmpAgentConfig agentConfig, String oid) {
        SnmpValue val = SnmpUtils.get((SnmpAgentConfig)agentConfig, (SnmpObjId)SnmpObjId.get((String)oid));
        return val == null ? null : val.toString();
    }

    @Override
    public boolean isProtocolSupported(InetAddress address, Map<String, Object> qualifiers) {
        int matchType = 0;
        try {
            SnmpObjId hrStorageDescrSnmpObject;
            Map descrResults;
            String disk = ParameterMap.getKeyedString(qualifiers, "disk", null);
            SnmpAgentConfig agentConfig = SnmpPeerFactory.getInstance().getAgentConfig(address);
            if (qualifiers != null) {
                if (qualifiers.get("port") != null) {
                    int port = ParameterMap.getKeyedInteger(qualifiers, "port", agentConfig.getPort());
                    agentConfig.setPort(port);
                }
                if (qualifiers.get("timeout") != null) {
                    int timeout = ParameterMap.getKeyedInteger(qualifiers, "timeout", agentConfig.getTimeout());
                    agentConfig.setTimeout(timeout);
                }
                if (qualifiers.get("retry") != null) {
                    int retry = ParameterMap.getKeyedInteger(qualifiers, "retry", agentConfig.getRetries());
                    agentConfig.setRetries(retry);
                }
                if (qualifiers.get("force version") != null) {
                    String version = (String)qualifiers.get("force version");
                    if (version.equalsIgnoreCase("snmpv1")) {
                        agentConfig.setVersion(1);
                    } else if (version.equalsIgnoreCase("snmpv2") || version.equalsIgnoreCase("snmpv2c")) {
                        agentConfig.setVersion(2);
                    } else if (version.equalsIgnoreCase("snmpv3")) {
                        agentConfig.setVersion(3);
                    }
                }
                if (qualifiers.get("match-type") != null) {
                    String matchTypeStr = ParameterMap.getKeyedString(qualifiers, "match-type", "exact");
                    if (matchTypeStr.equalsIgnoreCase("exact")) {
                        matchType = 0;
                    } else if (matchTypeStr.equalsIgnoreCase("startswith")) {
                        matchType = 1;
                    } else if (matchTypeStr.equalsIgnoreCase("endswith")) {
                        matchType = 2;
                    } else if (matchTypeStr.equalsIgnoreCase("regex")) {
                        matchType = 3;
                    } else {
                        throw new RuntimeException("Unknown value '" + matchTypeStr + "' for parameter 'match-type'");
                    }
                }
            }
            if ((descrResults = SnmpUtils.getOidValues((SnmpAgentConfig)agentConfig, (String)"DiskUsagePoller", (SnmpObjId)(hrStorageDescrSnmpObject = SnmpObjId.get((String)hrStorageDescr)))).size() == 0) {
                return false;
            }
            for (Map.Entry e : descrResults.entrySet()) {
                this.log().debug((Object)("capsd: SNMPwalk succeeded, addr=" + address.getHostAddress() + " oid=" + hrStorageDescrSnmpObject + " instance=" + e.getKey() + " value=" + e.getValue()));
                if (!this.isMatch(((SnmpValue)e.getValue()).toString(), disk, matchType)) continue;
                this.log().debug((Object)("Found disk '" + disk + "' (matching hrStorageDescr was '" + ((SnmpValue)e.getValue()).toString() + "'"));
                return true;
            }
            return false;
        }
        catch (Throwable t) {
            throw new UndeclaredThrowableException(t);
        }
    }

    private boolean isMatch(String candidate, String target, int matchType) {
        boolean matches = false;
        this.log().debug((Object)("isMessage: candidate is '" + candidate + "', matching against target '" + target + "'"));
        if (matchType == 0) {
            this.log().debug((Object)("Attempting equality match: candidate '" + candidate + "', target '" + target + "'"));
            matches = candidate.equals(target);
        } else if (matchType == 1) {
            this.log().debug((Object)("Attempting startsWith match: candidate '" + candidate + "', target '" + target + "'"));
            matches = candidate.startsWith(target);
        } else if (matchType == 2) {
            this.log().debug((Object)("Attempting endsWith match: candidate '" + candidate + "', target '" + target + "'"));
            matches = candidate.endsWith(target);
        } else if (matchType == 3) {
            this.log().debug((Object)("Attempting endsWith match: candidate '" + candidate + "', target '" + target + "'"));
            matches = Pattern.compile(target).matcher(candidate).find();
        }
        this.log().debug((Object)"isMatch: Match is positive");
        return matches;
    }

    private Category log() {
        return ThreadCategory.getInstance(this.getClass());
    }
}

