/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.capsd.plugins;

import java.lang.reflect.UndeclaredThrowableException;
import java.net.InetAddress;
import java.util.Map;
import org.apache.log4j.Category;
import org.jfree.util.Log;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.capsd.plugins.SnmpPlugin;
import org.opennms.netmgt.config.SnmpPeerFactory;
import org.opennms.netmgt.snmp.SnmpAgentConfig;
import org.opennms.netmgt.snmp.SnmpObjId;
import org.opennms.netmgt.snmp.SnmpUtils;
import org.opennms.netmgt.snmp.SnmpValue;
import org.opennms.netmgt.utils.ParameterMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BgpSessionPlugin
extends SnmpPlugin {
    private static final String PROTOCOL_NAME = "BGP_Session";
    private static final String BGP_PEER_STATE_OID = ".1.3.6.1.2.1.15.3.1.2";

    @Override
    public String getProtocolName() {
        return PROTOCOL_NAME;
    }

    @Override
    public boolean isProtocolSupported(InetAddress address, Map<String, Object> qualifiers) {
        try {
            String bgpPeerIp = ParameterMap.getKeyedString(qualifiers, "bgpPeerIp", null);
            SnmpAgentConfig agentConfig = SnmpPeerFactory.getInstance().getAgentConfig(address);
            if (qualifiers != null) {
                if (qualifiers.get("port") != null) {
                    int port = ParameterMap.getKeyedInteger(qualifiers, "port", agentConfig.getPort());
                    agentConfig.setPort(port);
                }
                if (qualifiers.get("timeout") != null) {
                    int timeout = ParameterMap.getKeyedInteger(qualifiers, "timeout", agentConfig.getTimeout());
                    agentConfig.setTimeout(timeout);
                }
                if (qualifiers.get("retry") != null) {
                    int retry = ParameterMap.getKeyedInteger(qualifiers, "retry", agentConfig.getRetries());
                    agentConfig.setRetries(retry);
                }
                if (qualifiers.get("force version") != null) {
                    String version = (String)qualifiers.get("force version");
                    if (version.equalsIgnoreCase("snmpv1")) {
                        agentConfig.setVersion(1);
                    } else if (version.equalsIgnoreCase("snmpv2") || version.equalsIgnoreCase("snmpv2c")) {
                        agentConfig.setVersion(2);
                    } else if (version.equalsIgnoreCase("snmpv3")) {
                        agentConfig.setVersion(3);
                    }
                }
                SnmpObjId bgpPeerStateSnmpObject = SnmpObjId.get((String)(".1.3.6.1.2.1.15.3.1.2." + bgpPeerIp));
                SnmpValue bgpPeerState = SnmpUtils.get((SnmpAgentConfig)agentConfig, (SnmpObjId)bgpPeerStateSnmpObject);
                if (Log.isDebugEnabled()) {
                    BgpSessionPlugin.log().debug((Object)("BgpSessionMonitor.capsd: bgpPeerState: " + bgpPeerState));
                }
                if (Integer.parseInt(bgpPeerState.toString()) >= 1 && Integer.parseInt(bgpPeerState.toString()) <= 6) {
                    return true;
                }
            }
        }
        catch (Throwable t) {
            throw new UndeclaredThrowableException(t);
        }
        return false;
    }

    public static Category log() {
        return ThreadCategory.getInstance(BgpSessionPlugin.class);
    }
}

