/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.capsd;

import java.net.InetAddress;
import org.apache.log4j.Category;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.capsd.snmp.IfTable;
import org.opennms.netmgt.capsd.snmp.IfXTable;
import org.opennms.netmgt.capsd.snmp.IpAddrTable;
import org.opennms.netmgt.capsd.snmp.SystemGroup;
import org.opennms.netmgt.config.SnmpPeerFactory;
import org.opennms.netmgt.snmp.CollectionTracker;
import org.opennms.netmgt.snmp.SnmpAgentConfig;
import org.opennms.netmgt.snmp.SnmpUtils;
import org.opennms.netmgt.snmp.SnmpWalker;

public final class IfSnmpCollector
implements Runnable {
    private final InetAddress m_address;
    private SystemGroup m_sysGroup;
    private IfTable m_ifTable;
    private IpAddrTable m_ipAddrTable;
    private IfXTable m_ifXTable;

    public IfSnmpCollector(InetAddress address) {
        this.m_address = address;
        this.m_sysGroup = null;
        this.m_ifTable = null;
        this.m_ifXTable = null;
        this.m_ipAddrTable = null;
    }

    public boolean failed() {
        return !this.hasSystemGroup() || !this.hasIfTable() || !this.hasIpAddrTable();
    }

    public boolean hasSystemGroup() {
        return this.m_sysGroup != null && !this.m_sysGroup.failed();
    }

    public SystemGroup getSystemGroup() {
        return this.m_sysGroup;
    }

    public boolean hasIfTable() {
        if (this.m_ifTable == null) {
            this.log().debug((Object)"hasIfTable: No interface table present.");
        }
        return this.m_ifTable != null && !this.m_ifTable.failed();
    }

    public IfTable getIfTable() {
        return this.m_ifTable;
    }

    public boolean hasIpAddrTable() {
        if (this.m_ipAddrTable == null) {
            this.log().debug((Object)"hasIpAddrTable: No IP interface address table present.");
        }
        return this.m_ipAddrTable != null && !this.m_ipAddrTable.failed();
    }

    public IpAddrTable getIpAddrTable() {
        return this.m_ipAddrTable;
    }

    public boolean hasIfXTable() {
        if (this.m_ifXTable == null) {
            this.log().debug((Object)"hasIfXTable: No interface extensions table present.");
        }
        return this.m_ifXTable != null && !this.m_ifXTable.failed();
    }

    public IfXTable getIfXTable() {
        return this.m_ifXTable;
    }

    public InetAddress getCollectorTargetAddress() {
        return this.m_address;
    }

    public InetAddress[] getIfAddressAndMask(int ifIndex) {
        if (!this.hasIpAddrTable()) {
            throw new IndexOutOfBoundsException("Illegal Index, no table present");
        }
        return this.m_ipAddrTable.getIfAddressAndMask(ifIndex);
    }

    public int getAdminStatus(int ifIndex) {
        if (!this.hasIfTable()) {
            throw new IndexOutOfBoundsException("Illegal Index, no table present");
        }
        return this.m_ifTable.getAdminStatus(ifIndex);
    }

    public int getOperStatus(int ifIndex) {
        if (!this.hasIfTable()) {
            throw new IndexOutOfBoundsException("Illegal Index, no table present");
        }
        return this.m_ifTable.getOperStatus(ifIndex);
    }

    public int getIfType(int ifIndex) {
        if (!this.hasIfTable()) {
            throw new IndexOutOfBoundsException("Illegal Index, no table present");
        }
        return this.m_ifTable.getIfType(ifIndex);
    }

    public int getIfIndex(InetAddress address) {
        this.log().debug((Object)("getIfIndex: retrieving ifIndex for " + address.getHostAddress()));
        if (!this.hasIpAddrTable()) {
            this.log().debug((Object)"getIfIndex: Illegal index, no table present.");
            throw new IndexOutOfBoundsException("Illegal Index, no table present");
        }
        return this.m_ipAddrTable.getIfIndex(address);
    }

    public String getIfName(int ifIndex) {
        String snmpIfName = null;
        if (this.hasIfXTable()) {
            snmpIfName = this.m_ifXTable.getIfName(ifIndex);
        }
        if (snmpIfName != null) {
            this.log().debug((Object)("getIfName: ifIndex " + ifIndex + " has ifName '" + snmpIfName));
        } else {
            this.log().debug((Object)("getIfName: no ifName found for ifIndex " + ifIndex));
        }
        return snmpIfName;
    }

    public String getIfDescr(int ifIndex) {
        String ifDescr = null;
        if (this.hasIfTable()) {
            ifDescr = this.m_ifTable.getIfDescr(ifIndex);
        }
        return ifDescr;
    }

    public Long getInterfaceSpeed(int ifIndex) {
        Long ifSpeed = null;
        try {
            if (this.hasIfXTable() && this.getIfXTable().getIfHighSpeed(ifIndex) != null && this.getIfXTable().getIfHighSpeed(ifIndex) > 4294L) {
                ifSpeed = this.getIfXTable().getIfHighSpeed(ifIndex) * 1000000L;
                this.log().debug((Object)("getInterfaceSpeed:  Using ifHighSpeed for ifIndex " + ifIndex + ": " + ifSpeed));
            } else if (this.hasIfTable()) {
                ifSpeed = this.m_ifTable.getIfSpeed(ifIndex);
                this.log().debug((Object)("getInterfaceSpeed:  Using ifSpeed for ifIndex " + ifIndex + ": " + ifSpeed));
            }
        }
        catch (Exception e) {
            this.log().warn((Object)("getInterfaceSpeed: exception retrieving interface speed for ifIndex " + ifIndex));
        }
        return ifSpeed;
    }

    public String getPhysAddr(int ifIndex) {
        String physAddr = null;
        if (this.hasIfTable()) {
            physAddr = this.m_ifTable.getPhysAddr(ifIndex);
        }
        return physAddr;
    }

    public String getIfAlias(int ifIndex) {
        String snmpIfAlias = null;
        if (this.hasIfXTable()) {
            snmpIfAlias = this.m_ifXTable.getIfAlias(ifIndex);
            if (this.log().isDebugEnabled()) {
                if (snmpIfAlias != null) {
                    this.log().debug((Object)("getIfAlias: ifIndex " + ifIndex + " has ifAlias '" + snmpIfAlias + "'"));
                } else {
                    this.log().debug((Object)("getIfAlias: no ifAlias found for ifIndex " + ifIndex));
                }
            }
        } else if (this.log().isDebugEnabled()) {
            this.log().debug((Object)("getIfAlias: no ifXTable retrieved from " + this.m_address));
        }
        return snmpIfAlias;
    }

    public void run() {
        this.m_sysGroup = new SystemGroup(this.m_address);
        this.m_ifTable = new IfTable(this.m_address);
        this.m_ipAddrTable = new IpAddrTable(this.m_address);
        this.m_ifXTable = new IfXTable(this.m_address);
        SnmpAgentConfig agentConfig = SnmpPeerFactory.getInstance().getAgentConfig(this.m_address);
        if (this.log().isDebugEnabled()) {
            this.log().debug((Object)("run: collecting for: " + this.m_address + " with agentConfig: " + agentConfig));
        }
        SnmpWalker walker = SnmpUtils.createWalker((SnmpAgentConfig)agentConfig, (String)"system/ifTable/ifXTable/ipAddrTable", (CollectionTracker[])new CollectionTracker[]{this.m_sysGroup, this.m_ifTable, this.m_ipAddrTable, this.m_ifXTable});
        walker.start();
        try {
            walker.waitFor(300000L);
        }
        catch (InterruptedException e) {
            this.m_sysGroup = null;
            this.m_ifTable = null;
            this.m_ipAddrTable = null;
            this.m_ifXTable = null;
            this.log().warn((Object)"IfSnmpCollector: collection interrupted, exiting", (Throwable)e);
            return;
        }
        if (!this.hasSystemGroup()) {
            this.log().info((Object)("IfSnmpCollector: failed to collect System group for " + this.m_address.getHostAddress()));
        }
        if (!this.hasIfTable()) {
            this.log().info((Object)("IfSnmpCollector: failed to collect ifTable for " + this.m_address.getHostAddress()));
        }
        if (!this.hasIpAddrTable()) {
            this.log().info((Object)("IfSnmpCollector: failed to collect ipAddrTable for " + this.m_address.getHostAddress()));
        }
        if (!this.hasIfXTable()) {
            this.log().info((Object)("IfSnmpCollector: failed to collect ifXTable for " + this.m_address.getHostAddress()));
        }
    }

    private Category log() {
        return ThreadCategory.getInstance((String)(this.getClass() + "." + this.m_address));
    }
}

