/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.capsd;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Category;
import org.opennms.core.queue.FifoQueue;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.capsd.DbIfServiceEntry;
import org.opennms.netmgt.capsd.DbIpInterfaceEntry;
import org.opennms.netmgt.capsd.DbNodeEntry;
import org.opennms.netmgt.capsd.EventUtils;
import org.opennms.netmgt.capsd.FailedOperationException;
import org.opennms.netmgt.capsd.InsufficientInformationException;
import org.opennms.netmgt.capsd.Scheduler;
import org.opennms.netmgt.capsd.SuspectEventProcessor;
import org.opennms.netmgt.capsd.SuspectEventProcessorFactory;
import org.opennms.netmgt.config.CapsdConfigFactory;
import org.opennms.netmgt.config.DataSourceFactory;
import org.opennms.netmgt.model.events.annotations.EventHandler;
import org.opennms.netmgt.model.events.annotations.EventListener;
import org.opennms.netmgt.xml.event.Event;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@EventListener(name="Capsd:BroadcastEventProcessor")
public class BroadcastEventProcessor
implements InitializingBean {
    private static String SQL_ADD_INTERFACE_TO_SERVER = "INSERT INTO serverMap VALUES (?, ?)";
    private static String SQL_ADD_SERVICE_TO_MAPPING = "INSERT INTO serviceMap VALUES (?, ?)";
    private static String SQL_DELETE_ALL_SERVICES_INTERFACE_MAPPING = "DELETE FROM serviceMap WHERE ipaddr = ?";
    private static String SQL_DELETE_INTERFACE_ON_SERVER = "DELETE FROM serverMap WHERE ipaddr = ? AND servername = ?";
    private static String SQL_DELETE_SERVICE_INTERFACE_MAPPING = "DELETE FROM serviceMap WHERE ipaddr = ? AND servicemapname = ?";
    private static String SQL_QUERY_IPADDRESS_EXIST = "SELECT nodeid FROM ipinterface WHERE ipaddr = ? AND isManaged !='D'";
    private static String SQL_QUERY_IPINTERFACE_EXIST = "SELECT nodelabel, ipaddr FROM node, ipinterface WHERE node.nodeid = ipinterface.nodeid AND node.nodelabel = ? AND ipinterface.ipaddr = ? AND isManaged !='D' AND nodeType !='D'";
    private static String SQL_QUERY_NODE_EXIST = "SELECT nodeid, dpname FROM node WHERE nodelabel = ? AND nodeType !='D'";
    private static String SQL_QUERY_SERVICE_EXIST = "SELECT nodeid FROM ifservices, service WHERE ifservices.serviceid = service.serviceid AND ipaddr = ? AND servicename = ? AND status !='D'";
    private static String SQL_QUERY_SERVICE_MAPPING_EXIST = "SELECT * FROM serviceMap WHERE ipaddr = ? AND servicemapname = ?";
    private static String SQL_RETRIEVE_NODEID = "select nodeid from ipinterface where ipaddr=? and isManaged!='D'";
    private static String SQL_RETRIEVE_SERVICE_ID = "SELECT serviceid FROM service WHERE servicename = ?";
    private String m_localServer = null;
    private Scheduler m_scheduler;
    private FifoQueue<Runnable> m_suspectQ;
    private SuspectEventProcessorFactory m_suspectEventProcessorFactory;

    public static boolean isPropagationEnabled() {
        return CapsdConfigFactory.getInstance().getDeletePropagationEnabled();
    }

    public static boolean isXmlRpcEnabled() {
        return CapsdConfigFactory.getInstance().getXmlrpc().equals("true");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int countOtherInterfacesOnNode(Connection dbConn, long nodeId, String ipAddr) throws SQLException {
        String DB_COUNT_OTHER_INTERFACES_ON_NODE = "SELECT count(*) FROM ipinterface WHERE nodeID=? and ipAddr != ? and isManaged != 'D'";
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = dbConn.prepareStatement("SELECT count(*) FROM ipinterface WHERE nodeID=? and ipAddr != ? and isManaged != 'D'");
            stmt.setLong(1, nodeId);
            stmt.setString(2, ipAddr);
            rs = stmt.executeQuery();
            int count = 0;
            while (rs.next()) {
                count = rs.getInt(1);
            }
            if (this.log().isDebugEnabled()) {
                this.log().debug((Object)("countServicesForInterface: count services for interface " + nodeId + "/" + ipAddr + ": found " + count));
            }
            int n = count;
            return n;
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            finally {
                if (stmt != null) {
                    stmt.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int countOtherServicesOnInterface(Connection dbConn, long nodeId, String ipAddr, String service) throws SQLException {
        String DB_COUNT_OTHER_SERVICES_ON_IFACE = "SELECT count(*) FROM ifservices, service WHERE ifservices.serviceId = service.serviceId AND ifservices.status != 'D' AND ifservices.nodeID=? AND ifservices.ipAddr=? AND service.servicename != ?";
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = dbConn.prepareStatement("SELECT count(*) FROM ifservices, service WHERE ifservices.serviceId = service.serviceId AND ifservices.status != 'D' AND ifservices.nodeID=? AND ifservices.ipAddr=? AND service.servicename != ?");
            stmt.setLong(1, nodeId);
            stmt.setString(2, ipAddr);
            stmt.setString(3, service);
            rs = stmt.executeQuery();
            int count = 0;
            while (rs.next()) {
                count = rs.getInt(1);
            }
            if (this.log().isDebugEnabled()) {
                this.log().debug((Object)("countServicesForInterface: count services for interface " + nodeId + "/" + ipAddr + ": found " + count));
            }
            int n = count;
            return n;
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            finally {
                if (stmt != null) {
                    stmt.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int countServicesOnOtherInterfaces(Connection dbConn, long nodeId, String ipAddr) throws SQLException {
        String DB_COUNT_SERVICES_ON_OTHER_INTERFACES = "SELECT count(*) FROM ifservices WHERE nodeID=? and ipAddr != ? and status != 'D'";
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = dbConn.prepareStatement("SELECT count(*) FROM ifservices WHERE nodeID=? and ipAddr != ? and status != 'D'");
            stmt.setLong(1, nodeId);
            stmt.setString(2, ipAddr);
            rs = stmt.executeQuery();
            int count = 0;
            while (rs.next()) {
                count = rs.getInt(1);
            }
            if (this.log().isDebugEnabled()) {
                this.log().debug((Object)("countServicesOnOtherInterfaces: count services for node " + nodeId + ": found " + count));
            }
            int n = count;
            return n;
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            finally {
                if (stmt != null) {
                    stmt.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Event> createInterfaceOnNode(Connection dbConn, String nodeLabel, String ipaddr) throws SQLException, FailedOperationException {
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = dbConn.prepareStatement(SQL_QUERY_NODE_EXIST);
            stmt.setString(1, nodeLabel);
            rs = stmt.executeQuery();
            LinkedList<Event> eventsToSend = new LinkedList<Event>();
            while (rs.next()) {
                if (this.log().isDebugEnabled()) {
                    this.log().debug((Object)("addInterfaceHandler:  add interface: " + ipaddr + " to the database."));
                }
                InetAddress ifaddr = InetAddress.getByName(ipaddr);
                int nodeId = rs.getInt(1);
                String dpName = rs.getString(2);
                DbIpInterfaceEntry ipInterface = DbIpInterfaceEntry.create(nodeId, ifaddr);
                ipInterface.setHostname(ifaddr.getHostName());
                ipInterface.setManagedState('M');
                ipInterface.setPrimaryState('N');
                ipInterface.store(dbConn);
                DbNodeEntry nodeEntry = DbNodeEntry.get(nodeId, dpName);
                Event newEvent = EventUtils.createNodeGainedInterfaceEvent(nodeEntry, ifaddr);
                eventsToSend.add(newEvent);
            }
            LinkedList<Event> linkedList = eventsToSend;
            return linkedList;
        }
        catch (UnknownHostException e) {
            throw new FailedOperationException("unable to resolve host " + ipaddr + ": " + e.getMessage(), e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            finally {
                if (stmt != null) {
                    stmt.close();
                }
            }
        }
    }

    private Category log() {
        return ThreadCategory.getInstance(this.getClass());
    }

    private List<Event> createNodeWithInterface(Connection conn, String nodeLabel, String ipaddr) throws SQLException, FailedOperationException {
        if (nodeLabel == null) {
            return Collections.emptyList();
        }
        if (this.log().isDebugEnabled()) {
            this.log().debug((Object)("addNode:  Add a node " + nodeLabel + " to the database"));
        }
        LinkedList<Event> eventsToSend = new LinkedList<Event>();
        DbNodeEntry node = DbNodeEntry.create();
        Date now = new Date();
        node.setCreationTime(now);
        node.setNodeType('A');
        node.setLabel(nodeLabel);
        node.setLabelSource('U');
        node.store(conn);
        Event newEvent = EventUtils.createNodeAddedEvent(node);
        eventsToSend.add(newEvent);
        if (ipaddr != null) {
            try {
                if (this.log().isDebugEnabled()) {
                    this.log().debug((Object)("addNode:  Add an IP Address " + ipaddr + " to the database"));
                }
                InetAddress ifaddress = InetAddress.getByName(ipaddr);
                DbIpInterfaceEntry ipInterface = DbIpInterfaceEntry.create(node.getNodeId(), ifaddress);
                ipInterface.setHostname(ifaddress.getHostName());
                ipInterface.setManagedState('M');
                ipInterface.setPrimaryState('N');
                ipInterface.store(conn);
                Event gainIfEvent = EventUtils.createNodeGainedInterfaceEvent(node, ifaddress);
                eventsToSend.add(gainIfEvent);
            }
            catch (UnknownHostException e) {
                throw new FailedOperationException("unable to resolve host " + ipaddr + ": " + e.getMessage(), e);
            }
        }
        return eventsToSend;
    }

    private List<Event> doAddInterface(Connection dbConn, String nodeLabel, String ipaddr) throws SQLException, FailedOperationException {
        List<Event> eventsToSend;
        if (this.interfaceExists(dbConn, nodeLabel, ipaddr)) {
            if (this.log().isDebugEnabled()) {
                this.log().debug((Object)("addInterfaceHandler: node " + nodeLabel + " with IPAddress " + ipaddr + " already exist in the database."));
            }
            eventsToSend = Collections.emptyList();
        } else {
            eventsToSend = this.nodeExists(dbConn, nodeLabel) ? this.createInterfaceOnNode(dbConn, nodeLabel, ipaddr) : this.createNodeWithInterface(dbConn, nodeLabel, ipaddr);
        }
        return eventsToSend;
    }

    private List<Event> doAddNode(Connection dbConn, String nodeLabel, String ipaddr) throws SQLException, FailedOperationException {
        List<Event> eventsToSend;
        if (!this.nodeExists(dbConn, nodeLabel)) {
            eventsToSend = this.createNodeWithInterface(dbConn, nodeLabel, ipaddr);
        } else {
            eventsToSend = Collections.emptyList();
            if (this.log().isDebugEnabled()) {
                this.log().debug((Object)("doAddNode: node " + nodeLabel + " with IPAddress " + ipaddr + " already exist in the database."));
            }
        }
        return eventsToSend;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Event> doAddServiceMapping(Connection dbConn, String ipaddr, String serviceName, long txNo) throws SQLException, FailedOperationException {
        PreparedStatement stmt = null;
        try {
            stmt = dbConn.prepareStatement(SQL_ADD_SERVICE_TO_MAPPING);
            stmt.setString(1, ipaddr);
            stmt.setString(2, serviceName);
            stmt.executeUpdate();
            if (this.log().isDebugEnabled()) {
                this.log().debug((Object)("updateServiceHandler: add service " + serviceName + " to interface: " + ipaddr));
            }
            List<Event> list = this.doChangeService(dbConn, ipaddr, serviceName, "ADD", txNo);
            return list;
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Event> doAddServiceToInterface(Connection dbConn, String ipaddr, String serviceName, int serviceId, long txNo) throws SQLException, FailedOperationException {
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = dbConn.prepareStatement(SQL_QUERY_IPADDRESS_EXIST);
            stmt.setString(1, ipaddr);
            rs = stmt.executeQuery();
            LinkedList<Event> eventsToSend = new LinkedList<Event>();
            while (rs.next()) {
                if (this.log().isDebugEnabled()) {
                    this.log().debug((Object)("changeServiceHandler: add service " + serviceName + " to interface: " + ipaddr));
                }
                int nodeId = rs.getInt(1);
                DbIfServiceEntry service = DbIfServiceEntry.create(nodeId, InetAddress.getByName(ipaddr), serviceId);
                service.setSource('P');
                service.setStatus('A');
                service.setNotify('Y');
                service.store(dbConn);
                DbNodeEntry nodeEntry = DbNodeEntry.get(nodeId);
                Event newEvent = EventUtils.createNodeGainedServiceEvent(nodeEntry, InetAddress.getByName(ipaddr), serviceName, txNo);
                eventsToSend.add(newEvent);
            }
            LinkedList<Event> linkedList = eventsToSend;
            return linkedList;
        }
        catch (UnknownHostException e) {
            throw new FailedOperationException("Unable to resolve host: " + e.getMessage(), e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            finally {
                if (stmt != null) {
                    stmt.close();
                }
            }
        }
    }

    private List<Event> doChangeService(Connection dbConn, String ipaddr, String serviceName, String action, long txNo) throws SQLException, FailedOperationException {
        List<Object> eventsToSend = null;
        int serviceId = this.verifyServiceExists(dbConn, serviceName);
        if (action.equalsIgnoreCase("DELETE")) {
            eventsToSend = new LinkedList();
            int[] nodeIds = this.findNodeIdForServiceAndInterface(dbConn, ipaddr, serviceName);
            for (int i = 0; i < nodeIds.length; ++i) {
                int nodeId = nodeIds[i];
                eventsToSend.addAll(this.doDeleteService(dbConn, "OpenNMS.Capsd", nodeId, ipaddr, serviceName, txNo));
            }
        } else {
            eventsToSend = action.equalsIgnoreCase("ADD") ? this.doAddServiceToInterface(dbConn, ipaddr, serviceName, serviceId, txNo) : Collections.emptyList();
        }
        return eventsToSend;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Event> doCreateInterfaceMappings(Connection dbConn, String nodeLabel, String ipaddr, String hostName, long txNo) throws SQLException {
        PreparedStatement stmt = null;
        try {
            stmt = dbConn.prepareStatement(SQL_ADD_INTERFACE_TO_SERVER);
            stmt.setString(1, ipaddr);
            stmt.setString(2, hostName);
            stmt.executeUpdate();
            if (this.log().isDebugEnabled()) {
                this.log().debug((Object)("updateServerHandler: added interface " + ipaddr + " into NMS server: " + hostName));
            }
            Event newEvent = EventUtils.createAddInterfaceEvent("OpenNMS.Capsd", nodeLabel, ipaddr, hostName, txNo);
            List<Event> list = Collections.singletonList(newEvent);
            return list;
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
        }
    }

    private List<Event> doDeleteInterface(Connection dbConn, String source, long nodeid, String ipAddr, long txNo) throws SQLException {
        LinkedList<Event> eventsToSend = new LinkedList<Event>();
        if (BroadcastEventProcessor.isPropagationEnabled() && this.countOtherInterfacesOnNode(dbConn, nodeid, ipAddr) == 0) {
            this.doDeleteNode(dbConn, source, nodeid, txNo);
        } else {
            eventsToSend.addAll(this.markAllServicesForInterfaceDeleted(dbConn, source, nodeid, ipAddr, txNo));
            eventsToSend.addAll(this.markInterfaceDeleted(dbConn, source, nodeid, ipAddr, txNo));
        }
        this.deleteAlarmsForInterface(dbConn, nodeid, ipAddr);
        return eventsToSend;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Event> doDeleteInterfaceMappings(Connection dbConn, String nodeLabel, String ipaddr, String hostName, long txNo) throws SQLException {
        Statement stmt = null;
        try {
            LinkedList<Event> eventsToSend = new LinkedList<Event>();
            if (this.log().isDebugEnabled()) {
                this.log().debug((Object)("updateServer: delete all services on the interface: " + ipaddr + " in the interface/service mapping."));
            }
            stmt = dbConn.prepareStatement(SQL_DELETE_ALL_SERVICES_INTERFACE_MAPPING);
            stmt.setString(1, ipaddr);
            stmt.executeUpdate();
            if (this.log().isDebugEnabled()) {
                this.log().debug((Object)("updateServer: delete interface: " + ipaddr + " on NMS server: " + hostName));
            }
            stmt = dbConn.prepareStatement(SQL_DELETE_INTERFACE_ON_SERVER);
            stmt.setString(1, ipaddr);
            stmt.setString(2, hostName);
            stmt.executeUpdate();
            long[] nodeIds = this.findNodeIdsForInterfaceAndLabel(dbConn, nodeLabel, ipaddr);
            for (int i = 0; i < nodeIds.length; ++i) {
                long nodeId = nodeIds[i];
                eventsToSend.addAll(this.doDeleteInterface(dbConn, "OpenNMS.Capsd", nodeId, ipaddr, txNo));
            }
            LinkedList<Event> linkedList = eventsToSend;
            return linkedList;
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
        }
    }

    private List<Event> doDeleteNode(Connection dbConn, String source, long nodeid, long txNo) throws SQLException {
        LinkedList<Event> eventsToSend = new LinkedList<Event>();
        eventsToSend.addAll(this.markInterfacesAndServicesDeleted(dbConn, source, nodeid, txNo));
        eventsToSend.addAll(this.markNodeDeleted(dbConn, source, nodeid, txNo));
        this.deleteAlarmsForNode(dbConn, nodeid);
        return eventsToSend;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteAlarmsForNode(Connection dbConn, long nodeId) throws SQLException {
        PreparedStatement stmt = null;
        try {
            stmt = dbConn.prepareStatement("DELETE FROM alarms WHERE nodeid = ?");
            stmt.setLong(1, nodeId);
            int count = stmt.executeUpdate();
            this.log().debug((Object)("deleteAlarmsForNode: deleted: " + count + " alarms for node: " + nodeId));
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteAlarmsForInterface(Connection dbConn, long nodeId, String ipAddr) throws SQLException {
        PreparedStatement stmt = null;
        try {
            stmt = dbConn.prepareStatement("DELETE FROM alarms WHERE nodeid = ? AND ipaddr = ?");
            stmt.setLong(1, nodeId);
            stmt.setString(2, ipAddr);
            int count = stmt.executeUpdate();
            this.log().debug((Object)("deleteAlarmsForInterace: deleted: " + count + " alarms for interface: " + ipAddr));
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteAlarmsForService(Connection dbConn, long nodeId, String ipAddr, String service) throws SQLException {
        PreparedStatement stmt = null;
        try {
            stmt = dbConn.prepareStatement("DELETE FROM alarms WHERE nodeid = ?  AND ipaddr = ?  AND serviceid   IN (SELECT serviceid FROM service WHERE servicename = ?)");
            stmt.setLong(1, nodeId);
            stmt.setString(2, ipAddr);
            stmt.setString(3, service);
            int count = stmt.executeUpdate();
            this.log().debug((Object)("deleteAlarmsForService: deleted: " + count + " alarms for service: " + service));
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
        }
    }

    private List<Event> doDeleteService(Connection dbConn, String source, long nodeid, String ipAddr, String service, long txNo) throws SQLException {
        LinkedList<Event> eventsToSend = new LinkedList<Event>();
        if (BroadcastEventProcessor.isPropagationEnabled()) {
            int otherSvcsOnIfCnt = this.countOtherServicesOnInterface(dbConn, nodeid, ipAddr, service);
            if (otherSvcsOnIfCnt == 0 && this.countServicesOnOtherInterfaces(dbConn, nodeid, ipAddr) == 0) {
                this.log().debug((Object)("Propagating service delete to node " + nodeid));
                eventsToSend.addAll(this.doDeleteNode(dbConn, source, nodeid, txNo));
            } else if (otherSvcsOnIfCnt == 0) {
                this.log().debug((Object)("Propagting service delete to interface " + nodeid + "/" + ipAddr));
                eventsToSend.addAll(this.doDeleteInterface(dbConn, source, nodeid, ipAddr, txNo));
            } else {
                this.log().debug((Object)("No need to Propagate service delete " + nodeid + "/" + ipAddr + "/" + service));
                eventsToSend.addAll(this.markServiceDeleted(dbConn, source, nodeid, ipAddr, service, txNo));
            }
        } else {
            this.log().debug((Object)("Propagation disabled:  deleting only service " + nodeid + "/" + ipAddr + "/" + service));
            eventsToSend.addAll(this.markServiceDeleted(dbConn, source, nodeid, ipAddr, service, txNo));
        }
        this.deleteAlarmsForService(dbConn, nodeid, ipAddr, service);
        return eventsToSend;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Event> doDeleteServiceMapping(Connection dbConn, String ipaddr, String serviceName, long txNo) throws SQLException, FailedOperationException {
        Statement stmt = null;
        try {
            if (this.log().isDebugEnabled()) {
                this.log().debug((Object)("handleUpdateService: delete service: " + serviceName + " on IPAddress: " + ipaddr));
            }
            stmt = dbConn.prepareStatement(SQL_DELETE_SERVICE_INTERFACE_MAPPING);
            stmt.setString(1, ipaddr);
            stmt.setString(2, serviceName);
            stmt.executeUpdate();
            List<Event> list = this.doChangeService(dbConn, ipaddr, serviceName, "DELETE", txNo);
            return list;
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
        }
    }

    private List<Event> doUpdateServer(Connection dbConn, String nodeLabel, String ipaddr, String action, String hostName, long txNo) throws SQLException, FailedOperationException {
        boolean exists = this.existsInServerMap(dbConn, hostName, ipaddr);
        if ("DELETE".equalsIgnoreCase(action)) {
            return this.doDeleteInterfaceMappings(dbConn, nodeLabel, ipaddr, hostName, txNo);
        }
        if ("ADD".equalsIgnoreCase(action)) {
            if (exists) {
                throw new FailedOperationException("Could not add interface " + ipaddr + " to NMS server: " + hostName + " because it already exists!");
            }
            return this.doCreateInterfaceMappings(dbConn, nodeLabel, ipaddr, hostName, txNo);
        }
        this.log().error((Object)("updateServerHandler: could not process interface: " + ipaddr + " on NMS server: " + hostName + ": action " + action + " unknown"));
        throw new FailedOperationException("Undefined operation " + action + " for updateServer event!");
    }

    private List<Event> doUpdateService(Connection dbConn, String nodeLabel, String ipaddr, String serviceName, String action, long txNo) throws SQLException, FailedOperationException {
        this.verifyServiceExists(dbConn, serviceName);
        this.verifyInterfaceExists(dbConn, nodeLabel, ipaddr);
        boolean mapExists = this.serviceMappingExists(dbConn, ipaddr, serviceName);
        List<Event> eventsToSend = mapExists && "DELETE".equalsIgnoreCase(action) ? this.doDeleteServiceMapping(dbConn, ipaddr, serviceName, txNo) : (!mapExists && "ADD".equalsIgnoreCase(action) ? this.doAddServiceMapping(dbConn, ipaddr, serviceName, txNo) : Collections.emptyList());
        return eventsToSend;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean existsInServerMap(Connection dbConn, String hostName, String ipaddr) throws SQLException {
        PreparedStatement stmt = null;
        try {
            String SQL_QUERY_INTERFACE_ON_SERVER = "SELECT count(*)  FROM serverMap WHERE ipaddr = ? AND servername = ?";
            stmt = dbConn.prepareStatement("SELECT count(*)  FROM serverMap WHERE ipaddr = ? AND servername = ?");
            stmt.setString(1, ipaddr);
            stmt.setString(2, hostName);
            ResultSet rs = stmt.executeQuery();
            int count = 0;
            while (rs.next()) {
                count = rs.getInt(1);
            }
            boolean bl = count > 0;
            return bl;
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int[] findNodeIdForServiceAndInterface(Connection dbConn, String ipaddr, String serviceName) throws SQLException {
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = dbConn.prepareStatement(SQL_QUERY_SERVICE_EXIST);
            stmt.setString(1, ipaddr);
            stmt.setString(2, serviceName);
            rs = stmt.executeQuery();
            LinkedList<Integer> nodeIdList = new LinkedList<Integer>();
            while (rs.next()) {
                if (this.log().isDebugEnabled()) {
                    this.log().debug((Object)("changeService: service " + serviceName + " on IPAddress " + ipaddr + " already exists in the database."));
                }
                int nodeId = rs.getInt(1);
                nodeIdList.add(new Integer(nodeId));
            }
            int[] nodeIds = new int[nodeIdList.size()];
            int i = 0;
            for (Integer n : nodeIdList) {
                nodeIds[i++] = n;
            }
            int[] nArray = nodeIds;
            return nArray;
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            finally {
                if (stmt != null) {
                    stmt.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long[] findNodeIdsForInterfaceAndLabel(Connection dbConn, String nodeLabel, String ipAddr) throws SQLException {
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = dbConn.prepareStatement("SELECT node.nodeid FROM node, ipinterface WHERE node.nodeid = ipinterface.nodeid AND node.nodelabel = ? AND ipinterface.ipaddr = ? AND isManaged !='D' AND nodeType !='D'");
            stmt.setString(1, nodeLabel);
            stmt.setString(2, ipAddr);
            rs = stmt.executeQuery();
            LinkedList<Long> nodeIdList = new LinkedList<Long>();
            while (rs.next()) {
                nodeIdList.add(new Long(rs.getLong(1)));
            }
            long[] nodeIds = new long[nodeIdList.size()];
            int i = 0;
            for (Long nodeId : nodeIdList) {
                nodeIds[i++] = nodeId;
            }
            long[] lArray = nodeIds;
            return lArray;
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            finally {
                if (stmt != null) {
                    stmt.close();
                }
            }
        }
    }

    public String getName() {
        return "Capsd:BroadcastEventProcessor";
    }

    /*
     * Unable to fully structure code
     */
    @EventHandler(uei="uei.opennms.org/internal/capsd/addInterface")
    public void handleAddInterface(Event event) throws InsufficientInformationException, FailedOperationException {
        block26: {
            EventUtils.checkInterface(event);
            EventUtils.requireParm(event, "nodelabel");
            if (BroadcastEventProcessor.isXmlRpcEnabled()) {
                EventUtils.requireParm(event, "txno");
            }
            if (this.log().isDebugEnabled()) {
                this.log().debug((Object)("addInterfaceHandler:  processing addInterface event for " + event.getInterface()));
            }
            nodeLabel = EventUtils.getParm(event, "nodelabel");
            txNo = EventUtils.getLongParm(event, "txno", -1L);
            dbConn = null;
            eventsToSend = null;
            dbConn = this.getConnection();
            dbConn.setAutoCommit(false);
            eventsToSend = this.doAddInterface(dbConn, nodeLabel, event.getInterface());
            var9_6 = null;
            if (dbConn == null) break block26;
            try {
                block27: {
                    if (eventsToSend != null) {
                        dbConn.commit();
                        for (Event e : eventsToSend) {
                            EventUtils.sendEvent(e, event.getUei(), txNo, BroadcastEventProcessor.isXmlRpcEnabled());
                        }
                        break block27;
                    }
                    dbConn.rollback();
                }
                var13_14 = null;
                ** if (dbConn == null) goto lbl-1000
            }
            catch (Throwable var12_22) {
                var13_15 = null;
                if (dbConn != null) {
                    try {
                        dbConn.setAutoCommit(true);
                        dbConn.close();
                    }
                    catch (SQLException ex) {
                        this.log().error((Object)"handleAddInterface: Threw Exception during close: ", (Throwable)ex);
                    }
                }
                throw var12_22;
            }
lbl-1000:
            // 1 sources

            {
                try {
                    dbConn.setAutoCommit(true);
                    dbConn.close();
                }
                catch (SQLException ex) {
                    this.log().error((Object)"handleAddInterface: Threw Exception during close: ", (Throwable)ex);
                }
            }
lbl-1000:
            // 2 sources

            {
                break block26;
                catch (SQLException ex) {
                    this.log().error((Object)"handleAddInterface: Threw Exception during commit: ", (Throwable)ex);
                    throw new FailedOperationException("Database error: " + ex.getMessage(), ex);
                }
            }
            {
                catch (SQLException sqlE) {
                    this.log().error((Object)"addInterfaceHandler: SQLException during add node and ipaddress to the database.", (Throwable)sqlE);
                    throw new FailedOperationException("Database error: " + sqlE.getMessage(), sqlE);
                }
            }
            catch (Throwable var8_25) {
                block30: {
                    var9_7 = null;
                    if (dbConn != null) {
                        try {
                            block29: {
                                if (eventsToSend != null) {
                                    dbConn.commit();
                                    for (Event e : eventsToSend) {
                                        EventUtils.sendEvent(e, event.getUei(), txNo, BroadcastEventProcessor.isXmlRpcEnabled());
                                    }
                                    break block29;
                                }
                                dbConn.rollback();
                            }
                            var13_16 = null;
                            ** if (dbConn == null) goto lbl-1000
                        }
                        catch (Throwable var12_23) {
                            var13_17 = null;
                            if (dbConn != null) {
                                try {
                                    dbConn.setAutoCommit(true);
                                    dbConn.close();
                                }
                                catch (SQLException ex) {
                                    this.log().error((Object)"handleAddInterface: Threw Exception during close: ", (Throwable)ex);
                                }
                            }
                            throw var12_23;
                        }
lbl-1000:
                        // 1 sources

                        {
                            try {
                                dbConn.setAutoCommit(true);
                                dbConn.close();
                            }
                            catch (SQLException ex) {
                                this.log().error((Object)"handleAddInterface: Threw Exception during close: ", (Throwable)ex);
                            }
                        }
lbl-1000:
                        // 2 sources

                        {
                            break block30;
                            catch (SQLException ex) {
                                this.log().error((Object)"handleAddInterface: Threw Exception during commit: ", (Throwable)ex);
                                throw new FailedOperationException("Database error: " + ex.getMessage(), ex);
                            }
                        }
                    }
                }
                throw var8_25;
            }
        }
    }

    private Connection getConnection() throws SQLException {
        return DataSourceFactory.getInstance().getConnection();
    }

    /*
     * Unable to fully structure code
     */
    @EventHandler(uei="uei.opennms.org/internal/capsd/addNode")
    public void handleAddNode(Event event) throws InsufficientInformationException, FailedOperationException {
        block25: {
            EventUtils.requireParm(event, "nodelabel");
            if (BroadcastEventProcessor.isXmlRpcEnabled()) {
                EventUtils.requireParm(event, "txno");
            }
            ipaddr = event.getInterface();
            nodeLabel = EventUtils.getParm(event, "nodelabel");
            txNo = EventUtils.getLongParm(event, "txno", -1L);
            this.log().debug((Object)("addNodeHandler:  processing addNode event for " + ipaddr));
            dbConn = null;
            eventsToSend = null;
            dbConn = this.getConnection();
            dbConn.setAutoCommit(false);
            eventsToSend = this.doAddNode(dbConn, nodeLabel, ipaddr);
            var10_7 = null;
            if (dbConn == null) break block25;
            try {
                block26: {
                    if (eventsToSend != null) {
                        dbConn.commit();
                        for (Event e : eventsToSend) {
                            EventUtils.sendEvent(e, event.getUei(), txNo, BroadcastEventProcessor.isXmlRpcEnabled());
                        }
                        break block26;
                    }
                    dbConn.rollback();
                }
                var14_15 = null;
                ** if (dbConn == null) goto lbl-1000
            }
            catch (Throwable var13_23) {
                var14_16 = null;
                if (dbConn != null) {
                    try {
                        dbConn.close();
                    }
                    catch (SQLException ex) {
                        this.log().error((Object)"handleAddNode: Threw Exception during close: ", (Throwable)ex);
                    }
                }
                throw var13_23;
            }
lbl-1000:
            // 1 sources

            {
                try {
                    dbConn.close();
                }
                catch (SQLException ex) {
                    this.log().error((Object)"handleAddNode: Threw Exception during close: ", (Throwable)ex);
                }
            }
lbl-1000:
            // 2 sources

            {
                break block25;
                catch (SQLException ex) {
                    this.log().error((Object)"handleAddNode: Threw Exception during commit: ", (Throwable)ex);
                    throw new FailedOperationException("database error: " + ex.getMessage(), ex);
                }
            }
            {
                catch (SQLException sqlE) {
                    this.log().error((Object)"addNodeHandler: SQLException during add node and ipaddress to tables", (Throwable)sqlE);
                    throw new FailedOperationException("database error: " + sqlE.getMessage(), sqlE);
                }
            }
            catch (Throwable var9_26) {
                block29: {
                    var10_8 = null;
                    if (dbConn != null) {
                        try {
                            block28: {
                                if (eventsToSend != null) {
                                    dbConn.commit();
                                    for (Event e : eventsToSend) {
                                        EventUtils.sendEvent(e, event.getUei(), txNo, BroadcastEventProcessor.isXmlRpcEnabled());
                                    }
                                    break block28;
                                }
                                dbConn.rollback();
                            }
                            var14_17 = null;
                            ** if (dbConn == null) goto lbl-1000
                        }
                        catch (Throwable var13_24) {
                            var14_18 = null;
                            if (dbConn != null) {
                                try {
                                    dbConn.close();
                                }
                                catch (SQLException ex) {
                                    this.log().error((Object)"handleAddNode: Threw Exception during close: ", (Throwable)ex);
                                }
                            }
                            throw var13_24;
                        }
lbl-1000:
                        // 1 sources

                        {
                            try {
                                dbConn.close();
                            }
                            catch (SQLException ex) {
                                this.log().error((Object)"handleAddNode: Threw Exception during close: ", (Throwable)ex);
                            }
                        }
lbl-1000:
                        // 2 sources

                        {
                            break block29;
                            catch (SQLException ex) {
                                this.log().error((Object)"handleAddNode: Threw Exception during commit: ", (Throwable)ex);
                                throw new FailedOperationException("database error: " + ex.getMessage(), ex);
                            }
                        }
                    }
                }
                throw var9_26;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    @EventHandler(uei="uei.opennms.org/internal/capsd/changeService")
    public void handleChangeService(Event event) throws InsufficientInformationException, FailedOperationException {
        block25: {
            EventUtils.checkInterface(event);
            EventUtils.checkService(event);
            EventUtils.requireParm(event, "action");
            if (BroadcastEventProcessor.isXmlRpcEnabled()) {
                EventUtils.requireParm(event, "txno");
            }
            action = EventUtils.getParm(event, "action");
            txNo = EventUtils.getLongParm(event, "txno", -1L);
            this.log().debug((Object)("changeServiceHandler:  processing changeService event on: " + event.getInterface()));
            dbConn = null;
            eventsToSend = null;
            dbConn = this.getConnection();
            dbConn.setAutoCommit(false);
            eventsToSend = this.doChangeService(dbConn, event.getInterface(), event.getService(), action, txNo);
            var9_6 = null;
            if (dbConn == null) break block25;
            try {
                block26: {
                    if (eventsToSend != null) {
                        dbConn.commit();
                        for (Event e : eventsToSend) {
                            EventUtils.sendEvent(e, event.getUei(), txNo, BroadcastEventProcessor.isXmlRpcEnabled());
                        }
                        break block26;
                    }
                    dbConn.rollback();
                }
                var13_14 = null;
                ** if (dbConn == null) goto lbl-1000
            }
            catch (Throwable var12_22) {
                var13_15 = null;
                if (dbConn != null) {
                    try {
                        dbConn.close();
                    }
                    catch (SQLException ex) {
                        this.log().error((Object)("handleChangeService: Exception thrown closing connection: " + ex));
                    }
                }
                throw var12_22;
            }
lbl-1000:
            // 1 sources

            {
                try {
                    dbConn.close();
                }
                catch (SQLException ex) {
                    this.log().error((Object)("handleChangeService: Exception thrown closing connection: " + ex));
                }
            }
lbl-1000:
            // 2 sources

            {
                break block25;
                catch (SQLException ex) {
                    this.log().error((Object)"handleChangeService: Exception thrown during commit/rollback: ", (Throwable)ex);
                    throw new FailedOperationException("exeption processing changeService: " + ex.getMessage(), ex);
                }
            }
            {
                catch (SQLException sqlE) {
                    this.log().error((Object)"SQLException during changeService on database.", (Throwable)sqlE);
                    throw new FailedOperationException("exeption processing changeService: " + sqlE.getMessage(), sqlE);
                }
            }
            catch (Throwable var8_25) {
                block29: {
                    var9_7 = null;
                    if (dbConn != null) {
                        try {
                            block28: {
                                if (eventsToSend != null) {
                                    dbConn.commit();
                                    for (Event e : eventsToSend) {
                                        EventUtils.sendEvent(e, event.getUei(), txNo, BroadcastEventProcessor.isXmlRpcEnabled());
                                    }
                                    break block28;
                                }
                                dbConn.rollback();
                            }
                            var13_16 = null;
                            ** if (dbConn == null) goto lbl-1000
                        }
                        catch (Throwable var12_23) {
                            var13_17 = null;
                            if (dbConn != null) {
                                try {
                                    dbConn.close();
                                }
                                catch (SQLException ex) {
                                    this.log().error((Object)("handleChangeService: Exception thrown closing connection: " + ex));
                                }
                            }
                            throw var12_23;
                        }
lbl-1000:
                        // 1 sources

                        {
                            try {
                                dbConn.close();
                            }
                            catch (SQLException ex) {
                                this.log().error((Object)("handleChangeService: Exception thrown closing connection: " + ex));
                            }
                        }
lbl-1000:
                        // 2 sources

                        {
                            break block29;
                            catch (SQLException ex) {
                                this.log().error((Object)"handleChangeService: Exception thrown during commit/rollback: ", (Throwable)ex);
                                throw new FailedOperationException("exeption processing changeService: " + ex.getMessage(), ex);
                            }
                        }
                    }
                }
                throw var8_25;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    @EventHandler(uei="uei.opennms.org/internal/capsd/deleteInterface")
    public void handleDeleteInterface(Event event) throws InsufficientInformationException, FailedOperationException {
        block26: {
            EventUtils.checkEventId(event);
            EventUtils.checkInterface(event);
            EventUtils.checkNodeId(event);
            if (BroadcastEventProcessor.isXmlRpcEnabled()) {
                EventUtils.requireParm(event, "txno");
            }
            if (this.log().isDebugEnabled()) {
                this.log().debug((Object)("handleDeleteInterface: Event\nuei\t\t" + event.getUei() + "\neventid\t\t" + event.getDbid() + "\nnodeId\t\t" + event.getNodeid() + "\nipaddr\t\t" + event.getInterface() + "\neventtime\t" + (event.getTime() != null ? event.getTime() : "<null>")));
            }
            txNo = EventUtils.getLongParm(event, "txno", -1L);
            dbConn = null;
            eventsToSend = null;
            dbConn = this.getConnection();
            dbConn.setAutoCommit(false);
            source = event.getSource() == null ? "OpenNMS.Capsd" : event.getSource();
            eventsToSend = this.doDeleteInterface(dbConn, source, event.getNodeid(), event.getInterface(), txNo);
            var8_7 = null;
            if (dbConn == null) break block26;
            try {
                block27: {
                    if (eventsToSend != null) {
                        dbConn.commit();
                        for (Event e : eventsToSend) {
                            EventUtils.sendEvent(e, event.getUei(), txNo, BroadcastEventProcessor.isXmlRpcEnabled());
                        }
                        break block27;
                    }
                    dbConn.rollback();
                }
                var12_15 = null;
                ** if (dbConn == null) goto lbl-1000
            }
            catch (Throwable var11_23) {
                var12_16 = null;
                if (dbConn != null) {
                    try {
                        dbConn.close();
                    }
                    catch (SQLException ex) {
                        this.log().error((Object)"handleDeleteInterface: Exception thrown closing connection: ", (Throwable)ex);
                    }
                }
                throw var11_23;
            }
lbl-1000:
            // 1 sources

            {
                try {
                    dbConn.close();
                }
                catch (SQLException ex) {
                    this.log().error((Object)"handleDeleteInterface: Exception thrown closing connection: ", (Throwable)ex);
                }
            }
lbl-1000:
            // 2 sources

            {
                break block26;
                catch (SQLException ex) {
                    this.log().error((Object)"handleDeleteInterface: Exception thrown during commit/rollback: ", (Throwable)ex);
                    throw new FailedOperationException("exeption processing delete interface: " + ex.getMessage(), ex);
                }
            }
            {
                catch (SQLException ex) {
                    this.log().error((Object)("handleDeleteService:  Database error deleting service " + event.getService() + " on ipAddr " + event.getInterface() + " for node " + event.getNodeid()), (Throwable)ex);
                    throw new FailedOperationException("database error: " + ex.getMessage(), ex);
                }
            }
            catch (Throwable var7_25) {
                block30: {
                    var8_8 = null;
                    if (dbConn != null) {
                        try {
                            block29: {
                                if (eventsToSend != null) {
                                    dbConn.commit();
                                    for (Event e : eventsToSend) {
                                        EventUtils.sendEvent(e, event.getUei(), txNo, BroadcastEventProcessor.isXmlRpcEnabled());
                                    }
                                    break block29;
                                }
                                dbConn.rollback();
                            }
                            var12_17 = null;
                            ** if (dbConn == null) goto lbl-1000
                        }
                        catch (Throwable var11_24) {
                            var12_18 = null;
                            if (dbConn != null) {
                                try {
                                    dbConn.close();
                                }
                                catch (SQLException ex) {
                                    this.log().error((Object)"handleDeleteInterface: Exception thrown closing connection: ", (Throwable)ex);
                                }
                            }
                            throw var11_24;
                        }
lbl-1000:
                        // 1 sources

                        {
                            try {
                                dbConn.close();
                            }
                            catch (SQLException ex) {
                                this.log().error((Object)"handleDeleteInterface: Exception thrown closing connection: ", (Throwable)ex);
                            }
                        }
lbl-1000:
                        // 2 sources

                        {
                            break block30;
                            catch (SQLException ex) {
                                this.log().error((Object)"handleDeleteInterface: Exception thrown during commit/rollback: ", (Throwable)ex);
                                throw new FailedOperationException("exeption processing delete interface: " + ex.getMessage(), ex);
                            }
                        }
                    }
                }
                throw var7_25;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    @EventHandler(uei="uei.opennms.org/internal/capsd/deleteNode")
    public void handleDeleteNode(Event event) throws InsufficientInformationException, FailedOperationException {
        block26: {
            EventUtils.checkEventId(event);
            EventUtils.checkNodeId(event);
            if (BroadcastEventProcessor.isXmlRpcEnabled()) {
                EventUtils.requireParm(event, "txno");
            }
            nodeid = event.getNodeid();
            if (this.log().isDebugEnabled()) {
                this.log().debug((Object)("handleDeleteNode: Event\nuei\t\t" + event.getUei() + "\neventid\t\t" + event.getDbid() + "\nnodeId\t\t" + nodeid + "\neventtime\t" + (event.getTime() != null ? event.getTime() : "<null>")));
            }
            txNo = EventUtils.getLongParm(event, "txno", -1L);
            dbConn = null;
            eventsToSend = null;
            dbConn = this.getConnection();
            dbConn.setAutoCommit(false);
            source = event.getSource() == null ? "OpenNMS.Capsd" : event.getSource();
            eventsToSend = this.doDeleteNode(dbConn, source, nodeid, txNo);
            var10_8 = null;
            if (dbConn == null) break block26;
            try {
                block27: {
                    if (eventsToSend != null) {
                        dbConn.commit();
                        for (Event e : eventsToSend) {
                            EventUtils.sendEvent(e, event.getUei(), txNo, BroadcastEventProcessor.isXmlRpcEnabled());
                        }
                        break block27;
                    }
                    dbConn.rollback();
                }
                var14_16 = null;
                ** if (dbConn == null) goto lbl-1000
            }
            catch (Throwable var13_24) {
                var14_17 = null;
                if (dbConn != null) {
                    try {
                        dbConn.close();
                    }
                    catch (SQLException ex) {
                        this.log().error((Object)"handleDeleteNode: Exception thrown closing connection: ", (Throwable)ex);
                    }
                }
                throw var13_24;
            }
lbl-1000:
            // 1 sources

            {
                try {
                    dbConn.close();
                }
                catch (SQLException ex) {
                    this.log().error((Object)"handleDeleteNode: Exception thrown closing connection: ", (Throwable)ex);
                }
            }
lbl-1000:
            // 2 sources

            {
                break block26;
                catch (SQLException ex) {
                    this.log().error((Object)"handleDeleteNode: Exception thrown during commit/rollback: ", (Throwable)ex);
                    throw new FailedOperationException("exeption processing deleteNode: " + ex.getMessage(), ex);
                }
            }
            {
                catch (SQLException ex) {
                    this.log().error((Object)("handleDeleteService:  Database error deleting service " + event.getService() + " on ipAddr " + event.getInterface() + " for node " + nodeid), (Throwable)ex);
                    throw new FailedOperationException("database error: " + ex.getMessage(), ex);
                }
            }
            catch (Throwable var9_26) {
                block30: {
                    var10_9 = null;
                    if (dbConn != null) {
                        try {
                            block29: {
                                if (eventsToSend != null) {
                                    dbConn.commit();
                                    for (Event e : eventsToSend) {
                                        EventUtils.sendEvent(e, event.getUei(), txNo, BroadcastEventProcessor.isXmlRpcEnabled());
                                    }
                                    break block29;
                                }
                                dbConn.rollback();
                            }
                            var14_18 = null;
                            ** if (dbConn == null) goto lbl-1000
                        }
                        catch (Throwable var13_25) {
                            var14_19 = null;
                            if (dbConn != null) {
                                try {
                                    dbConn.close();
                                }
                                catch (SQLException ex) {
                                    this.log().error((Object)"handleDeleteNode: Exception thrown closing connection: ", (Throwable)ex);
                                }
                            }
                            throw var13_25;
                        }
lbl-1000:
                        // 1 sources

                        {
                            try {
                                dbConn.close();
                            }
                            catch (SQLException ex) {
                                this.log().error((Object)"handleDeleteNode: Exception thrown closing connection: ", (Throwable)ex);
                            }
                        }
lbl-1000:
                        // 2 sources

                        {
                            break block30;
                            catch (SQLException ex) {
                                this.log().error((Object)"handleDeleteNode: Exception thrown during commit/rollback: ", (Throwable)ex);
                                throw new FailedOperationException("exeption processing deleteNode: " + ex.getMessage(), ex);
                            }
                        }
                    }
                }
                throw var9_26;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    @EventHandler(uei="uei.opennms.org/nodes/deleteService")
    public void handleDeleteService(Event event) throws InsufficientInformationException, FailedOperationException {
        block25: {
            EventUtils.checkEventId(event);
            EventUtils.checkNodeId(event);
            EventUtils.checkInterface(event);
            EventUtils.checkService(event);
            if (this.log().isDebugEnabled()) {
                this.log().debug((Object)("handleDeleteService: Event\nuei\t\t" + event.getUei() + "\neventid\t\t" + event.getDbid() + "\nnodeid\t\t" + event.getNodeid() + "\nipaddr\t\t" + event.getInterface() + "\nservice\t\t" + event.getService() + "\neventtime\t" + (event.getTime() != null ? event.getTime() : "<null>")));
            }
            txNo = EventUtils.getLongParm(event, "txno", -1L);
            dbConn = null;
            eventsToSend = null;
            dbConn = this.getConnection();
            dbConn.setAutoCommit(false);
            source = event.getSource() == null ? "OpenNMS.Capsd" : event.getSource();
            eventsToSend = this.doDeleteService(dbConn, source, event.getNodeid(), event.getInterface(), event.getService(), txNo);
            var8_7 = null;
            if (dbConn == null) break block25;
            try {
                block26: {
                    if (eventsToSend != null) {
                        dbConn.commit();
                        for (Event e : eventsToSend) {
                            EventUtils.sendEvent(e, event.getUei(), txNo, BroadcastEventProcessor.isXmlRpcEnabled());
                        }
                        break block26;
                    }
                    dbConn.rollback();
                }
                var12_15 = null;
                ** if (dbConn == null) goto lbl-1000
            }
            catch (Throwable var11_23) {
                var12_16 = null;
                if (dbConn != null) {
                    try {
                        dbConn.close();
                    }
                    catch (SQLException ex) {
                        this.log().error((Object)"handleDeleteService: Exception thrown closing connection: ", (Throwable)ex);
                    }
                }
                throw var11_23;
            }
lbl-1000:
            // 1 sources

            {
                try {
                    dbConn.close();
                }
                catch (SQLException ex) {
                    this.log().error((Object)"handleDeleteService: Exception thrown closing connection: ", (Throwable)ex);
                }
            }
lbl-1000:
            // 2 sources

            {
                break block25;
                catch (SQLException ex) {
                    this.log().error((Object)"handleDeleteService: Exception thrown during commit/rollback: ", (Throwable)ex);
                    throw new FailedOperationException("exeption processing deleteService: " + ex.getMessage(), ex);
                }
            }
            {
                catch (SQLException ex) {
                    this.log().error((Object)("handleDeleteService:  Database error deleting service " + event.getService() + " on ipAddr " + event.getInterface() + " for node " + event.getNodeid()), (Throwable)ex);
                    throw new FailedOperationException("database error: " + ex.getMessage(), ex);
                }
            }
            catch (Throwable var7_25) {
                block29: {
                    var8_8 = null;
                    if (dbConn != null) {
                        try {
                            block28: {
                                if (eventsToSend != null) {
                                    dbConn.commit();
                                    for (Event e : eventsToSend) {
                                        EventUtils.sendEvent(e, event.getUei(), txNo, BroadcastEventProcessor.isXmlRpcEnabled());
                                    }
                                    break block28;
                                }
                                dbConn.rollback();
                            }
                            var12_17 = null;
                            ** if (dbConn == null) goto lbl-1000
                        }
                        catch (Throwable var11_24) {
                            var12_18 = null;
                            if (dbConn != null) {
                                try {
                                    dbConn.close();
                                }
                                catch (SQLException ex) {
                                    this.log().error((Object)"handleDeleteService: Exception thrown closing connection: ", (Throwable)ex);
                                }
                            }
                            throw var11_24;
                        }
lbl-1000:
                        // 1 sources

                        {
                            try {
                                dbConn.close();
                            }
                            catch (SQLException ex) {
                                this.log().error((Object)"handleDeleteService: Exception thrown closing connection: ", (Throwable)ex);
                            }
                        }
lbl-1000:
                        // 2 sources

                        {
                            break block29;
                            catch (SQLException ex) {
                                this.log().error((Object)"handleDeleteService: Exception thrown during commit/rollback: ", (Throwable)ex);
                                throw new FailedOperationException("exeption processing deleteService: " + ex.getMessage(), ex);
                            }
                        }
                    }
                }
                throw var7_25;
            }
        }
    }

    @EventHandler(uei="uei.opennms.org/nodes/duplicateNodeDeleted")
    public void handleDupNodeDeleted(Event event) throws InsufficientInformationException {
        EventUtils.checkNodeId(event);
        this.m_scheduler.unscheduleNode((int)event.getNodeid());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @EventHandler(uei="uei.opennms.org/internal/capsd/forceRescan")
    public void handleForceRescan(Event event) throws InsufficientInformationException {
        int nodeid;
        block40: {
            ResultSet rs;
            PreparedStatement stmt;
            Connection dbc;
            nodeid = -1;
            if (event.hasNodeid()) {
                nodeid = (int)event.getNodeid();
            } else {
                Object v1;
                Object v0;
                block37: {
                    EventUtils.checkInterface(event);
                    dbc = null;
                    stmt = null;
                    rs = null;
                    dbc = this.getConnection();
                    stmt = dbc.prepareStatement(SQL_RETRIEVE_NODEID);
                    stmt.setString(1, event.getInterface());
                    rs = stmt.executeQuery();
                    if (!rs.next()) break block37;
                    nodeid = rs.getInt(1);
                }
                Object var8_6 = null;
                try {
                    try {
                        if (rs != null) {
                            rs.close();
                        }
                        v0 = null;
                    }
                    catch (SQLException e) {
                        this.log().error((Object)"handleForceRescan: Exception thrown closing resultset: ", (Throwable)e);
                        v0 = null;
                    }
                }
                catch (Throwable throwable) {
                    v0 = null;
                }
                Object var11_15 = v0;
                try {
                    try {
                        if (stmt != null) {
                            stmt.close();
                        }
                        v1 = null;
                    }
                    catch (SQLException e) {
                        this.log().error((Object)"handleForceRescan: Exception thrown closing statement: ", (Throwable)e);
                        v1 = null;
                    }
                }
                catch (Throwable throwable) {
                    v1 = null;
                }
                Object var14_24 = v1;
                try {
                    if (dbc != null) {
                        dbc.close();
                    }
                    break block40;
                }
                catch (SQLException e) {
                    this.log().error((Object)"handleForceRescan: Exception thrown closing connection: ", (Throwable)e);
                }
            }
            break block40;
            {
                catch (SQLException sqlE) {
                    Object v3;
                    Object v2;
                    this.log().error((Object)("handleForceRescan: Database error during nodeid retrieval for interface " + event.getInterface()), (Throwable)sqlE);
                    Object var8_7 = null;
                    try {
                        try {
                            if (rs != null) {
                                rs.close();
                            }
                            v2 = null;
                        }
                        catch (SQLException e) {
                            this.log().error((Object)"handleForceRescan: Exception thrown closing resultset: ", (Throwable)e);
                            v2 = null;
                        }
                    }
                    catch (Throwable throwable) {
                        v2 = null;
                    }
                    Object var11_16 = v2;
                    try {
                        try {
                            if (stmt != null) {
                                stmt.close();
                            }
                            v3 = null;
                        }
                        catch (SQLException e) {
                            this.log().error((Object)"handleForceRescan: Exception thrown closing statement: ", (Throwable)e);
                            v3 = null;
                        }
                    }
                    catch (Throwable throwable) {
                        v3 = null;
                    }
                    Object var14_25 = v3;
                    try {
                        if (dbc != null) {
                            dbc.close();
                        }
                        break block40;
                    }
                    catch (SQLException e) {
                        this.log().error((Object)"handleForceRescan: Exception thrown closing connection: ", (Throwable)e);
                    }
                }
            }
            catch (Throwable throwable) {
                Object v5;
                Object v4;
                Object var8_8 = null;
                try {
                    try {
                        if (rs != null) {
                            rs.close();
                        }
                        v4 = null;
                    }
                    catch (SQLException e) {
                        this.log().error((Object)"handleForceRescan: Exception thrown closing resultset: ", (Throwable)e);
                        v4 = null;
                    }
                }
                catch (Throwable throwable2) {
                    v4 = null;
                }
                Object var11_17 = v4;
                try {
                    try {
                        if (stmt != null) {
                            stmt.close();
                        }
                        v5 = null;
                    }
                    catch (SQLException e) {
                        this.log().error((Object)"handleForceRescan: Exception thrown closing statement: ", (Throwable)e);
                        v5 = null;
                    }
                }
                catch (Throwable throwable3) {
                    v5 = null;
                }
                Object var14_26 = v5;
                try {
                    if (dbc != null) {
                        dbc.close();
                    }
                }
                catch (SQLException e) {
                    this.log().error((Object)"handleForceRescan: Exception thrown closing connection: ", (Throwable)e);
                }
                throw throwable;
            }
        }
        if (nodeid == -1) {
            this.log().error((Object)("handleForceRescan: Nodeid retrieval for interface " + event.getInterface() + " failed.  Unable to perform rescan."));
        } else {
            this.m_scheduler.forceRescan(nodeid);
        }
    }

    @EventHandler(uei="uei.opennms.org/internal/discovery/newSuspect")
    public void handleNewSuspect(Event event) throws InsufficientInformationException {
        EventUtils.checkInterface(event);
        if (SuspectEventProcessor.isScanQueuedForAddress(event.getInterface())) {
            this.log().info((Object)("Ignoring newSuspect event for interface " + event.getInterface() + " because a newSuspect scan for that interface already exists in the queue"));
            return;
        }
        try {
            this.log().debug((Object)("onMessage: Adding interface to suspectInterface Q: " + event.getInterface()));
            this.m_suspectQ.add((Object)this.m_suspectEventProcessorFactory.createSuspectEventProcessor(event.getInterface()));
        }
        catch (Exception ex) {
            this.log().error((Object)"onMessage: Failed to add interface to suspect queue", (Throwable)ex);
        }
    }

    @EventHandler(uei="uei.opennms.org/nodes/nodeAdded")
    public void handleNodeAdded(Event event) throws InsufficientInformationException {
        EventUtils.checkNodeId(event);
        try {
            this.m_scheduler.scheduleNode((int)event.getNodeid());
        }
        catch (SQLException sqlE) {
            this.log().error((Object)("onMessage: SQL exception while attempting to schedule node " + event.getNodeid()), (Throwable)sqlE);
        }
    }

    @EventHandler(uei="uei.opennms.org/nodes/nodeDeleted")
    public void handleNodeDeleted(Event event) throws InsufficientInformationException {
        EventUtils.checkNodeId(event);
        this.m_scheduler.unscheduleNode((int)event.getNodeid());
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @EventHandler(uei="uei.opennms.org/internal/capsd/updateServer")
    public void handleUpdateServer(Event event) throws InsufficientInformationException, FailedOperationException {
        EventUtils.checkInterface(event);
        EventUtils.checkHost(event);
        EventUtils.requireParm(event, "action");
        EventUtils.requireParm(event, "nodelabel");
        if (BroadcastEventProcessor.isXmlRpcEnabled()) {
            EventUtils.requireParm(event, "txno");
        }
        action = EventUtils.getParm(event, "action");
        nodeLabel = EventUtils.getParm(event, "nodelabel");
        txNo = EventUtils.getLongParm(event, "txno", -1L);
        if (this.log().isDebugEnabled()) {
            this.log().debug((Object)("updateServerHandler:  processing updateServer event for: " + event.getInterface() + " on OpenNMS server: " + this.m_localServer));
        }
        dbConn = null;
        eventsToSend = null;
        try {
            try {
                dbConn = this.getConnection();
                dbConn.setAutoCommit(false);
                eventsToSend = this.doUpdateServer(dbConn, nodeLabel, event.getInterface(), action, this.m_localServer, txNo);
            }
            catch (SQLException sqlE) {
                this.log().error((Object)"SQLException during updateServer on database.", (Throwable)sqlE);
                throw new FailedOperationException("SQLException during updateServer on database.", sqlE);
            }
            var10_7 = null;
            if (dbConn == null) return;
            ** GOTO lbl57
        }
        catch (Throwable var9_26) {
            var10_8 = null;
            if (dbConn == null) throw var9_26;
            try {
                if (eventsToSend != null) {
                    dbConn.commit();
                    for (Event e : eventsToSend) {
                        EventUtils.sendEvent(e, event.getUei(), txNo, BroadcastEventProcessor.isXmlRpcEnabled());
                    }
                } else {
                    dbConn.rollback();
                }
            }
            catch (SQLException ex) {
                this.log().error((Object)"handleUpdateServer: Exception thrown during commit/rollback: ", (Throwable)ex);
                throw new FailedOperationException("SQLException during updateServer on database.", ex);
            }
            var14_17 = null;
            if (dbConn == null) throw var9_26;
            ** GOTO lbl-1000
            {
                block26: {
                    catch (Throwable var13_24) {
                        var14_18 = null;
                        if (dbConn == null) throw var13_24;
                        try {
                            dbConn.close();
                            throw var13_24;
                        }
                        catch (SQLException ex) {
                            this.log().error((Object)"handleUpdateServer: Exception thrown closing connection: ", (Throwable)ex);
                        }
                        throw var13_24;
                    }
lbl57:
                    // 1 sources

                    ** try [egrp 2[TRYBLOCK] [4 : 198->301)] { 
lbl58:
                    // 1 sources

                    ** try [egrp 3[TRYBLOCK] [3 : 198->268)] { 
lbl59:
                    // 1 sources

                    if (eventsToSend != null) {
                        dbConn.commit();
                        for (Event e : eventsToSend) {
                            EventUtils.sendEvent(e, event.getUei(), txNo, BroadcastEventProcessor.isXmlRpcEnabled());
                        }
                        break block26;
                    } else {
                        dbConn.rollback();
                    }
                    break block26;
lbl67:
                    // 1 sources

                    catch (SQLException ex) {
                        this.log().error((Object)"handleUpdateServer: Exception thrown during commit/rollback: ", (Throwable)ex);
                        throw new FailedOperationException("SQLException during updateServer on database.", ex);
                    }
                }
                var14_15 = null;
                if (dbConn == null) return;
                ** GOTO lbl-1000
lbl-1000:
                // 1 sources

                {
                    catch (Throwable var13_23) {
                        var14_16 = null;
                        if (dbConn == null) throw var13_23;
                        ** try [egrp 4[TRYBLOCK] [6 : 316->326)] { 
lbl79:
                        // 1 sources

                        dbConn.close();
                        throw var13_23;
lbl81:
                        // 1 sources

                        catch (SQLException ex) {
                            this.log().error((Object)"handleUpdateServer: Exception thrown closing connection: ", (Throwable)ex);
                        }
                        throw var13_23;
                    }
lbl-1000:
                    // 1 sources

                    try {}
                    catch (SQLException ex) {}
                    this.log().error((Object)"handleUpdateServer: Exception thrown closing connection: ", (Throwable)ex);
                    return;
                    dbConn.close();
                    return;
                }
lbl-1000:
                // 1 sources

                try {}
                catch (SQLException ex) {}
                this.log().error((Object)"handleUpdateServer: Exception thrown closing connection: ", (Throwable)ex);
                throw var9_26;
                dbConn.close();
                throw var9_26;
            }
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @EventHandler(uei="uei.opennms.org/internal/capsd/updateService")
    public void handleUpdateService(Event event) throws InsufficientInformationException, FailedOperationException {
        Connection dbConn;
        List<Event> eventsToSend;
        long txNo;
        block21: {
            EventUtils.checkInterface(event);
            EventUtils.checkService(event);
            EventUtils.requireParm(event, "nodelabel");
            EventUtils.requireParm(event, "action");
            if (BroadcastEventProcessor.isXmlRpcEnabled()) {
                EventUtils.requireParm(event, "txno");
            }
            txNo = EventUtils.getLongParm(event, "txno", -1L);
            String action = EventUtils.getParm(event, "action");
            String nodeLabel = EventUtils.getParm(event, "nodelabel");
            if (this.log().isDebugEnabled()) {
                this.log().debug((Object)("handleUpdateService:  processing updateService event for : " + event.getService() + " on : " + event.getInterface()));
            }
            eventsToSend = null;
            dbConn = null;
            dbConn = this.getConnection();
            dbConn.setAutoCommit(false);
            eventsToSend = this.doUpdateService(dbConn, nodeLabel, event.getInterface(), event.getService(), action, txNo);
            Object var10_7 = null;
            if (dbConn == null) return;
            if (eventsToSend != null) {
                dbConn.commit();
                for (Event e : eventsToSend) {
                    EventUtils.sendEvent(e, event.getUei(), txNo, BroadcastEventProcessor.isXmlRpcEnabled());
                }
                break block21;
            }
            dbConn.rollback();
        }
        Object var14_15 = null;
        if (dbConn == null) return;
        try {
            dbConn.close();
            return;
        }
        catch (SQLException ex) {
            this.log().error((Object)"handleUpdateService: Exception thrown during close: ", (Throwable)ex);
        }
        return;
        {
            catch (SQLException ex) {
                this.log().error((Object)"handleUpdateService: Exception thrown during commit/rollback: ", (Throwable)ex);
                throw new FailedOperationException(ex.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var14_16 = null;
            if (dbConn == null) throw throwable;
            try {
                dbConn.close();
                throw throwable;
            }
            catch (SQLException ex) {
                this.log().error((Object)"handleUpdateService: Exception thrown during close: ", (Throwable)ex);
            }
            throw throwable;
        }
        {
            catch (SQLException sqlE) {
                this.log().error((Object)"SQLException during handleUpdateService on database.", (Throwable)sqlE);
                throw new FailedOperationException(sqlE.getMessage());
            }
        }
        catch (Throwable throwable) {
            block22: {
                Object var10_8 = null;
                if (dbConn == null) throw throwable;
                if (eventsToSend != null) {
                    dbConn.commit();
                    for (Event e : eventsToSend) {
                        EventUtils.sendEvent(e, event.getUei(), txNo, BroadcastEventProcessor.isXmlRpcEnabled());
                    }
                    break block22;
                }
                dbConn.rollback();
            }
            Object var14_17 = null;
            if (dbConn == null) throw throwable;
            try {
                dbConn.close();
                throw throwable;
            }
            catch (SQLException ex) {
                this.log().error((Object)"handleUpdateService: Exception thrown during close: ", (Throwable)ex);
            }
            throw throwable;
            {
                catch (SQLException ex) {
                    this.log().error((Object)"handleUpdateService: Exception thrown during commit/rollback: ", (Throwable)ex);
                    throw new FailedOperationException(ex.getMessage());
                }
            }
            catch (Throwable throwable2) {
                Object var14_18 = null;
                if (dbConn == null) throw throwable2;
                try {
                    dbConn.close();
                    throw throwable2;
                }
                catch (SQLException ex) {
                    this.log().error((Object)"handleUpdateService: Exception thrown during close: ", (Throwable)ex);
                }
                throw throwable2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean interfaceExists(Connection dbConn, String nodeLabel, String ipaddr) throws SQLException {
        Object v1;
        boolean bl;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = dbConn.prepareStatement(SQL_QUERY_IPINTERFACE_EXIST);
            stmt.setString(1, nodeLabel);
            stmt.setString(2, ipaddr);
            rs = stmt.executeQuery();
            bl = rs.next();
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            block9: {
                Object v0;
                Object var8_8 = null;
                try {
                    if (rs != null) {
                        rs.close();
                    }
                    v0 = null;
                }
                catch (Throwable throwable2) {
                    Object var10_12;
                    v0 = var10_12 = null;
                }
                if (stmt == null) break block9;
                stmt.close();
            }
            throw throwable;
        }
        try {
            if (rs != null) {
                rs.close();
            }
            v1 = null;
        }
        catch (Throwable throwable) {
            Object var10_11;
            v1 = var10_11 = null;
        }
        if (stmt != null) {
            stmt.close();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Event> markAllServicesForInterfaceDeleted(Connection dbConn, String source, long nodeId, String ipAddr, long txNo) throws SQLException {
        Object v1;
        LinkedList<Event> linkedList;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            LinkedList<Event> eventsToSend = new LinkedList<Event>();
            String DB_FIND_SERVICES_FOR_INTERFACE = "SELECT DISTINCT service.serviceName FROM ifservices as ifservices, service as service WHERE ifservices.nodeID = ? and ifservices.ipAddr = ? and ifservices.status != 'D' and ifservices.serviceID = service.serviceID";
            stmt = dbConn.prepareStatement("SELECT DISTINCT service.serviceName FROM ifservices as ifservices, service as service WHERE ifservices.nodeID = ? and ifservices.ipAddr = ? and ifservices.status != 'D' and ifservices.serviceID = service.serviceID");
            stmt.setLong(1, nodeId);
            stmt.setString(2, ipAddr);
            rs = stmt.executeQuery();
            HashSet<String> services = new HashSet<String>();
            while (rs.next()) {
                String serviceName = rs.getString(1);
                this.log().debug((Object)("found service " + serviceName + " for ipAddr " + ipAddr + " node " + nodeId));
                services.add(serviceName);
            }
            rs.close();
            rs = null;
            stmt.close();
            stmt = null;
            String DB_MARK_SERVICES_FOR_INTERFACE = "UPDATE ifservices SET status = 'D' where ifservices.nodeID = ? and ifservices.ipAddr = ?";
            stmt = dbConn.prepareStatement("UPDATE ifservices SET status = 'D' where ifservices.nodeID = ? and ifservices.ipAddr = ?");
            stmt.setLong(1, nodeId);
            stmt.setString(2, ipAddr);
            stmt.executeUpdate();
            for (String serviceName : services) {
                this.log().debug((Object)("creating event for service " + serviceName + " for ipAddr " + ipAddr + " node " + nodeId));
                eventsToSend.add(EventUtils.createServiceDeletedEvent(source, nodeId, ipAddr, serviceName, txNo));
            }
            if (this.log().isDebugEnabled()) {
                this.log().debug((Object)("markServicesDeleted: marked service deleted: " + nodeId + "/" + ipAddr));
            }
            linkedList = eventsToSend;
            Object var17_14 = null;
        }
        catch (Throwable throwable) {
            block12: {
                Object v0;
                Object var17_15 = null;
                try {
                    if (rs != null) {
                        rs.close();
                    }
                    v0 = null;
                }
                catch (Throwable throwable2) {
                    Object var19_19;
                    v0 = var19_19 = null;
                }
                if (stmt == null) break block12;
                stmt.close();
            }
            throw throwable;
        }
        try {
            if (rs != null) {
                rs.close();
            }
            v1 = null;
        }
        catch (Throwable throwable) {
            Object var19_18;
            v1 = var19_18 = null;
        }
        if (stmt != null) {
            stmt.close();
        }
        return linkedList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Event> markInterfaceDeleted(Connection dbConn, String source, long nodeId, String ipAddr, long txNo) throws SQLException {
        List<Event> list;
        block6: {
            PreparedStatement stmt;
            block4: {
                List<Event> list2;
                block5: {
                    String DB_FIND_INTERFACE = "UPDATE ipinterface SET isManaged = 'D' WHERE nodeid = ? and ipAddr = ? and isManaged != 'D'";
                    stmt = null;
                    try {
                        stmt = dbConn.prepareStatement("UPDATE ipinterface SET isManaged = 'D' WHERE nodeid = ? and ipAddr = ? and isManaged != 'D'");
                        stmt.setLong(1, nodeId);
                        stmt.setString(2, ipAddr);
                        int count = stmt.executeUpdate();
                        if (this.log().isDebugEnabled()) {
                            this.log().debug((Object)("markServicesDeleted: marked service deleted: " + nodeId + "/" + ipAddr));
                        }
                        if (count <= 0) break block4;
                        list2 = Collections.singletonList(EventUtils.createInterfaceDeletedEvent(source, nodeId, ipAddr, txNo));
                        Object var13_11 = null;
                        if (stmt == null) break block5;
                    }
                    catch (Throwable throwable) {
                        block7: {
                            Object var13_13 = null;
                            if (stmt == null) break block7;
                            stmt.close();
                        }
                        throw throwable;
                    }
                    stmt.close();
                }
                return list2;
            }
            list = Collections.emptyList();
            Object var13_12 = null;
            if (stmt == null) break block6;
            stmt.close();
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Event> markInterfacesAndServicesDeleted(Connection dbConn, String source, long nodeId, long txNo) throws SQLException {
        Object v1;
        LinkedList<Event> linkedList;
        LinkedList<Event> eventsToSend = new LinkedList<Event>();
        String DB_FIND_IFS_FOR_NODE = "SELECT ipinterface.ipaddr FROM ipinterface WHERE ipinterface.nodeid = ? and ipinterface.ismanaged != 'D'";
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = dbConn.prepareStatement("SELECT ipinterface.ipaddr FROM ipinterface WHERE ipinterface.nodeid = ? and ipinterface.ismanaged != 'D'");
            stmt.setLong(1, nodeId);
            rs = stmt.executeQuery();
            HashSet<String> ipAddrs = new HashSet<String>();
            while (rs.next()) {
                String ipAddr = rs.getString(1);
                this.log().debug((Object)("found interface " + ipAddr + " for node " + nodeId));
                ipAddrs.add(ipAddr);
            }
            for (String ipAddr : ipAddrs) {
                this.log().debug((Object)("deleting interface " + ipAddr + " for node " + nodeId));
                eventsToSend.addAll(this.markAllServicesForInterfaceDeleted(dbConn, source, nodeId, ipAddr, txNo));
                eventsToSend.addAll(this.markInterfaceDeleted(dbConn, source, nodeId, ipAddr, txNo));
            }
            linkedList = eventsToSend;
            Object var15_12 = null;
        }
        catch (Throwable throwable) {
            block11: {
                Object v0;
                Object var15_13 = null;
                try {
                    if (rs != null) {
                        rs.close();
                    }
                    v0 = null;
                }
                catch (Throwable throwable2) {
                    Object var17_17;
                    v0 = var17_17 = null;
                }
                if (stmt == null) break block11;
                stmt.close();
            }
            throw throwable;
        }
        try {
            if (rs != null) {
                rs.close();
            }
            v1 = null;
        }
        catch (Throwable throwable) {
            Object var17_16;
            v1 = var17_16 = null;
        }
        if (stmt != null) {
            stmt.close();
        }
        return linkedList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Event> markNodeDeleted(Connection dbConn, String source, long nodeId, long txNo) throws SQLException {
        List<Event> list;
        block5: {
            PreparedStatement stmt;
            block3: {
                List<Event> list2;
                block4: {
                    String DB_FIND_INTERFACE = "UPDATE node SET nodeType = 'D' WHERE nodeid = ? and nodeType != 'D'";
                    stmt = null;
                    try {
                        stmt = dbConn.prepareStatement("UPDATE node SET nodeType = 'D' WHERE nodeid = ? and nodeType != 'D'");
                        stmt.setLong(1, nodeId);
                        int count = stmt.executeUpdate();
                        this.log().debug((Object)("markServicesDeleted: marked service deleted: " + nodeId));
                        if (count <= 0) break block3;
                        list2 = Collections.singletonList(EventUtils.createNodeDeletedEvent(source, nodeId, txNo));
                        Object var12_10 = null;
                        if (stmt == null) break block4;
                    }
                    catch (Throwable throwable) {
                        block6: {
                            Object var12_12 = null;
                            if (stmt == null) break block6;
                            stmt.close();
                        }
                        throw throwable;
                    }
                    stmt.close();
                }
                return list2;
            }
            list = Collections.emptyList();
            Object var12_11 = null;
            if (stmt == null) break block5;
            stmt.close();
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Event> markServiceDeleted(Connection dbConn, String source, long nodeId, String ipAddr, String service, long txNo) throws SQLException {
        List<Event> list;
        block6: {
            PreparedStatement stmt;
            block4: {
                List<Event> list2;
                block5: {
                    stmt = null;
                    String DB_MARK_SERVICE_DELETED = "UPDATE ifservices SET status='D' FROM service WHERE ifservices.serviceID = service.serviceID AND ifservices.nodeID=? AND ifservices.ipAddr=? AND service.serviceName=?";
                    try {
                        stmt = dbConn.prepareStatement("UPDATE ifservices SET status='D' FROM service WHERE ifservices.serviceID = service.serviceID AND ifservices.nodeID=? AND ifservices.ipAddr=? AND service.serviceName=?");
                        stmt.setLong(1, nodeId);
                        stmt.setString(2, ipAddr);
                        stmt.setString(3, service);
                        int count = stmt.executeUpdate();
                        if (this.log().isDebugEnabled()) {
                            this.log().debug((Object)("markServiceDeleted: marked service deleted: " + nodeId + "/" + ipAddr + "/" + service));
                        }
                        if (count <= 0) break block4;
                        list2 = Collections.singletonList(EventUtils.createServiceDeletedEvent(source, nodeId, ipAddr, service, txNo));
                        Object var14_12 = null;
                        if (stmt == null) break block5;
                    }
                    catch (Throwable throwable) {
                        block7: {
                            Object var14_14 = null;
                            if (stmt == null) break block7;
                            stmt.close();
                        }
                        throw throwable;
                    }
                    stmt.close();
                }
                return list2;
            }
            list = Collections.emptyList();
            Object var14_13 = null;
            if (stmt == null) break block6;
            stmt.close();
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean nodeExists(Connection dbConn, String nodeLabel) throws SQLException {
        Object v1;
        boolean bl;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = dbConn.prepareStatement(SQL_QUERY_NODE_EXIST);
            stmt.setString(1, nodeLabel);
            rs = stmt.executeQuery();
            bl = rs.next();
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            block9: {
                Object v0;
                Object var7_7 = null;
                try {
                    if (rs != null) {
                        rs.close();
                    }
                    v0 = null;
                }
                catch (Throwable throwable2) {
                    Object var9_11;
                    v0 = var9_11 = null;
                }
                if (stmt == null) break block9;
                stmt.close();
            }
            throw throwable;
        }
        try {
            if (rs != null) {
                rs.close();
            }
            v1 = null;
        }
        catch (Throwable throwable) {
            Object var9_10;
            v1 = var9_10 = null;
        }
        if (stmt != null) {
            stmt.close();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean serviceMappingExists(Connection dbConn, String ipaddr, String serviceName) throws SQLException {
        boolean bl;
        block2: {
            PreparedStatement stmt = null;
            try {
                boolean mapExists;
                stmt = dbConn.prepareStatement(SQL_QUERY_SERVICE_MAPPING_EXIST);
                stmt.setString(1, ipaddr);
                stmt.setString(2, serviceName);
                ResultSet rs = stmt.executeQuery();
                bl = mapExists = rs.next();
                Object var9_8 = null;
                if (stmt == null) break block2;
            }
            catch (Throwable throwable) {
                block3: {
                    Object var9_9 = null;
                    if (stmt == null) break block3;
                    stmt.close();
                }
                throw throwable;
            }
            stmt.close();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int verifyServiceExists(Connection dbConn, String serviceName) throws SQLException, FailedOperationException {
        Object v1;
        int n;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = dbConn.prepareStatement(SQL_RETRIEVE_SERVICE_ID);
            stmt.setString(1, serviceName);
            rs = stmt.executeQuery();
            int serviceId = -1;
            while (rs.next()) {
                this.log().debug((Object)("verifyServiceExists: retrieve serviceid for service " + serviceName));
                serviceId = rs.getInt(1);
            }
            if (serviceId < 0) {
                if (this.log().isDebugEnabled()) {
                    this.log().debug((Object)("verifyServiceExists: the specified service: " + serviceName + " does not exist in the database."));
                }
                throw new FailedOperationException("Invalid service: " + serviceName);
            }
            n = serviceId;
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            block12: {
                Object v0;
                Object var8_8 = null;
                try {
                    if (rs != null) {
                        rs.close();
                    }
                    v0 = null;
                }
                catch (Throwable throwable2) {
                    Object var10_12;
                    v0 = var10_12 = null;
                }
                if (stmt == null) break block12;
                stmt.close();
            }
            throw throwable;
        }
        try {
            if (rs != null) {
                rs.close();
            }
            v1 = null;
        }
        catch (Throwable throwable) {
            Object var10_11;
            v1 = var10_11 = null;
        }
        if (stmt != null) {
            stmt.close();
        }
        return n;
    }

    private void verifyInterfaceExists(Connection dbConn, String nodeLabel, String ipaddr) throws SQLException, FailedOperationException {
        if (!this.interfaceExists(dbConn, nodeLabel, ipaddr)) {
            throw new FailedOperationException("Interface " + ipaddr + " does not exist on a node with nodeLabel " + nodeLabel);
        }
    }

    public void setSuspectEventProcessorFactory(SuspectEventProcessorFactory suspectEventProcessorFactory) {
        this.m_suspectEventProcessorFactory = suspectEventProcessorFactory;
    }

    public void setScheduler(Scheduler scheduler) {
        this.m_scheduler = scheduler;
    }

    public void setSuspectQueue(FifoQueue<Runnable> suspectQ) {
        this.m_suspectQ = suspectQ;
    }

    public void setLocalServer(String localServer) {
        this.m_localServer = localServer;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.state((this.m_suspectEventProcessorFactory != null ? 1 : 0) != 0, (String)"The suspectEventProcessor must be set");
        Assert.state((this.m_scheduler != null ? 1 : 0) != 0, (String)"The schedule must be set");
        Assert.state((this.m_suspectQ != null ? 1 : 0) != 0, (String)"The suspectQueue must be set");
        Assert.state((this.m_localServer != null ? 1 : 0) != 0, (String)"The localServer must be set");
    }
}

