/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.trapd;

import java.net.InetAddress;
import java.util.LinkedHashMap;
import java.util.Map;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.opennms.core.utils.Base64;
import org.opennms.netmgt.mock.EventAnticipator;
import org.opennms.netmgt.mock.MockEventIpcManager;
import org.opennms.netmgt.snmp.SnmpInstId;
import org.opennms.netmgt.snmp.SnmpObjId;
import org.opennms.netmgt.snmp.SnmpTrapBuilder;
import org.opennms.netmgt.snmp.SnmpUtils;
import org.opennms.netmgt.snmp.SnmpV1TrapBuilder;
import org.opennms.netmgt.snmp.SnmpValue;
import org.opennms.netmgt.snmp.SnmpValueFactory;
import org.opennms.netmgt.trapd.MockTrapdIpMgr;
import org.opennms.netmgt.trapd.TrapQueueProcessor;
import org.opennms.netmgt.trapd.Trapd;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.test.PropertySettingTestSuite;
import org.opennms.test.mock.MockLogAppender;
import org.springframework.test.AbstractDependencyInjectionSpringContextTests;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TrapHandlerTest
extends AbstractDependencyInjectionSpringContextTests {
    private Trapd m_trapd = null;
    private EventAnticipator m_anticipator;
    private MockEventIpcManager m_eventMgr;
    private InetAddress m_localhost = null;
    private int m_snmpTrapPort = 10000;
    private boolean m_doStop = false;
    private static final String m_ip = "127.0.0.1";
    private static final long m_nodeId = 1L;
    private MockTrapdIpMgr m_trapdIpMgr;
    private TrapQueueProcessor m_processor;

    public static TestSuite suite() {
        Class<TrapHandlerTest> testClass = TrapHandlerTest.class;
        TestSuite suite = new TestSuite(testClass.getName());
        suite.addTest((Test)new PropertySettingTestSuite(testClass, "JoeSnmp Tests", "org.opennms.snmp.strategyClass", "org.opennms.netmgt.snmp.joesnmp.JoeSnmpStrategy"));
        suite.addTest((Test)new PropertySettingTestSuite(testClass, "Snmp4J Tests", "org.opennms.snmp.strategyClass", "org.opennms.netmgt.snmp.snmp4j.Snmp4JStrategy"));
        return suite;
    }

    protected String[] getConfigLocations() {
        return new String[]{"classpath:META-INF/opennms/applicationContext-trapDaemon.xml", "classpath:org/opennms/netmgt/trapd/applicationContext-trapDaemonTest.xml", "classpath:META-INF/opennms/mockEventIpcManager.xml"};
    }

    protected void onSetUp() throws Exception {
        super.onSetUp();
        super.setDirty();
        MockLogAppender.setupLogging();
        this.m_anticipator = new EventAnticipator();
        this.m_eventMgr.setEventAnticipator(this.m_anticipator);
        this.m_localhost = InetAddress.getByName(m_ip);
        this.m_trapdIpMgr.clearKnownIpsMap();
        this.m_trapdIpMgr.setNodeId(m_ip, 1L);
        this.m_trapd.start();
        this.m_doStop = true;
    }

    public void finishUp() {
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.m_eventMgr.finishProcessingEvents();
        this.m_anticipator.verifyAnticipated(1000L, 0L, 0L, 0, 0);
    }

    public void onTearDown() throws Exception {
        if (this.m_trapd != null && this.m_doStop) {
            this.m_trapd.stop();
            this.m_trapd = null;
        }
        super.onTearDown();
    }

    public void testV1TrapNoNewSuspect() throws Exception {
        this.m_trapdIpMgr.clearKnownIpsMap();
        this.anticipateAndSend(false, false, "uei.opennms.org/default/trap", "v1", null, 6, 1);
    }

    public void testV2TrapNoNewSuspect() throws Exception {
        this.m_trapdIpMgr.clearKnownIpsMap();
        this.anticipateAndSend(false, false, "uei.opennms.org/default/trap", "v2c", null, 6, 1);
    }

    public void testV1TrapNewSuspect() throws Exception {
        this.m_trapdIpMgr.clearKnownIpsMap();
        this.anticipateAndSend(true, false, "uei.opennms.org/default/trap", "v1", null, 6, 1);
    }

    public void testV2TrapNewSuspect() throws Exception {
        this.m_trapdIpMgr.clearKnownIpsMap();
        this.anticipateAndSend(true, false, "uei.opennms.org/default/trap", "v2c", null, 6, 1);
    }

    public void testV1EnterpriseIdAndGenericMatch() throws Exception {
        this.anticipateAndSend(false, true, "uei.opennms.org/IETF/BGP/traps/bgpEstablished", "v1", ".1.3.6.1.2.1.15.7", 6, 1);
    }

    public void testV2EnterpriseIdAndGenericAndSpecificMatch() throws Exception {
        this.anticipateAndSend(false, true, "uei.opennms.org/IETF/BGP/traps/bgpEstablished", "v2c", ".1.3.6.1.2.1.15.7", 6, 1);
    }

    public void testV1EnterpriseIdAndGenericAndSpecificAndMatchWithVarbinds() throws Exception {
        SnmpValueFactory valueFactory = SnmpUtils.getValueFactory();
        LinkedHashMap<String, SnmpValue> varbinds = new LinkedHashMap<String, SnmpValue>();
        varbinds.put(".1.3.6.1.4.1.11.2.14.11.1.7.2.1.4.2404", valueFactory.getInt32(3));
        varbinds.put(".1.3.6.1.4.1.11.2.14.11.1.7.2.1.5.2404", valueFactory.getInt32(2));
        varbinds.put(".1.3.6.1.4.1.11.2.14.11.1.7.2.1.6.2404", valueFactory.getInt32(5));
        varbinds.put(".1.3.6.1.4.1.11.2.14.11.1.7.3.0.2404", valueFactory.getOctetString("http://a.b.c.d/cgi/fDetail?index=2404".getBytes()));
        this.anticipateAndSend(false, true, "uei.opennms.org/vendor/HP/traps/hpicfFaultFinderTrap", "v1", ".1.3.6.1.4.1.11.2.14.12.1", 6, 5, varbinds);
    }

    public void testV2EnterpriseIdAndGenericAndSpecificAndMatchWithVarbinds() throws Exception {
        SnmpValueFactory valueFactory = SnmpUtils.getValueFactory();
        LinkedHashMap<String, SnmpValue> varbinds = new LinkedHashMap<String, SnmpValue>();
        varbinds.put(".1.3.6.1.4.1.11.2.14.11.1.7.2.1.4.2404", valueFactory.getInt32(3));
        varbinds.put(".1.3.6.1.4.1.11.2.14.11.1.7.2.1.5.2404", valueFactory.getInt32(2));
        varbinds.put(".1.3.6.1.4.1.11.2.14.11.1.7.2.1.6.2404", valueFactory.getInt32(5));
        varbinds.put(".1.3.6.1.4.1.11.2.14.11.1.7.3.0.2404", valueFactory.getOctetString("http://a.b.c.d/cgi/fDetail?index=2404".getBytes()));
        this.anticipateAndSend(false, true, "uei.opennms.org/vendor/HP/traps/hpicfFaultFinderTrap", "v2c", ".1.3.6.1.4.1.11.2.14.12.1", 6, 5, varbinds);
    }

    public void FIXMEtestV1EnterpriseIdAndGenericAndSpecificAndMatchWithVarbindsAndTC() throws Exception {
        SnmpValueFactory valueFactory = SnmpUtils.getValueFactory();
        LinkedHashMap<String, SnmpValue> varbinds = new LinkedHashMap<String, SnmpValue>();
        varbinds.put(".1.3.6.1.4.1.14179.2.6.2.20.0", valueFactory.getOctetString(new byte[]{0, 20, -15, -83, -89, 80}));
        this.anticipateAndSend(false, true, "uei.opennms.org/vendor/cisco/bsnAPNoiseProfileUpdatedToPass", "v1", ".1.3.6.1.4.1.14179.2.6.3", 6, 38, varbinds);
    }

    public void FIXMEtestV2EnterpriseIdAndGenericAndSpecificAndMatchWithVarbindsAndTC() throws Exception {
        SnmpValueFactory valueFactory = SnmpUtils.getValueFactory();
        byte[] macAddr = new byte[]{0, 20, -15, -83, -89, 80};
        String encoded = new String(Base64.encodeBase64((byte[])macAddr));
        byte[] decodeBytes = Base64.decodeBase64((char[])encoded.toCharArray());
        this.assertByteArrayEquals(macAddr, decodeBytes);
        String decoded = new String(macAddr);
        byte[] roundTripMacAddr = decoded.getBytes();
        this.assertByteArrayEquals(macAddr, roundTripMacAddr);
        LinkedHashMap<String, SnmpValue> varbinds = new LinkedHashMap<String, SnmpValue>();
        varbinds.put(".1.3.6.1.4.1.14179.2.6.2.20.0", valueFactory.getOctetString(macAddr));
        this.anticipateAndSend(false, true, "uei.opennms.org/vendor/cisco/bsnAPNoiseProfileUpdatedToPass", "v2c", ".1.3.6.1.4.1.14179.2.6.3", 6, 38, varbinds);
    }

    private void assertByteArrayEquals(byte[] macAddr, byte[] bytes) {
        TrapHandlerTest.assertEquals((String)("expect length: " + macAddr.length), (int)macAddr.length, (int)bytes.length);
        for (int i = 0; i < macAddr.length; ++i) {
            TrapHandlerTest.assertEquals((String)("Expected byte " + i + " to match"), (byte)macAddr[i], (byte)bytes[i]);
        }
    }

    public void testV2EnterpriseIdAndGenericAndSpecificMatchWithZero() throws Exception {
        this.anticipateAndSend(false, true, "uei.opennms.org/IETF/BGP/traps/bgpEstablished", "v2c", ".1.3.6.1.2.1.15.7.0", 6, 1);
    }

    public void testV2EnterpriseIdAndGenericAndSpecificMissWithExtraZeros() throws Exception {
        this.anticipateAndSend(false, true, "uei.opennms.org/default/trap", "v2c", ".1.3.6.1.2.1.15.7.0.0", 6, 1);
    }

    public void testV1EnterpriseIdAndGenericAndSpecificMissWithWrongGeneric() throws Exception {
        this.anticipateAndSend(false, true, "uei.opennms.org/default/trap", "v1", ".1.3.6.1.2.1.15.7", 5, 1);
    }

    public void testV1EnterpriseIdAndGenericAndSpecificMissWithWrongSpecific() throws Exception {
        this.anticipateAndSend(false, true, "uei.opennms.org/default/trap", "v1", ".1.3.6.1.2.1.15.7", 6, 50);
    }

    public void testV1GenericMatch() throws Exception {
        this.anticipateAndSend(false, true, "uei.opennms.org/generic/traps/SNMP_Cold_Start", "v1", null, 0, 0);
    }

    public void testV2GenericMatch() throws Exception {
        this.anticipateAndSend(false, true, "uei.opennms.org/generic/traps/SNMP_Cold_Start", "v2c", ".1.3.6.1.6.3.1.1.5.1", 0, 0);
    }

    public void testV1TrapDroppedEvent() throws Exception {
        this.anticipateAndSend(false, true, null, "v1", ".1.3.6.1.2.1.15.7", 6, 2);
    }

    public void testV2TrapDroppedEvent() throws Exception {
        this.anticipateAndSend(false, true, null, "v2c", ".1.3.6.1.2.1.15.7", 6, 2);
    }

    public void testV1TrapDefaultEvent() throws Exception {
        this.anticipateAndSend(false, true, "uei.opennms.org/default/trap", "v1", null, 6, 1);
    }

    public void testV2TrapDefaultEvent() throws Exception {
        this.anticipateAndSend(false, true, "uei.opennms.org/default/trap", "v2c", null, 6, 1);
    }

    public void testNodeGainedModifiesIpMgr() throws Exception {
        long nodeId = 2L;
        this.m_processor.setNewSuspect(Boolean.valueOf(true));
        this.anticipateEvent("uei.opennms.org/default/trap", m_ip, nodeId);
        Event event = this.anticipateEvent("uei.opennms.org/nodes/nodeGainedInterface", m_ip, nodeId);
        this.m_eventMgr.sendNow(event);
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        this.sendTrap("v1", null, 6, 1);
        this.finishUp();
    }

    public void testInterfaceReparentedModifiesIpMgr() throws Exception {
        long nodeId = 2L;
        this.m_processor.setNewSuspect(Boolean.valueOf(true));
        this.anticipateEvent("uei.opennms.org/default/trap", m_ip, nodeId);
        Event event = this.anticipateEvent("uei.opennms.org/nodes/interfaceReparented", m_ip, nodeId);
        this.m_eventMgr.sendNow(event);
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        this.sendTrap("v1", null, 6, 1);
        this.finishUp();
    }

    public void testInterfaceDeletedModifiesIpMgr() throws Exception {
        long nodeId = 0L;
        this.m_processor.setNewSuspect(Boolean.valueOf(true));
        this.anticipateEvent("uei.opennms.org/default/trap", m_ip, nodeId);
        Event event = this.anticipateEvent("uei.opennms.org/nodes/interfaceDeleted", m_ip, nodeId);
        this.m_eventMgr.sendNow(event);
        this.anticipateEvent("uei.opennms.org/internal/discovery/newSuspect", m_ip, nodeId);
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        this.sendTrap("v1", null, 6, 1);
        this.finishUp();
    }

    public Event anticipateEvent(String uei) {
        return this.anticipateEvent(uei, m_ip, 1L);
    }

    public Event anticipateEvent(String uei, String ip, long nodeId) {
        Event event = new Event();
        event.setInterface(ip);
        event.setNodeid(nodeId);
        event.setUei(uei);
        this.m_anticipator.anticipateEvent(event);
        return event;
    }

    public void anticipateAndSend(boolean newSuspectOnTrap, boolean nodeKnown, String event, String version, String enterprise, int generic, int specific) throws Exception {
        this.m_processor.setNewSuspect(Boolean.valueOf(newSuspectOnTrap));
        if (newSuspectOnTrap) {
            this.anticipateEvent("uei.opennms.org/internal/discovery/newSuspect", m_ip, 0L);
        }
        if (event != null) {
            if (nodeKnown) {
                this.anticipateEvent(event);
            } else {
                this.anticipateEvent(event, m_ip, 0L);
            }
        }
        this.sendTrap(version, enterprise, generic, specific);
        this.finishUp();
    }

    public void anticipateAndSend(boolean newSuspectOnTrap, boolean nodeKnown, String event, String version, String enterprise, int generic, int specific, LinkedHashMap<String, SnmpValue> varbinds) throws Exception {
        this.m_processor.setNewSuspect(Boolean.valueOf(newSuspectOnTrap));
        if (newSuspectOnTrap) {
            this.anticipateEvent("uei.opennms.org/internal/discovery/newSuspect", m_ip, 0L);
        }
        if (event != null) {
            if (nodeKnown) {
                this.anticipateEvent(event);
            } else {
                this.anticipateEvent(event, m_ip, 0L);
            }
        }
        this.sendTrap(version, enterprise, generic, specific, varbinds);
        this.finishUp();
    }

    public void sendTrap(String version, String enterprise, int generic, int specific) throws Exception {
        if (enterprise == null) {
            enterprise = ".0.0";
        }
        if (version.equals("v1")) {
            this.sendV1Trap(enterprise, generic, specific);
        } else if (version.equals("v2c")) {
            this.sendV2Trap(enterprise, specific);
        } else {
            throw new Exception("unsupported SNMP version for test: " + version);
        }
    }

    private void sendTrap(String version, String enterprise, int generic, int specific, LinkedHashMap<String, SnmpValue> varbinds) throws Exception {
        if (enterprise == null) {
            enterprise = ".0.0";
        }
        if (version.equals("v1")) {
            this.sendV1Trap(enterprise, generic, specific, varbinds);
        } else if (version.equals("v2c")) {
            this.sendV2Trap(enterprise, specific, varbinds);
        } else {
            throw new Exception("unsupported SNMP version for test: " + version);
        }
    }

    public void sendV1Trap(String enterprise, int generic, int specific) throws Exception {
        SnmpV1TrapBuilder pdu = SnmpUtils.getV1TrapBuilder();
        pdu.setEnterprise(SnmpObjId.get((String)enterprise));
        pdu.setGeneric(generic);
        pdu.setSpecific(specific);
        pdu.setTimeStamp(0L);
        pdu.setAgentAddress(this.m_localhost);
        pdu.send(this.m_localhost.getHostAddress(), this.m_snmpTrapPort, "public");
    }

    public void sendV1Trap(String enterprise, int generic, int specific, LinkedHashMap<String, SnmpValue> varbinds) throws Exception {
        SnmpV1TrapBuilder pdu = SnmpUtils.getV1TrapBuilder();
        pdu.setEnterprise(SnmpObjId.get((String)enterprise));
        pdu.setGeneric(generic);
        pdu.setSpecific(specific);
        pdu.setTimeStamp(0L);
        pdu.setAgentAddress(this.m_localhost);
        for (Map.Entry<String, SnmpValue> pairs : varbinds.entrySet()) {
            pdu.addVarBind(SnmpObjId.get((String)pairs.getKey()), pairs.getValue());
        }
        pdu.send(this.m_localhost.getHostAddress(), this.m_snmpTrapPort, "public");
    }

    public void sendV2Trap(String enterprise, int specific) throws Exception {
        SnmpObjId trapOID;
        SnmpObjId enterpriseId = SnmpObjId.get((String)enterprise);
        boolean isGeneric = false;
        if (SnmpObjId.get((String)".1.3.6.1.6.3.1.1.5").isPrefixOf(enterpriseId)) {
            isGeneric = true;
            trapOID = enterpriseId;
        } else {
            trapOID = SnmpObjId.get((SnmpObjId)enterpriseId, (SnmpObjId)new SnmpInstId(specific));
        }
        SnmpTrapBuilder pdu = SnmpUtils.getV2TrapBuilder();
        pdu.addVarBind(SnmpObjId.get((String)".1.3.6.1.2.1.1.3.0"), SnmpUtils.getValueFactory().getTimeTicks(0L));
        pdu.addVarBind(SnmpObjId.get((String)".1.3.6.1.6.3.1.1.4.1.0"), SnmpUtils.getValueFactory().getObjectId(trapOID));
        if (isGeneric) {
            pdu.addVarBind(SnmpObjId.get((String)".1.3.6.1.6.3.1.1.4.3.0"), SnmpUtils.getValueFactory().getObjectId(enterpriseId));
        }
        pdu.send(this.m_localhost.getHostAddress(), this.m_snmpTrapPort, "public");
    }

    public void sendV2Trap(String enterprise, int specific, LinkedHashMap<String, SnmpValue> varbinds) throws Exception {
        SnmpObjId trapOID;
        SnmpObjId enterpriseId = SnmpObjId.get((String)enterprise);
        boolean isGeneric = false;
        if (SnmpObjId.get((String)".1.3.6.1.6.3.1.1.5").isPrefixOf(enterpriseId)) {
            isGeneric = true;
            trapOID = enterpriseId;
        } else {
            trapOID = SnmpObjId.get((SnmpObjId)enterpriseId, (SnmpObjId)new SnmpInstId(specific));
        }
        SnmpTrapBuilder pdu = SnmpUtils.getV2TrapBuilder();
        pdu.addVarBind(SnmpObjId.get((String)".1.3.6.1.2.1.1.3.0"), SnmpUtils.getValueFactory().getTimeTicks(0L));
        pdu.addVarBind(SnmpObjId.get((String)".1.3.6.1.6.3.1.1.4.1.0"), SnmpUtils.getValueFactory().getObjectId(trapOID));
        if (isGeneric) {
            pdu.addVarBind(SnmpObjId.get((String)".1.3.6.1.6.3.1.1.4.3.0"), SnmpUtils.getValueFactory().getObjectId(enterpriseId));
        }
        for (Map.Entry<String, SnmpValue> entry : varbinds.entrySet()) {
            pdu.addVarBind(SnmpObjId.get((String)entry.getKey()), entry.getValue());
        }
        pdu.send(this.m_localhost.getHostAddress(), this.m_snmpTrapPort, "public");
    }

    public Trapd getDaemon() {
        return this.m_trapd;
    }

    public void setDaemon(Trapd trapd) {
        this.m_trapd = trapd;
    }

    public MockTrapdIpMgr getTrapdIpMgr() {
        return this.m_trapdIpMgr;
    }

    public void setTrapdIpMgr(MockTrapdIpMgr trapdIpMgr) {
        this.m_trapdIpMgr = trapdIpMgr;
    }

    public TrapQueueProcessor getProcessor() {
        return this.m_processor;
    }

    public void setProcessor(TrapQueueProcessor processor) {
        this.m_processor = processor;
    }

    public MockEventIpcManager getEventMgr() {
        return this.m_eventMgr;
    }

    public void setEventMgr(MockEventIpcManager eventMgr) {
        this.m_eventMgr = eventMgr;
    }
}

