/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.threshd;

import java.util.Collection;
import java.util.HashMap;
import junit.framework.TestCase;
import org.opennms.netmgt.config.threshd.Basethresholddef;
import org.opennms.netmgt.config.threshd.Expression;
import org.opennms.netmgt.threshd.BaseThresholdDefConfigWrapper;
import org.opennms.netmgt.threshd.ExpressionConfigWrapper;
import org.opennms.netmgt.threshd.ThresholdEntity;

public class ThresholdExpressionTestCase
extends TestCase {
    Expression expression;

    public void setUp() {
        this.expression = new Expression();
        this.expression.setType("high");
        this.expression.setDsType("ds-type");
        this.expression.setValue(99.0);
        this.expression.setRearm(0.5);
        this.expression.setTrigger(1);
    }

    public void testEvaluateEvaluateSingleItemWithDivision() throws Exception {
        this.expression.setExpression("dsname/10");
        ExpressionConfigWrapper wrapper = new ExpressionConfigWrapper(this.expression);
        HashMap<String, Double> values = new HashMap<String, Double>();
        values.put("dsname", 1000.0);
        double result = wrapper.evaluate(values);
        ThresholdExpressionTestCase.assertEquals((String)"Threshold Expression result", (Object)new Double(result), (Object)new Double(100.0));
    }

    public void testEvaluateEvaluateSingleItemWithMultiply() throws Exception {
        this.expression.setExpression("dsname*10");
        ExpressionConfigWrapper wrapper = new ExpressionConfigWrapper(this.expression);
        HashMap<String, Double> values = new HashMap<String, Double>();
        values.put("dsname", 100.0);
        double result = wrapper.evaluate(values);
        ThresholdExpressionTestCase.assertEquals((String)"Threshold Expression result", (Object)new Double(result), (Object)new Double(1000.0));
    }

    public void testEvaluateEvaluateSingleItemWithSubtraction() throws Exception {
        this.expression.setExpression("dsname-10");
        ExpressionConfigWrapper wrapper = new ExpressionConfigWrapper(this.expression);
        HashMap<String, Double> values = new HashMap<String, Double>();
        values.put("dsname", 100.0);
        double result = wrapper.evaluate(values);
        ThresholdExpressionTestCase.assertEquals((String)"Threshold Expression result", (Object)new Double(result), (Object)new Double(90.0));
    }

    public void testEvaluateEvaluateSingleItemWithAddition() throws Exception {
        this.expression.setExpression("dsname+10");
        ExpressionConfigWrapper wrapper = new ExpressionConfigWrapper(this.expression);
        HashMap<String, Double> values = new HashMap<String, Double>();
        values.put("dsname", 100.0);
        double result = wrapper.evaluate(values);
        ThresholdExpressionTestCase.assertEquals((String)"Threshold Expression result", (Object)new Double(result), (Object)new Double(110.0));
    }

    public void testEvaluateEvaluateMultipleItemsDivided() throws Exception {
        this.expression.setExpression("dsname1/dsname2");
        ExpressionConfigWrapper wrapper = new ExpressionConfigWrapper(this.expression);
        HashMap<String, Double> values = new HashMap<String, Double>();
        values.put("dsname1", 100.0);
        values.put("dsname2", 5.0);
        double result = wrapper.evaluate(values);
        ThresholdExpressionTestCase.assertEquals((String)"Threshold Expression result", (Object)new Double(result), (Object)new Double(20.0));
    }

    public void testEvaluateEvaluateMultipleItemsMultiplied() throws Exception {
        this.expression.setExpression("dsname1*dsname2");
        ExpressionConfigWrapper wrapper = new ExpressionConfigWrapper(this.expression);
        HashMap<String, Double> values = new HashMap<String, Double>();
        values.put("dsname1", 20.0);
        values.put("dsname2", 5.0);
        double result = wrapper.evaluate(values);
        ThresholdExpressionTestCase.assertEquals((String)"Threshold Expression result", (Object)new Double(result), (Object)new Double(100.0));
    }

    public void testEvaluateEvaluateMultipleItemsAdded() throws Exception {
        this.expression.setExpression("dsname1+dsname2");
        ExpressionConfigWrapper wrapper = new ExpressionConfigWrapper(this.expression);
        HashMap<String, Double> values = new HashMap<String, Double>();
        values.put("dsname1", 20.0);
        values.put("dsname2", 5.0);
        double result = wrapper.evaluate(values);
        ThresholdExpressionTestCase.assertEquals((String)"Threshold Expression result", (Object)new Double(result), (Object)new Double(25.0));
    }

    public void testEvaluateEvaluateMultipleItemsSubtracted() throws Exception {
        this.expression.setExpression("dsname1-dsname2");
        ExpressionConfigWrapper wrapper = new ExpressionConfigWrapper(this.expression);
        HashMap<String, Double> values = new HashMap<String, Double>();
        values.put("dsname1", 20.0);
        values.put("dsname2", 5.0);
        double result = wrapper.evaluate(values);
        ThresholdExpressionTestCase.assertEquals((String)"Threshold Expression result", (Object)new Double(result), (Object)new Double(15.0));
    }

    public void testSemiComplexExpression() throws Exception {
        this.expression.setExpression("(hrStorageSize-hrStorageUsed)*hrStorageAllocationUnits");
        ExpressionConfigWrapper wrapper = new ExpressionConfigWrapper(this.expression);
        HashMap<String, Double> values = new HashMap<String, Double>();
        values.put("hrStorageAllocationUnits", 1024.0);
        values.put("hrStorageSize", 2048.0);
        values.put("hrStorageUsed", 1024.0);
        double result = wrapper.evaluate(values);
        ThresholdExpressionTestCase.assertEquals((String)"Threshold Expression result", (Object)new Double(result), (Object)new Double(1048576.0));
    }

    public void testThresholdEntityRequiredDataSources() throws Exception {
        ThresholdEntity entity = new ThresholdEntity();
        this.expression.setExpression("(hrStorageSize-hrStorageUsed)*hrStorageAllocationUnits");
        BaseThresholdDefConfigWrapper wrapper = BaseThresholdDefConfigWrapper.getConfigWrapper((Basethresholddef)this.expression);
        entity.addThreshold(wrapper);
        Collection dataSources = entity.getRequiredDatasources();
        ThresholdExpressionTestCase.assertTrue((String)"Required data sources contains name", (boolean)dataSources.contains("hrStorageSize"));
        ThresholdExpressionTestCase.assertTrue((String)"Required data sources contains name", (boolean)dataSources.contains("hrStorageUsed"));
        ThresholdExpressionTestCase.assertTrue((String)"Required data sources contains name", (boolean)dataSources.contains("hrStorageAllocationUnits"));
    }
}

