/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.threshd;

import org.opennms.netmgt.rrd.RrdUtils;
import org.opennms.netmgt.threshd.LatencyThresholder;
import org.opennms.netmgt.threshd.ThresholdNetworkInterface;
import org.opennms.netmgt.threshd.ThresholderTestCase;
import org.opennms.test.mock.MockLogAppender;

public class LatencyThresholderIntegrationTest
extends ThresholderTestCase {
    protected void setUp() throws Exception {
        super.setUp();
        MockLogAppender.setupLogging();
        this.setupDatabase();
        this.createMockRrd();
        this.setupEventManager();
        this.replayMocks();
        String dirName = "target/threshd-test/192.168.1.1";
        String fileName = "icmp" + RrdUtils.getExtension();
        int nodeId = 1;
        String ipAddress = "192.168.1.1";
        String serviceName = "ICMP";
        String groupName = "icmp-latency";
        this.setupThresholdConfig(dirName, fileName, nodeId, ipAddress, serviceName, groupName);
        this.m_thresholder = new LatencyThresholder();
        this.m_thresholder.initialize(this.m_serviceParameters);
        this.m_thresholder.initialize((ThresholdNetworkInterface)this.m_iface, this.m_parameters);
        this.verifyMocks();
        this.expectRrdStrategyCalls();
    }

    protected void tearDown() throws Exception {
        RrdUtils.setStrategy(null);
        MockLogAppender.assertNoWarningsOrGreater();
        super.tearDown();
    }

    public void xtestIcmpDouble() throws Exception {
        this.setupFetchSequence("icmp-double", 69000.0, 79000.0, 74999.0, 74998.0);
        this.replayMocks();
        this.ensureExceededAfterFetches("icmp-double", 3);
        this.verifyMocks();
    }

    public void testNormalValue() throws Exception {
        this.setupFetchSequence("icmp", 69000.0, 79000.0, 74999.0, 74998.0);
        this.replayMocks();
        this.ensureNoEventAfterFetches("icmp", 4);
        this.verifyMocks();
    }

    public void testBigValue() throws Exception {
        this.setupFetchSequence("icmp", 79000.0, 80000.0, 84999.0, 84998.0, 97000.0);
        this.replayMocks();
        this.ensureExceededAfterFetches("icmp", 3);
        this.ensureNoEventAfterFetches("icmp", 2);
        this.verifyMocks();
    }

    public void testRearm() throws Exception {
        double[] values = new double[]{79000.0, 80000.0, 84999.0, 84998.0, 15000.0, 77000.0, 77000.0, 77000.0};
        this.setupFetchSequence("icmp", values);
        this.replayMocks();
        this.ensureExceededAfterFetches("icmp", 3);
        this.ensureRearmedAfterFetches("icmp", 2);
        this.ensureExceededAfterFetches("icmp", 3);
        this.verifyMocks();
    }
}

