/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.pollables;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.concurrent.Callable;
import javax.sql.DataSource;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opennms.netmgt.config.PollOutagesConfig;
import org.opennms.netmgt.config.PollerConfig;
import org.opennms.netmgt.config.poller.Package;
import org.opennms.netmgt.mock.EventAnticipator;
import org.opennms.netmgt.mock.MockDatabase;
import org.opennms.netmgt.mock.MockElement;
import org.opennms.netmgt.mock.MockEventIpcManager;
import org.opennms.netmgt.mock.MockEventUtil;
import org.opennms.netmgt.mock.MockInterface;
import org.opennms.netmgt.mock.MockNetwork;
import org.opennms.netmgt.mock.MockNode;
import org.opennms.netmgt.mock.MockPollerConfig;
import org.opennms.netmgt.mock.MockService;
import org.opennms.netmgt.mock.MockVisitorAdapter;
import org.opennms.netmgt.mock.OutageAnticipator;
import org.opennms.netmgt.model.PollStatus;
import org.opennms.netmgt.poller.mock.MockPollContext;
import org.opennms.netmgt.poller.mock.MockScheduler;
import org.opennms.netmgt.poller.mock.MockTimer;
import org.opennms.netmgt.poller.pollables.DbPollEvent;
import org.opennms.netmgt.poller.pollables.LockUnavailable;
import org.opennms.netmgt.poller.pollables.PollContext;
import org.opennms.netmgt.poller.pollables.PollEvent;
import org.opennms.netmgt.poller.pollables.PollableContainer;
import org.opennms.netmgt.poller.pollables.PollableElement;
import org.opennms.netmgt.poller.pollables.PollableInterface;
import org.opennms.netmgt.poller.pollables.PollableNetwork;
import org.opennms.netmgt.poller.pollables.PollableNode;
import org.opennms.netmgt.poller.pollables.PollableService;
import org.opennms.netmgt.poller.pollables.PollableServiceConfig;
import org.opennms.netmgt.poller.pollables.PollableVisitor;
import org.opennms.netmgt.poller.pollables.PollableVisitorAdaptor;
import org.opennms.netmgt.scheduler.ReadyRunnable;
import org.opennms.netmgt.scheduler.Schedule;
import org.opennms.netmgt.scheduler.ScheduleInterval;
import org.opennms.netmgt.scheduler.ScheduleTimer;
import org.opennms.netmgt.scheduler.Timer;
import org.opennms.netmgt.utils.Querier;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.test.DaoTestConfigBean;
import org.opennms.test.mock.MockLogAppender;
import org.opennms.test.mock.MockUtil;

public class PollablesTest {
    private PollableNetwork m_network;
    private MockPollContext m_pollContext;
    private MockNetwork m_mockNetwork;
    private MockDatabase m_db;
    private EventAnticipator m_anticipator;
    private MockEventIpcManager m_eventMgr;
    private MockNode mNode1;
    private MockInterface mDot1;
    private MockInterface mDot2;
    private MockNode mNode2;
    private MockService mDot1Smtp;
    private MockService mDot1Icmp;
    private MockService mDot2Icmp;
    private MockInterface mDot3;
    private MockService mDot3Http;
    private MockNode mNode3;
    private MockInterface mDot4;
    private MockService mDot4Smtp;
    private MockService mDot4Http;
    private PollableNode pNode1;
    private PollableInterface pDot1;
    private PollableService pDot1Smtp;
    private PollableService pDot1Icmp;
    private PollableInterface pDot2;
    private PollableService pDot2Smtp;
    private PollableService pDot2Icmp;
    private PollableNode pNode2;
    private PollableInterface pDot3;
    private PollableService pDot3Http;
    private PollableService pDot3Icmp;
    private PollableNode pNode3;
    private PollableInterface pDot4;
    private PollableService pDot4Smtp;
    private PollableService pDot4Http;
    private OutageAnticipator m_outageAnticipator;
    private MockPollerConfig m_pollerConfig;
    private MockScheduler m_scheduler;
    private MockTimer m_timer;
    private int m_lockCount = 0;

    @Before
    public void setUp() throws Exception {
        DaoTestConfigBean bean = new DaoTestConfigBean();
        bean.afterPropertiesSet();
        MockUtil.println((String)"------------ Begin Test --------------------------");
        MockLogAppender.setupLogging();
        this.m_lockCount = 0;
        this.m_mockNetwork = new MockNetwork();
        this.m_mockNetwork.addNode(1, "Router");
        this.m_mockNetwork.addInterface("192.168.1.1");
        this.m_mockNetwork.addService("ICMP");
        this.m_mockNetwork.addService("SMTP");
        this.m_mockNetwork.addInterface("192.168.1.2");
        this.m_mockNetwork.addService("ICMP");
        this.m_mockNetwork.addService("SMTP");
        this.m_mockNetwork.addNode(2, "Server");
        this.m_mockNetwork.addInterface("192.168.1.3");
        this.m_mockNetwork.addService("ICMP");
        this.m_mockNetwork.addService("HTTP");
        this.m_mockNetwork.addNode(3, "Firewall");
        this.m_mockNetwork.addInterface("192.168.1.4");
        this.m_mockNetwork.addService("SMTP");
        this.m_mockNetwork.addService("HTTP");
        this.m_mockNetwork.addInterface("192.168.1.5");
        this.m_mockNetwork.addService("SMTP");
        this.m_mockNetwork.addService("SNMP");
        this.m_db = new MockDatabase();
        this.m_db.populate(this.m_mockNetwork);
        this.m_anticipator = new EventAnticipator();
        this.m_outageAnticipator = new OutageAnticipator(this.m_db);
        this.m_eventMgr = new MockEventIpcManager();
        this.m_eventMgr.setEventWriter(this.m_db);
        this.m_eventMgr.setEventAnticipator(this.m_anticipator);
        this.m_eventMgr.addEventListener(this.m_outageAnticipator);
        this.m_pollContext = new MockPollContext();
        this.m_pollContext.setDatabase(this.m_db);
        this.m_pollContext.setCriticalServiceName("ICMP");
        this.m_pollContext.setNodeProcessingEnabled(true);
        this.m_pollContext.setPollingAllIfCritServiceUndefined(true);
        this.m_pollContext.setServiceUnresponsiveEnabled(true);
        this.m_pollContext.setEventMgr(this.m_eventMgr);
        this.m_pollContext.setMockNetwork(this.m_mockNetwork);
        this.m_pollerConfig = new MockPollerConfig(this.m_mockNetwork);
        this.m_pollerConfig.setNodeOutageProcessingEnabled(true);
        this.m_pollerConfig.setCriticalService("ICMP");
        this.m_pollerConfig.addPackage("TestPackage");
        this.m_pollerConfig.addDowntime(100L, 0L, 500L, false);
        this.m_pollerConfig.addDowntime(200L, 500L, 1500L, false);
        this.m_pollerConfig.addDowntime(500L, 1500L, -1L, true);
        this.m_pollerConfig.setDefaultPollInterval(1000L);
        this.m_pollerConfig.populatePackage(this.m_mockNetwork);
        this.m_pollerConfig.addPackage("TestPkg2");
        this.m_pollerConfig.addDowntime(500L, 0L, 1000L, false);
        this.m_pollerConfig.addDowntime(500L, 1000L, -1L, true);
        this.m_pollerConfig.setDefaultPollInterval(2000L);
        this.m_pollerConfig.addService(this.m_mockNetwork.getService(2, "192.168.1.3", "HTTP"));
        this.m_timer = new MockTimer();
        this.m_scheduler = new MockScheduler(this.m_timer);
        this.m_network = this.createPollableNetwork((DataSource)((Object)this.m_db), (ScheduleTimer)this.m_scheduler, this.m_pollerConfig, (PollOutagesConfig)this.m_pollerConfig, this.m_pollContext);
        this.mNode1 = this.m_mockNetwork.getNode(1);
        this.mDot1 = this.mNode1.getInterface("192.168.1.1");
        this.mDot1Smtp = this.mDot1.getService("SMTP");
        this.mDot1Icmp = this.mDot1.getService("ICMP");
        this.mDot2 = this.mNode1.getInterface("192.168.1.2");
        this.mDot2Icmp = this.mDot2.getService("ICMP");
        this.mNode2 = this.m_mockNetwork.getNode(2);
        this.mDot3 = this.mNode2.getInterface("192.168.1.3");
        this.mDot3Http = this.mDot3.getService("HTTP");
        this.mNode3 = this.m_mockNetwork.getNode(3);
        this.mDot4 = this.mNode3.getInterface("192.168.1.4");
        this.mDot4Smtp = this.mDot4.getService("SMTP");
        this.mDot4Http = this.mDot4.getService("HTTP");
        this.assignPollableMembers(this.m_network);
    }

    private void assignPollableMembers(PollableNetwork pNetwork) throws UnknownHostException {
        this.pNode1 = pNetwork.getNode(1);
        this.pDot1 = this.pNode1.getInterface(InetAddress.getByName("192.168.1.1"));
        this.pDot1Smtp = this.pDot1.getService("SMTP");
        this.pDot1Icmp = this.pDot1.getService("ICMP");
        this.pDot2 = this.pNode1.getInterface(InetAddress.getByName("192.168.1.2"));
        this.pDot2Smtp = this.pDot2.getService("SMTP");
        this.pDot2Icmp = this.pDot2.getService("ICMP");
        this.pNode2 = pNetwork.getNode(2);
        this.pDot3 = this.pNode2.getInterface(InetAddress.getByName("192.168.1.3"));
        this.pDot3Http = this.pDot3.getService("HTTP");
        this.pDot3Icmp = this.pDot3.getService("ICMP");
        this.pNode3 = pNetwork.getNode(3);
        this.pDot4 = this.pNode3.getInterface(InetAddress.getByName("192.168.1.4"));
        this.pDot4Smtp = this.pDot4.getService("SMTP");
        this.pDot4Http = this.pDot4.getService("HTTP");
    }

    private PollableNetwork createPollableNetwork(DataSource db, final ScheduleTimer scheduler, final PollerConfig pollerConfig, final PollOutagesConfig pollOutageConfig, PollContext pollContext) throws UnknownHostException {
        final PollableNetwork pNetwork = new PollableNetwork(pollContext);
        String sql = "select ifServices.nodeId as nodeId, node.nodeLabel as nodeLabel, ifServices.ipAddr as ipAddr, ifServices.serviceId as serviceId, service.serviceName as serviceName, outages.svcLostEventId as svcLostEventId, events.eventUei as svcLostEventUei, outages.ifLostService as ifLostService, outages.ifRegainedService as ifRegainedService from ifServices join node on ifServices.nodeId = node.nodeId join service on ifServices.serviceId = service.serviceId left outer join outages on ifServices.nodeId = outages.nodeId and ifServices.ipAddr = outages.ipAddr and ifServices.serviceId = outages.serviceId and ifRegainedService is null left outer join events on outages.svcLostEventId = events.eventid where ifServices.status = 'A'";
        Querier querier = new Querier(db, sql){

            public void processRow(ResultSet rs) throws SQLException {
                int nodeId = rs.getInt("nodeId");
                String nodeLabel = rs.getString("nodeLabel");
                String ipAddr = rs.getString("ipAddr");
                String serviceName = rs.getString("serviceName");
                Timestamp date = rs.getTimestamp("ifLostService");
                Number svcLostEventId = (Number)rs.getObject("svcLostEventId");
                String svcLostUei = rs.getString("svcLostEventUei");
                PollablesTest.this.addServiceToNetwork(pNetwork, nodeId, nodeLabel, ipAddr, serviceName, svcLostEventId, svcLostUei, date, scheduler, pollerConfig, pollOutageConfig);
            }
        };
        querier.execute();
        pNetwork.recalculateStatus();
        pNetwork.propagateInitialCause();
        pNetwork.resetStatusChanged();
        return pNetwork;
    }

    @After
    public void tearDown() throws Exception {
        this.m_eventMgr.finishProcessingEvents();
        MockLogAppender.assertNoWarningsOrGreater();
        this.m_db.drop();
    }

    @Test
    public void testCreateNode() {
        int nodeId = 99;
        PollableNode node = this.m_network.createNode(nodeId, "WebServer99");
        Assert.assertNotNull((String)"node is null", (Object)node);
        Assert.assertEquals((long)99L, (long)node.getNodeId());
        Assert.assertEquals((Object)"WebServer99", (Object)node.getNodeLabel());
        Assert.assertEquals((Object)node, (Object)this.m_network.getNode(nodeId));
        Assert.assertEquals((Object)this.m_network, (Object)node.getNetwork());
    }

    @Test
    public void testCreateInterface() throws UnknownHostException {
        int nodeId = 99;
        InetAddress addr = InetAddress.getByName("192.168.1.99");
        PollableInterface iface = this.m_network.createInterface(nodeId, "WebServer99", addr);
        Assert.assertNotNull((String)"iface is null", (Object)iface);
        Assert.assertEquals((Object)addr, (Object)iface.getAddress());
        Assert.assertEquals((long)nodeId, (long)iface.getNodeId());
        Assert.assertEquals((Object)iface, (Object)this.m_network.getInterface(nodeId, addr));
        PollableNode node = iface.getNode();
        Assert.assertNotNull((String)"node is null", (Object)node);
        Assert.assertEquals((long)nodeId, (long)node.getNodeId());
        Assert.assertEquals((Object)"WebServer99", (Object)node.getNodeLabel());
        Assert.assertEquals((Object)node, (Object)this.m_network.getNode(nodeId));
        Assert.assertEquals((Object)this.m_network, (Object)iface.getNetwork());
    }

    @Test
    public void testCreateService() throws Exception {
        int nodeId = 99;
        InetAddress addr = InetAddress.getByName("192.168.1.99");
        String svcName = "HTTP-99";
        PollableService svc = this.m_network.createService(nodeId, "WebServer99", addr, svcName);
        Assert.assertNotNull((String)"svc is null", (Object)svc);
        Assert.assertEquals((Object)svcName, (Object)svc.getSvcName());
        Assert.assertEquals((Object)addr, (Object)svc.getAddress());
        Assert.assertEquals((long)nodeId, (long)svc.getNodeId());
        Assert.assertEquals((Object)svc, (Object)this.m_network.getService(nodeId, addr, svcName));
        PollableInterface iface = svc.getInterface();
        Assert.assertNotNull((String)"iface is null", (Object)iface);
        Assert.assertEquals((Object)addr, (Object)iface.getAddress());
        Assert.assertEquals((long)nodeId, (long)iface.getNodeId());
        Assert.assertEquals((Object)iface, (Object)this.m_network.getInterface(nodeId, addr));
        PollableNode node = svc.getNode();
        Assert.assertNotNull((String)"node is null", (Object)node);
        Assert.assertEquals((long)nodeId, (long)node.getNodeId());
        Assert.assertEquals((Object)"WebServer99", (Object)node.getNodeLabel());
        Assert.assertEquals((Object)node, (Object)this.m_network.getNode(nodeId));
        Assert.assertEquals((Object)this.m_network, (Object)svc.getNetwork());
    }

    @Test
    public void testVisit() {
        class Counter
        extends PollableVisitorAdaptor {
            public int svcCount;
            public int ifCount;
            public int nodeCount;
            public int elementCount;
            public int containerCount;
            public int networkCount;

            Counter() {
            }

            public void visitService(PollableService s) {
                ++this.svcCount;
            }

            public void visitInterface(PollableInterface iface) {
                ++this.ifCount;
            }

            public void visitNode(PollableNode node) {
                ++this.nodeCount;
            }

            public void visitElement(PollableElement element) {
                ++this.elementCount;
            }

            public void visitContainer(PollableContainer container) {
                ++this.containerCount;
            }

            public void visitNetwork(PollableNetwork n) {
                ++this.networkCount;
            }
        }
        Counter counter = new Counter();
        this.m_network.visit((PollableVisitor)counter);
        Assert.assertEquals((long)10L, (long)counter.svcCount);
        Assert.assertEquals((long)5L, (long)counter.ifCount);
        Assert.assertEquals((long)3L, (long)counter.nodeCount);
        Assert.assertEquals((long)1L, (long)counter.networkCount);
        Assert.assertEquals((long)19L, (long)counter.elementCount);
        Assert.assertEquals((long)9L, (long)counter.containerCount);
    }

    @Test
    public void testDeleteService() {
        this.pDot1Icmp.delete();
        this.assertDeleted(this.pDot1Icmp);
        this.assertNotDeleted(this.pDot1);
        this.assertNotDeleted(this.pNode1);
        this.pDot1Smtp.delete();
        this.assertDeleted(this.pDot1Smtp);
        this.assertDeleted(this.pDot1);
        this.assertNotDeleted(this.pNode1);
        this.pDot2Smtp.delete();
        this.assertDeleted(this.pDot2Smtp);
        this.assertNotDeleted(this.pDot2);
        this.assertNotDeleted(this.pNode1);
        this.pDot2Icmp.delete();
        this.assertDeleted(this.pDot2Icmp);
        this.assertDeleted(this.pDot2);
        this.assertDeleted(this.pNode1);
    }

    private void assertDeleted(PollableService svc) {
        Assert.assertTrue((boolean)svc.isDeleted());
        Assert.assertNull((Object)this.m_network.getService(svc.getNodeId(), svc.getAddress(), svc.getSvcName()));
    }

    private void assertNotDeleted(PollableService svc) {
        Assert.assertFalse((boolean)svc.isDeleted());
        Assert.assertNotNull((Object)this.m_network.getService(svc.getNodeId(), svc.getAddress(), svc.getSvcName()));
    }

    private void assertDeleted(PollableInterface iface) {
        Assert.assertTrue((boolean)iface.isDeleted());
        Assert.assertNull((Object)this.m_network.getInterface(iface.getNodeId(), iface.getAddress()));
    }

    private void assertNotDeleted(PollableInterface iface) {
        Assert.assertFalse((boolean)iface.isDeleted());
        Assert.assertNotNull((Object)this.m_network.getInterface(iface.getNodeId(), iface.getAddress()));
    }

    private void assertDeleted(PollableNode node) {
        Assert.assertTrue((boolean)node.isDeleted());
        Assert.assertNull((Object)this.m_network.getNode(node.getNodeId()));
    }

    private void assertNotDeleted(PollableNode node) {
        Assert.assertFalse((boolean)node.isDeleted());
        Assert.assertNotNull((Object)this.m_network.getNode(node.getNodeId()));
    }

    @Test
    public void testDeleteInterface() throws Exception {
        this.pDot1.delete();
        this.assertDeleted(this.pDot1Icmp);
        this.assertDeleted(this.pDot1Smtp);
        this.assertDeleted(this.pDot1);
        this.assertNotDeleted(this.pDot2);
        this.assertNotDeleted(this.pNode1);
        this.pDot2.delete();
        this.assertDeleted(this.pDot2Icmp);
        this.assertDeleted(this.pDot2Smtp);
        this.assertDeleted(this.pDot2);
        this.assertDeleted(this.pNode1);
    }

    @Test
    public void testDeleteNode() throws Exception {
        this.pNode1.delete();
        this.assertDeleted(this.pDot1Icmp);
        this.assertDeleted(this.pDot1Smtp);
        this.assertDeleted(this.pDot1);
        this.assertDeleted(this.pDot2Icmp);
        this.assertDeleted(this.pDot2Smtp);
        this.assertDeleted(this.pDot2);
        this.assertDeleted(this.pNode1);
    }

    @Test
    public void testDeleteServiceStatus() {
        this.anticipateDown(this.mDot1);
        this.mDot1Icmp.bringDown();
        this.pDot1Icmp.doPoll();
        this.m_network.processStatusChange(new Date());
        this.verifyAnticipated();
        this.mDot1.removeService(this.mDot1Icmp);
        this.anticipateUp(this.mDot1);
        this.pDot1Icmp.delete();
        this.m_network.processStatusChange(new Date());
        this.verifyAnticipated();
    }

    @Test
    public void testDowntimeDelete() {
        this.pDot3Http.getSchedule().schedule();
        this.m_scheduler.next();
        this.assertTime(0L);
        this.assertNotDeleted(this.pDot3Http);
        this.m_scheduler.next();
        this.assertTime(2000L);
        this.assertNotDeleted(this.pDot3Http);
        this.anticipateDown(this.mDot3Http);
        this.mDot3Http.bringDown();
        this.m_scheduler.next();
        this.assertTime(4000L);
        this.assertNotDeleted(this.pDot3Http);
        this.verifyAnticipated();
        this.m_scheduler.next();
        this.assertTime(4500L);
        this.assertNotDeleted(this.pDot3Http);
        this.m_anticipator.anticipateEvent(MockEventUtil.createServiceEvent("Test", "uei.opennms.org/nodes/deleteService", this.mDot3Http, null));
        this.m_scheduler.next();
        this.assertTime(5000L);
        this.verifyAnticipated();
    }

    @Test
    public void testReparentInterface() {
        InetAddress address = this.pDot1.getAddress();
        this.pDot1.reparentTo(this.pNode2);
        Assert.assertNull((Object)this.m_network.getInterface(1, address));
        Assert.assertNotNull((Object)this.m_network.getInterface(2, address));
        Assert.assertEquals((long)2L, (long)this.pDot1.getNodeId());
        Assert.assertSame((Object)this.pNode2, (Object)this.pDot1.getNode());
    }

    @Test
    public void testReparentOutages() {
        this.mDot1.bringDown();
        this.pDot1Icmp.doPoll();
        this.m_network.processStatusChange(new Date());
        this.mDot1.bringUp();
        this.pDot1Icmp.doPoll();
        this.m_network.processStatusChange(new Date());
        String ifOutageOnNode1 = "select * from outages where nodeId = 1 and ipAddr = '192.168.1.1'";
        String ifOutageOnNode2 = "select * from outages where nodeId = 2 and ipAddr = '192.168.1.1'";
        this.m_eventMgr.finishProcessingEvents();
        Assert.assertEquals((long)2L, (long)this.m_db.countRows("select * from outages where nodeId = 1 and ipAddr = '192.168.1.1'", new Object[0]));
        Assert.assertEquals((long)0L, (long)this.m_db.countRows("select * from outages where nodeId = 2 and ipAddr = '192.168.1.1'", new Object[0]));
        this.m_db.reparentInterface(this.pDot1.getIpAddr(), this.pDot1.getNodeId(), this.pNode2.getNodeId());
        this.pDot1.reparentTo(this.pNode2);
        Assert.assertEquals((long)0L, (long)this.m_db.countRows("select * from outages where nodeId = 1 and ipAddr = '192.168.1.1'", new Object[0]));
        Assert.assertEquals((long)2L, (long)this.m_db.countRows("select * from outages where nodeId = 2 and ipAddr = '192.168.1.1'", new Object[0]));
    }

    @Test
    public void testReparentStatusChanges() {
        this.anticipateDown(this.mNode2);
        this.anticipateDown(this.mDot1);
        this.mNode1.bringDown();
        this.mNode2.bringDown();
        this.mDot2.bringUp();
        this.pDot1Icmp.doPoll();
        this.m_network.processStatusChange(new Date());
        this.pDot2Icmp.doPoll();
        this.m_network.processStatusChange(new Date());
        this.pDot3Icmp.doPoll();
        this.m_network.processStatusChange(new Date());
        this.verifyAnticipated();
        this.m_db.reparentInterface(this.mDot2.getIpAddr(), this.mDot2.getNodeId(), this.mNode2.getNodeId());
        this.mDot2.moveTo(this.mNode2);
        this.resetAnticipated();
        this.anticipateDown(this.mNode1);
        this.anticipateUp(this.mNode2);
        this.anticipateDown(this.mDot3);
        this.pDot2.reparentTo(this.pNode2);
        this.verifyAnticipated();
    }

    @Test
    public void testStatus() throws Exception {
        PollableVisitorAdaptor updater = new PollableVisitorAdaptor(){

            public void visitElement(PollableElement e) {
                e.updateStatus(PollStatus.down());
            }
        };
        this.m_network.visit((PollableVisitor)updater);
        PollableVisitorAdaptor downChecker = new PollableVisitorAdaptor(){

            public void visitElement(PollableElement e) {
                Assert.assertEquals((Object)PollStatus.down(), (Object)e.getStatus());
                Assert.assertEquals((Object)true, (Object)e.isStatusChanged());
            }
        };
        this.m_network.visit((PollableVisitor)downChecker);
        this.m_network.resetStatusChanged();
        PollableVisitorAdaptor statusChangedChecker = new PollableVisitorAdaptor(){

            public void visitElement(PollableElement e) {
                Assert.assertEquals((Object)false, (Object)e.isStatusChanged());
            }
        };
        this.m_network.visit((PollableVisitor)statusChangedChecker);
        this.pDot1Icmp.updateStatus(PollStatus.up());
        this.m_network.recalculateStatus();
        PollableVisitorAdaptor upChecker = new PollableVisitorAdaptor(){

            public void visitNode(PollableNode node) {
                if (node == PollablesTest.this.pDot1Icmp.getNode()) {
                    PollablesTest.this.assertUp((PollableElement)node);
                } else {
                    PollablesTest.this.assertDown((PollableElement)node);
                }
            }

            public void visitInterface(PollableInterface iface) {
                if (iface == PollablesTest.this.pDot1Icmp.getInterface()) {
                    PollablesTest.this.assertUp((PollableElement)iface);
                } else {
                    PollablesTest.this.assertDown((PollableElement)iface);
                }
            }

            public void visitService(PollableService s) {
                if (s == PollablesTest.this.pDot1Icmp) {
                    PollablesTest.this.assertUp((PollableElement)s);
                } else {
                    PollablesTest.this.assertDown((PollableElement)s);
                }
            }
        };
        this.m_network.visit((PollableVisitor)upChecker);
    }

    @Test
    public void testInterfaceStatus() throws Exception {
        this.pDot2Smtp.updateStatus(PollStatus.down());
        this.m_network.recalculateStatus();
        this.assertDown((PollableElement)this.pDot2Smtp);
        this.assertUp((PollableElement)this.pDot2Smtp.getInterface());
        this.pDot2Smtp.updateStatus(PollStatus.up());
        this.m_network.recalculateStatus();
        this.assertUp((PollableElement)this.pDot2Smtp);
        this.assertUp((PollableElement)this.pDot2Smtp.getInterface());
        this.pDot2Icmp.updateStatus(PollStatus.down());
        this.m_network.recalculateStatus();
        this.assertDown((PollableElement)this.pDot2Icmp);
        this.assertDown((PollableElement)this.pDot2Icmp.getInterface());
    }

    @Test
    public void testFindMemberWithDescendent() throws Exception {
        Assert.assertSame((Object)this.pNode1, (Object)this.m_network.findMemberWithDescendent((PollableElement)this.pDot1Icmp));
        Assert.assertSame((Object)this.pDot1, (Object)this.pNode1.findMemberWithDescendent((PollableElement)this.pDot1Icmp));
        Assert.assertSame((Object)this.pDot1Icmp, (Object)this.pDot1.findMemberWithDescendent((PollableElement)this.pDot1Icmp));
        Assert.assertNull((Object)this.pNode2.findMemberWithDescendent((PollableElement)this.pDot1Icmp));
    }

    @Test
    public void testPropagateUnresponsive() throws Exception {
        this.pDot1Smtp.updateStatus(PollStatus.unresponsive());
        this.pDot1Icmp.updateStatus(PollStatus.unresponsive());
        this.m_network.recalculateStatus();
        this.assertUp((PollableElement)this.pDot1);
    }

    @Test
    public void testPollUnresponsive() {
        this.m_pollContext.setServiceUnresponsiveEnabled(true);
        this.anticipateUnresponsive(this.mDot1);
        this.mDot1.bringUnresponsive();
        this.pDot1Smtp.doPoll();
        this.m_network.processStatusChange(new Date());
        this.pDot1Icmp.doPoll();
        this.m_network.processStatusChange(new Date());
        this.assertUp((PollableElement)this.pDot1);
        this.verifyAnticipated();
        this.anticipateResponsive(this.mDot1);
        this.mDot1.bringUp();
        this.pDot1Smtp.doPoll();
        this.m_network.processStatusChange(new Date());
        this.pDot1Icmp.doPoll();
        this.m_network.processStatusChange(new Date());
        this.assertUp((PollableElement)this.pDot1);
        this.verifyAnticipated();
    }

    @Test
    public void testPollUnresponsiveWithOutage() {
        this.m_pollContext.setServiceUnresponsiveEnabled(true);
        this.anticipateUnresponsive(this.mDot1);
        this.mDot1.bringUnresponsive();
        this.pDot1Smtp.doPoll();
        this.m_network.processStatusChange(new Date());
        this.pDot1Icmp.doPoll();
        this.m_network.processStatusChange(new Date());
        this.assertUp((PollableElement)this.pDot1);
        this.verifyAnticipated();
        this.anticipateDown(this.mDot1);
        this.mDot1.bringDown();
        this.pDot1Smtp.doPoll();
        this.m_network.processStatusChange(new Date());
        this.verifyAnticipated();
        this.anticipateUp(this.mDot1);
        this.mDot1.bringUp();
        this.pDot1Icmp.doPoll();
        this.m_network.processStatusChange(new Date());
        this.verifyAnticipated();
        this.anticipateUnresponsive(this.mDot1);
        this.mDot1.bringUnresponsive();
        this.pDot1Smtp.doPoll();
        this.m_network.processStatusChange(new Date());
        this.pDot1Icmp.doPoll();
        this.m_network.processStatusChange(new Date());
        this.assertUp((PollableElement)this.pDot1);
        this.verifyAnticipated();
    }

    @Test
    public void testNoEventsOnNoOutages() throws Exception {
        this.pDot1Smtp.doPoll();
        this.m_network.processStatusChange(new Date());
        this.verifyAnticipated();
    }

    @Test
    public void testPollService() throws Exception {
        PollableService pSvc = this.pDot1Smtp;
        MockService mSvc = this.mDot1Smtp;
        pSvc.doPoll();
        this.assertUp((PollableElement)pSvc);
        this.assertUnchanged((PollableElement)pSvc);
        mSvc.bringDown();
        pSvc.doPoll();
        this.assertDown((PollableElement)pSvc);
        this.assertChanged((PollableElement)pSvc);
        pSvc.resetStatusChanged();
        mSvc.bringUp();
        pSvc.doPoll();
        this.assertUp((PollableElement)pSvc);
        this.assertChanged((PollableElement)pSvc);
        pSvc.recalculateStatus();
    }

    @Test
    public void testPollAllUp() throws Exception {
        this.pDot1Icmp.doPoll();
        this.assertUp((PollableElement)this.pDot1Icmp);
        this.assertUp((PollableElement)this.pDot1);
        this.assertUnchanged((PollableElement)this.pDot1Icmp);
        this.assertUnchanged((PollableElement)this.pDot1);
        this.assertPoll(this.mDot1Icmp);
        this.assertNoPoll(this.m_mockNetwork);
    }

    @Test
    public void testPollIfUpNonCritSvcDown() throws Exception {
        this.mDot1Smtp.bringDown();
        this.pDot1Smtp.doPoll();
        this.assertDown((PollableElement)this.pDot1Smtp);
        this.assertUp((PollableElement)this.pDot1);
        this.assertChanged((PollableElement)this.pDot1Smtp);
        this.assertUnchanged((PollableElement)this.pDot1);
        this.assertPoll(this.mDot1Smtp);
        this.assertPoll(this.mDot1Icmp);
        this.assertNoPoll(this.m_mockNetwork);
    }

    @Test
    public void testPollIfUpCritSvcDownPoll() throws Exception {
        this.mDot1Icmp.bringDown();
        this.pDot1Icmp.doPoll();
        this.assertDown((PollableElement)this.pDot1Icmp);
        this.assertDown((PollableElement)this.pDot1);
        this.assertChanged((PollableElement)this.pDot1Icmp);
        this.assertChanged((PollableElement)this.pDot1);
        this.assertPoll(this.mDot1Icmp);
        this.assertPoll(this.mDot2Icmp);
        this.assertNoPoll(this.m_mockNetwork);
    }

    @Test
    public void testPollIfDownNonCritSvcUp() throws Exception {
        this.mDot1.bringDown();
        this.pDot1.updateStatus(PollStatus.down());
        this.pDot1Icmp.updateStatus(PollStatus.down());
        this.m_network.recalculateStatus();
        this.m_network.resetStatusChanged();
        this.assertDown((PollableElement)this.pDot1Icmp);
        this.assertDown((PollableElement)this.pDot1);
        this.mDot1Smtp.bringUp();
        this.pDot1Smtp.doPoll();
        this.assertDown((PollableElement)this.pDot1Icmp);
        this.assertDown((PollableElement)this.pDot1);
        this.assertUnchanged((PollableElement)this.pDot1Icmp);
        this.assertUnchanged((PollableElement)this.pDot1);
        this.assertNoPoll(this.m_mockNetwork);
    }

    @Test
    public void testPollIfDownCritSvcUp() throws Exception {
        this.mDot1.bringDown();
        this.pDot1.updateStatus(PollStatus.down());
        this.pDot1Icmp.updateStatus(PollStatus.down());
        this.pDot1.setCause((PollEvent)new DbPollEvent(1, "uei.opennms.org/nodes/interfaceDown", new Date()));
        this.m_network.recalculateStatus();
        this.m_network.resetStatusChanged();
        this.assertDown((PollableElement)this.pDot1Icmp);
        this.assertDown((PollableElement)this.pDot1);
        this.mDot1Icmp.bringUp();
        this.pDot1Icmp.doPoll();
        this.assertDown((PollableElement)this.pDot1Smtp);
        this.assertUp((PollableElement)this.pDot1Icmp);
        this.assertUp((PollableElement)this.pDot1);
        this.assertChanged((PollableElement)this.pDot1Icmp);
        this.assertChanged((PollableElement)this.pDot1);
        this.assertPoll(this.mDot1Smtp);
        this.assertPoll(this.mDot1Icmp);
        this.assertNoPoll(this.m_mockNetwork);
    }

    @Test
    public void testPollIfUpCritSvcUndefSvcDown() throws Exception {
        this.m_pollContext.setCriticalServiceName(null);
        this.mDot1Smtp.bringDown();
        this.pDot1Smtp.doPoll();
        this.assertDown((PollableElement)this.pDot1Smtp);
        this.assertUp((PollableElement)this.pDot1);
        this.assertChanged((PollableElement)this.pDot1Smtp);
        this.assertUnchanged((PollableElement)this.pDot1);
        this.assertPoll(this.mDot1Smtp);
        this.assertPoll(this.mDot1Icmp);
        this.assertNoPoll(this.m_mockNetwork);
    }

    @Test
    public void testPollIfDownCritSvcUndefSvcDown() throws Exception {
        this.m_pollContext.setCriticalServiceName(null);
        this.mDot1.bringDown();
        this.pDot1.updateStatus(PollStatus.down());
        this.pDot1Icmp.updateStatus(PollStatus.down());
        this.pDot1Smtp.updateStatus(PollStatus.down());
        this.m_network.recalculateStatus();
        this.m_network.resetStatusChanged();
        this.assertDown((PollableElement)this.pDot1Smtp);
        this.assertDown((PollableElement)this.pDot1Icmp);
        this.assertDown((PollableElement)this.pDot1);
        this.mDot1Smtp.bringUp();
        this.pDot1Smtp.doPoll();
        this.assertUp((PollableElement)this.pDot1Smtp);
        this.assertDown((PollableElement)this.pDot1Icmp);
        this.assertUp((PollableElement)this.pDot1);
        this.assertChanged((PollableElement)this.pDot1Smtp);
        this.assertUnchanged((PollableElement)this.pDot1Icmp);
        this.assertChanged((PollableElement)this.pDot1);
        this.assertPoll(this.mDot1Smtp);
        this.assertPoll(this.mDot1Icmp);
        this.assertNoPoll(this.m_mockNetwork);
    }

    @Test
    public void testPollIfUpCritSvcUndefSvcDownNoPoll() throws Exception {
        this.m_pollContext.setCriticalServiceName(null);
        this.m_pollContext.setPollingAllIfCritServiceUndefined(false);
        this.mDot1Smtp.bringDown();
        this.pDot1Smtp.doPoll();
        this.assertDown((PollableElement)this.pDot1Smtp);
        this.assertUp((PollableElement)this.pDot1);
        this.assertChanged((PollableElement)this.pDot1Smtp);
        this.assertUnchanged((PollableElement)this.pDot1);
        this.assertPoll(this.mDot1Smtp);
        this.assertNoPoll(this.m_mockNetwork);
    }

    @Test
    public void testPollIfDownCritSvcUndefSvcDownNoPoll() throws Exception {
        this.m_pollContext.setCriticalServiceName(null);
        this.m_pollContext.setPollingAllIfCritServiceUndefined(false);
        this.mDot1.bringDown();
        this.pDot1.updateStatus(PollStatus.down());
        this.pDot1Icmp.updateStatus(PollStatus.down());
        this.pDot1Smtp.updateStatus(PollStatus.down());
        this.m_network.recalculateStatus();
        this.m_network.resetStatusChanged();
        this.assertDown((PollableElement)this.pDot1Smtp);
        this.assertDown((PollableElement)this.pDot1Icmp);
        this.assertDown((PollableElement)this.pDot1);
        this.mDot1Smtp.bringUp();
        this.pDot1Smtp.doPoll();
        this.assertUp((PollableElement)this.pDot1Smtp);
        this.assertDown((PollableElement)this.pDot1Icmp);
        this.assertUp((PollableElement)this.pDot1);
        this.assertChanged((PollableElement)this.pDot1Smtp);
        this.assertUnchanged((PollableElement)this.pDot1Icmp);
        this.assertChanged((PollableElement)this.pDot1);
        this.assertPoll(this.mDot1Smtp);
        this.assertNoPoll(this.m_mockNetwork);
    }

    @Test
    public void testPollNode() throws Exception {
        this.mNode1.bringDown();
        this.pDot1Smtp.doPoll();
        this.assertDown((PollableElement)this.pDot1Smtp);
        this.assertDown((PollableElement)this.pDot1Icmp);
        this.assertDown((PollableElement)this.pDot2Icmp);
        this.assertDown((PollableElement)this.pNode1);
        this.assertPoll(this.mDot1Smtp);
        this.assertPoll(this.mDot1Icmp);
        this.assertPoll(this.mDot2Icmp);
        this.assertNoPoll(this.m_mockNetwork);
    }

    @Test
    public void testNodeProcessingDisabled() {
        this.m_pollContext.setNodeProcessingEnabled(false);
        this.pDot1Smtp.run();
        this.verifyAnticipated();
        this.anticipateDown(this.mDot1Smtp);
        this.mDot1Smtp.bringDown();
        this.pDot1Smtp.run();
        this.verifyAnticipated();
        this.pDot1Smtp.run();
        this.verifyAnticipated();
        this.anticipateUp(this.mDot1Smtp);
        this.mDot1Smtp.bringUp();
        this.pDot1Smtp.run();
        this.verifyAnticipated();
    }

    @Test
    public void testServiceEvent() throws Exception {
        MockService mSvc = this.mDot1Smtp;
        PollableService pSvc = this.pDot1Smtp;
        this.anticipateDown(mSvc);
        mSvc.bringDown();
        pSvc.doPoll();
        this.m_network.processStatusChange(new Date());
        this.verifyAnticipated();
        pSvc.doPoll();
        this.m_network.processStatusChange(new Date());
        this.verifyAnticipated();
        this.anticipateUp(mSvc);
        mSvc.bringUp();
        pSvc.doPoll();
        this.m_network.processStatusChange(new Date());
        this.verifyAnticipated();
    }

    @Test
    public void testInterfaceEvent() throws Exception {
        this.anticipateDown(this.mDot1);
        this.mDot1.bringDown();
        this.pDot1Smtp.doPoll();
        this.m_network.processStatusChange(new Date());
        this.verifyAnticipated();
        this.anticipateUp(this.mDot1);
        this.mDot1.bringUp();
        this.pDot1Icmp.doPoll();
        this.m_network.processStatusChange(new Date());
        this.verifyAnticipated();
    }

    @Test
    public void testNodeEvent() throws Exception {
        this.anticipateDown(this.mNode1);
        this.mNode1.bringDown();
        this.pDot1Smtp.doPoll();
        this.m_network.processStatusChange(new Date());
        this.verifyAnticipated();
        this.anticipateUp(this.mNode1);
        this.mNode1.bringUp();
        this.pDot1Icmp.doPoll();
        this.m_network.processStatusChange(new Date());
        this.verifyAnticipated();
    }

    @Test
    public void testLingeringSvcDownOnIfUp() throws Exception {
        this.anticipateDown(this.mDot1);
        this.mDot1.bringDown();
        this.pDot1Smtp.doPoll();
        this.m_network.processStatusChange(new Date());
        this.verifyAnticipated();
        this.anticipateUp(this.mDot1);
        this.anticipateDown(this.mDot1Smtp);
        this.mDot1.bringUp();
        this.mDot1Smtp.bringDown();
        this.pDot1Icmp.doPoll();
        this.m_network.processStatusChange(new Date());
        this.verifyAnticipated();
        this.anticipateUp(this.mDot1Smtp);
        this.mDot1Smtp.bringUp();
        this.pDot1Smtp.doPoll();
        this.m_network.processStatusChange(new Date());
        this.verifyAnticipated();
    }

    @Test
    public void testLingeringSvcDownOnNodeUp() throws Exception {
        this.anticipateDown(this.mNode1);
        this.mNode1.bringDown();
        this.pDot1Smtp.doPoll();
        this.m_network.processStatusChange(new Date());
        this.verifyAnticipated();
        this.anticipateUp(this.mNode1);
        this.anticipateDown(this.mDot1);
        this.mNode1.bringUp();
        this.mDot1Icmp.bringDown();
        this.pDot2Icmp.doPoll();
        this.m_network.processStatusChange(new Date());
        this.verifyAnticipated();
        this.anticipateUp(this.mDot1);
        this.anticipateDown(this.mDot1Smtp);
        this.mDot1.bringUp();
        this.mDot1Smtp.bringDown();
        this.pDot1Icmp.doPoll();
        this.m_network.processStatusChange(new Date());
        this.verifyAnticipated();
    }

    @Test
    public void testSvcOutage() {
        this.anticipateDown(this.mDot1Smtp);
        this.mDot1Smtp.bringDown();
        this.pDot1Smtp.doPoll();
        this.pDot1Smtp.processStatusChange(new Date());
        this.verifyAnticipated();
        this.anticipateUp(this.mDot1Smtp);
        this.mDot1Smtp.bringUp();
        this.pDot1Smtp.doPoll();
        this.pDot1Smtp.processStatusChange(new Date());
        this.verifyAnticipated();
    }

    @Test
    public void testIfOutage() {
        this.anticipateDown(this.mDot1);
        this.mDot1.bringDown();
        this.pDot1Smtp.doPoll();
        this.m_network.processStatusChange(new Date());
        this.verifyAnticipated();
        this.anticipateUp(this.mDot1);
        this.mDot1.bringUp();
        this.pDot1Icmp.doPoll();
        this.m_network.processStatusChange(new Date());
        this.verifyAnticipated();
    }

    @Test
    public void testCause() {
        this.anticipateDown(this.mDot1Smtp);
        this.mDot1Smtp.bringDown();
        this.pDot1Smtp.doPoll();
        this.m_network.processStatusChange(new Date());
        this.verifyAnticipated();
        this.anticipateDown(this.mDot1);
        this.mDot1.bringDown();
        this.pDot1Icmp.doPoll();
        this.m_network.processStatusChange(new Date());
        this.verifyAnticipated();
        PollEvent cause = this.pDot1.getCause();
        Assert.assertNotNull((Object)cause);
        Assert.assertEquals((Object)cause, (Object)this.pDot1.getCause());
        Assert.assertEquals((Object)cause, (Object)this.pDot1Icmp.getCause());
        Assert.assertFalse((boolean)cause.equals(this.pDot1Smtp.getCause()));
    }

    @Test
    public void testIndependentOutageEventsUpTogether() throws Exception {
        this.anticipateDown(this.mDot1Smtp);
        this.mDot1Smtp.bringDown();
        this.pDot1Smtp.doPoll();
        this.m_network.processStatusChange(new Date());
        this.verifyAnticipated();
        this.anticipateDown(this.mNode1);
        this.mNode1.bringDown();
        this.pDot1Icmp.doPoll();
        this.m_network.processStatusChange(new Date());
        this.verifyAnticipated();
        this.anticipateUp(this.mDot1Smtp);
        this.anticipateUp(this.mNode1);
        this.mNode1.bringUp();
        this.pDot1Icmp.doPoll();
        this.m_network.processStatusChange(new Date());
        this.verifyAnticipated();
    }

    @Test
    public void testIndependentOutageEventsUpSeparately() throws Exception {
        this.anticipateDown(this.mDot1Smtp);
        this.mDot1Smtp.bringDown();
        this.pDot1Smtp.doPoll();
        this.m_network.processStatusChange(new Date());
        this.verifyAnticipated();
        this.anticipateDown(this.mNode1);
        this.mNode1.bringDown();
        this.pDot1Icmp.doPoll();
        this.m_network.processStatusChange(new Date());
        this.verifyAnticipated();
        this.anticipateUp(this.mNode1);
        this.m_outageAnticipator.deanticipateOutageClosed(this.mDot1Smtp, this.mNode1.createUpEvent());
        this.mNode1.bringUp();
        this.mDot1Smtp.bringDown();
        this.pDot1Icmp.doPoll();
        this.m_network.processStatusChange(new Date());
        this.verifyAnticipated();
        this.anticipateUp(this.mDot1Smtp);
        this.mDot1Smtp.bringUp();
        this.pDot1Smtp.doPoll();
        this.m_network.processStatusChange(new Date());
        this.verifyAnticipated();
    }

    @Test
    public void testDowntimeInterval() {
        Package pkg = this.m_pollerConfig.getPackage("TestPackage");
        PollableServiceConfig pollConfig = new PollableServiceConfig(this.pDot1Smtp, (PollerConfig)this.m_pollerConfig, (PollOutagesConfig)this.m_pollerConfig, pkg, (Timer)this.m_timer);
        this.m_timer.setCurrentTime(1000L);
        this.pDot1Smtp.updateStatus(PollStatus.down());
        Assert.assertEquals((long)1000L, (long)this.pDot1Smtp.getStatusChangeTime());
        this.assertDown((PollableElement)this.pDot1Smtp);
        this.pDot1.resetStatusChanged();
        Assert.assertEquals((long)100L, (long)pollConfig.getInterval());
        this.m_timer.setCurrentTime(1234L);
        Assert.assertEquals((long)100L, (long)pollConfig.getInterval());
        this.m_timer.setCurrentTime(1500L);
        Assert.assertEquals((long)200L, (long)pollConfig.getInterval());
        this.m_timer.setCurrentTime(1700L);
        Assert.assertEquals((long)200L, (long)pollConfig.getInterval());
        this.m_timer.setCurrentTime(2500L);
        Assert.assertEquals((long)-1L, (long)pollConfig.getInterval());
    }

    @Test
    public void testSchedule() {
        int downFor;
        this.pDot1Smtp.getSchedule().schedule();
        this.m_scheduler.next();
        this.assertPoll(this.mDot1Smtp);
        this.assertTime(0L);
        this.assertUp((PollableElement)this.pDot1Smtp);
        this.assertUnchanged((PollableElement)this.pDot1Smtp);
        this.mDot1Smtp.bringDown();
        this.m_scheduler.next();
        this.assertPoll(this.mDot1Smtp);
        this.assertTime(1000L);
        this.assertDown((PollableElement)this.pDot1Smtp);
        this.assertChanged((PollableElement)this.pDot1Smtp);
        this.pDot1Smtp.resetStatusChanged();
        for (downFor = 100; downFor < 500; downFor += 100) {
            this.m_scheduler.next();
            this.assertPoll(this.mDot1Smtp);
            this.assertTime(1000 + downFor);
        }
        for (downFor = 500; downFor < 1500; downFor += 200) {
            this.m_scheduler.next();
            this.assertPoll(this.mDot1Smtp);
            this.assertTime(1000 + downFor);
        }
        this.mDot1Smtp.bringUp();
        this.m_scheduler.next();
        this.assertPoll(this.mDot1Smtp);
        this.assertUp((PollableElement)this.pDot1Smtp);
        this.assertChanged((PollableElement)this.pDot1Smtp);
        this.pDot1Smtp.recalculateStatus();
    }

    @Test
    public void testScheduleAdjust() {
        this.m_pollerConfig.setPollInterval(this.m_pollerConfig.getPackage("TestPackage"), "SMTP", 10000L);
        this.pDot1Icmp.getSchedule().schedule();
        this.pDot1Smtp.getSchedule().schedule();
        this.m_scheduler.next();
        this.m_scheduler.next();
        this.assertTime(0L);
        this.assertPoll(this.mDot1Icmp);
        this.assertPoll(this.mDot1Smtp);
        this.assertUp((PollableElement)this.pDot1Smtp);
        this.assertUp((PollableElement)this.pDot1Icmp);
        this.assertUnchanged((PollableElement)this.pDot1Smtp);
        this.assertUnchanged((PollableElement)this.pDot1Icmp);
        this.m_scheduler.next();
        this.assertTime(1000L);
        this.assertPoll(this.mDot1Icmp);
        this.assertNoPoll(this.mDot1Smtp);
        this.assertUp((PollableElement)this.pDot1Smtp);
        this.assertUp((PollableElement)this.pDot1Icmp);
        this.assertUnchanged((PollableElement)this.pDot1Smtp);
        this.assertUnchanged((PollableElement)this.pDot1Icmp);
        this.mDot1.bringDown();
        this.m_scheduler.next();
        this.assertTime(2000L);
        this.assertPoll(this.mDot1Icmp);
        this.assertNoPoll(this.mDot1Smtp);
        this.assertUp((PollableElement)this.pDot1Smtp);
        this.assertDown((PollableElement)this.pDot1Icmp);
        this.assertUnchanged((PollableElement)this.pDot1Smtp);
        this.assertChanged((PollableElement)this.pDot1Icmp);
        this.mDot1Icmp.bringUp();
        this.m_scheduler.next();
        this.assertTime(2100L);
        this.assertPoll(this.mDot1Icmp);
        this.assertPoll(this.mDot1Smtp);
        this.assertDown((PollableElement)this.pDot1Smtp);
        this.assertUp((PollableElement)this.pDot1Icmp);
        this.assertChanged((PollableElement)this.pDot1Smtp);
        this.assertChanged((PollableElement)this.pDot1Icmp);
        this.m_scheduler.next();
        this.assertTime(2200L);
        this.assertNoPoll(this.mDot1Icmp);
        this.assertPoll(this.mDot1Smtp);
        this.assertDown((PollableElement)this.pDot1Smtp);
        this.assertUp((PollableElement)this.pDot1Icmp);
        this.assertUnchanged((PollableElement)this.pDot1Smtp);
        this.assertUnchanged((PollableElement)this.pDot1Icmp);
        this.mDot1Smtp.bringUp();
        this.m_scheduler.next();
        this.assertTime(2300L);
        this.assertNoPoll(this.mDot1Icmp);
        this.assertPoll(this.mDot1Smtp);
        this.assertUp((PollableElement)this.pDot1Smtp);
        this.assertUp((PollableElement)this.pDot1Icmp);
        this.assertChanged((PollableElement)this.pDot1Smtp);
        this.assertUnchanged((PollableElement)this.pDot1Icmp);
        this.m_scheduler.next();
        this.assertTime(3100L);
        this.assertPoll(this.mDot1Icmp);
        this.assertNoPoll(this.mDot1Smtp);
        this.assertUp((PollableElement)this.pDot1Smtp);
        this.assertUp((PollableElement)this.pDot1Icmp);
        this.assertUnchanged((PollableElement)this.pDot1Smtp);
        this.assertUnchanged((PollableElement)this.pDot1Icmp);
    }

    @Test
    public void testComputeScheduledOutageTime() {
        Package pkg = this.m_pollerConfig.getPackage("TestPackage");
        this.m_pollerConfig.addScheduledOutage(pkg, "first", 3000L, 5000L, "192.168.1.1");
        PollableServiceConfig pollConfig = new PollableServiceConfig(this.pDot1Smtp, (PollerConfig)this.m_pollerConfig, (PollOutagesConfig)this.m_pollerConfig, pkg, (Timer)this.m_timer);
        this.m_timer.setCurrentTime(2000L);
        Assert.assertFalse((boolean)pollConfig.scheduledSuspension());
        this.m_timer.setCurrentTime(4000L);
        Assert.assertTrue((boolean)pollConfig.scheduledSuspension());
    }

    @Test
    public void testScheduledOutage() {
        this.m_pollerConfig.addScheduledOutage(this.m_pollerConfig.getPackage("TestPackage"), "first", 3000L, 5000L, "192.168.1.1");
        this.pDot1Smtp.getSchedule().schedule();
        this.m_scheduler.next();
        this.assertPoll(this.mDot1Smtp);
        this.assertTime(0L);
        this.assertUp((PollableElement)this.pDot1Smtp);
        this.assertUnchanged((PollableElement)this.pDot1Smtp);
        this.m_scheduler.next();
        this.assertPoll(this.mDot1Smtp);
        this.assertTime(1000L);
        this.assertUp((PollableElement)this.pDot1Smtp);
        this.assertUnchanged((PollableElement)this.pDot1Smtp);
        this.m_scheduler.next();
        this.assertPoll(this.mDot1Smtp);
        this.assertTime(2000L);
        this.assertUp((PollableElement)this.pDot1Smtp);
        this.assertUnchanged((PollableElement)this.pDot1Smtp);
        this.m_scheduler.next();
        this.assertNoPoll(this.mDot1Smtp);
        this.assertTime(3000L);
        this.assertUp((PollableElement)this.pDot1Smtp);
        this.assertUnchanged((PollableElement)this.pDot1Smtp);
        this.m_scheduler.next();
        this.assertNoPoll(this.mDot1Smtp);
        this.assertTime(4000L);
        this.assertUp((PollableElement)this.pDot1Smtp);
        this.assertUnchanged((PollableElement)this.pDot1Smtp);
        this.m_scheduler.next();
        this.assertNoPoll(this.mDot1Smtp);
        this.assertTime(5000L);
        this.assertUp((PollableElement)this.pDot1Smtp);
        this.assertUnchanged((PollableElement)this.pDot1Smtp);
        this.m_scheduler.next();
        this.assertPoll(this.mDot1Smtp);
        this.assertTime(6000L);
        this.assertUp((PollableElement)this.pDot1Smtp);
        this.assertUnchanged((PollableElement)this.pDot1Smtp);
    }

    @Test
    public void testScheduledOutageOnNode() {
        this.m_pollerConfig.addScheduledOutage(this.m_pollerConfig.getPackage("TestPackage"), "first", 3000L, 5000L, this.pNode1.getNodeId());
        this.pDot1Smtp.getSchedule().schedule();
        this.m_scheduler.next();
        this.assertPoll(this.mDot1Smtp);
        this.assertTime(0L);
        this.assertUp((PollableElement)this.pDot1Smtp);
        this.assertUnchanged((PollableElement)this.pDot1Smtp);
        this.m_scheduler.next();
        this.assertPoll(this.mDot1Smtp);
        this.assertTime(1000L);
        this.assertUp((PollableElement)this.pDot1Smtp);
        this.assertUnchanged((PollableElement)this.pDot1Smtp);
        this.m_scheduler.next();
        this.assertPoll(this.mDot1Smtp);
        this.assertTime(2000L);
        this.assertUp((PollableElement)this.pDot1Smtp);
        this.assertUnchanged((PollableElement)this.pDot1Smtp);
        this.m_scheduler.next();
        this.assertNoPoll(this.mDot1Smtp);
        this.assertTime(3000L);
        this.assertUp((PollableElement)this.pDot1Smtp);
        this.assertUnchanged((PollableElement)this.pDot1Smtp);
        this.m_scheduler.next();
        this.assertNoPoll(this.mDot1Smtp);
        this.assertTime(4000L);
        this.assertUp((PollableElement)this.pDot1Smtp);
        this.assertUnchanged((PollableElement)this.pDot1Smtp);
        this.m_scheduler.next();
        this.assertNoPoll(this.mDot1Smtp);
        this.assertTime(5000L);
        this.assertUp((PollableElement)this.pDot1Smtp);
        this.assertUnchanged((PollableElement)this.pDot1Smtp);
        this.m_scheduler.next();
        this.assertPoll(this.mDot1Smtp);
        this.assertTime(6000L);
        this.assertUp((PollableElement)this.pDot1Smtp);
        this.assertUnchanged((PollableElement)this.pDot1Smtp);
    }

    @Test
    public void testMidnightOutageBug1122() throws ParseException {
        this.m_pollerConfig.addScheduledOutage(this.m_pollerConfig.getPackage("TestPackage"), "first", "monday", "23:59:57", "23:59:59", "192.168.1.1");
        this.m_pollerConfig.addScheduledOutage(this.m_pollerConfig.getPackage("TestPackage"), "second", "tuesday", "00:00:00", "00:00:02", "192.168.1.1");
        Date start = new SimpleDateFormat("dd-MMM-yyyy HH:mm:ss").parse("21-FEB-2005 23:59:56");
        long startTime = start.getTime();
        this.m_timer.setCurrentTime(startTime);
        this.pDot1Smtp.getSchedule().schedule();
        this.m_scheduler.next();
        this.assertPoll(this.mDot1Smtp);
        this.assertTime(startTime + 0L);
        this.assertUp((PollableElement)this.pDot1Smtp);
        this.assertUnchanged((PollableElement)this.pDot1Smtp);
        this.m_scheduler.next();
        this.assertNoPoll(this.mDot1Smtp);
        this.assertTime(startTime + 1000L);
        this.assertUp((PollableElement)this.pDot1Smtp);
        this.assertUnchanged((PollableElement)this.pDot1Smtp);
        this.m_scheduler.next();
        this.assertNoPoll(this.mDot1Smtp);
        this.assertTime(startTime + 2000L);
        this.assertUp((PollableElement)this.pDot1Smtp);
        this.assertUnchanged((PollableElement)this.pDot1Smtp);
        this.m_scheduler.next();
        this.assertNoPoll(this.mDot1Smtp);
        this.assertTime(startTime + 3000L);
        this.assertUp((PollableElement)this.pDot1Smtp);
        this.assertUnchanged((PollableElement)this.pDot1Smtp);
        this.m_scheduler.next();
        this.assertNoPoll(this.mDot1Smtp);
        this.assertTime(startTime + 4000L);
        this.assertUp((PollableElement)this.pDot1Smtp);
        this.assertUnchanged((PollableElement)this.pDot1Smtp);
        this.m_scheduler.next();
        this.assertNoPoll(this.mDot1Smtp);
        this.assertTime(startTime + 5000L);
        this.assertUp((PollableElement)this.pDot1Smtp);
        this.assertUnchanged((PollableElement)this.pDot1Smtp);
        this.m_scheduler.next();
        this.assertNoPoll(this.mDot1Smtp);
        this.assertTime(startTime + 6000L);
        this.assertUp((PollableElement)this.pDot1Smtp);
        this.assertUnchanged((PollableElement)this.pDot1Smtp);
        this.m_scheduler.next();
        this.assertPoll(this.mDot1Smtp);
        this.assertTime(startTime + 7000L);
        this.assertUp((PollableElement)this.pDot1Smtp);
        this.assertUnchanged((PollableElement)this.pDot1Smtp);
    }

    @Test
    public void testLoadService() throws Exception {
        this.anticipateDown(this.mDot1Smtp);
        this.mDot1Smtp.bringDown();
        this.pDot1Smtp.doPoll();
        this.m_network.processStatusChange(new Date());
        this.verifyAnticipated();
        this.m_network = this.createPollableNetwork((DataSource)((Object)this.m_db), (ScheduleTimer)this.m_scheduler, this.m_pollerConfig, (PollOutagesConfig)this.m_pollerConfig, this.m_pollContext);
        this.assignPollableMembers(this.m_network);
        this.assertDown((PollableElement)this.pDot1Smtp);
        this.anticipateUp(this.mDot1Smtp);
        this.mDot1Smtp.bringUp();
        this.pDot1Smtp.doPoll();
        this.m_network.processStatusChange(new Date());
        this.verifyAnticipated();
    }

    @Test
    public void testAddUpServiceToUpNodeWithCritSvc() throws Exception {
        this.testAddUpSvcToUpNode(1, "Router", "192.168.1.1", "SMTP", "HTTP");
    }

    @Test
    public void testAddUpServiceToUpNodeHasNoCritSvc() throws Exception {
        this.testAddUpSvcToUpNode(3, "Firewall", "192.168.1.4", "SMTP", "SNMP");
    }

    private void testAddUpSvcToUpNode(int nodeId, String nodeLabel, String ipAddr, String existingSvcName, String newSvcName) {
        PollableService pExistingSvc = this.m_network.getService(nodeId, this.getInetAddress(ipAddr), existingSvcName);
        Assert.assertNotNull((Object)pExistingSvc);
        PollableInterface pIface = pExistingSvc.getInterface();
        PollableNode pNode = pIface.getNode();
        pExistingSvc.doPoll();
        this.m_network.processStatusChange(new Date());
        this.verifyAnticipated();
        MockService mSvc = this.m_mockNetwork.addService(nodeId, ipAddr, newSvcName);
        this.m_db.writeService(mSvc);
        PollableService pSvc = this.addServiceToNetwork(nodeId, nodeLabel, ipAddr, newSvcName);
        Assert.assertNotNull((Object)pSvc);
        this.assertElementHasNullCause((PollableElement)pSvc);
        this.assertElementHasNullCause((PollableElement)pExistingSvc);
        this.assertElementHasNullCause((PollableElement)pIface);
        this.assertElementHasNullCause((PollableElement)pNode);
        this.assertUp((PollableElement)pSvc);
        this.assertUp((PollableElement)pExistingSvc);
        this.assertUp((PollableElement)pIface);
        this.assertUp((PollableElement)pNode);
        this.anticipateDown(mSvc);
        mSvc.bringDown();
        pSvc.doPoll();
        this.m_network.processStatusChange(new Date());
        this.verifyAnticipated();
    }

    @Test
    public void testAddDownServiceToDownNodeWithCritSvc() throws Exception {
        this.addDownServiceToDownNode(1, "Router", "192.168.1.1", "SMTP", "HTTP");
    }

    @Test
    public void testAddDownServiceToDownNodeHasNoCritSvc() throws Exception {
        this.addDownServiceToDownNode(3, "Firewall", "192.168.1.4", "SMTP", "SNMP");
    }

    private void addDownServiceToDownNode(int nodeId, String nodeLabel, String ipAddr, String existingSvcName, String newSvcName) {
        MockNode mNode = this.m_mockNetwork.getNode(nodeId);
        PollableService pExistingSvc = this.m_network.getService(nodeId, this.getInetAddress(ipAddr), existingSvcName);
        PollableInterface pIface = pExistingSvc.getInterface();
        PollableNode pNode = pExistingSvc.getNode();
        this.anticipateDown(mNode);
        mNode.bringDown();
        pExistingSvc.doPoll();
        this.m_network.processStatusChange(new Date());
        this.verifyAnticipated();
        PollEvent nodeCause = pNode.getCause();
        MockService mSvc = this.m_mockNetwork.addService(nodeId, ipAddr, newSvcName);
        this.m_db.writeService(mSvc);
        mSvc.bringDown();
        PollableService pSvc = this.addServiceToNetwork(nodeId, nodeLabel, ipAddr, newSvcName);
        Assert.assertNotNull((Object)pSvc);
        this.assertElementHasCause((PollableElement)pSvc, nodeCause);
        this.assertElementHasCause((PollableElement)pExistingSvc, nodeCause);
        this.assertElementHasCause((PollableElement)pIface, nodeCause);
        this.assertElementHasCause((PollableElement)pNode, nodeCause);
        this.assertDown((PollableElement)pSvc);
        this.assertDown((PollableElement)pExistingSvc);
        this.assertDown((PollableElement)pIface);
        this.assertDown((PollableElement)pNode);
        pSvc.doPoll();
        this.assertDown((PollableElement)pSvc);
        this.assertDown((PollableElement)pExistingSvc);
        this.assertDown((PollableElement)pIface);
        this.assertDown((PollableElement)pNode);
        this.m_network.processStatusChange(new Date());
        this.assertElementHasCause((PollableElement)pSvc, nodeCause);
        this.assertElementHasCause((PollableElement)pExistingSvc, nodeCause);
        this.assertElementHasCause((PollableElement)pIface, nodeCause);
        this.assertElementHasCause((PollableElement)pNode, nodeCause);
        this.verifyAnticipated();
    }

    @Test
    public void testAddDownServiceToUpNodeWithCritSvc() throws Exception {
        this.testAddDownServiceToUpNode(1, "Router", "192.168.1.1", "SMTP", "HTTP");
    }

    @Test
    public void testAddDownServiceToUpNodeHasNoCritSvc() throws Exception {
        this.testAddDownServiceToUpNode(3, "Firewal", "192.168.1.4", "SMTP", "SNMP");
    }

    private void testAddDownServiceToUpNode(int nodeId, String nodeLabel, String ipAddr, String existingSvcName, String newSvcName) {
        PollableService pExistingSvc = this.m_network.getService(nodeId, this.getInetAddress(ipAddr), existingSvcName);
        PollableInterface pIface = pExistingSvc.getInterface();
        PollableNode pNode = pExistingSvc.getNode();
        pExistingSvc.doPoll();
        this.m_network.processStatusChange(new Date());
        this.verifyAnticipated();
        MockService mSvc = this.m_mockNetwork.addService(nodeId, ipAddr, newSvcName);
        this.m_db.writeService(mSvc);
        mSvc.bringDown();
        this.anticipateDown(mSvc);
        PollableService pSvc = this.addServiceToNetwork(nodeId, nodeLabel, ipAddr, newSvcName);
        Assert.assertNotNull((Object)pSvc);
        this.assertElementHasNullCause((PollableElement)pSvc);
        this.assertElementHasNullCause((PollableElement)pExistingSvc);
        this.assertElementHasNullCause((PollableElement)pIface);
        this.assertElementHasNullCause((PollableElement)pNode);
        this.assertUp((PollableElement)pSvc);
        this.assertUp((PollableElement)pExistingSvc);
        this.assertUp((PollableElement)pIface);
        this.assertUp((PollableElement)pNode);
        pSvc.doPoll();
        this.assertDown((PollableElement)pSvc);
        this.assertUp((PollableElement)pExistingSvc);
        this.assertUp((PollableElement)pIface);
        this.assertUp((PollableElement)pNode);
        this.m_network.processStatusChange(new Date());
        Assert.assertNotNull((Object)pSvc.getCause());
        this.assertElementHasNullCause((PollableElement)pExistingSvc);
        this.assertElementHasNullCause((PollableElement)pIface);
        this.assertElementHasNullCause((PollableElement)pNode);
        this.verifyAnticipated();
    }

    @Test
    public void testLoadInterface() throws Exception {
        this.anticipateDown(this.mDot1);
        this.mDot1.bringDown();
        this.pDot1Smtp.doPoll();
        this.m_network.processStatusChange(new Date());
        this.verifyAnticipated();
        PollEvent ifCause = this.pDot1.getCause();
        this.m_network = this.createPollableNetwork((DataSource)((Object)this.m_db), (ScheduleTimer)this.m_scheduler, this.m_pollerConfig, (PollOutagesConfig)this.m_pollerConfig, this.m_pollContext);
        this.assignPollableMembers(this.m_network);
        this.assertElementHasCause((PollableElement)this.pDot1Smtp, ifCause);
        this.assertElementHasCause((PollableElement)this.pDot1Icmp, ifCause);
        this.assertElementHasCause((PollableElement)this.pDot1, ifCause);
        this.assertElementHasNullCause((PollableElement)this.pNode1);
        this.assertDown((PollableElement)this.pDot1Smtp);
        this.assertDown((PollableElement)this.pDot1Icmp);
        this.anticipateUp(this.mDot1);
        this.mDot1.bringUp();
        this.pDot1Icmp.doPoll();
        this.m_network.processStatusChange(new Date());
        this.verifyAnticipated();
    }

    @Test
    public void testLoadInterfaceWithMissingOutage() throws Exception {
        this.mDot4.bringDown();
        Event ifDownEvent = this.mDot4.createDownEvent();
        this.m_db.writeEvent(ifDownEvent);
        this.m_db.createOutage(this.mDot4Smtp, ifDownEvent);
        this.m_network = this.createPollableNetwork((DataSource)((Object)this.m_db), (ScheduleTimer)this.m_scheduler, this.m_pollerConfig, (PollOutagesConfig)this.m_pollerConfig, this.m_pollContext);
        this.assignPollableMembers(this.m_network);
        this.resetAnticipated();
        this.assertElementHasCause((PollableElement)this.pDot4Smtp, ifDownEvent);
        this.assertElementHasCause((PollableElement)this.pDot4, ifDownEvent);
        this.assertElementHasCause((PollableElement)this.pDot4Http, ifDownEvent);
        this.assertDown((PollableElement)this.pDot4Smtp);
        this.assertDown((PollableElement)this.pDot4Http);
        this.anticipateUp(this.mDot4);
        this.mDot4.bringUp();
        this.pDot4Http.doPoll();
        this.m_network.processStatusChange(new Date());
        this.verifyAnticipated();
    }

    private void assertElementHasCause(PollableElement element, Event causeEvent) {
        if (causeEvent == null) {
            this.assertElementHasNullCause(element);
        } else if (element.getCause() == null || element.getCause().getEventId() != causeEvent.getDbid()) {
            this.failCause(element, causeEvent);
        }
    }

    private void assertElementHasNullCause(PollableElement element) {
        Assert.assertNull((String)("Unexpected cause for element " + element + ": Expected cause to be null"), (Object)element.getCause());
    }

    private void assertElementHasCause(PollableElement element, PollEvent causeEvent) {
        if (causeEvent == null) {
            this.assertElementHasNullCause(element);
        } else if (element.getCause() == null || element.getCause().getEventId() != causeEvent.getEventId()) {
            this.failCause(element, causeEvent);
        }
    }

    private void failCause(PollableElement element, Object expectedCause) {
        throw new AssertionError((Object)("Unexpected cause for element " + element + " expected cause matching " + expectedCause + " but cause was " + element.getCause()));
    }

    @Test
    public void testLoadNode() throws Exception {
        this.anticipateDown(this.mNode1);
        this.mNode1.bringDown();
        this.pDot1Smtp.doPoll();
        this.m_network.processStatusChange(new Date());
        System.out.println("Cause is " + this.pNode1.getCause());
        this.verifyAnticipated();
        this.m_network = this.createPollableNetwork((DataSource)((Object)this.m_db), (ScheduleTimer)this.m_scheduler, this.m_pollerConfig, (PollOutagesConfig)this.m_pollerConfig, this.m_pollContext);
        this.assignPollableMembers(this.m_network);
        this.assertDown((PollableElement)this.pDot1Smtp);
        this.assertDown((PollableElement)this.pDot1Icmp);
        this.assertDown((PollableElement)this.pDot2Smtp);
        this.assertDown((PollableElement)this.pDot2Icmp);
        this.anticipateUp(this.mNode1);
        this.mNode1.bringUp();
        this.pDot1Icmp.doPoll();
        this.m_network.processStatusChange(new Date());
        this.verifyAnticipated();
    }

    @Test
    public void testLoadIndependentOutageEventsUpTogether() throws Exception {
        this.anticipateDown(this.mDot1Smtp);
        this.mDot1Smtp.bringDown();
        this.pDot1Smtp.doPoll();
        this.m_network.processStatusChange(new Date());
        PollEvent svcCause = this.pDot1Smtp.getCause();
        this.verifyAnticipated();
        this.anticipateDown(this.mNode1);
        this.mNode1.bringDown();
        this.pDot1Icmp.doPoll();
        this.m_network.processStatusChange(new Date());
        PollEvent nodeCause = this.pNode1.getCause();
        this.assertElementHasCause((PollableElement)this.pDot1Smtp, svcCause);
        this.assertElementHasCause((PollableElement)this.pDot1Icmp, nodeCause);
        this.assertElementHasCause((PollableElement)this.pNode1, nodeCause);
        this.verifyAnticipated();
        this.m_network = this.createPollableNetwork((DataSource)((Object)this.m_db), (ScheduleTimer)this.m_scheduler, this.m_pollerConfig, (PollOutagesConfig)this.m_pollerConfig, this.m_pollContext);
        this.assignPollableMembers(this.m_network);
        this.assertElementHasCause((PollableElement)this.pDot1Smtp, svcCause);
        this.assertElementHasCause((PollableElement)this.pDot1Icmp, nodeCause);
        this.assertElementHasCause((PollableElement)this.pNode1, nodeCause);
        this.assertDown((PollableElement)this.pDot1Smtp);
        this.assertDown((PollableElement)this.pDot1Icmp);
        this.assertDown((PollableElement)this.pDot2Smtp);
        this.assertDown((PollableElement)this.pDot2Icmp);
        this.assertDown((PollableElement)this.pDot1);
        this.assertDown((PollableElement)this.pDot2);
        this.assertDown((PollableElement)this.pNode1);
        this.anticipateUp(this.mDot1Smtp);
        this.anticipateUp(this.mNode1);
        this.mNode1.bringUp();
        this.pDot1Icmp.doPoll();
        this.m_network.processStatusChange(new Date());
        this.verifyAnticipated();
    }

    @Test
    public void testLoadIndependentOutageEventsUpSeparately() throws Exception {
        this.anticipateDown(this.mDot1Smtp);
        this.mDot1Smtp.bringDown();
        this.pDot1Smtp.doPoll();
        this.m_network.processStatusChange(new Date());
        this.verifyAnticipated();
        this.anticipateDown(this.mNode1);
        this.mNode1.bringDown();
        this.pDot1Icmp.doPoll();
        this.m_network.processStatusChange(new Date());
        this.verifyAnticipated();
        this.m_network = this.createPollableNetwork((DataSource)((Object)this.m_db), (ScheduleTimer)this.m_scheduler, this.m_pollerConfig, (PollOutagesConfig)this.m_pollerConfig, this.m_pollContext);
        this.assignPollableMembers(this.m_network);
        this.assertDown((PollableElement)this.pDot1Smtp);
        this.assertDown((PollableElement)this.pDot1Icmp);
        this.assertDown((PollableElement)this.pDot2Smtp);
        this.assertDown((PollableElement)this.pDot2Icmp);
        this.assertDown((PollableElement)this.pDot1);
        this.assertDown((PollableElement)this.pDot2);
        this.assertDown((PollableElement)this.pNode1);
        this.anticipateUp(this.mNode1);
        this.m_outageAnticipator.deanticipateOutageClosed(this.mDot1Smtp, this.mNode1.createUpEvent());
        this.mNode1.bringUp();
        this.mDot1Smtp.bringDown();
        this.pDot1Icmp.doPoll();
        this.m_network.processStatusChange(new Date());
        this.verifyAnticipated();
        this.anticipateUp(this.mDot1Smtp);
        this.mDot1Smtp.bringUp();
        this.pDot1Smtp.doPoll();
        this.m_network.processStatusChange(new Date());
        this.verifyAnticipated();
    }

    @Test
    public void testLock() throws Exception {
        int i;
        final Runnable r = new Runnable(){

            public void run() {
                PollablesTest.this.m_lockCount++;
                Assert.assertEquals((long)1L, (long)PollablesTest.this.m_lockCount);
                try {
                    Thread.sleep(3000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                PollablesTest.this.m_lockCount--;
                Assert.assertEquals((long)0L, (long)PollablesTest.this.m_lockCount);
            }
        };
        Runnable locker = new Runnable(){

            public void run() {
                PollablesTest.this.pNode1.withTreeLock(r);
            }
        };
        Thread[] threads = new Thread[5];
        for (i = 0; i < 5; ++i) {
            threads[i] = new Thread(locker);
            threads[i].start();
        }
        for (i = 0; i < 5; ++i) {
            threads[i].join();
        }
    }

    @Test
    public void testLockTimeout() throws Exception {
        int i;
        final Runnable r = new Runnable(){

            public void run() {
                PollablesTest.this.m_lockCount++;
                Assert.assertEquals((long)1L, (long)PollablesTest.this.m_lockCount);
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                PollablesTest.this.m_lockCount--;
                Assert.assertEquals((long)0L, (long)PollablesTest.this.m_lockCount);
            }
        };
        Runnable locker = new Runnable(){

            public void run() {
                PollablesTest.this.pNode1.withTreeLock(r);
            }
        };
        Runnable lockerWithTimeout = new Runnable(){

            public void run() {
                try {
                    PollablesTest.this.pNode1.withTreeLock(r, 500L);
                    Assert.fail((String)"Expected LockUnavailable");
                }
                catch (LockUnavailable e) {
                    MockUtil.println((String)("Received expected exception " + (Object)((Object)e)));
                }
            }
        };
        Thread[] threads = new Thread[5];
        threads[0] = new Thread(locker);
        threads[0].start();
        for (i = 1; i < 5; ++i) {
            threads[i] = new Thread(lockerWithTimeout);
            threads[i].start();
        }
        for (i = 0; i < 5; ++i) {
            threads[i].join();
        }
    }

    private void assertTime(long time) {
        Assert.assertEquals((String)"Unexpected time", (long)time, (long)this.m_scheduler.getCurrentTime());
    }

    private void verifyAnticipated() {
        this.m_eventMgr.finishProcessingEvents();
        MockEventUtil.printEvents("Missing Anticipated Events: ", this.m_anticipator.getAnticipatedEvents());
        Assert.assertTrue((String)"Expected events not forthcoming", (boolean)this.m_anticipator.getAnticipatedEvents().isEmpty());
        MockEventUtil.printEvents("Unanticipated: ", this.m_anticipator.unanticipatedEvents());
        Assert.assertEquals((String)"Received unexpected events", (long)0L, (long)this.m_anticipator.unanticipatedEvents().size());
        Assert.assertEquals((String)"Wrong number of outages opened", (long)this.m_outageAnticipator.getExpectedOpens(), (long)this.m_outageAnticipator.getActualOpens());
        Assert.assertEquals((String)"Wrong number of outages in outage table", (long)this.m_outageAnticipator.getExpectedOutages(), (long)this.m_outageAnticipator.getActualOutages());
        Assert.assertTrue((String)"Created outages don't match the expected outages", (boolean)this.m_outageAnticipator.checkAnticipated());
        this.resetAnticipated();
    }

    private void resetAnticipated() {
        this.m_anticipator.reset();
        this.m_outageAnticipator.reset();
    }

    private void anticipateUp(MockElement element) {
        Event event = element.createUpEvent();
        this.m_anticipator.anticipateEvent(event);
        this.m_outageAnticipator.anticipateOutageClosed(element, event);
    }

    private void anticipateDown(MockElement element) {
        Event event = element.createDownEvent();
        this.m_anticipator.anticipateEvent(event);
        this.m_outageAnticipator.anticipateOutageOpened(element, event);
    }

    private void anticipateUnresponsive(MockElement element) {
        MockVisitorAdapter visitor = new MockVisitorAdapter(){

            public void visitService(MockService svc) {
                PollablesTest.this.m_anticipator.anticipateEvent(svc.createUnresponsiveEvent());
            }
        };
        element.visit(visitor);
    }

    private void anticipateResponsive(MockElement element) {
        MockVisitorAdapter visitor = new MockVisitorAdapter(){

            public void visitService(MockService svc) {
                PollablesTest.this.m_anticipator.anticipateEvent(svc.createResponsiveEvent());
            }
        };
        element.visit(visitor);
    }

    private void assertPoll(MockService svc) {
        Assert.assertEquals((long)1L, (long)svc.getPollCount());
        svc.resetPollCount();
    }

    private void assertNoPoll(MockElement elem) {
        MockVisitorAdapter zeroAsserter = new MockVisitorAdapter(){

            public void visitService(MockService svc) {
                Assert.assertEquals((String)("Unexpected poll count for " + svc), (long)0L, (long)svc.getPollCount());
            }
        };
        elem.visit(zeroAsserter);
    }

    private void assertChanged(PollableElement elem) {
        Assert.assertEquals((Object)true, (Object)elem.isStatusChanged());
    }

    private void assertUnchanged(PollableElement elem) {
        Assert.assertEquals((Object)false, (Object)elem.isStatusChanged());
    }

    private void assertUp(PollableElement elem) {
        Assert.assertEquals((Object)PollStatus.up(), (Object)elem.getStatus());
    }

    private void assertDown(PollableElement elem) {
        Assert.assertEquals((Object)PollStatus.down(), (Object)elem.getStatus());
    }

    protected Package findPackageForService(PollerConfig pollerConfig, String ipAddr, String serviceName) {
        Enumeration en = pollerConfig.enumeratePackage();
        Package lastPkg = null;
        while (en.hasMoreElements()) {
            Package pkg = (Package)en.nextElement();
            if (!this.pollableServiceInPackage(pollerConfig, ipAddr, serviceName, pkg)) continue;
            lastPkg = pkg;
        }
        return lastPkg;
    }

    private boolean pollableServiceInPackage(PollerConfig pollerConfig, String ipAddr, String serviceName, Package pkg) {
        return pollerConfig.serviceInPackageAndEnabled(serviceName, pkg) && pollerConfig.interfaceInPackage(ipAddr, pkg);
    }

    private InetAddress getInetAddress(String ipAddr) {
        InetAddress addr;
        try {
            addr = InetAddress.getByName(ipAddr);
        }
        catch (UnknownHostException e) {
            throw new RuntimeException("Error converting " + ipAddr + " to an InetAddress", e);
        }
        return addr;
    }

    private PollableService addServiceToNetwork(final int nodeId, final String nodeLabel, final String ipAddr, final String serviceName) {
        PollableNode svcNode = this.m_network.createNodeIfNecessary(nodeId, nodeLabel);
        return (PollableService)svcNode.withTreeLock((Callable)new Callable<PollableService>(){

            @Override
            public PollableService call() throws Exception {
                PollableService svc = PollablesTest.this.addServiceToNetwork(PollablesTest.this.m_network, nodeId, nodeLabel, ipAddr, serviceName, null, null, null, (ScheduleTimer)PollablesTest.this.m_scheduler, PollablesTest.this.m_pollerConfig, (PollOutagesConfig)PollablesTest.this.m_pollerConfig);
                return svc;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PollableService addServiceToNetwork(PollableNetwork pNetwork, int nodeId, String nodeLabel, String ipAddr, String serviceName, Number svcLostEventId, String svcLostUei, Date svcLostTime, ScheduleTimer scheduler, PollerConfig pollerConfig, PollOutagesConfig pollOutageConfig) {
        InetAddress addr = this.getInetAddress(ipAddr);
        Package pkg = this.findPackageForService(pollerConfig, ipAddr, serviceName);
        if (pkg == null) {
            MockUtil.println((String)("No package for service " + serviceName + " with ipAddr " + ipAddr));
            return null;
        }
        PollableService svc = pNetwork.createService(nodeId, nodeLabel, addr, serviceName);
        PollableServiceConfig pollConfig = new PollableServiceConfig(svc, pollerConfig, pollOutageConfig, pkg, (Timer)scheduler);
        svc.setPollConfig(pollConfig);
        PollableService pollableService = svc;
        synchronized (pollableService) {
            if (svc.getSchedule() == null) {
                Schedule schedule = new Schedule((ReadyRunnable)svc, (ScheduleInterval)pollConfig, scheduler);
                svc.setSchedule(schedule);
            }
        }
        if (svcLostEventId == null) {
            if (svc.getParent().getStatus().isUnknown()) {
                svc.updateStatus(PollStatus.up());
            } else {
                svc.updateStatus(svc.getParent().getStatus());
                svc.setCause(svc.getParent().getCause());
            }
        } else {
            svc.updateStatus(PollStatus.down());
            DbPollEvent cause = new DbPollEvent(svcLostEventId.intValue(), svcLostUei, svcLostTime);
            svc.setCause((PollEvent)cause);
        }
        return svc;
    }

    static class InitCause
    extends PollableVisitorAdaptor {
        private PollEvent m_cause;

        public InitCause(PollEvent cause) {
            this.m_cause = cause;
        }

        public void visitElement(PollableElement element) {
            if (!element.hasOpenOutage()) {
                element.setCause(this.m_cause);
            }
        }
    }
}

