/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.notifd;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.LinkedList;
import java.util.Map;
import junit.textui.TestRunner;
import org.opennms.netmgt.config.groups.Group;
import org.opennms.netmgt.config.notifications.Notification;
import org.opennms.netmgt.mock.MockNode;
import org.opennms.netmgt.notifd.BroadcastEventProcessor;
import org.opennms.netmgt.notifd.NotificationTask;
import org.opennms.netmgt.notifd.NotificationsTestCase;
import org.opennms.netmgt.xml.event.Event;

public class TaskCreationTest
extends NotificationsTestCase {
    private static final int INTERVAL = 1000;
    private BroadcastEventProcessor m_eventProcessor;
    private Notification m_notif;
    private Map<String, String> m_params;
    private String[] m_commands;

    public static void main(String[] args) {
        TestRunner.run(TaskCreationTest.class);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.m_eventProcessor = this.m_notifd.getBroadcastEventProcessor();
        this.m_notif = this.m_notificationManager.getNotification("nodeDown");
        MockNode node = this.m_network.getNode(1);
        Event nodeDownEvent = node.createDownEvent();
        this.m_params = this.m_eventProcessor.buildParameterMap(this.m_notif, nodeDownEvent, 1);
        this.m_commands = new String[]{"email"};
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testMakeEmailTask() throws Exception {
        long startTime = this.now();
        NotificationTask task = this.m_eventProcessor.makeEmailTask(startTime, this.m_params, 1, "brozow@opennms.org", this.m_commands, new LinkedList(), null);
        TaskCreationTest.assertNotNull((Object)task);
        TaskCreationTest.assertEquals((String)"brozow@opennms.org", (String)task.getEmail());
        TaskCreationTest.assertEquals((long)startTime, (long)task.getSendTime());
    }

    private long now() {
        return System.currentTimeMillis();
    }

    public void testMakeUserTask() throws Exception {
        long startTime = this.now();
        NotificationTask task = this.m_eventProcessor.makeUserTask(startTime, this.m_params, 1, "brozow", this.m_commands, new LinkedList(), null);
        TaskCreationTest.assertNotNull((Object)task);
        TaskCreationTest.assertEquals((String)"brozow@opennms.org", (String)task.getEmail());
        TaskCreationTest.assertEquals((long)startTime, (long)task.getSendTime());
    }

    private void assertTasksWithEmail(NotificationTask[] tasks, String ... emails) throws Exception {
        TaskCreationTest.assertNotNull((Object)tasks);
        TaskCreationTest.assertEquals((String)"Unexpected number of tasks", (int)emails.length, (int)tasks.length);
        for (String email : emails) {
            TaskCreationTest.assertNotNull((String)("Expected to find a task with email " + email + " in " + tasks), (Object)this.findTaskWithEmail(tasks, email));
        }
    }

    private void assertStartInterval(NotificationTask[] tasks, long startTime, long interval) {
        TaskCreationTest.assertNotNull((Object)tasks);
        long expectedTime = startTime;
        for (NotificationTask task : tasks) {
            TaskCreationTest.assertEquals((String)("Expected task " + task + " to have sendTime " + expectedTime), (long)expectedTime, (long)task.getSendTime());
            expectedTime += interval;
        }
    }

    public void testMakeGroupTasks() throws Exception {
        long startTime = this.now();
        NotificationTask[] tasks = this.m_eventProcessor.makeGroupTasks(startTime, this.m_params, 1, "EscalationGroup", this.m_commands, new LinkedList(), null, 1000L);
        this.assertTasksWithEmail(tasks, "brozow@opennms.org", "david@opennms.org");
        this.assertStartInterval(tasks, startTime, 1000L);
    }

    public void testMakeGroupTasksWithDutySchedule() throws Exception {
        String groupName = "EscalationGroup";
        Group group = this.m_groupManager.getGroup("EscalationGroup");
        group.addDutySchedule("MoTuWeThFr0900-1700");
        this.m_groupManager.saveGroups();
        long dayTime = this.getTimeStampFor("21-FEB-2005 11:59:56");
        NotificationTask[] dayTasks = this.m_eventProcessor.makeGroupTasks(dayTime, this.m_params, 1, "EscalationGroup", this.m_commands, new LinkedList(), null, 1000L);
        this.assertTasksWithEmail(dayTasks, "brozow@opennms.org", "david@opennms.org");
        this.assertStartInterval(dayTasks, dayTime, 1000L);
        long nightTime = this.getTimeStampFor("21-FEB-2005 23:00:00");
        NotificationTask[] nightTasks = this.m_eventProcessor.makeGroupTasks(nightTime, this.m_params, 1, "EscalationGroup", this.m_commands, new LinkedList(), null, 1000L);
        this.assertTasksWithEmail(nightTasks, "brozow@opennms.org", "david@opennms.org");
        this.assertStartInterval(nightTasks, nightTime + 36000000L, 1000L);
    }

    public void testMakeRoleTasks() throws Exception {
        long dayTime = this.getTimeStampFor("21-FEB-2005 11:59:56");
        NotificationTask[] tasks = this.m_eventProcessor.makeRoleTasks(dayTime, this.m_params, 1, "oncall", this.m_commands, new LinkedList(), null, 1000L);
        this.assertTasksWithEmail(tasks, "brozow@opennms.org");
        this.assertStartInterval(tasks, dayTime, 1000L);
        long sundayTime = this.getTimeStampFor("30-JAN-2005 11:59:56");
        NotificationTask[] sundayTasks = this.m_eventProcessor.makeRoleTasks(sundayTime, this.m_params, 1, "oncall", this.m_commands, new LinkedList(), null, 1000L);
        this.assertTasksWithEmail(sundayTasks, "brozow@opennms.org", "admin@opennms.org");
        this.assertStartInterval(sundayTasks, sundayTime, 1000L);
    }

    private long getTimeStampFor(String timeString) throws ParseException {
        return new SimpleDateFormat("dd-MMM-yyyy HH:mm:ss").parse(timeString).getTime();
    }

    private NotificationTask findTaskWithEmail(NotificationTask[] tasks, String email) throws Exception {
        TaskCreationTest.assertNotNull((Object)email);
        for (NotificationTask task : tasks) {
            TaskCreationTest.assertNotNull((Object)task);
            if (!email.equals(task.getEmail())) continue;
            return task;
        }
        return null;
    }
}

