/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.mock;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.opennms.core.utils.PropertiesUtils;
import org.opennms.mock.snmp.MockSnmpAgent;
import org.opennms.netmgt.config.snmp.Definition;
import org.opennms.netmgt.config.snmp.SnmpConfig;
import org.opennms.netmgt.eventd.EventIpcManager;
import org.opennms.netmgt.eventd.EventIpcManagerFactory;
import org.opennms.netmgt.mock.EventAnticipator;
import org.opennms.netmgt.mock.MockDatabase;
import org.opennms.netmgt.mock.MockEventIpcManager;
import org.opennms.netmgt.mock.MockNetwork;
import org.opennms.test.ConfigurationTestUtils;
import org.springframework.core.io.Resource;
import org.springframework.test.AbstractTransactionalDataSourceSpringContextTests;

public abstract class OpenNMSIntegrationTestCase
extends AbstractTransactionalDataSourceSpringContextTests {
    protected MockDatabase m_db;
    private Properties m_substitions;
    private MockNetwork m_network;
    private MockSnmpAgent m_agent;
    private static MockEventIpcManager s_mockEventIpcManager;
    private static boolean s_setupHomeDir;

    public MockEventIpcManager getMockEventIpcManager() {
        return s_mockEventIpcManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setupOpenNMSHomeDir() throws Exception {
        File etcSourceDir = ConfigurationTestUtils.getDaemonEtcDirectory();
        File currentDir = new File(System.getProperty("user.dir"));
        File targetDir = new File(currentDir, "target");
        File itTestDir = new File(targetDir, "integration-tests");
        File homeDir = new File(itTestDir, ((Object)((Object)this)).getClass().getName());
        if (!homeDir.exists()) {
            OpenNMSIntegrationTestCase.assertTrue((String)("Unable to create tmp homeDir " + homeDir), (boolean)homeDir.mkdirs());
        }
        System.setProperty("opennms.home", homeDir.getAbsolutePath());
        final File etcDestDir = new File(homeDir, "etc");
        File shareDir = new File(homeDir, "share");
        File rrdDir = new File(shareDir, "rrd");
        if (!rrdDir.exists()) {
            OpenNMSIntegrationTestCase.assertTrue((String)"Unable to create rrd base dir", (boolean)rrdDir.mkdirs());
        }
        final File createSql = new File(etcDestDir, "create.sql");
        this.m_db = new MockDatabase(false){

            protected String getCreateSqlLocation() {
                return createSql.getAbsolutePath();
            }

            protected String getStoredProcDirectory() {
                return etcDestDir.getAbsolutePath();
            }
        };
        this.m_substitions = new Properties(System.getProperties());
        this.m_substitions.setProperty("install.database.driver", this.m_db.getDriver());
        this.m_substitions.setProperty("install.database.url", this.m_db.getUrl());
        this.m_substitions.setProperty("install.database.name", this.m_db.getTestDatabase());
        this.m_substitions.setProperty("install.database.user", "opennms");
        this.m_substitions.setProperty("install.database.password", "opennms");
        this.m_substitions.setProperty("install.share.dir", shareDir.getAbsolutePath());
        this.m_substitions.setProperty("install.rrdtool.bin", "/usr/local/bin/rrdtool");
        this.copyDirectory(etcSourceDir, etcDestDir);
        this.m_db.create();
        Properties opennmsProperties = new Properties();
        FileInputStream in = null;
        try {
            in = new FileInputStream(new File(etcDestDir, "opennms.properties"));
            opennmsProperties.load(in);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(in);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)in);
        System.getProperties().putAll((Map<?, ?>)opennmsProperties);
        if (s_mockEventIpcManager == null) {
            s_mockEventIpcManager = new MockEventIpcManager();
            EventIpcManagerFactory.setIpcManager((EventIpcManager)s_mockEventIpcManager);
        } else {
            s_mockEventIpcManager.reset();
        }
        this.m_network = this.createMockNetwork();
        this.populateDatabase();
        MockAgentConfiguration mockAgentConfig = this.getMockAgentConfiguration();
        if (mockAgentConfig != null) {
            String localhost = this.getLocalHostAddress();
            this.m_agent = MockSnmpAgent.createAgentAndRun((Resource)mockAgentConfig.getSnmpDataResource(), (String)(localhost + "/9161"));
            File snmpConfigFile = new File(etcDestDir, "snmp-config.xml");
            SnmpConfig config = this.readSnmpConfig(snmpConfigFile);
            Definition def = new Definition();
            def.setPort(9161);
            def.setVersion("v2c");
            def.setReadCommunity("public");
            def.setProxyHost(localhost);
            for (String ipAddr : mockAgentConfig.getProxiedAddresses()) {
                def.addSpecific(ipAddr);
            }
            config.addDefinition(def);
            this.writeSnmpConfig(config, snmpConfigFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeSnmpConfig(SnmpConfig config, File snmpConfigFile) throws IOException, MarshalException, ValidationException {
        FileWriter cfgOut = null;
        try {
            cfgOut = new FileWriter(snmpConfigFile);
            Marshaller.marshal((Object)config, (Writer)cfgOut);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(cfgOut);
            throw throwable;
        }
        IOUtils.closeQuietly((Writer)cfgOut);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SnmpConfig readSnmpConfig(File snmpConfig) throws FileNotFoundException, MarshalException, ValidationException {
        SnmpConfig snmpConfig2;
        FileReader cfgIn = null;
        try {
            cfgIn = new FileReader(snmpConfig);
            snmpConfig2 = (SnmpConfig)Unmarshaller.unmarshal(SnmpConfig.class, (Reader)cfgIn);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(cfgIn);
            throw throwable;
        }
        IOUtils.closeQuietly((Reader)cfgIn);
        return snmpConfig2;
    }

    protected String getLocalHostAddress() {
        try {
            return InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
            OpenNMSIntegrationTestCase.fail((String)"Exception getting localhost");
            return null;
        }
    }

    protected MockAgentConfiguration getMockAgentConfiguration() {
        return null;
    }

    protected MockNetwork createMockNetwork() {
        MockNetwork network = new MockNetwork();
        network.setCriticalService("ICMP");
        network.addNode(1, "Router");
        network.addInterface("192.168.1.1");
        network.addService("ICMP");
        network.addService("SMTP");
        network.addInterface("192.168.1.2");
        network.addService("ICMP");
        network.addService("SMTP");
        network.addNode(2, "Server");
        network.addInterface("192.168.1.3");
        network.addService("ICMP");
        network.addService("HTTP");
        network.addNode(3, "Firewall");
        network.addInterface("192.168.1.4");
        network.addService("SMTP");
        network.addService("HTTP");
        network.addInterface("192.168.1.5");
        network.addService("SMTP");
        network.addService("HTTP");
        return network;
    }

    protected void populateDatabase() throws Exception {
        this.m_db.populate(this.m_network);
    }

    private void copyDirectory(File srcDir, File destDir) throws IOException {
        OpenNMSIntegrationTestCase.assertNotNull((Object)srcDir);
        OpenNMSIntegrationTestCase.assertNotNull((Object)destDir);
        OpenNMSIntegrationTestCase.assertTrue((boolean)srcDir.exists());
        if (destDir.exists()) {
            OpenNMSIntegrationTestCase.assertTrue((String)("Expected destDir to be a directory: " + destDir), (boolean)destDir.isDirectory());
        }
        this.doCopyDirectory(srcDir, destDir);
    }

    private void doCopyDirectory(File srcDir, File destDir) throws IOException {
        if (!destDir.exists()) {
            OpenNMSIntegrationTestCase.assertTrue((String)("Unable to create directory " + destDir), (boolean)destDir.mkdirs());
        }
        for (File srcFile : srcDir.listFiles()) {
            File destFile = new File(destDir, srcFile.getName());
            if (srcFile.isDirectory()) {
                this.doCopyDirectory(srcFile, destFile);
                continue;
            }
            this.doCopyFile(srcFile, destFile);
        }
    }

    private void doCopyFile(File srcFile, File destFile) throws IOException {
        String contents = this.readFileContents(srcFile);
        contents = this.preprocessConfigContents(srcFile, contents);
        String results = PropertiesUtils.substitute((String)contents, (Properties)this.m_substitions, (String)"${", (String)"}");
        results = this.postprocessConfigContents(destFile, results);
        this.writeFileContents(results, destFile);
    }

    protected String postprocessConfigContents(File destFile, String results) {
        return results;
    }

    protected String preprocessConfigContents(File srcFile, String contents) {
        return contents;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeFileContents(String results, File destFile) throws IOException {
        FileWriter writer = null;
        try {
            writer = new FileWriter(destFile);
            IOUtils.write((String)results, (Writer)writer);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(writer);
            throw throwable;
        }
        IOUtils.closeQuietly((Writer)writer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readFileContents(File srcFile) throws IOException {
        String string;
        FileReader reader = null;
        try {
            reader = new FileReader(srcFile);
            string = IOUtils.toString((Reader)reader);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(reader);
            throw throwable;
        }
        IOUtils.closeQuietly((Reader)reader);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runBare() throws Throwable {
        try {
            if (!s_setupHomeDir) {
                this.setupOpenNMSHomeDir();
                s_setupHomeDir = true;
            }
            super.runBare();
        }
        finally {
            this.stopAgent();
        }
    }

    private void stopAgent() throws InterruptedException {
        if (this.m_agent != null) {
            this.m_agent.shutDownAndWait();
        }
    }

    protected EventAnticipator getEventAnticipator() {
        return this.getMockEventIpcManager().getEventAnticipator();
    }

    static {
        s_setupHomeDir = false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class MockAgentConfiguration {
        Resource m_snmpDataResource;
        List<String> m_proxiedAddresses = new ArrayList<String>();

        public Resource getSnmpDataResource() {
            return this.m_snmpDataResource;
        }

        public void setSnmpDataResource(Resource snmpDataResource) {
            this.m_snmpDataResource = snmpDataResource;
        }

        public Collection<String> getProxiedAddresses() {
            return this.m_proxiedAddresses;
        }

        public void addProxiedAddress(String ipAddr) {
            this.m_proxiedAddresses.add(ipAddr);
        }
    }
}

