/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.mock;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;
import org.opennms.netmgt.mock.MockContainer;
import org.opennms.netmgt.mock.MockEventUtil;
import org.opennms.netmgt.mock.MockNetwork;
import org.opennms.netmgt.mock.MockNode;
import org.opennms.netmgt.mock.MockService;
import org.opennms.netmgt.mock.MockVisitor;
import org.opennms.netmgt.mock.MockVisitorAdapter;
import org.opennms.netmgt.model.PollStatus;
import org.opennms.netmgt.xml.event.Event;

public class MockInterface
extends MockContainer {
    private String m_ipAddr;
    private String m_ifAlias;
    private InetAddress m_inetAddr;
    private int m_ifIndex;

    public MockInterface(MockNode node, String ipAddr) {
        super(node);
        this.m_ipAddr = ipAddr;
        this.m_ifIndex = node.getNextIfIndex();
        try {
            this.m_inetAddr = InetAddress.getByName(ipAddr);
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException("unable to convert " + ipAddr + " to an InetAddress: " + e.getMessage());
        }
    }

    public MockService addService(String svcName, int serviceId) {
        return (MockService)this.addMember(new MockService(this, svcName, serviceId));
    }

    public String getIpAddr() {
        return this.m_ipAddr;
    }

    Object getKey() {
        return this.m_ipAddr;
    }

    public MockNetwork getNetwork() {
        return this.getNode().getNetwork();
    }

    public MockNode getNode() {
        return (MockNode)this.getParent();
    }

    public int getNodeId() {
        return this.getNode().getNodeId();
    }

    public String getNodeLabel() {
        return this.getNode().getLabel();
    }

    public PollStatus getPollStatus() {
        String critSvcName = this.getNetwork().getCriticalService();
        final MockService critSvc = this.getService(critSvcName);
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class IFStatusCalculator
        extends MockVisitorAdapter {
            PollStatus status = PollStatus.down();

            IFStatusCalculator() {
            }

            public PollStatus getStatus() {
                return this.status;
            }

            @Override
            public void visitService(MockService svc) {
                if ((critSvc == null || critSvc.equals(svc)) && svc.getPollStatus().isUp()) {
                    this.status = PollStatus.up();
                }
            }
        }
        IFStatusCalculator calc = new IFStatusCalculator();
        this.visit(calc);
        return calc.getStatus();
    }

    public MockService getService(String svcName) {
        return (MockService)this.getMember(svcName);
    }

    public List getServices() {
        return this.getMembers();
    }

    public void removeService(MockService svc) {
        this.removeMember(svc);
    }

    public String toString() {
        return "If[" + this.m_ipAddr + "]";
    }

    public void visit(MockVisitor v) {
        super.visit(v);
        v.visitInterface(this);
        this.visitMembers(v);
    }

    public Event createDownEvent() {
        return MockEventUtil.createInterfaceDownEvent("Test", this);
    }

    public Event createUpEvent() {
        return MockEventUtil.createInterfaceUpEvent("Test", this);
    }

    public Event createDeleteEvent() {
        return MockEventUtil.createInterfaceDeletedEvent("Test", this);
    }

    public void setIfAlias(String ifAlias) {
        this.m_ifAlias = ifAlias;
    }

    public String getIfAlias() {
        return this.m_ifAlias;
    }

    public InetAddress getAddress() {
        return this.m_inetAddr;
    }

    public int getIfIndex() {
        return this.m_ifIndex;
    }
}

