/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.mock;

import java.sql.ResultSet;
import java.sql.SQLException;
import javax.sql.DataSource;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.opennms.netmgt.mock.MockDatabase;
import org.opennms.netmgt.mock.MockEventUtil;
import org.opennms.netmgt.mock.MockInterface;
import org.opennms.netmgt.mock.MockNetwork;
import org.opennms.netmgt.mock.MockNode;
import org.opennms.netmgt.mock.MockService;
import org.opennms.netmgt.utils.Querier;
import org.opennms.netmgt.xml.event.Event;

public class MockDatabaseTest
extends TestCase {
    private MockNetwork m_network;
    private MockDatabase m_db;
    private MockDatabase m_secondDb;

    protected void setUp() throws Exception {
        super.setUp();
        this.m_network = new MockNetwork();
        this.m_network.setCriticalService("ICMP");
        this.m_network.addNode(1, "Router");
        this.m_network.addInterface("192.168.1.1");
        this.m_network.addService("ICMP");
        this.m_network.addService("SMTP");
        this.m_network.addInterface("192.168.1.2");
        this.m_network.addService("ICMP");
        this.m_network.addService("SMTP");
        this.m_network.addNode(2, "Server");
        this.m_network.addInterface("192.168.1.3");
        this.m_network.addService("ICMP");
        this.m_network.addService("HTTP").setMgmtStatus(MockService.SvcMgmtStatus.NOT_POLLED);
        this.m_network.addInterface("192.168.1.2");
        this.m_db = new MockDatabase();
        this.m_db.populate(this.m_network);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.m_db.drop();
        if (this.m_secondDb != null) {
            this.m_secondDb.drop();
        }
    }

    public void testNodeQuery() {
        Querier querier = new Querier((DataSource)((Object)this.m_db), "select * from node"){

            public void processRow(ResultSet rs) throws SQLException {
                int nodeId = rs.getInt("nodeId");
                String label = rs.getString("nodeLabel");
                MockNode node = MockDatabaseTest.this.m_network.getNode(nodeId);
                Assert.assertNotNull((Object)node);
                Assert.assertEquals((int)nodeId, (int)node.getNodeId());
                Assert.assertEquals((String)label, (String)node.getLabel());
            }
        };
        querier.execute();
        MockDatabaseTest.assertEquals((int)this.m_network.getNodeCount(), (int)querier.getCount());
    }

    public void testMultipleDatabases() throws Exception {
        this.m_secondDb = new MockDatabase(this.m_db.getTestDatabase() + "_test2");
        Querier secondQuerier = new Querier((DataSource)((Object)this.m_secondDb), "select * from node");
        secondQuerier.execute();
        Querier querier = new Querier((DataSource)((Object)this.m_db), "select * from node");
        querier.execute();
        MockDatabaseTest.assertFalse((secondQuerier.getCount() == querier.getCount() ? 1 : 0) != 0);
        MockNode node = this.m_network.getNode(1);
        this.m_secondDb.writeNode(node);
        secondQuerier = new Querier((DataSource)((Object)this.m_secondDb), "select * from node");
        secondQuerier.execute();
        MockDatabaseTest.assertEquals((int)1, (int)secondQuerier.getCount());
    }

    public void testIFQuery() {
        Querier querier = new Querier((DataSource)((Object)this.m_db), "select * from ipInterface"){

            public void processRow(ResultSet rs) throws SQLException {
                int nodeId = rs.getInt("nodeId");
                String ipAddr = rs.getString("ipAddr");
                MockInterface iface = MockDatabaseTest.this.m_network.getInterface(nodeId, ipAddr);
                Assert.assertNotNull((Object)iface);
                Assert.assertEquals((int)nodeId, (int)iface.getNodeId());
                Assert.assertEquals((String)ipAddr, (String)iface.getIpAddr());
            }
        };
        querier.execute();
        MockDatabaseTest.assertEquals((int)this.m_network.getInterfaceCount(), (int)querier.getCount());
    }

    public void testServiceQuery() {
        Querier querier = new Querier((DataSource)((Object)this.m_db), "select nodeId, ipAddr, ifServices.status as status, ifServices.serviceId as serviceId, service.serviceName as serviceName from ifServices, service where ifServices.serviceId = service.serviceId;"){

            public void processRow(ResultSet rs) throws SQLException {
                int nodeId = rs.getInt("nodeId");
                String ipAddr = rs.getString("ipAddr");
                int serviceId = rs.getInt("serviceId");
                String serviceName = rs.getString("serviceName");
                String status = rs.getString("status");
                MockService svc = MockDatabaseTest.this.m_network.getService(nodeId, ipAddr, serviceName);
                Assert.assertNotNull((Object)svc);
                Assert.assertEquals((int)svc.getNodeId(), (int)nodeId);
                Assert.assertEquals((String)svc.getIpAddr(), (String)ipAddr);
                Assert.assertEquals((String)svc.getSvcName(), (String)serviceName);
                Assert.assertEquals((int)svc.getId(), (int)serviceId);
                Assert.assertEquals((String)svc.getMgmtStatus().toDbString(), (String)status);
            }
        };
        querier.execute();
        MockDatabaseTest.assertEquals((int)this.m_network.getServiceCount(), (int)querier.getCount());
    }

    public void testCascade() {
        this.m_db.update("delete from node where nodeid = '1'", new Object[0]);
        MockDatabaseTest.assertEquals((int)0, (int)this.m_db.countRows("select * from node where nodeid = '1'", new Object[0]));
        MockDatabaseTest.assertEquals((int)0, (int)this.m_db.countRows("select * from ipInterface where nodeid = '1'", new Object[0]));
        MockDatabaseTest.assertEquals((int)0, (int)this.m_db.countRows("select * from ifServices where nodeid = '1'", new Object[0]));
    }

    public void testOutage() {
        final MockService svc = this.m_network.getService(1, "192.168.1.1", "ICMP");
        Event svcLostEvent = MockEventUtil.createNodeLostServiceEvent("TEST", svc);
        this.m_db.writeEvent(svcLostEvent);
        this.m_db.createOutage(svc, svcLostEvent);
        this.m_db.createOutage(svc, svcLostEvent);
        MockDatabaseTest.assertEquals((int)2, (int)this.m_db.countOutagesForService(svc));
        Querier querier = new Querier((DataSource)((Object)this.m_db), "select * from outages"){

            public void processRow(ResultSet rs) throws SQLException {
                int nodeId = rs.getInt("nodeId");
                String ipAddr = rs.getString("ipAddr");
                int serviceId = rs.getInt("serviceId");
                Assert.assertEquals((int)nodeId, (int)svc.getNodeId());
                Assert.assertEquals((String)ipAddr, (String)svc.getIpAddr());
                Assert.assertEquals((int)serviceId, (int)svc.getId());
            }
        };
        querier.execute();
        MockDatabaseTest.assertEquals((int)2, (int)querier.getCount());
    }

    public void testUpdateNodeSequence() {
        int maxNodeId = this.m_db.getJdbcTemplate().queryForInt("select max(nodeid) from node", new Object[0]);
        int nextSeqNum = this.m_db.getJdbcTemplate().queryForInt("select nextval('nodeNxtId')", new Object[0]);
        MockDatabaseTest.assertTrue((nextSeqNum > maxNodeId ? 1 : 0) != 0);
    }

    public void testSetServiceStatus() {
        MockService svc = this.m_network.getService(1, "192.168.1.1", "SMTP");
        MockDatabaseTest.assertEquals((char)'A', (char)this.m_db.getServiceStatus(svc));
        this.m_db.setServiceStatus(svc, 'U');
        MockDatabaseTest.assertEquals((char)'U', (char)this.m_db.getServiceStatus(svc));
    }
}

