/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import junit.framework.AssertionFailedError;
import org.exolab.castor.util.LocalConfiguration;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opennms.netmgt.config.actiond.ActiondConfiguration;
import org.opennms.netmgt.config.archiver.events.EventsArchiverConfiguration;
import org.opennms.netmgt.config.capsd.CapsdConfiguration;
import org.opennms.netmgt.config.categories.Catinfo;
import org.opennms.netmgt.config.charts.ChartConfiguration;
import org.opennms.netmgt.config.collectd.CollectdConfiguration;
import org.opennms.netmgt.config.collectd.JmxDatacollectionConfig;
import org.opennms.netmgt.config.datacollection.DatacollectionConfig;
import org.opennms.netmgt.config.destinationPaths.DestinationPaths;
import org.opennms.netmgt.config.dhcpd.DhcpdConfiguration;
import org.opennms.netmgt.config.discovery.DiscoveryConfiguration;
import org.opennms.netmgt.config.filter.DatabaseSchema;
import org.opennms.netmgt.config.groups.Groupinfo;
import org.opennms.netmgt.config.httpdatacollection.HttpDatacollectionConfig;
import org.opennms.netmgt.config.kscReports.ReportsList;
import org.opennms.netmgt.config.linkd.LinkdConfiguration;
import org.opennms.netmgt.config.mailtransporttest.MailTransportTest;
import org.opennms.netmgt.config.modelimport.ModelImport;
import org.opennms.netmgt.config.monitoringLocations.MonitoringLocationsConfiguration;
import org.opennms.netmgt.config.notifd.NotifdConfiguration;
import org.opennms.netmgt.config.notificationCommands.NotificationCommands;
import org.opennms.netmgt.config.notifications.Notifications;
import org.opennms.netmgt.config.nsclient.NsclientConfig;
import org.opennms.netmgt.config.nsclient.NsclientDatacollectionConfig;
import org.opennms.netmgt.config.opennmsDataSources.DataSourceConfiguration;
import org.opennms.netmgt.config.poller.Outages;
import org.opennms.netmgt.config.poller.PollerConfiguration;
import org.opennms.netmgt.config.rtc.RTCConfiguration;
import org.opennms.netmgt.config.scriptd.ScriptdConfiguration;
import org.opennms.netmgt.config.server.LocalServer;
import org.opennms.netmgt.config.service.ServiceConfiguration;
import org.opennms.netmgt.config.siteStatusViews.SiteStatusViewConfiguration;
import org.opennms.netmgt.config.snmp.SnmpConfig;
import org.opennms.netmgt.config.statsd.StatisticsDaemonConfiguration;
import org.opennms.netmgt.config.surveillanceViews.SurveillanceViewConfiguration;
import org.opennms.netmgt.config.syslogd.SyslogdConfiguration;
import org.opennms.netmgt.config.threshd.ThreshdConfiguration;
import org.opennms.netmgt.config.threshd.ThresholdingConfig;
import org.opennms.netmgt.config.tl1d.Tl1dConfiguration;
import org.opennms.netmgt.config.translator.EventTranslatorConfiguration;
import org.opennms.netmgt.config.trapd.TrapdConfiguration;
import org.opennms.netmgt.config.users.Userinfo;
import org.opennms.netmgt.config.vacuumd.VacuumdConfiguration;
import org.opennms.netmgt.config.viewsdisplay.Viewinfo;
import org.opennms.netmgt.config.vulnscand.VulnscandConfiguration;
import org.opennms.netmgt.config.xmlrpcd.XmlrpcdConfiguration;
import org.opennms.netmgt.dao.castor.CastorUtils;
import org.opennms.netmgt.xml.eventconf.Events;
import org.opennms.test.ConfigurationTestUtils;
import org.opennms.test.mock.MockLogAppender;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WillItUnmarshalTest {
    private static final String CASTOR_LENIENT_SEQUENCE_ORDERING_PROPERTY = "org.exolab.castor.xml.lenient.sequence.order";
    private static Set<String> m_filesTested = new HashSet<String>();
    private static Set<String> m_exampleFilesTested = new HashSet<String>();

    @Before
    public void setUp() throws Exception {
        MockLogAppender.setupLogging((boolean)true, (String)"INFO");
        LocalConfiguration.getInstance().getProperties().clear();
        LocalConfiguration.getInstance().getProperties().load(ConfigurationTestUtils.getInputStreamForResource((Object)this, (String)"/castor.properties"));
    }

    @After
    public void checkWarnings() {
        MockLogAppender.assertNoWarningsOrGreater();
    }

    @Test
    public void testGoodOrdering() throws Exception {
        LocalConfiguration.getInstance().getProperties().remove(CASTOR_LENIENT_SEQUENCE_ORDERING_PROPERTY);
        CastorUtils.unmarshal(Events.class, (Reader)ConfigurationTestUtils.getReaderForResource((Object)this, (String)"eventconf-good-ordering.xml"));
    }

    @Test
    public void testLenientOrdering() throws Exception {
        LocalConfiguration.getInstance().getProperties().put(CASTOR_LENIENT_SEQUENCE_ORDERING_PROPERTY, "true");
        CastorUtils.unmarshal(Events.class, (Reader)ConfigurationTestUtils.getReaderForResource((Object)this, (String)"eventconf-bad-ordering.xml"));
    }

    @Test
    public void testLenientOrderingAsDefault() throws Exception {
        CastorUtils.unmarshal(Events.class, (Reader)ConfigurationTestUtils.getReaderForResource((Object)this, (String)"eventconf-bad-ordering.xml"));
    }

    @Test
    public void testLenientOrderingDisabled() throws Exception {
        LocalConfiguration.getInstance().getProperties().remove(CASTOR_LENIENT_SEQUENCE_ORDERING_PROPERTY);
        String exceptionText = "Element with name event passed to type events in incorrect order";
        boolean gotException = false;
        try {
            CastorUtils.unmarshal(Events.class, (Reader)ConfigurationTestUtils.getReaderForResource((Object)this, (String)"eventconf-bad-ordering.xml"));
        }
        catch (MarshalException e) {
            if (e.getMessage().contains(exceptionText)) {
                gotException = true;
            }
            AssertionFailedError newE = new AssertionFailedError("unmarshal threw MarshalException but did not contain expected text: " + exceptionText);
            newE.initCause((Throwable)e);
            throw newE;
        }
        if (!gotException) {
            Assert.fail((String)("unmarshal did not throw MarshalException containing expected text: " + exceptionText));
        }
    }

    @Test
    public void testActiondConfiguration() throws Exception {
        WillItUnmarshalTest.unmarshal("actiond-configuration.xml", ActiondConfiguration.class);
    }

    @Test
    public void testCapsdConfiguration() throws Exception {
        WillItUnmarshalTest.unmarshal("capsd-configuration.xml", CapsdConfiguration.class);
    }

    @Test
    public void testExampleCapsdConfiguration() throws Exception {
        WillItUnmarshalTest.unmarshalExample("capsd-configuration.xml", CapsdConfiguration.class);
    }

    @Test
    public void testExampleHypericCapsdConfiguration() throws Exception {
        WillItUnmarshalTest.unmarshalExample("hyperic-integration/capsd-configuration.xml", CapsdConfiguration.class);
    }

    @Test
    public void testCategories() throws Exception {
        WillItUnmarshalTest.unmarshal("categories.xml", Catinfo.class);
    }

    @Test
    public void testChartConfiguration() throws Exception {
        WillItUnmarshalTest.unmarshal("chart-configuration.xml", ChartConfiguration.class);
    }

    @Test
    public void testCollectdConfiguration() throws Exception {
        WillItUnmarshalTest.unmarshal("collectd-configuration.xml", CollectdConfiguration.class);
    }

    @Test
    public void testExampleCollectdConfiguration() throws Exception {
        WillItUnmarshalTest.unmarshalExample("collectd-configuration.xml", CollectdConfiguration.class);
    }

    @Test
    public void testDatabaseSchema() throws Exception {
        WillItUnmarshalTest.unmarshal("database-schema.xml", DatabaseSchema.class);
    }

    @Test
    public void testDataCollectionConfiguration() throws Exception {
        WillItUnmarshalTest.unmarshal("datacollection-config.xml", DatacollectionConfig.class);
    }

    @Test
    public void testDestinationPaths() throws Exception {
        WillItUnmarshalTest.unmarshal("destinationPaths.xml", DestinationPaths.class);
    }

    @Test
    public void testExampleDestinationPaths() throws Exception {
        WillItUnmarshalTest.unmarshalExample("destinationPaths.xml", DestinationPaths.class);
    }

    @Test
    public void testDhcpdConfiguration() throws Exception {
        WillItUnmarshalTest.unmarshal("dhcpd-configuration.xml", DhcpdConfiguration.class);
    }

    @Test
    public void testDiscoveryConfiguration() throws Exception {
        WillItUnmarshalTest.unmarshal("discovery-configuration.xml", DiscoveryConfiguration.class);
    }

    @Test
    public void testExampleDiscoveryConfiguration() throws Exception {
        WillItUnmarshalTest.unmarshalExample("discovery-configuration.xml", DiscoveryConfiguration.class);
    }

    @Test
    public void testEventconf() throws Exception {
        WillItUnmarshalTest.unmarshal("eventconf.xml", Events.class);
    }

    @Test
    public void testExampleHypericEventconf() throws Exception {
        WillItUnmarshalTest.unmarshalExample("hyperic-integration/eventconf.xml", Events.class);
    }

    @Test
    public void testExampleHypericEvents() throws Exception {
        WillItUnmarshalTest.unmarshalExample("hyperic-integration/Hyperic.events.xml", Events.class);
    }

    @Test
    public void testEventsArchiverConfiguration() throws Exception {
        WillItUnmarshalTest.unmarshal("events-archiver-configuration.xml", EventsArchiverConfiguration.class);
    }

    @Test
    public void testGroups() throws Exception {
        WillItUnmarshalTest.unmarshal("groups.xml", Groupinfo.class);
    }

    @Test
    public void testExampleGroups() throws Exception {
        WillItUnmarshalTest.unmarshalExample("groups.xml", Groupinfo.class);
    }

    @Test
    public void testHttpDataCollectionConfiguration() throws Exception {
        WillItUnmarshalTest.unmarshal("http-datacollection-config.xml", HttpDatacollectionConfig.class);
    }

    @Test
    public void testJmxDataCollectionConfiguration() throws Exception {
        WillItUnmarshalTest.unmarshal("jmx-datacollection-config.xml", JmxDatacollectionConfig.class);
    }

    @Test
    public void testKscPerformanceReports() throws Exception {
        WillItUnmarshalTest.unmarshal("ksc-performance-reports.xml", ReportsList.class);
    }

    @Test
    public void testLinkdConfiguration() throws Exception {
        WillItUnmarshalTest.unmarshal("linkd-configuration.xml", LinkdConfiguration.class);
    }

    @Test
    public void testExampleMailTransportTest() throws Exception {
        WillItUnmarshalTest.unmarshalExample("mail-transport-test.xml", MailTransportTest.class);
    }

    @Test
    public void testExampleHypericImportsHQ() throws Exception {
        WillItUnmarshalTest.unmarshalExample("hyperic-integration/imports-HQ.xml", ModelImport.class);
    }

    @Test
    public void testExampleHypericImportsOpennmsAdmin() throws Exception {
        WillItUnmarshalTest.unmarshalExample("hyperic-integration/imports-opennms-admin.xml", ModelImport.class);
    }

    @Test
    public void testMonitoringLocations() throws Exception {
        WillItUnmarshalTest.unmarshal("monitoring-locations.xml", MonitoringLocationsConfiguration.class);
    }

    @Test
    public void testExampleMonitoringLocations() throws Exception {
        WillItUnmarshalTest.unmarshalExample("monitoring-locations.xml", MonitoringLocationsConfiguration.class);
    }

    @Test
    public void testNotifdConfiguration() throws Exception {
        WillItUnmarshalTest.unmarshal("notifd-configuration.xml", NotifdConfiguration.class);
    }

    @Test
    public void testNotificationCommands() throws Exception {
        WillItUnmarshalTest.unmarshal("notificationCommands.xml", NotificationCommands.class);
    }

    @Test
    public void testExampleNotificationCommands() throws Exception {
        WillItUnmarshalTest.unmarshalExample("notificationCommands.xml", NotificationCommands.class);
    }

    @Test
    public void testNotifications() throws Exception {
        WillItUnmarshalTest.unmarshal("notifications.xml", Notifications.class);
    }

    @Test
    public void testExampleNotifications() throws Exception {
        WillItUnmarshalTest.unmarshalExample("notifications.xml", Notifications.class);
    }

    @Test
    public void testNsclientConfiguration() throws Exception {
        WillItUnmarshalTest.unmarshal("nsclient-config.xml", NsclientConfig.class);
    }

    @Test
    public void testExampleNsclientConfiguration() throws Exception {
        WillItUnmarshalTest.unmarshalExample("nsclient-config.xml", NsclientConfig.class);
    }

    @Test
    public void testNsclientDataCollectionConfiguration() throws Exception {
        WillItUnmarshalTest.unmarshal("nsclient-datacollection-config.xml", NsclientDatacollectionConfig.class);
    }

    @Test
    public void testOpennmsDatasources() throws Exception {
        WillItUnmarshalTest.unmarshal("opennms-datasources.xml", DataSourceConfiguration.class);
    }

    @Test
    public void testOpennmsServer() throws Exception {
        WillItUnmarshalTest.unmarshal("opennms-server.xml", LocalServer.class);
    }

    @Test
    public void testExampleOpennmsServer() throws Exception {
        WillItUnmarshalTest.unmarshalExample("opennms-server.xml", LocalServer.class);
    }

    @Test
    public void testPollOutages() throws Exception {
        WillItUnmarshalTest.unmarshal("poll-outages.xml", Outages.class);
    }

    @Test
    public void testExamplePollOutages() throws Exception {
        WillItUnmarshalTest.unmarshalExample("poll-outages.xml", Outages.class);
    }

    @Test
    public void testPollerConfiguration() throws Exception {
        WillItUnmarshalTest.unmarshal("poller-configuration.xml", PollerConfiguration.class);
    }

    @Test
    public void testExamplePollerConfiguration() throws Exception {
        WillItUnmarshalTest.unmarshalExample("poller-configuration.xml", PollerConfiguration.class);
    }

    @Test
    public void testExampleHypericPollerConfiguration() throws Exception {
        WillItUnmarshalTest.unmarshalExample("hyperic-integration/poller-configuration.xml", PollerConfiguration.class);
    }

    @Test
    public void testRtcConfiguration() throws Exception {
        WillItUnmarshalTest.unmarshal("rtc-configuration.xml", RTCConfiguration.class);
    }

    @Test
    public void testScriptdConfiguration() throws Exception {
        WillItUnmarshalTest.unmarshal("scriptd-configuration.xml", ScriptdConfiguration.class);
    }

    @Test
    public void testExampleScriptdConfiguration() throws Exception {
        WillItUnmarshalTest.unmarshalExample("scriptd-configuration.xml", ScriptdConfiguration.class);
    }

    @Test
    public void testExampleScriptdConfigurationWithEventProxy() throws Exception {
        WillItUnmarshalTest.unmarshalExample("scriptd-configuration-with-event-proxy.xml", ScriptdConfiguration.class);
    }

    @Test
    public void testSiteStatusViews() throws Exception {
        WillItUnmarshalTest.unmarshal("site-status-views.xml", SiteStatusViewConfiguration.class);
    }

    @Test
    public void testSnmpConfig() throws Exception {
        WillItUnmarshalTest.unmarshal("snmp-config.xml", SnmpConfig.class);
    }

    @Test
    public void testExampleSnmpConfig() throws Exception {
        WillItUnmarshalTest.unmarshalExample("snmp-config.xml", SnmpConfig.class);
    }

    @Test
    public void testStatsdConfiguration() throws Exception {
        WillItUnmarshalTest.unmarshal("statsd-configuration.xml", StatisticsDaemonConfiguration.class);
    }

    @Test
    public void testSurveillanceViews() throws Exception {
        WillItUnmarshalTest.unmarshal("surveillance-views.xml", SurveillanceViewConfiguration.class);
    }

    @Test
    public void testExampleSurveillanceViews() throws Exception {
        WillItUnmarshalTest.unmarshalExample("surveillance-views.xml", SurveillanceViewConfiguration.class);
    }

    @Test
    public void testSyslogdConfiguration() throws Exception {
        WillItUnmarshalTest.unmarshal("syslogd-configuration.xml", SyslogdConfiguration.class);
    }

    @Test
    public void testThreshdConfiguration() throws Exception {
        WillItUnmarshalTest.unmarshal("threshd-configuration.xml", ThreshdConfiguration.class);
    }

    @Test
    public void testExampleThreshdConfiguration() throws Exception {
        WillItUnmarshalTest.unmarshalExample("threshd-configuration.xml", ThreshdConfiguration.class);
    }

    @Test
    public void testThresholds() throws Exception {
        WillItUnmarshalTest.unmarshal("thresholds.xml", ThresholdingConfig.class);
    }

    @Test
    public void testExampleThresholds() throws Exception {
        WillItUnmarshalTest.unmarshalExample("thresholds.xml", ThresholdingConfig.class);
    }

    @Test
    public void testTl1dConfiguration() throws Exception {
        WillItUnmarshalTest.unmarshal("tl1d-configuration.xml", Tl1dConfiguration.class);
    }

    @Test
    public void testTranslatorConfiguration() throws Exception {
        WillItUnmarshalTest.unmarshal("translator-configuration.xml", EventTranslatorConfiguration.class);
    }

    @Test
    public void testExampleTranslatorConfiguration() throws Exception {
        WillItUnmarshalTest.unmarshalExample("translator-configuration.xml", EventTranslatorConfiguration.class);
    }

    @Test
    public void testExampleHypericTranslatorConfiguration() throws Exception {
        WillItUnmarshalTest.unmarshalExample("hyperic-integration/translator-configuration.xml", EventTranslatorConfiguration.class);
    }

    @Test
    public void testTrapdonfiguration() throws Exception {
        WillItUnmarshalTest.unmarshal("trapd-configuration.xml", TrapdConfiguration.class);
    }

    @Test
    public void testUsers() throws Exception {
        WillItUnmarshalTest.unmarshal("users.xml", Userinfo.class);
    }

    @Test
    public void testVacuumdConfiguration() throws Exception {
        WillItUnmarshalTest.unmarshal("vacuumd-configuration.xml", VacuumdConfiguration.class);
    }

    @Test
    public void testVulnscandConfiguration() throws Exception {
        WillItUnmarshalTest.unmarshal("vulnscand-configuration.xml", VulnscandConfiguration.class);
    }

    @Test
    public void testXmlrpcdConfiguration() throws Exception {
        WillItUnmarshalTest.unmarshal("xmlrpcd-configuration.xml", XmlrpcdConfiguration.class);
    }

    @Test
    public void testExampleXmlrpcdConfiguration() throws Exception {
        WillItUnmarshalTest.unmarshalExample("xmlrpcd-configuration.xml", XmlrpcdConfiguration.class);
    }

    @Test
    public void testEventdConfiguration() throws Exception {
        WillItUnmarshalTest.unmarshal("eventd-configuration.xml", Viewinfo.class);
    }

    @Test
    public void testServiceConfiguration() throws Exception {
        WillItUnmarshalTest.unmarshal("service-configuration.xml", ServiceConfiguration.class);
    }

    @Test
    public void testViewsDisplay() throws Exception {
        WillItUnmarshalTest.unmarshal("viewsdisplay.xml", Viewinfo.class);
    }

    @Test
    public void testExampleViewsDisplay() throws Exception {
        WillItUnmarshalTest.unmarshalExample("viewsdisplay.xml", Viewinfo.class);
    }

    @Test
    public void testExampleTl1dConfiguration() throws Exception {
        WillItUnmarshalTest.unmarshalExample("tl1d-configuration.xml", Tl1dConfiguration.class);
    }

    @Test
    public void testCheckAllDaemonXmlConfigFilesTested() {
        File someConfigFile = ConfigurationTestUtils.getFileForConfigFile((String)"discovery-configuration.xml");
        File configDir = someConfigFile.getParentFile();
        Assert.assertTrue((String)("daemon configuration directory exists at " + configDir.getAbsolutePath()), (boolean)configDir.exists());
        Assert.assertTrue((String)("daemon configuration directory is a directory at " + configDir.getAbsolutePath()), (boolean)configDir.isDirectory());
        String[] configFiles = configDir.list(new FilenameFilter(){

            public boolean accept(File file, String name) {
                return name.endsWith(".xml");
            }
        });
        HashSet<String> allXml = new HashSet<String>(Arrays.asList(configFiles));
        allXml.removeAll(m_filesTested);
        if (allXml.size() > 0) {
            ArrayList<String> files = new ArrayList<String>(allXml);
            Collections.sort(files);
            Assert.fail((String)("These files in " + configDir.getAbsolutePath() + " were not tested: \n\t" + StringUtils.collectionToDelimitedString(files, (String)"\n\t")));
        }
    }

    @Test
    public void testCheckAllDaemonXmlExampleConfigFilesTested() {
        File someConfigFile = ConfigurationTestUtils.getFileForConfigFile((String)"discovery-configuration.xml");
        File examplesDir = new File(someConfigFile.getParentFile(), "examples");
        HashSet<String> allXml = new HashSet<String>();
        this.findConfigurationFilesInDirectory(examplesDir, null, allXml);
        allXml.removeAll(m_exampleFilesTested);
        allXml.remove("correlation-engine.xml");
        allXml.remove("drools-engine.xml");
        allXml.remove("nodeParentRules-context.xml");
        if (allXml.size() > 0) {
            ArrayList<String> files = new ArrayList<String>(allXml);
            Collections.sort(files);
            Assert.fail((String)("These files in " + examplesDir.getAbsolutePath() + " were not tested: \n\t" + StringUtils.collectionToDelimitedString(files, (String)"\n\t")));
        }
    }

    private void findConfigurationFilesInDirectory(File directory, String directoryPrefix, Set<String> allXml) {
        File[] subDirectories;
        String[] configFiles;
        Assert.assertTrue((String)("directory to search for configuration files in is not a directory at " + directory.getAbsolutePath()), (boolean)directory.isDirectory());
        for (String configFile : configFiles = directory.list(new FilenameFilter(){

            public boolean accept(File file, String name) {
                return name.endsWith(".xml");
            }
        })) {
            allXml.add(directoryPrefix != null ? directoryPrefix + File.separator + configFile : configFile);
        }
        for (File subDirectory : subDirectories = directory.listFiles(new FileFilter(){

            public boolean accept(File file) {
                return file.isDirectory() && !file.getName().startsWith(".");
            }
        })) {
            String newPrefix = directoryPrefix != null ? directoryPrefix + File.separator + subDirectory.getName() : subDirectory.getName();
            this.findConfigurationFilesInDirectory(subDirectory, newPrefix, allXml);
        }
    }

    @Test
    public void testAllIncludedEventXml() throws Exception {
        File[] includedEventFiles;
        File eventConfFile = ConfigurationTestUtils.getFileForConfigFile((String)"eventconf.xml");
        File eventsDirFile = new File(eventConfFile.getParentFile(), "events");
        Assert.assertTrue((String)("events directory exists at " + eventsDirFile.getAbsolutePath()), (boolean)eventsDirFile.exists());
        Assert.assertTrue((String)("events directory is a directory at " + eventsDirFile.getAbsolutePath()), (boolean)eventsDirFile.isDirectory());
        for (File includedEventFile : includedEventFiles = eventsDirFile.listFiles(new FilenameFilter(){

            public boolean accept(File file, String name) {
                return name.endsWith(".xml");
            }
        })) {
            try {
                LocalConfiguration.getInstance().getProperties().remove(CASTOR_LENIENT_SEQUENCE_ORDERING_PROPERTY);
                CastorUtils.unmarshal(Events.class, (Reader)new FileReader(includedEventFile));
            }
            catch (Throwable t) {
                throw new RuntimeException("Failed to unmarshal " + includedEventFile + ": " + t, t);
            }
        }
    }

    private static <T> T unmarshal(String configFile, Class<T> clazz) throws MarshalException, ValidationException, FileNotFoundException {
        return WillItUnmarshalTest.unmarshal(ConfigurationTestUtils.getFileForConfigFile((String)configFile), clazz, m_filesTested, configFile);
    }

    private static <T> T unmarshalExample(String configFile, Class<T> clazz) throws MarshalException, ValidationException, FileNotFoundException {
        return WillItUnmarshalTest.unmarshal(ConfigurationTestUtils.getFileForConfigFile((String)("examples/" + configFile)), clazz, m_exampleFilesTested, configFile);
    }

    private static <T> T unmarshal(File file, Class<T> clazz, Set<String> testedSet, String fileName) throws MarshalException, ValidationException, FileNotFoundException {
        LocalConfiguration.getInstance().getProperties().remove(CASTOR_LENIENT_SEQUENCE_ORDERING_PROPERTY);
        Object config = CastorUtils.unmarshal(clazz, (Reader)new FileReader(file));
        Assert.assertNotNull((String)("unmarshalled object should not be null after unmarshalling from " + file.getAbsolutePath()), (Object)config);
        testedSet.add(fileName);
        return (T)config;
    }
}

