/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opennms.netmgt.config.GroupManager;
import org.opennms.netmgt.config.UserManager;
import org.opennms.netmgt.config.groups.Group;
import org.opennms.netmgt.config.groups.Role;
import org.opennms.netmgt.config.users.User;
import org.opennms.netmgt.notifd.mock.MockGroupManager;
import org.opennms.netmgt.notifd.mock.MockUserManager;
import org.opennms.test.mock.MockLogAppender;

public class UserGroupManagerTest {
    public static final String GROUP_MANAGER = "<?xml version=\"1.0\"?>\n<groupinfo>\n    <header>\n        <rev>1.3</rev>\n        <created>Wednesday, February 6, 2002 10:10:00 AM EST</created>\n        <mstation>dhcp-219.internal.opennms.org</mstation>\n    </header>\n    <groups>\n        <group>\n            <name>InitialGroup</name>\n            <comments>The group that gets notified first</comments>\n            <user>admin</user>            <user>brozow</user>        </group>\n        <group>\n            <name>EscalationGroup</name>\n            <comments>The group things escalate to</comments>\n            <user>brozow</user>            <user>david</user>        </group>\n        <group>\n            <name>UpGroup</name>\n            <comments>The group things escalate to</comments>\n            <user>upUser</user>        </group>\n    </groups>\n  <roles>\n    <role supervisor=\"admin\" name=\"oncall\" description=\"The On Call Schedule\" membership-group=\"InitialGroup\">\n      <schedule name=\"brozow\" type=\"weekly\">\n         <time day=\"sunday\" begins=\"09:00:00\" ends=\"17:00:00\"/>\n         <time day=\"monday\" begins=\"09:00:00\" ends=\"17:00:00\"/>\n         <time day=\"wednesday\" begins=\"09:00:00\" ends=\"17:00:00\"/>\n         <time day=\"friday\" begins=\"09:00:00\" ends=\"17:00:00\"/>\n      </schedule>\n      <schedule name=\"admin\" type=\"weekly\">\n         <time day=\"sunday\" begins=\"00:00:00\" ends=\"23:59:59\"/>\n         <time day=\"tuesday\" begins=\"09:00:00\" ends=\"17:00:00\"/>\n         <time day=\"thursday\" begins=\"09:00:00\" ends=\"17:00:00\"/>\n         <time day=\"saturday\" begins=\"09:00:00\" ends=\"17:00:00\"/>\n      </schedule>\n      <schedule name=\"david\" type=\"weekly\">\n         <time day=\"sunday\"    begins=\"00:00:00\" ends=\"09:00:00\"/>\n         <time day=\"sunday\"    begins=\"17:00:00\" ends=\"23:59:59\"/>\n         <time day=\"monday\"    begins=\"00:00:00\" ends=\"09:00:00\"/>\n         <time day=\"monday\"    begins=\"17:00:00\" ends=\"23:59:59\"/>\n         <time day=\"tuesday\"   begins=\"00:00:00\" ends=\"09:00:00\"/>\n         <time day=\"tuesday\"   begins=\"17:00:00\" ends=\"23:59:59\"/>\n         <time day=\"wednesday\" begins=\"00:00:00\" ends=\"09:00:00\"/>\n         <time day=\"wednesday\" begins=\"17:00:00\" ends=\"23:59:59\"/>\n         <time day=\"thursday\"  begins=\"00:00:00\" ends=\"09:00:00\"/>\n         <time day=\"thursday\"  begins=\"17:00:00\" ends=\"23:59:59\"/>\n         <time day=\"friday\"    begins=\"00:00:00\" ends=\"09:00:00\"/>\n         <time day=\"friday\"    begins=\"17:00:00\" ends=\"23:59:59\"/>\n         <time day=\"saturday\"  begins=\"00:00:00\" ends=\"09:00:00\"/>\n         <time day=\"saturday\"  begins=\"17:00:00\" ends=\"23:59:59\"/>\n      </schedule>\n    </role>\n    <role supervisor=\"admin\" name=\"unscheduled\" description=\"The Unscheduled Schedule\" membership-group=\"UpGroup\">\n           <schedule name=\"upUser\" type=\"weekly\">               <time day=\"sunday\" begins=\"00:00:00\" ends=\"23:59:59\"/>\n               <time day=\"monday\" begins=\"00:00:00\" ends=\"23:59:59\"/>\n               <time day=\"tuesday\" begins=\"00:00:00\" ends=\"23:59:59\"/>\n               <time day=\"wednesday\" begins=\"00:00:00\" ends=\"23:59:59\"/>\n               <time day=\"thursday\" begins=\"00:00:00\" ends=\"23:59:59\"/>\n               <time day=\"friday\" begins=\"00:00:00\" ends=\"23:59:59\"/>\n               <time day=\"saturday\" begins=\"00:00:00\" ends=\"23:59:59\"/>\n           </schedule>    </role>\n  </roles>\n</groupinfo>\n";
    public static final String USER_MANAGER = "<?xml version=\"1.0\"?>\n<userinfo xmlns=\"http://xmlns.opennms.org/xsd/users\">\n   <header>\n       <rev>.9</rev>\n           <created>Wednesday, February 6, 2002 10:10:00 AM EST</created>\n       <mstation>master.nmanage.com</mstation>\n   </header>\n   <users>\n       <user>\n           <user-id>brozow</user-id>\n           <full-name>Mathew Brozowski</full-name>\n           <user-comments>Test User</user-comments>\n           <password>21232F297A57A5A743894A0E4A801FC3</password>\n           <contact type=\"email\" info=\"brozow@opennms.org\"/>\n       </user>\n       <user>\n           <user-id>admin</user-id>\n           <full-name>Administrator</full-name>\n           <user-comments>Default administrator, do not delete</user-comments>\n           <password>21232F297A57A5A743894A0E4A801FC3</password>\n           <contact type=\"email\" info=\"admin@opennms.org\"/>\n       </user>\n       <user>\n           <user-id>upUser</user-id>\n           <full-name>User that receives up notifications</full-name>\n           <user-comments>Default administrator, do not delete</user-comments>\n           <password>21232F297A57A5A743894A0E4A801FC3</password>\n           <contact type=\"email\" info=\"up@opennms.org\"/>\n       </user>\n       <user>\n           <user-id>david</user-id>\n           <full-name>David Hustace</full-name>\n           <user-comments>A cool dude!</user-comments>\n           <password>18126E7BD3F84B3F3E4DF094DEF5B7DE</password>\n           <contact type=\"email\" info=\"david@opennms.org\"/>\n           <contact type=\"numericPage\" info=\"6789\" serviceProvider=\"ATT\"/>\n           <contact type=\"textPage\" info=\"9876\" serviceProvider=\"Sprint\"/>\n           <duty-schedule>MoTuWeThFrSaSu800-2300</duty-schedule>\n       </user>\n   </users>\n</userinfo>\n";
    private GroupManager m_groupManager;
    private UserManager m_userManager;
    private User brozow;
    private User admin;
    private User upUser;
    private User david;
    private Role oncall;
    private Role unscheduled;
    private Date night;
    private Date day;
    private Date sunday;

    @Before
    public void setUp() throws Exception {
        MockLogAppender.setupLogging();
        this.m_groupManager = new MockGroupManager(GROUP_MANAGER);
        this.m_userManager = new MockUserManager(this.m_groupManager, USER_MANAGER);
        this.night = new SimpleDateFormat("dd-MMM-yyyy HH:mm:ss").parse("21-FEB-2005 23:00:00");
        this.day = new SimpleDateFormat("dd-MMM-yyyy HH:mm:ss").parse("21-FEB-2005 11:59:56");
        this.sunday = new SimpleDateFormat("dd-MMM-yyyy HH:mm:ss").parse("30-JAN-2005 11:59:56");
        this.brozow = this.m_userManager.getUser("brozow");
        Assert.assertNotNull((Object)this.brozow);
        Assert.assertEquals((Object)"brozow", (Object)this.brozow.getUserId());
        this.admin = this.m_userManager.getUser("admin");
        Assert.assertNotNull((Object)this.admin);
        Assert.assertEquals((Object)"admin", (Object)this.admin.getUserId());
        this.upUser = this.m_userManager.getUser("upUser");
        Assert.assertNotNull((Object)this.upUser);
        Assert.assertEquals((Object)"upUser", (Object)this.upUser.getUserId());
        this.david = this.m_userManager.getUser("david");
        Assert.assertNotNull((Object)this.david);
        Assert.assertEquals((Object)"david", (Object)this.david.getUserId());
        this.oncall = this.m_groupManager.getRole("oncall");
        Assert.assertNotNull((Object)this.oncall);
        Assert.assertEquals((Object)"oncall", (Object)this.oncall.getName());
        this.unscheduled = this.m_groupManager.getRole("unscheduled");
        Assert.assertNotNull((Object)this.unscheduled);
        Assert.assertEquals((Object)"unscheduled", (Object)this.unscheduled.getName());
    }

    @After
    public void tearDown() throws Exception {
        MockLogAppender.assertNoWarningsOrGreater();
    }

    @Test
    public void testGetUserNames() throws Exception {
        List userNameList = this.m_userManager.getUserNames();
        Assert.assertEquals((long)4L, (long)userNameList.size());
        Assert.assertTrue((boolean)userNameList.contains("admin"));
        Assert.assertTrue((boolean)userNameList.contains("brozow"));
        Assert.assertTrue((boolean)userNameList.contains("upUser"));
        Assert.assertTrue((boolean)userNameList.contains("david"));
    }

    @Test
    public void testRenameUser() throws Exception {
        this.m_userManager.renameUser("brozow", "brozow2");
        List userNameList = this.m_userManager.getUserNames();
        Assert.assertEquals((long)4L, (long)userNameList.size());
        Assert.assertTrue((boolean)userNameList.contains("brozow2"));
        List group1Users = this.m_groupManager.getGroup("InitialGroup").getUserCollection();
        List group2Users = this.m_groupManager.getGroup("EscalationGroup").getUserCollection();
        List group3Users = this.m_groupManager.getGroup("UpGroup").getUserCollection();
        Assert.assertFalse((boolean)group1Users.contains("brozow"));
        Assert.assertFalse((boolean)group2Users.contains("brozow"));
        Assert.assertFalse((boolean)group3Users.contains("brozow"));
    }

    @Test
    public void testSaveUser() throws Exception {
        String userName = "brozow";
        User user = this.brozow;
        Calendar nightCal = Calendar.getInstance();
        nightCal.setTime(this.night);
        Calendar dayCal = Calendar.getInstance();
        dayCal.setTime(this.day);
        Assert.assertTrue((boolean)this.m_userManager.isUserOnDuty(userName, dayCal));
        Assert.assertTrue((boolean)this.m_userManager.isUserOnDuty(userName, nightCal));
        this.brozow.addDutySchedule("MoTuWeThFr0900-1700");
        this.m_userManager.saveUser(userName, user);
        Assert.assertTrue((boolean)this.m_userManager.isUserOnDuty(userName, dayCal));
        Assert.assertFalse((boolean)this.m_userManager.isUserOnDuty(userName, nightCal));
    }

    @Test
    public void testGetGroupNames() throws Exception {
        List userNameList = this.m_groupManager.getGroupNames();
        Assert.assertEquals((long)3L, (long)userNameList.size());
        Assert.assertTrue((boolean)userNameList.contains("InitialGroup"));
        Assert.assertTrue((boolean)userNameList.contains("EscalationGroup"));
        Assert.assertTrue((boolean)userNameList.contains("UpGroup"));
    }

    @Test
    public void testSaveGroups() throws Exception {
        String groupName = "UpGroup";
        Group group = this.m_groupManager.getGroup("UpGroup");
        Calendar nightCal = Calendar.getInstance();
        nightCal.setTime(this.night);
        Calendar dayCal = Calendar.getInstance();
        dayCal.setTime(this.day);
        Assert.assertTrue((boolean)this.m_groupManager.isGroupOnDuty("UpGroup", dayCal));
        Assert.assertEquals((long)0L, (long)this.m_groupManager.groupNextOnDuty("UpGroup", dayCal));
        Assert.assertTrue((boolean)this.m_groupManager.isGroupOnDuty("UpGroup", nightCal));
        Assert.assertEquals((long)0L, (long)this.m_groupManager.groupNextOnDuty("UpGroup", nightCal));
        group.addDutySchedule("MoTuWeThFr0900-1700");
        this.m_groupManager.saveGroups();
        Assert.assertTrue((boolean)this.m_groupManager.isGroupOnDuty("UpGroup", dayCal));
        Assert.assertEquals((long)0L, (long)this.m_groupManager.groupNextOnDuty("UpGroup", dayCal));
        Assert.assertFalse((boolean)this.m_groupManager.isGroupOnDuty("UpGroup", nightCal));
        Assert.assertEquals((long)36000000L, (long)this.m_groupManager.groupNextOnDuty("UpGroup", nightCal));
    }

    @Test
    public void testGetRoles() {
        this.assertRoles(this.m_groupManager.getRoleNames(), new Role[]{this.oncall, this.unscheduled});
    }

    @Test
    public void testUserHasRole() throws Exception {
        Assert.assertTrue((boolean)this.m_userManager.userHasRole(this.brozow, "oncall"));
        Assert.assertTrue((boolean)this.m_userManager.userHasRole(this.admin, "oncall"));
        Assert.assertFalse((boolean)this.m_userManager.userHasRole(this.upUser, "oncall"));
        Assert.assertTrue((boolean)this.m_userManager.userHasRole(this.david, "oncall"));
    }

    @Test
    public void testGetUsersWithRole() throws Exception {
        String[] userNames = this.m_userManager.getUsersWithRole("oncall");
        this.assertUsers(userNames, new User[]{this.brozow, this.admin, this.david});
    }

    @Test
    public void testUserScheduledForRoleNew() throws Exception {
        Date[] dates = new Date[]{this.night, this.day, this.sunday};
        for (int i = 0; i < dates.length; ++i) {
            this.testUsersScheduledForRolesAt(dates[i]);
        }
    }

    private void testUsersScheduledForRolesAt(Date date) throws Exception {
        String[] roles = this.m_groupManager.getRoleNames();
        for (int i = 0; i < roles.length; ++i) {
            this.testUsersScheduleForRoleAt(roles[i], date);
        }
    }

    private void testUsersScheduleForRoleAt(String role, Date date) throws Exception {
        for (String userId : this.m_userManager.getUserNames()) {
            User u = this.m_userManager.getUser(userId);
            this.testUserScheduledForRoleAt(u, role, date);
        }
    }

    private void testUserScheduledForRoleAt(User u, String role, Date date) throws Exception {
        Assert.assertEquals((String)("Unexpected value " + u.getUserId() + " for role " + role + " at " + date), (Object)this.m_userManager.isUserScheduledForRole(u, role, date), (Object)this.m_userManager.isUserScheduledForRole(u, role, date));
    }

    @Test
    public void testUserScheduledForRole() throws Exception {
        Assert.assertFalse((boolean)this.m_userManager.isUserScheduledForRole(this.brozow, "oncall", this.night));
        Assert.assertTrue((boolean)this.m_userManager.isUserScheduledForRole(this.brozow, "oncall", this.day));
        Assert.assertTrue((boolean)this.m_userManager.isUserScheduledForRole(this.brozow, "oncall", this.sunday));
        Assert.assertFalse((boolean)this.m_userManager.isUserScheduledForRole(this.brozow, "unscheduled", this.day));
        Assert.assertFalse((boolean)this.m_userManager.isUserScheduledForRole(this.admin, "oncall", this.night));
        Assert.assertFalse((boolean)this.m_userManager.isUserScheduledForRole(this.admin, "oncall", this.day));
        Assert.assertTrue((boolean)this.m_userManager.isUserScheduledForRole(this.admin, "oncall", this.sunday));
        Assert.assertFalse((boolean)this.m_userManager.isUserScheduledForRole(this.admin, "unscheduled", this.day));
        Assert.assertFalse((boolean)this.m_userManager.isUserScheduledForRole(this.upUser, "oncall", this.night));
        Assert.assertFalse((boolean)this.m_userManager.isUserScheduledForRole(this.upUser, "oncall", this.day));
        Assert.assertFalse((boolean)this.m_userManager.isUserScheduledForRole(this.upUser, "oncall", this.sunday));
        Assert.assertTrue((boolean)this.m_userManager.isUserScheduledForRole(this.upUser, "unscheduled", this.day));
        Assert.assertTrue((boolean)this.m_userManager.isUserScheduledForRole(this.david, "oncall", this.night));
        Assert.assertFalse((boolean)this.m_userManager.isUserScheduledForRole(this.david, "oncall", this.day));
        Assert.assertFalse((boolean)this.m_userManager.isUserScheduledForRole(this.david, "oncall", this.sunday));
        Assert.assertFalse((boolean)this.m_userManager.isUserScheduledForRole(this.david, "unscheduled", this.day));
    }

    @Test
    public void testGetUsersScheduledForRole() throws Exception {
        String[] nightUserNames = this.m_userManager.getUsersScheduledForRole("oncall", this.night);
        this.assertUsers(nightUserNames, new User[]{this.david});
        String[] dayUserNames = this.m_userManager.getUsersScheduledForRole("oncall", this.day);
        this.assertUsers(dayUserNames, new User[]{this.brozow});
        String[] sundayUserNames = this.m_userManager.getUsersScheduledForRole("oncall", this.sunday);
        this.assertUsers(sundayUserNames, new User[]{this.brozow, this.admin});
    }

    private void assertRoles(String[] roleNames, Role[] expected) {
        if (expected == null) {
            Assert.assertNull((String)"Expected null list", (Object)roleNames);
        }
        Assert.assertNotNull((String)"Unexpected null user list", (Object)roleNames);
        Assert.assertEquals((String)"Unexpected number of users", (long)expected.length, (long)roleNames.length);
        List<String> nameList = Arrays.asList(roleNames);
        for (int i = 0; i < expected.length; ++i) {
            Role r = expected[i];
            Assert.assertTrue((String)("Expected user " + r.getName() + " in list " + nameList), (boolean)nameList.contains(r.getName()));
        }
    }

    private void assertUsers(String[] userNames, User[] expected) {
        if (expected == null) {
            Assert.assertNull((String)"Expected null list", (Object)userNames);
        }
        Assert.assertNotNull((String)"Unexpected null user list", (Object)userNames);
        Assert.assertEquals((String)"Unexpected number of users", (long)expected.length, (long)userNames.length);
        List<String> nameList = Arrays.asList(userNames);
        for (int i = 0; i < expected.length; ++i) {
            User u = expected[i];
            Assert.assertTrue((String)("Expected user " + u.getUserId() + " in list " + nameList), (boolean)nameList.contains(u.getUserId()));
        }
    }
}

