/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.io.IOException;
import java.io.Reader;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import junit.framework.TestCase;
import org.easymock.EasyMock;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.opennms.netmgt.config.PollerConfigManager;
import org.opennms.netmgt.config.SnmpPeerFactory;
import org.opennms.netmgt.config.poller.Package;
import org.opennms.netmgt.config.poller.Parameter;
import org.opennms.netmgt.config.poller.Rrd;
import org.opennms.netmgt.config.poller.Service;
import org.opennms.netmgt.dao.FilterDao;
import org.opennms.netmgt.dao.support.RrdTestUtils;
import org.opennms.netmgt.filter.FilterDaoFactory;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsMonitoredService;
import org.opennms.netmgt.model.OnmsServiceType;
import org.opennms.netmgt.rrd.RrdDataSource;
import org.opennms.netmgt.rrd.RrdStrategy;
import org.opennms.netmgt.rrd.RrdUtils;
import org.opennms.test.ConfigurationTestUtils;
import org.opennms.test.mock.EasyMockUtils;
import org.opennms.test.mock.MockLogAppender;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PollerConfigManagerTest
extends TestCase {
    private EasyMockUtils m_mocks = new EasyMockUtils();
    private RrdStrategy m_rrdStrategy = (RrdStrategy)this.m_mocks.createMock(RrdStrategy.class);

    protected void setUp() throws Exception {
        super.setUp();
        MockLogAppender.setupLogging();
        FilterDao filterDao = (FilterDao)EasyMock.createMock(FilterDao.class);
        EasyMock.expect((Object)filterDao.getIPList((String)EasyMock.isA(String.class))).andReturn(new ArrayList(0)).anyTimes();
        EasyMock.replay((Object[])new Object[]{filterDao});
        FilterDaoFactory.setInstance((FilterDao)filterDao);
        RrdTestUtils.initializeNullStrategy();
        RrdUtils.setStrategy((RrdStrategy)this.m_rrdStrategy);
        SnmpPeerFactory.setInstance((SnmpPeerFactory)new SnmpPeerFactory(ConfigurationTestUtils.getReaderForConfigFile((String)"snmp-config.xml")));
    }

    protected void runTest() throws Throwable {
        super.runTest();
        MockLogAppender.assertNoWarningsOrGreater();
    }

    public void testSaveResponseTimeDataWithLocaleThatUsesCommasForDecimals() throws Exception {
        Locale.setDefault(Locale.FRENCH);
        NumberFormat nf = NumberFormat.getInstance();
        PollerConfigManagerTest.assertEquals((String)("ensure that the newly set default locale (" + Locale.getDefault() + ") uses ',' as the decimal marker"), (String)"1,5", (String)nf.format(1.5));
        TestPollerConfigManager mgr = new TestPollerConfigManager();
        OnmsMonitoredService svc = new OnmsMonitoredService();
        OnmsServiceType svcType = new OnmsServiceType();
        svcType.setName("HTTP");
        svc.setServiceType(svcType);
        OnmsIpInterface intf = new OnmsIpInterface();
        intf.setIpAddress("1.2.3.4");
        svc.setIpInterface(intf);
        Package pkg = new Package();
        Service pkgService = new Service();
        pkgService.setName("HTTP");
        this.addParameterToService(pkgService, "ds-name", "http");
        this.addParameterToService(pkgService, "rrd-repository", "/foo");
        pkg.addService(pkgService);
        Rrd rrd = new Rrd();
        rrd.setStep(300);
        rrd.addRra("bogusRRA");
        pkg.setRrd(rrd);
        this.m_rrdStrategy.initialize();
        EasyMock.expect((Object)this.m_rrdStrategy.getDefaultFileExtension()).andReturn((Object)".rrd").anyTimes();
        EasyMock.expect((Object)this.m_rrdStrategy.createDefinition((String)EasyMock.isA(String.class), (String)EasyMock.isA(String.class), (String)EasyMock.isA(String.class), EasyMock.anyInt(), PollerConfigManagerTest.isAList(RrdDataSource.class), PollerConfigManagerTest.isAList(String.class))).andReturn(new Object());
        this.m_rrdStrategy.createFile(EasyMock.isA(Object.class));
        EasyMock.expect((Object)this.m_rrdStrategy.openFile((String)EasyMock.isA(String.class))).andReturn(new Object());
        this.m_rrdStrategy.updateFile(EasyMock.isA(Object.class), (String)EasyMock.isA(String.class), EasyMock.endsWith((String)":1.5"));
        this.m_rrdStrategy.closeFile(EasyMock.isA(Object.class));
        this.m_mocks.replayAll();
        mgr.saveResponseTimeData("Tuvalu", svc, 1.5, pkg);
        this.m_mocks.verifyAll();
    }

    private void addParameterToService(Service pkgService, String key, String value) {
        Parameter param = new Parameter();
        param.setKey(key);
        param.setValue(value);
        pkgService.addParameter(param);
    }

    private static <T> List<T> isAList(Class<T> clazz) {
        return (List)EasyMock.isA(List.class);
    }

    public static class TestPollerConfigManager
    extends PollerConfigManager {
        public TestPollerConfigManager() throws MarshalException, ValidationException, IOException {
            super(ConfigurationTestUtils.getReaderForConfigFile((String)"poller-configuration.xml"), "foo", false);
        }

        public TestPollerConfigManager(Reader reader, String localServer, boolean verifyServer) throws MarshalException, ValidationException, IOException {
            super(reader, localServer, verifyServer);
        }

        protected void saveXml(String xml) throws IOException {
            throw new UnsupportedOperationException("dude, where's my car?  Oh, yeah, this method isn't supported");
        }

        public void update() throws IOException, MarshalException, ValidationException {
            throw new UnsupportedOperationException("dude, where's my car?  Oh, yeah, this method isn't supported");
        }
    }
}

