/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collectd;

import java.net.InetAddress;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.opennms.netmgt.collectd.CollectionResource;
import org.opennms.netmgt.collectd.SnmpCollectorTestCase;
import org.opennms.netmgt.collectd.SnmpNodeCollector;
import org.opennms.netmgt.snmp.CollectionTracker;
import org.opennms.test.VersionSettingTestSuite;

public class SnmpNodeCollectorTest
extends SnmpCollectorTestCase {
    public static TestSuite suite() {
        Class<SnmpNodeCollectorTest> testClass = SnmpNodeCollectorTest.class;
        TestSuite suite = new TestSuite(testClass.getName());
        suite.addTest((Test)new VersionSettingTestSuite(testClass, "SNMPv1 Tests", 1));
        suite.addTest((Test)new VersionSettingTestSuite(testClass, "SNMPv2 Tests", 2));
        suite.addTest((Test)new VersionSettingTestSuite(testClass, "SNMPv3 Tests", 3));
        return suite;
    }

    public void testZeroVars() throws Exception {
        SnmpNodeCollector collector = this.createNodeCollector();
        this.assertMibObjectsPresent((CollectionResource)collector.getCollectionSet().getNodeInfo(), this.getAttributeList());
    }

    public void testInvalidVar() throws Exception {
        this.addAttribute("invalid", ".1.3.6.1.2.1.2", "0", "string");
        SnmpNodeCollector collector = this.createNodeCollector();
        SnmpNodeCollectorTest.assertTrue((boolean)collector.getEntry().isEmpty());
    }

    public void testInvalidInst() throws Exception {
        this.addAttribute("invalid", ".1.3.6.1.2.1.1.3", "1", "timeTicks");
        SnmpNodeCollector collector = this.createNodeCollector();
        SnmpNodeCollectorTest.assertTrue((boolean)collector.getEntry().isEmpty());
    }

    public void testOneVar() throws Exception {
        this.addSysName();
        SnmpNodeCollector collector = this.createNodeCollector();
        this.assertMibObjectsPresent((CollectionResource)collector.getCollectionSet().getNodeInfo(), this.getAttributeList());
    }

    private SnmpNodeCollector createNodeCollector() throws Exception, InterruptedException {
        this.initializeAgent();
        SnmpNodeCollector collector = new SnmpNodeCollector(InetAddress.getLocalHost(), this.getCollectionSet().getAttributeList(), this.getCollectionSet());
        this.createWalker((CollectionTracker)collector);
        this.waitForSignal();
        SnmpNodeCollectorTest.assertNotNull((String)"No entry data", (Object)collector.getEntry());
        SnmpNodeCollectorTest.assertFalse((String)"Timeout collecting data", (boolean)collector.timedOut());
        SnmpNodeCollectorTest.assertFalse((String)"Collector failed to collect data", (boolean)collector.failed());
        return collector;
    }
}

