/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collectd;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import javax.sql.DataSource;
import org.easymock.EasyMock;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.opennms.netmgt.collectd.CollectionAgent;
import org.opennms.netmgt.collectd.CollectionSet;
import org.opennms.netmgt.collectd.CollectionSetVisitor;
import org.opennms.netmgt.collectd.CollectionSpecification;
import org.opennms.netmgt.collectd.DefaultCollectionAgent;
import org.opennms.netmgt.collectd.GroupPersister;
import org.opennms.netmgt.collectd.OneToOnePersister;
import org.opennms.netmgt.collectd.ServiceCollector;
import org.opennms.netmgt.collectd.ServiceParameters;
import org.opennms.netmgt.config.CollectdPackage;
import org.opennms.netmgt.config.DataCollectionConfig;
import org.opennms.netmgt.config.DataCollectionConfigFactory;
import org.opennms.netmgt.config.DatabaseSchemaConfigFactory;
import org.opennms.netmgt.config.collectd.Filter;
import org.opennms.netmgt.config.collectd.Package;
import org.opennms.netmgt.config.collectd.Parameter;
import org.opennms.netmgt.config.collectd.Service;
import org.opennms.netmgt.dao.IpInterfaceDao;
import org.opennms.netmgt.mock.OpenNMSTestCase;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.RrdRepository;
import org.opennms.netmgt.rrd.RrdException;
import org.opennms.netmgt.rrd.RrdUtils;
import org.opennms.test.ConfigurationTestUtils;
import org.opennms.test.FileAnticipator;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.support.DefaultTransactionStatus;

public abstract class AbstractCollectorTest
extends OpenNMSTestCase {
    protected FileAnticipator m_fileAnticipator;
    File m_snmpRrdDirectory;
    protected PlatformTransactionManager m_transMgr;

    protected void persistCollectionSet(CollectionSpecification spec, CollectionSet collectionSet) {
        RrdRepository repository = spec.getRrdRepository("default");
        ServiceParameters params = new ServiceParameters(spec.getReadOnlyPropertyMap());
        Object persister = Boolean.getBoolean("org.opennms.rrd.storeByGroup") ? new GroupPersister(params, repository) : new OneToOnePersister(params, repository);
        collectionSet.visit((CollectionSetVisitor)persister);
    }

    CollectionSpecification createCollectionSpec(String svcName, ServiceCollector svcCollector, String collectionName) {
        Package pkg = new Package();
        Filter filter = new Filter();
        filter.setContent("IPADDR IPLIKE *.*.*.*");
        pkg.setFilter(filter);
        Service service = new Service();
        service.setName(svcName);
        Parameter collectionParm = new Parameter();
        collectionParm.setKey("collection");
        collectionParm.setValue(collectionName);
        service.addParameter(collectionParm);
        pkg.addService(service);
        CollectdPackage wpkg = new CollectdPackage(pkg, "foo", false);
        CollectionSpecification spec = new CollectionSpecification(wpkg, svcName, svcCollector);
        return spec;
    }

    protected void collectNTimes(CollectionSpecification spec, CollectionAgent agent, int numUpdates) throws InterruptedException {
        for (int i = 0; i < numUpdates; ++i) {
            CollectionSet collectionSet = spec.collect(agent);
            AbstractCollectorTest.assertEquals((String)"collection status", (int)1, (int)collectionSet.getStatus());
            this.persistCollectionSet(spec, collectionSet);
            System.err.println("COLLECTION " + i + " FINISHED");
            Thread.sleep(1000L);
        }
    }

    protected String rrd(String file) {
        return file + RrdUtils.getExtension();
    }

    protected void anticipateFiles(File baseDir, String ... fileNames) {
        for (String fileName : fileNames) {
            this.m_fileAnticipator.expecting(baseDir, fileName);
        }
    }

    protected void anticipateRrdFiles(File baseDir, String ... rrdBaseNames) {
        for (String rrdBaseName : rrdBaseNames) {
            this.m_fileAnticipator.expecting(baseDir, this.rrd(rrdBaseName));
        }
    }

    protected File anticipatePath(File rootDir, String ... pathElements) {
        File parent = rootDir;
        AbstractCollectorTest.assertTrue((pathElements.length > 0 ? 1 : 0) != 0);
        for (String pathElement : pathElements) {
            parent = this.m_fileAnticipator.expecting(parent, pathElement);
        }
        return parent;
    }

    protected CollectionAgent createCollectionAgent(OnmsIpInterface iface) {
        IpInterfaceDao ifDao = (IpInterfaceDao)EasyMock.createMock(IpInterfaceDao.class);
        EasyMock.expect((Object)ifDao.load((Serializable)iface.getId())).andReturn((Object)iface).anyTimes();
        EasyMock.replay((Object[])new Object[]{ifDao});
        CollectionAgent agent = DefaultCollectionAgent.create((Integer)iface.getId(), (IpInterfaceDao)ifDao, (PlatformTransactionManager)this.m_transMgr);
        return agent;
    }

    protected File getSnmpRrdDirectory() throws IOException {
        if (this.m_snmpRrdDirectory == null) {
            this.m_snmpRrdDirectory = this.m_fileAnticipator.tempDir("snmp");
        }
        return this.m_snmpRrdDirectory;
    }

    protected void setFileAnticipator() throws Exception {
        this.m_fileAnticipator = new FileAnticipator();
    }

    protected void setTransMgr() {
        this.m_transMgr = new DataSourceTransactionManager((DataSource)((Object)m_db)){
            private static final long serialVersionUID = 1L;

            protected void doCommit(DefaultTransactionStatus status) {
                super.doCommit(status);
                System.err.println("call to commit a transaction");
            }

            protected void doBegin(Object transaction, TransactionDefinition definition) {
                super.doBegin(transaction, definition);
                System.err.println("Call to begin a transaction");
            }
        };
    }

    protected void initializeDatabaseSchemaConfig(String databaseSchemaConfig) throws MarshalException, ValidationException, IOException {
        Reader rdr = ConfigurationTestUtils.getReaderForResource((Object)((Object)this), (String)databaseSchemaConfig);
        DatabaseSchemaConfigFactory.setInstance((DatabaseSchemaConfigFactory)new DatabaseSchemaConfigFactory(rdr));
        rdr.close();
    }

    protected void initializeDataCollectionConfig(String dataCollectionConfig) throws IOException, MarshalException, ValidationException, RrdException {
        Reader rdr = this.getDataCollectionConfigReader(dataCollectionConfig);
        DataCollectionConfigFactory.setInstance((DataCollectionConfig)new DataCollectionConfigFactory(rdr));
        rdr.close();
    }

    protected Reader getDataCollectionConfigReader(String classPathLocation) throws IOException {
        return ConfigurationTestUtils.getReaderForResourceWithReplacements((Object)((Object)this), (String)classPathLocation, (String[][])new String[][]{{"%rrdRepository%", this.getSnmpRrdDirectory().getAbsolutePath()}});
    }
}

