/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.protocols.dns;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.opennms.protocols.dns.DNSInputStream;

public class DNSAddressRequest {
    public final int CLASS_IN = 1;
    public final int TYPE_ADDR = 1;
    public final int SHIFT_QUERY = 15;
    public final int SHIFT_OPCODE = 11;
    public final int SHIFT_AUTHORITATIVE = 10;
    public final int SHIFT_TRUNCATED = 9;
    public final int SHIFT_RECURSE_PLEASE = 8;
    public final int SHIFT_RECURSE_AVAILABLE = 7;
    public final int SHIFT_RESERVED = 4;
    public final int SHIFT_RESPONSE_CODE = 0;
    public final int OPCODE_QUERY = 0;
    public String m_reqHost;
    public int m_reqID;
    public boolean m_authoritative;
    public boolean m_truncated;
    public boolean m_recursive;
    public List m_answers;
    private static int globalID = 1;

    private void decodeFlags(int flags) throws IOException {
        boolean isResponse;
        boolean bl = isResponse = (flags >> 15 & 1) != 0;
        if (!isResponse) {
            throw new IOException("Response flag not set");
        }
        int code = flags >> 0 & 0xF;
        if (code != 0 && code == 2) {
            throw new IOException(DNSAddressRequest.codeName(code) + " (" + code + ")");
        }
        this.m_authoritative = (flags >> 10 & 1) != 0;
        this.m_truncated = (flags >> 9 & 1) != 0;
        this.m_recursive = (flags >> 7 & 1) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DNSAddressRequest(String host) {
        StringTokenizer labels = new StringTokenizer(host, ".");
        while (labels.hasMoreTokens()) {
            if (labels.nextToken().length() <= 63) continue;
            throw new IllegalArgumentException("Invalid hostname: " + host);
        }
        this.m_reqHost = host;
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            this.m_reqID = globalID % 65536;
            globalID = this.m_reqID + 1;
        }
        this.m_answers = new ArrayList();
    }

    public byte[] buildRequest() throws IOException {
        ByteArrayOutputStream byteArrayOut = new ByteArrayOutputStream();
        DataOutputStream dataOut = new DataOutputStream(byteArrayOut);
        dataOut.writeShort(this.m_reqID);
        dataOut.writeShort(256);
        dataOut.writeShort(1);
        dataOut.writeShort(0);
        dataOut.writeShort(0);
        dataOut.writeShort(0);
        StringTokenizer labels = new StringTokenizer(this.m_reqHost, ".");
        while (labels.hasMoreTokens()) {
            String label = labels.nextToken();
            dataOut.writeByte(label.length());
            dataOut.writeBytes(label);
        }
        dataOut.writeByte(0);
        dataOut.writeShort(1);
        dataOut.writeShort(1);
        return byteArrayOut.toByteArray();
    }

    public void receiveResponse(byte[] data, int length) throws IOException {
        block5: {
            DNSInputStream dnsIn = new DNSInputStream(data, 0, length);
            int id = dnsIn.readShort();
            if (id != this.m_reqID) {
                throw new IOException("ID does not match request");
            }
            int flags = dnsIn.readShort();
            this.decodeFlags(flags);
            int numQueries = dnsIn.readShort();
            int numAnswers = dnsIn.readShort();
            int numAuthorities = dnsIn.readShort();
            int numAdditional = dnsIn.readShort();
            while (numQueries-- > 0) {
                String rname = dnsIn.readDomainName();
                int rtype = dnsIn.readShort();
                int rclass = dnsIn.readShort();
            }
            try {
                while (numAnswers-- > 0) {
                    this.m_answers.add(dnsIn.readRR());
                }
            }
            catch (IOException ex) {
                if (this.m_truncated) break block5;
                throw ex;
            }
        }
    }

    public void verifyResponse(byte[] data, int length) throws IOException {
        DNSInputStream dnsIn = new DNSInputStream(data, 0, length);
        int id = dnsIn.readShort();
        if (id != this.m_reqID) {
            throw new IOException("ID does not match request");
        }
        int flags = dnsIn.readShort();
        this.decodeFlags(flags);
    }

    public List getAnswers() {
        return this.m_answers;
    }

    public int getRequestID() {
        return this.m_reqID;
    }

    public String getHost() {
        return this.m_reqHost;
    }

    public boolean isTruncated() {
        return this.m_truncated;
    }

    public boolean isRecursive() {
        return this.m_recursive;
    }

    public boolean isAuthoritative() {
        return this.m_authoritative;
    }

    public static String codeName(int code) {
        String[] codeNames = new String[]{"Format error", "Server failure", "Name not known", "Not implemented", "Refused"};
        return code >= 1 && code <= 5 ? codeNames[code - 1] : "Unknown error";
    }
}

