/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.xmlrpcd;

import java.util.ArrayList;
import java.util.Enumeration;
import org.apache.log4j.Category;
import org.opennms.core.queue.FifoQueue;
import org.opennms.core.queue.FifoQueueException;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.config.XmlrpcdConfigFactory;
import org.opennms.netmgt.config.xmlrpcd.SubscribedEvent;
import org.opennms.netmgt.eventd.EventIpcManagerFactory;
import org.opennms.netmgt.eventd.EventListener;
import org.opennms.netmgt.xml.event.Event;

final class BroadcastEventProcessor
implements EventListener {
    private FifoQueue m_eventQ;
    private int m_maxQSize;

    BroadcastEventProcessor(FifoQueue eventQ, int maxQSize, Enumeration eventEnum) {
        ArrayList<String> ueiList = new ArrayList<String>();
        while (eventEnum.hasMoreElements()) {
            SubscribedEvent sEvent = (SubscribedEvent)eventEnum.nextElement();
            ueiList.add(sEvent.getUei());
        }
        this.m_eventQ = eventQ;
        this.m_maxQSize = maxQSize;
        EventIpcManagerFactory.init();
        EventIpcManagerFactory.getIpcManager().addEventListener((EventListener)this, ueiList);
    }

    public void close() {
        EventIpcManagerFactory.getIpcManager().removeEventListener(this);
    }

    public void onEvent(Event event) {
        Category log = ThreadCategory.getInstance(this.getClass());
        String eventUei = event.getUei();
        if (eventUei == null) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Received event: " + eventUei));
        }
        try {
            if (XmlrpcdConfigFactory.getInstance().eventSubscribed(eventUei)) {
                if (this.m_eventQ.size() >= this.m_maxQSize) {
                    this.m_eventQ.remove(1000L);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Event " + eventUei + " removed from event queue"));
                    }
                }
                this.m_eventQ.add((Object)event);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Event " + eventUei + " added to event queue"));
                }
            }
        }
        catch (InterruptedException ex) {
            log.error((Object)"Failed to process event", (Throwable)ex);
            return;
        }
        catch (FifoQueueException ex) {
            log.error((Object)"Failed to process event", (Throwable)ex);
            return;
        }
        catch (Throwable t) {
            log.error((Object)"Failed to process event", t);
            return;
        }
    }

    public String getName() {
        return "Xmlrpcd:BroadcastEventProcessor";
    }
}

