/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.vmmgr;

import java.io.FileInputStream;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import org.exolab.castor.jdo.conf.Database;
import org.exolab.castor.jdo.conf.Param;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.opennms.netmgt.ConfigFileConstants;
import org.xml.sax.InputSource;

public class DatabaseChecker {
    private Database m_database = null;
    private String m_driverUrl;
    private String m_driverUser;
    private String m_driverPass;

    protected DatabaseChecker(String configFile) throws IOException, MarshalException, ValidationException, ClassNotFoundException {
        Class<Database> dsc = Database.class;
        InputSource dbIn = new InputSource(new FileInputStream(configFile));
        dbIn.setSystemId(configFile);
        this.m_database = (Database)Unmarshaller.unmarshal(dsc, (InputSource)dbIn);
        Param[] parms = this.m_database.getDatabaseChoice().getDriver().getParam();
        for (int i = 0; i < parms.length; ++i) {
            if (parms[i].getName().equals("user")) {
                this.m_driverUser = parms[i].getValue();
                continue;
            }
            if (parms[i].getName().equals("password")) {
                this.m_driverPass = parms[i].getValue();
                continue;
            }
            throw new ValidationException("Unsupported JDO parameter: " + parms[i].getName());
        }
        this.m_driverUrl = this.m_database.getDatabaseChoice().getDriver().getUrl();
        String driverCN = this.m_database.getDatabaseChoice().getDriver().getClassName();
        Class.forName(driverCN);
    }

    protected DatabaseChecker() throws IOException, MarshalException, ValidationException, ClassNotFoundException {
        this(ConfigFileConstants.getFile((int)ConfigFileConstants.DB_CONFIG_FILE_NAME).getPath());
    }

    public void check() throws SQLException {
        Connection c = DriverManager.getConnection(this.m_driverUrl, this.m_driverUser, this.m_driverPass);
        c.close();
    }

    public static void main(String[] argv) throws Exception {
        DatabaseChecker checker = new DatabaseChecker();
        checker.check();
    }
}

