/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.trapd;

import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.sql.SQLException;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.config.TrapdConfigFactory;
import org.opennms.netmgt.daemon.AbstractServiceDaemon;
import org.opennms.netmgt.dao.EventDao;
import org.opennms.netmgt.eventd.EventIpcManager;
import org.opennms.netmgt.eventd.EventIpcManagerFactory;
import org.opennms.netmgt.trapd.TrapHandler;
import org.opennms.netmgt.trapd.TrapdIPMgr;

public class Trapd
extends AbstractServiceDaemon {
    private static final String LOG4J_CATEGORY = "OpenNMS.Trapd";
    private static final Trapd m_singleton = new Trapd();
    private EventDao m_eventDao;

    public Trapd() {
        super(LOG4J_CATEGORY);
    }

    protected void onInit() {
        try {
            this.log().debug((Object)"start: Initializing the trapd config factory");
            TrapdConfigFactory.init();
        }
        catch (MarshalException e) {
            this.log().error((Object)"Failed to load configuration", (Throwable)e);
            throw new UndeclaredThrowableException(e);
        }
        catch (ValidationException e) {
            this.log().error((Object)"Failed to load configuration", (Throwable)e);
            throw new UndeclaredThrowableException(e);
        }
        catch (IOException e) {
            this.log().error((Object)"Failed to load configuration", (Throwable)e);
            throw new UndeclaredThrowableException(e);
        }
        try {
            TrapdIPMgr.dataSourceSync();
        }
        catch (SQLException e) {
            this.log().error((Object)"Failed to load known IP address list", (Throwable)e);
            throw new UndeclaredThrowableException(e);
        }
        TrapHandler trapHandler = this.getTrapHandler();
        trapHandler.setTrapdConfig(TrapdConfigFactory.getInstance());
        EventIpcManagerFactory.init();
        EventIpcManager mgr = EventIpcManagerFactory.getIpcManager();
        trapHandler.setEventManager(mgr);
        trapHandler.init();
    }

    protected void onStart() {
        this.getTrapHandler().start();
    }

    protected void onPause() {
        this.getTrapHandler().pause();
    }

    protected void onResume() {
        this.getTrapHandler().resume();
    }

    protected void onStop() {
        this.getTrapHandler().stop();
    }

    public synchronized int getStatus() {
        return this.getTrapHandler().getStatus();
    }

    public static Trapd getInstance() {
        return m_singleton;
    }

    private TrapHandler getTrapHandler() {
        ThreadCategory.setPrefix((String)LOG4J_CATEGORY);
        return TrapHandler.getInstance();
    }

    public EventDao getEventDao() {
        return this.m_eventDao;
    }

    public void setEventDao(EventDao eventDao) {
        this.m_eventDao = eventDao;
    }
}

