/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.threshd;

import java.io.File;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Category;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.rrd.RrdException;
import org.opennms.netmgt.rrd.RrdUtils;
import org.opennms.netmgt.threshd.BaseThresholdDefConfigWrapper;
import org.opennms.netmgt.threshd.LatencyInterface;
import org.opennms.netmgt.threshd.LatencyParameters;
import org.opennms.netmgt.threshd.ThresholdEvaluator;
import org.opennms.netmgt.threshd.ThresholdEvaluatorHighLow;
import org.opennms.netmgt.threshd.ThresholdEvaluatorRelativeChange;
import org.opennms.netmgt.threshd.ThresholdEvaluatorState;
import org.opennms.netmgt.threshd.ThresholdExpressionException;
import org.opennms.netmgt.threshd.ThresholdingException;
import org.opennms.netmgt.xml.event.Event;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ThresholdEntity
implements Cloneable {
    private static List<ThresholdEvaluator> s_thresholdEvaluators = new LinkedList<ThresholdEvaluator>();
    private List<ThresholdEvaluatorState> m_thresholdEvaluatorStates = new LinkedList<ThresholdEvaluatorState>();

    public String getDataSourceExpression() {
        if (this.getThresholdEvaluatorStates().size() > 0) {
            return this.getThresholdEvaluatorStates().get(0).getThresholdConfig().getDatasourceExpression();
        }
        throw new IllegalStateException("No thresholds have been added.");
    }

    public String getDatasourceType() {
        if (this.getThresholdEvaluatorStates().size() > 0) {
            return this.getThresholdEvaluatorStates().get(0).getThresholdConfig().getDsType();
        }
        throw new IllegalStateException("No thresholds have been added.");
    }

    public String getDatasourceLabel() {
        if (this.getThresholdEvaluatorStates().size() > 0) {
            return this.getThresholdEvaluatorStates().get(0).getThresholdConfig().getDsLabel();
        }
        return null;
    }

    public Collection<String> getRequiredDatasources() {
        if (this.getThresholdEvaluatorStates().size() > 0) {
            return this.getThresholdEvaluatorStates().get(0).getThresholdConfig().getRequiredDatasources();
        }
        throw new IllegalStateException("No thresholds have been added.");
    }

    public ThresholdEntity clone() {
        ThresholdEntity clone = new ThresholdEntity();
        for (ThresholdEvaluatorState thresholdItem : this.getThresholdEvaluatorStates()) {
            clone.addThreshold(thresholdItem.getThresholdConfig());
        }
        return clone;
    }

    public String toString() {
        if (this.getThresholdEvaluatorStates().size() == 0) {
            return "";
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append("dsName=").append(this.getDataSourceExpression());
        buffer.append(", dsType=").append(this.getDatasourceType());
        for (ThresholdEvaluatorState item : this.getThresholdEvaluatorStates()) {
            buffer.append(", ds=").append(item.getThresholdConfig().getDatasourceExpression());
            buffer.append(", value=").append(item.getThresholdConfig().getValue());
            buffer.append(", rearm=").append(item.getThresholdConfig().getRearm());
            buffer.append(", trigger=").append(item.getThresholdConfig().getTrigger());
        }
        return buffer.toString();
    }

    public List<Event> evaluateAndCreateEvents(Map<String, Double> values, Date date) {
        LinkedList<Event> events = new LinkedList<Event>();
        double dsValue = 0.0;
        try {
            if (this.getThresholdEvaluatorStates().size() <= 0) {
                throw new IllegalStateException("No thresholds have been added.");
            }
            dsValue = this.getThresholdEvaluatorStates().get(0).getThresholdConfig().evaluate(values);
        }
        catch (ThresholdExpressionException e) {
            this.log().warn((Object)"Failed to evaluate: ", (Throwable)e);
            return events;
        }
        if (this.log().isDebugEnabled()) {
            this.log().debug((Object)("evaluate: value= " + dsValue + " against threshold: " + this));
        }
        for (ThresholdEvaluatorState item : this.getThresholdEvaluatorStates()) {
            ThresholdEvaluatorState.Status status;
            Event event = item.getEventForState(status = item.evaluate(dsValue), date, dsValue);
            if (event == null) continue;
            events.add(event);
        }
        return events;
    }

    private final Category log() {
        return ThreadCategory.getInstance(ThresholdEntity.class);
    }

    public Double fetchLastValue(LatencyInterface latIface, LatencyParameters latParms) throws ThresholdingException {
        String datasource = this.getDataSourceExpression();
        Double dsValue = null;
        try {
            if (this.getDatasourceType().equals("if")) {
                File rrdFile;
                if (this.log().isDebugEnabled()) {
                    this.log().debug((Object)("Fetching last value from dataSource '" + datasource + "'"));
                }
                if (!(rrdFile = new File(latIface.getLatencyDir(), datasource + RrdUtils.getExtension())).exists()) {
                    this.log().info((Object)("rrd file " + rrdFile + " does not exist"));
                    return null;
                }
                if (!rrdFile.canRead()) {
                    this.log().error((Object)("Unable to read existing rrd file " + rrdFile));
                    return null;
                }
                dsValue = latParms.getRange() == 0 ? RrdUtils.fetchLastValue((String)rrdFile.getAbsolutePath(), (String)datasource, (int)latParms.getInterval()) : RrdUtils.fetchLastValueInRange((String)rrdFile.getAbsolutePath(), (String)datasource, (int)latParms.getInterval(), (int)latParms.getRange());
            } else {
                throw new ThresholdingException("expr types not yet implemented", 2);
            }
            if (this.log().isDebugEnabled()) {
                this.log().debug((Object)("Last value from dataSource '" + datasource + "' was " + dsValue));
            }
        }
        catch (NumberFormatException nfe) {
            this.log().warn((Object)("Unable to convert retrieved value for datasource '" + datasource + "' to a double, skipping evaluation."));
        }
        catch (RrdException e) {
            this.log().error((Object)("An error occurred retriving the last value for datasource '" + datasource + "': " + (Object)((Object)e)), (Throwable)e);
        }
        return dsValue;
    }

    public void addThreshold(BaseThresholdDefConfigWrapper threshold) {
        ThresholdEvaluator evaluator = this.getEvaluatorForThreshold(threshold);
        for (ThresholdEvaluatorState item : this.getThresholdEvaluatorStates()) {
            if (item.getThresholdConfig().getType() != threshold.getType()) continue;
            throw new IllegalStateException(threshold.getType().toString() + " threshold already set.");
        }
        this.m_thresholdEvaluatorStates.add(evaluator.getThresholdEvaluatorState(threshold));
    }

    private ThresholdEvaluator getEvaluatorForThreshold(BaseThresholdDefConfigWrapper threshold) {
        for (ThresholdEvaluator evaluator : ThresholdEntity.getThresholdEvaluators()) {
            if (!evaluator.supportsType(threshold.getType())) continue;
            return evaluator;
        }
        String message = "Threshold type '" + threshold.getType().toString() + "' for " + threshold.getDatasourceExpression() + " is not supported";
        this.log().warn((Object)message);
        throw new IllegalArgumentException(message);
    }

    public List<ThresholdEvaluatorState> getThresholdEvaluatorStates() {
        return this.m_thresholdEvaluatorStates;
    }

    public static final List<ThresholdEvaluator> getThresholdEvaluators() {
        return s_thresholdEvaluators;
    }

    static {
        s_thresholdEvaluators.add(new ThresholdEvaluatorHighLow());
        s_thresholdEvaluators.add(new ThresholdEvaluatorRelativeChange());
    }
}

