/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.syslogd;

import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Category;
import org.opennms.core.queue.FifoQueue;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.EventConstants;
import org.opennms.netmgt.config.SyslogdConfig;
import org.opennms.netmgt.config.syslogd.HideMessage;
import org.opennms.netmgt.config.syslogd.UeiList;
import org.opennms.netmgt.eventd.EventIpcManagerFactory;
import org.opennms.netmgt.syslogd.BroadcastEventProcessor;
import org.opennms.netmgt.syslogd.ConvertToEvent;
import org.opennms.netmgt.syslogd.SyslogHandler;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.netmgt.xml.event.Parm;

final class SyslogProcessor
implements Runnable {
    private BroadcastEventProcessor m_eventReader;
    private Thread m_context = null;
    private List m_eventsIn;
    private List m_eventsOut;
    private List m_handlers;
    private volatile boolean m_stop = false;
    private boolean m_NewSuspectOnMessage;
    private String m_ForwardingRegexp;
    private int m_MatchingGroupHost;
    private int m_MatchingGroupMessage;
    private UeiList m_UeiList;
    private HideMessage m_HideMessages;
    private DatagramSocket m_dgSock;
    private FifoQueue m_queue;
    private String m_logPrefix;
    private String m_localAddr;

    public static void setSyslogConfig(SyslogdConfig syslogdConfig) {
        SyslogdConfig m_syslogdConfig = syslogdConfig;
    }

    SyslogProcessor(boolean newSuspectOnMessage, String forwardingRegexp, int matchingGroupHost, int matchingGroupMessage, UeiList ueiList, HideMessage hideMessages) {
        this.m_NewSuspectOnMessage = newSuspectOnMessage;
        this.m_ForwardingRegexp = forwardingRegexp;
        this.m_MatchingGroupHost = matchingGroupHost;
        this.m_MatchingGroupMessage = matchingGroupMessage;
        this.m_UeiList = ueiList;
        this.m_HideMessages = hideMessages;
        this.m_logPrefix = "OpenNMS.Syslogd";
        try {
            this.m_localAddr = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException uhE) {
            Category log = ThreadCategory.getInstance(this.getClass());
            this.m_localAddr = "localhost";
            log.error((Object)"<ctor>: Error looking up local hostname", (Throwable)uhE);
        }
    }

    boolean isAlive() {
        return this.m_context != null && this.m_context.isAlive();
    }

    void stop() throws InterruptedException {
        this.m_stop = true;
        if (this.m_context != null) {
            Category log = ThreadCategory.getInstance(this.getClass());
            if (log.isDebugEnabled()) {
                log.debug((Object)("Stopping and joining thread context " + this.m_context.getName()));
            }
            this.m_context.interrupt();
            this.m_context.join();
            if (log.isDebugEnabled()) {
                log.debug((Object)"Thread context stopped and joined");
            }
        }
    }

    public void run() {
        this.m_context = Thread.currentThread();
        ThreadCategory.setPrefix((String)this.m_logPrefix);
        Category log = ThreadCategory.getInstance(this.getClass());
        boolean isTracing = log.isDebugEnabled();
        if (this.m_stop) {
            if (isTracing) {
                log.debug((Object)"Stop flag set before thread started, exiting");
            }
            return;
        }
        if (isTracing) {
            log.debug((Object)"Thread context started");
        }
        while (!this.m_stop) {
            ConvertToEvent o = null;
            o = SyslogHandler.queueManager.getFromQueue();
            if (o == null) continue;
            try {
                Parm[] parms;
                log.debug((Object)("Processing a syslog to event dispatch" + o.toString()));
                String uuid = o.getEvent().getUuid();
                log.debug((Object)"Event {");
                log.debug((Object)("  uuid  = " + (uuid != null && uuid.length() > 0 ? uuid : "<not-set>")));
                log.debug((Object)("  uei   = " + o.getEvent().getUei()));
                log.debug((Object)("  src   = " + o.getEvent().getSource()));
                log.debug((Object)("  iface = " + o.getEvent().getInterface()));
                log.debug((Object)("  time  = " + o.getEvent().getTime()));
                log.debug((Object)("  Msg   = " + o.getEvent().getLogmsg().getContent()));
                log.debug((Object)("  Dst   = " + o.getEvent().getLogmsg().getDest()));
                Parm[] parmArray = parms = o.getEvent().getParms() == null ? null : o.getEvent().getParms().getParm();
                if (parms != null) {
                    log.debug((Object)"  parms {");
                    for (Parm parm : parms) {
                        if (parm.getParmName() == null || parm.getValue().getContent() == null) continue;
                        log.debug((Object)("    (" + parm.getParmName().trim() + ", " + parm.getValue().getContent().trim() + ")"));
                    }
                    log.debug((Object)"  }");
                }
                log.debug((Object)"}");
                EventIpcManagerFactory.getIpcManager().sendNow(o.getEvent());
                if (!this.m_NewSuspectOnMessage || o.getEvent().hasNodeid()) continue;
                log.debug((Object)("Syslogd: Found a new suspect " + o.getEvent().getInterface()));
                this.sendNewSuspectEvent(o.getEvent().getInterface());
            }
            catch (Throwable t) {
                log.error((Object)"Unexpected error processing SyslogMessage - Could not send", t);
            }
        }
    }

    void setLogPrefix(String prefix) {
        this.m_logPrefix = prefix;
    }

    private void sendNewSuspectEvent(String trapInterface) {
        Event event = new Event();
        event.setSource("syslogd");
        event.setUei("uei.opennms.org/internal/discovery/newSuspect");
        event.setHost(this.m_localAddr);
        event.setInterface(trapInterface);
        event.setTime(EventConstants.formatToString(new Date()));
        EventIpcManagerFactory.getIpcManager().sendNow(event);
    }
}

