/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.statsd;

import org.opennms.netmgt.dao.FilterDao;
import org.opennms.netmgt.dao.ResourceDao;
import org.opennms.netmgt.dao.RrdDao;
import org.opennms.netmgt.dao.castor.statsd.PackageReport;
import org.opennms.netmgt.model.AttributeStatisticVisitorWithResults;
import org.opennms.netmgt.statsd.AbstractReportInstance;
import org.opennms.netmgt.statsd.FilteredReportInstance;
import org.opennms.netmgt.statsd.RelativeTime;
import org.opennms.netmgt.statsd.ReportInstance;
import org.opennms.netmgt.statsd.UnfilteredReportInstance;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.util.Assert;

public class ReportDefinition
implements InitializingBean {
    private PackageReport m_report;
    private Class m_reportClass;
    private Integer m_count;
    private String m_consolidationFunction;
    private RelativeTime m_relativeTime;
    private String m_resourceTypeMatch;
    private String m_attributeMatch;

    public String getAttributeMatch() {
        return this.m_attributeMatch;
    }

    public void setAttributeMatch(String attributeMatch) {
        this.m_attributeMatch = attributeMatch;
    }

    public String getConsolidationFunction() {
        return this.m_consolidationFunction;
    }

    public void setConsolidationFunction(String consolidationFunction) {
        this.m_consolidationFunction = consolidationFunction;
    }

    public Integer getCount() {
        return this.m_count;
    }

    public void setCount(Integer count) {
        this.m_count = count;
    }

    public String getResourceTypeMatch() {
        return this.m_resourceTypeMatch;
    }

    public void setResourceTypeMatch(String resourceTypeMatch) {
        this.m_resourceTypeMatch = resourceTypeMatch;
    }

    public Class getReportClass() {
        return this.m_reportClass;
    }

    public void setReportClass(Class reportClass) {
        this.m_reportClass = reportClass;
    }

    public RelativeTime getRelativeTime() {
        return this.m_relativeTime;
    }

    public void setRelativeTime(RelativeTime relativeTime) {
        this.m_relativeTime = relativeTime;
    }

    public PackageReport getReport() {
        return this.m_report;
    }

    public void setReport(PackageReport report) {
        this.m_report = report;
    }

    public String getCronExpression() {
        return this.getReport().getSchedule();
    }

    public String getDescription() {
        return this.getReport().getDescription();
    }

    public String getName() {
        return this.getReport().getReport().getName();
    }

    public Long getRetainInterval() {
        return this.getReport().getRetainInterval();
    }

    public ReportInstance createReport(ResourceDao resourceDao, RrdDao rrdDao, FilterDao filterDao) throws Exception {
        AbstractReportInstance report;
        AttributeStatisticVisitorWithResults visitor;
        try {
            visitor = (AttributeStatisticVisitorWithResults)this.getReportClass().newInstance();
        }
        catch (Exception e) {
            throw new DataAccessResourceFailureException("Could not instantiate visitor object; nested exception: " + e, (Throwable)e);
        }
        if (this.getReport().getPackage().getFilter() != null) {
            FilteredReportInstance thisReport = new FilteredReportInstance(visitor);
            thisReport.setResourceDao(resourceDao);
            thisReport.setRrdDao(rrdDao);
            thisReport.setFilterDao(filterDao);
            thisReport.setFilter(this.getReport().getPackage().getFilter());
            report = thisReport;
        } else {
            UnfilteredReportInstance thisReport = new UnfilteredReportInstance(visitor);
            thisReport.setResourceDao(resourceDao);
            thisReport.setRrdDao(rrdDao);
            report = thisReport;
        }
        report.setReportDefinition(this);
        report.setStartTime(this.getRelativeTime().getStart().getTime());
        report.setEndTime(this.getRelativeTime().getEnd().getTime());
        report.setCount(this.getCount());
        report.setConsolidationFunction(this.getConsolidationFunction());
        report.setResourceTypeMatch(this.getResourceTypeMatch());
        report.setAttributeMatch(this.getAttributeMatch());
        if (report instanceof InitializingBean) {
            ((InitializingBean)report).afterPropertiesSet();
        }
        return report;
    }

    public void afterPropertiesSet() {
        Assert.state((this.m_report != null ? 1 : 0) != 0, (String)"property report must be set to a non-null value");
        Assert.state((this.m_count != null ? 1 : 0) != 0, (String)"property count must be set to a non-null value");
        Assert.state((this.m_consolidationFunction != null ? 1 : 0) != 0, (String)"property consolidationFunction must be set to a non-null value");
        Assert.state((this.m_relativeTime != null ? 1 : 0) != 0, (String)"property relativeTime must be set to a non-null value");
        Assert.state((this.m_resourceTypeMatch != null ? 1 : 0) != 0, (String)"property resourceTypeMatch must be set to a non-null value");
        Assert.state((this.m_attributeMatch != null ? 1 : 0) != 0, (String)"property attributeMatch must be set to a non-null value");
        Assert.state((this.m_reportClass != null ? 1 : 0) != 0, (String)"property reportClass must be set to a non-null value");
    }
}

