/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.remote;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.opennms.netmgt.model.PollStatus;
import org.opennms.netmgt.poller.ServiceMonitor;
import org.opennms.netmgt.poller.ServiceMonitorLocator;
import org.opennms.netmgt.poller.remote.PollService;
import org.opennms.netmgt.poller.remote.PolledService;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultPollService
implements PollService {
    Collection<ServiceMonitorLocator> m_locators;
    Map<String, ServiceMonitor> m_monitors;

    @Override
    public void setServiceMonitorLocators(Collection<ServiceMonitorLocator> locators) {
        this.m_locators = locators;
        HashMap<String, ServiceMonitor> monitors = new HashMap<String, ServiceMonitor>();
        for (ServiceMonitorLocator locator : locators) {
            monitors.put(locator.getServiceName(), locator.getServiceMonitor());
        }
        this.m_monitors = monitors;
    }

    @Override
    public void initialize(PolledService polledService) {
        ServiceMonitor monitor = this.getServiceMonitor(polledService);
        monitor.initialize(polledService);
    }

    @Override
    public PollStatus poll(PolledService polledService) {
        ServiceMonitor monitor = this.getServiceMonitor(polledService);
        return monitor.poll(polledService, polledService.getMonitorConfiguration());
    }

    private ServiceMonitor getServiceMonitor(PolledService polledService) {
        Assert.notNull(this.m_monitors, (String)"setServiceMonitorLocators must be called before any other operations");
        ServiceMonitor monitor = this.m_monitors.get(polledService.getSvcName());
        Assert.notNull((Object)monitor, (String)("Unable to find monitor for service " + polledService.getSvcName()));
        return monitor;
    }

    @Override
    public void release(PolledService polledService) {
        ServiceMonitor monitor = this.getServiceMonitor(polledService);
        monitor.release(polledService);
    }
}

