/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.pollables;

import java.net.InetAddress;
import java.util.Date;
import org.apache.log4j.Category;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.model.PollStatus;
import org.opennms.netmgt.poller.pollables.LockUnavailable;
import org.opennms.netmgt.poller.pollables.PollContext;
import org.opennms.netmgt.poller.pollables.PollableContainer;
import org.opennms.netmgt.poller.pollables.PollableElement;
import org.opennms.netmgt.poller.pollables.PollableInterface;
import org.opennms.netmgt.poller.pollables.PollableNetwork;
import org.opennms.netmgt.poller.pollables.PollableService;
import org.opennms.netmgt.poller.pollables.PollableVisitor;
import org.opennms.netmgt.poller.pollables.ThreadInterrupted;
import org.opennms.netmgt.xml.event.Event;

public class PollableNode
extends PollableContainer {
    private int m_nodeId;
    private String m_nodeLabel;
    private Lock m_lock = new Lock();

    public PollableNode(PollableNetwork network, int nodeId, String nodeLabel) {
        super(network);
        this.m_nodeId = nodeId;
        this.m_nodeLabel = nodeLabel;
    }

    public int getNodeId() {
        return this.m_nodeId;
    }

    public String getNodeLabel() {
        return this.m_nodeLabel;
    }

    public PollableInterface createInterface(final InetAddress addr) {
        final PollableInterface[] retVal = new PollableInterface[1];
        Runnable r = new Runnable(){

            public void run() {
                PollableInterface iface = new PollableInterface(PollableNode.this, addr);
                PollableNode.this.addMember(iface);
                retVal[0] = iface;
            }
        };
        this.withTreeLock(r);
        return retVal[0];
    }

    public PollableInterface getInterface(InetAddress addr) {
        return (PollableInterface)this.getMember(addr);
    }

    public PollableNetwork getNetwork() {
        return (PollableNetwork)this.getParent();
    }

    public PollContext getContext() {
        return this.getNetwork().getContext();
    }

    protected Object createMemberKey(PollableElement member) {
        PollableInterface iface = (PollableInterface)member;
        return iface.getAddress();
    }

    public PollableService createService(final InetAddress addr, final String svcName) {
        final PollableService[] retVal = new PollableService[1];
        Runnable r = new Runnable(){

            public void run() {
                PollableInterface iface = PollableNode.this.getInterface(addr);
                if (iface == null) {
                    iface = PollableNode.this.createInterface(addr);
                }
                retVal[0] = iface.createService(svcName);
            }
        };
        this.withTreeLock(r);
        return retVal[0];
    }

    public PollableService getService(InetAddress addr, String svcName) {
        PollableInterface iface = this.getInterface(addr);
        return iface == null ? null : iface.getService(svcName);
    }

    protected void visitThis(PollableVisitor v) {
        super.visitThis(v);
        v.visitNode(this);
    }

    public Event createDownEvent(Date date) {
        return this.getContext().createEvent("uei.opennms.org/nodes/nodeDown", this.getNodeId(), null, null, date, this.getStatus().getReason());
    }

    public Event createUpEvent(Date date) {
        return this.getContext().createEvent("uei.opennms.org/nodes/nodeUp", this.getNodeId(), null, null, date, this.getStatus().getReason());
    }

    public String toString() {
        return String.valueOf(this.getNodeId());
    }

    public PollableElement getLockRoot() {
        return this;
    }

    public boolean isTreeLockAvailable() {
        return this.m_lock.isLockAvailable();
    }

    public void obtainTreeLock(long timeout) {
        if (timeout == 0L) {
            this.m_lock.obtain();
        } else {
            this.m_lock.obtain(timeout);
        }
    }

    public void releaseTreeLock() {
        this.m_lock.release();
    }

    public PollStatus doPoll(final PollableElement elem) {
        final PollStatus[] retVal = new PollStatus[1];
        Runnable r = new Runnable(){

            public void run() {
                PollableNode.this.resetStatusChanged();
                retVal[0] = PollableNode.this.poll(elem);
            }
        };
        this.withTreeLock(r);
        return retVal[0];
    }

    public class Lock {
        Thread m_owner = null;
        int m_obtainCount = 0;

        public synchronized void obtain() {
            Category log = ThreadCategory.getInstance(this.getClass());
            if (this.m_owner != Thread.currentThread()) {
                log.debug((Object)("Trying to obtain lock for " + PollableNode.this));
                while (this.m_owner != null) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        throw new ThreadInterrupted("Lock for " + PollableNode.this + " is unavailable", e);
                    }
                }
                this.m_owner = Thread.currentThread();
                log.debug((Object)("Obtained lock for " + PollableNode.this));
            }
            ++this.m_obtainCount;
        }

        public synchronized void obtain(long timeout) {
            Category log = ThreadCategory.getInstance(this.getClass());
            if (this.m_owner != Thread.currentThread()) {
                long endTime;
                log.debug((Object)("Trying to obtain lock for " + PollableNode.this));
                long now = System.currentTimeMillis();
                long l = endTime = timeout == 0L ? Long.MAX_VALUE : now + timeout;
                while (this.m_owner != null) {
                    try {
                        this.wait(endTime - now);
                    }
                    catch (InterruptedException e) {
                        throw new ThreadInterrupted("Lock for " + PollableNode.this + " is unavailable", e);
                    }
                    now = System.currentTimeMillis();
                    if (now < endTime) continue;
                    throw new LockUnavailable("Unable to obtain lock for " + PollableNode.this + " before timeout");
                }
                this.m_owner = Thread.currentThread();
                log.debug((Object)("Obtained lock for " + PollableNode.this));
            }
            ++this.m_obtainCount;
        }

        public synchronized void release() {
            if (this.m_owner == Thread.currentThread()) {
                --this.m_obtainCount;
                if (this.m_obtainCount == 0) {
                    ThreadCategory.getInstance(this.getClass()).debug((Object)("Releasing lock for " + PollableNode.this));
                    this.m_owner = null;
                    this.notifyAll();
                }
            }
        }

        public synchronized boolean isLockAvailable() {
            return this.m_owner == null;
        }
    }
}

