/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.monitors;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NoRouteToHostException;
import java.net.Socket;
import java.util.Map;
import org.apache.log4j.Category;
import org.apache.log4j.Level;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.model.PollStatus;
import org.opennms.netmgt.poller.Distributable;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.NetworkInterface;
import org.opennms.netmgt.poller.NetworkInterfaceNotSupportedException;
import org.opennms.netmgt.poller.monitors.IPv4Monitor;
import org.opennms.netmgt.utils.ParameterMap;

@Distributable
public final class SshMonitor
extends IPv4Monitor {
    private static final int DEFAULT_PORT = -1;
    private static final int DEFAULT_RETRY = 0;
    private static final int DEFAULT_TIMEOUT = 3000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PollStatus poll(MonitoredService svc, Map parameters) {
        NetworkInterface iface = svc.getNetInterface();
        Category log = ThreadCategory.getInstance(this.getClass());
        if (iface.getType() != 1) {
            throw new NetworkInterfaceNotSupportedException("Unsupported interface type, only TYPE_IPV4 currently supported");
        }
        int retry = ParameterMap.getKeyedInteger(parameters, "retry", 0);
        int timeout = ParameterMap.getKeyedInteger(parameters, "timeout", 3000);
        int port = ParameterMap.getKeyedInteger(parameters, "port", -1);
        if (port == -1) {
            throw new RuntimeException("SshMonitor: required parameter 'port' is not present in supplied properties.");
        }
        String strBannerMatch = (String)parameters.get("banner");
        InetAddress ipv4Addr = (InetAddress)iface.getAddress();
        if (log.isDebugEnabled()) {
            log.debug((Object)("poll: address = " + ipv4Addr.getHostAddress() + ", port = " + port + ", timeout = " + timeout + ", retry = " + retry));
        }
        PollStatus serviceStatus = PollStatus.unavailable();
        long responseTime = -1L;
        for (int attempts = 0; attempts <= retry && !serviceStatus.isAvailable(); ++attempts) {
            Socket socket = null;
            try {
                long sentTime = System.currentTimeMillis();
                socket = new Socket();
                socket.connect(new InetSocketAddress(ipv4Addr, port), timeout);
                socket.setSoTimeout(timeout);
                log.debug((Object)("SshMonitor: connected to host: " + ipv4Addr + " on port: " + port));
                serviceStatus = PollStatus.unresponsive();
                if (strBannerMatch == null || strBannerMatch.equals("*")) {
                    serviceStatus = PollStatus.available((double)(System.currentTimeMillis() - sentTime));
                    break;
                }
                BufferedReader rdr = new BufferedReader(new InputStreamReader(socket.getInputStream()));
                String response = rdr.readLine();
                responseTime = System.currentTimeMillis() - sentTime;
                if (response == null) continue;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("poll: banner = " + response));
                    log.debug((Object)("poll: responseTime= " + responseTime + "ms"));
                }
                if (response.indexOf(strBannerMatch) > -1) {
                    serviceStatus = PollStatus.available((double)responseTime);
                    String cmd = "SSH-1.99-OpenNMS_1.1\r\n";
                    socket.getOutputStream().write(cmd.getBytes());
                    response = null;
                    try {
                        response = rdr.readLine();
                    }
                    catch (IOException e) {}
                    continue;
                }
                serviceStatus = PollStatus.unavailable();
                continue;
            }
            catch (NoRouteToHostException e) {
                serviceStatus = this.logDown(Level.WARN, "No route to host exception for address " + ipv4Addr.getHostAddress(), e);
                break;
            }
            catch (InterruptedIOException e) {
                serviceStatus = this.logDown(Level.DEBUG, "did not connect to host within timeout: " + timeout + " attempt: " + attempts);
                continue;
            }
            catch (ConnectException e) {
                serviceStatus = this.logDown(Level.DEBUG, "Connection exception for address: " + ipv4Addr, e);
                continue;
            }
            catch (IOException e) {
                serviceStatus = this.logDown(Level.DEBUG, "IOException while polling address: " + ipv4Addr, e);
                continue;
            }
            finally {
                block39: {
                    try {
                        if (socket != null) {
                            socket.close();
                        }
                    }
                    catch (IOException e) {
                        e.fillInStackTrace();
                        if (!log.isDebugEnabled()) break block39;
                        log.debug((Object)"poll: Error closing socket.", (Throwable)e);
                    }
                }
            }
        }
        return serviceStatus;
    }
}

