/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.monitors;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NoRouteToHostException;
import java.net.Socket;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.log4j.Category;
import org.apache.log4j.Level;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.model.PollStatus;
import org.opennms.netmgt.poller.Distributable;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.NetworkInterface;
import org.opennms.netmgt.poller.NetworkInterfaceNotSupportedException;
import org.opennms.netmgt.poller.monitors.IPv4Monitor;
import org.opennms.netmgt.utils.ParameterMap;

@Distributable
public final class Pop3Monitor
extends IPv4Monitor {
    private static final int DEFAULT_PORT = 110;
    private static final int DEFAULT_RETRY = 0;
    private static final int DEFAULT_TIMEOUT = 3000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PollStatus poll(MonitoredService svc, Map parameters) {
        NetworkInterface iface = svc.getNetInterface();
        if (iface.getType() != 1) {
            throw new NetworkInterfaceNotSupportedException("Unsupported interface type, only TYPE_IPV4 currently supported");
        }
        Category log = ThreadCategory.getInstance(this.getClass());
        int retry = ParameterMap.getKeyedInteger(parameters, "retry", 0);
        int port = ParameterMap.getKeyedInteger(parameters, "port", 110);
        int timeout = ParameterMap.getKeyedInteger(parameters, "timeout", 3000) + 1;
        InetAddress ipv4Addr = (InetAddress)iface.getAddress();
        if (log.isDebugEnabled()) {
            log.debug((Object)("poll: address = " + ipv4Addr + ", port = " + port + ", timeout = " + timeout + ", retry = " + retry));
        }
        PollStatus serviceStatus = PollStatus.unavailable();
        long responseTime = -1L;
        for (int attempts = 0; attempts <= retry && !serviceStatus.isAvailable(); ++attempts) {
            Socket socket = null;
            try {
                long sentTime = System.currentTimeMillis();
                socket = new Socket();
                socket.connect(new InetSocketAddress(ipv4Addr, port), timeout);
                socket.setSoTimeout(timeout);
                log.debug((Object)("Pop3Monitor: connected to host: " + ipv4Addr + " on port: " + port));
                serviceStatus = PollStatus.unresponsive();
                BufferedReader rdr = new BufferedReader(new InputStreamReader(socket.getInputStream()));
                String banner = rdr.readLine();
                responseTime = System.currentTimeMillis() - sentTime;
                if (banner == null) continue;
                StringTokenizer t = new StringTokenizer(banner);
                if (t.nextToken().equals("+OK")) {
                    String cmd = "QUIT\r\n";
                    socket.getOutputStream().write(cmd.getBytes());
                    t = new StringTokenizer(rdr.readLine());
                    if (t.nextToken().equals("+OK")) {
                        serviceStatus = PollStatus.available((double)responseTime);
                    }
                }
                if (serviceStatus.isAvailable()) continue;
                serviceStatus = PollStatus.unavailable();
                continue;
            }
            catch (NoRouteToHostException e) {
                serviceStatus = this.logDown(Level.WARN, "No route to host exception for address " + ipv4Addr.getHostAddress(), e);
                break;
            }
            catch (InterruptedIOException e) {
                serviceStatus = this.logDown(Level.DEBUG, "did not connect to host within timeout: " + timeout + " attempt: " + attempts);
                continue;
            }
            catch (ConnectException e) {
                serviceStatus = this.logDown(Level.DEBUG, "Connection exception for address " + ipv4Addr.getHostAddress(), e);
                continue;
            }
            catch (IOException e) {
                serviceStatus = this.logDown(Level.DEBUG, "IOException while polling address " + ipv4Addr.getHostAddress(), e);
                continue;
            }
            finally {
                block32: {
                    try {
                        if (socket != null) {
                            socket.close();
                        }
                    }
                    catch (IOException e) {
                        if (!log.isDebugEnabled()) break block32;
                        log.debug((Object)"poll: Error closing socket.", (Throwable)e);
                    }
                }
            }
        }
        return serviceStatus;
    }
}

