/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.monitors;

import java.net.InetAddress;
import java.util.Map;
import org.apache.log4j.Category;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.model.PollStatus;
import org.opennms.netmgt.poller.Distributable;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.NetworkInterface;
import org.opennms.netmgt.poller.NetworkInterfaceNotSupportedException;
import org.opennms.netmgt.poller.monitors.IPv4Monitor;
import org.opennms.netmgt.poller.nsclient.NsclientCheckParams;
import org.opennms.netmgt.poller.nsclient.NsclientException;
import org.opennms.netmgt.poller.nsclient.NsclientManager;
import org.opennms.netmgt.poller.nsclient.NsclientPacket;
import org.opennms.netmgt.utils.ParameterMap;

@Distributable
public class NsclientMonitor
extends IPv4Monitor {
    private static final int DEFAULT_RETRY = 0;
    private static final int DEFAULT_TIMEOUT = 3000;

    public PollStatus poll(MonitoredService svc, Map parameters) {
        String reason = null;
        int serviceStatus = 3;
        NsclientPacket response = null;
        long responseTime = -1L;
        NetworkInterface iface = svc.getNetInterface();
        Category log = ThreadCategory.getInstance(this.getClass());
        if (iface.getType() != 1) {
            throw new NetworkInterfaceNotSupportedException("Unsupported interface type, only TYPE_IPV4 currently supported");
        }
        String command = ParameterMap.getKeyedString(parameters, "command", NsclientManager.convertTypeToString("1"));
        int port = ParameterMap.getKeyedInteger(parameters, "port", NsclientManager.DEFAULT_PORT);
        String password = ParameterMap.getKeyedString(parameters, "password", "None");
        String params = ParameterMap.getKeyedString(parameters, "parameter", null);
        int critPerc = ParameterMap.getKeyedInteger(parameters, "criticalPercent", 0);
        int warnPerc = ParameterMap.getKeyedInteger(parameters, "warningPercent", 0);
        int retry = ParameterMap.getKeyedInteger(parameters, "retry", 0);
        int timeout = ParameterMap.getKeyedInteger(parameters, "timeout", 3000);
        InetAddress ipv4Addr = (InetAddress)iface.getAddress();
        for (int attempts = 0; attempts <= retry && serviceStatus != 1; ++attempts) {
            try {
                long sentTime = System.currentTimeMillis();
                NsclientManager client = new NsclientManager(ipv4Addr.getHostAddress(), port, password);
                client.setTimeout(timeout);
                client.setPassword(password);
                client.init();
                NsclientCheckParams clientParams = new NsclientCheckParams(critPerc, warnPerc, params);
                response = client.processCheckCommand(NsclientManager.convertStringToType(command), clientParams);
                responseTime = System.currentTimeMillis() - sentTime;
                if (response == null) continue;
                if (response.getResultCode() == 0) {
                    serviceStatus = 1;
                    reason = response.getResponse();
                    continue;
                }
                if (response.getResultCode() != 2) continue;
                serviceStatus = 2;
                reason = response.getResponse();
                continue;
            }
            catch (NsclientException e) {
                log.debug((Object)("Nsclient Poller received exception from client: " + e.getMessage()));
                reason = "NsclientException: " + e.getMessage();
            }
        }
        return PollStatus.get((int)serviceStatus, reason, (double)responseTime);
    }
}

