/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.monitors;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NoRouteToHostException;
import java.net.Socket;
import java.util.Map;
import org.apache.log4j.Category;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.model.PollStatus;
import org.opennms.netmgt.poller.Distributable;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.NetworkInterface;
import org.opennms.netmgt.poller.NetworkInterfaceNotSupportedException;
import org.opennms.netmgt.poller.monitors.IPv4Monitor;
import org.opennms.netmgt.poller.nrpe.NrpeException;
import org.opennms.netmgt.poller.nrpe.NrpePacket;
import org.opennms.netmgt.utils.ParameterMap;

@Distributable
public final class NrpeMonitor
extends IPv4Monitor {
    private static final int DEFAULT_RETRY = 0;
    private static final int DEFAULT_TIMEOUT = 3000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PollStatus poll(MonitoredService svc, Map parameters) {
        NetworkInterface iface = svc.getNetInterface();
        String reason = null;
        Category log = ThreadCategory.getInstance(this.getClass());
        if (iface.getType() != 1) {
            throw new NetworkInterfaceNotSupportedException("Unsupported interface type, only TYPE_IPV4 currently supported");
        }
        String command = ParameterMap.getKeyedString(parameters, "command", "_NRPE_CHECK");
        int port = ParameterMap.getKeyedInteger(parameters, "port", 5666);
        int padding = ParameterMap.getKeyedInteger(parameters, "padding", 2);
        int retry = ParameterMap.getKeyedInteger(parameters, "retry", 0);
        int timeout = ParameterMap.getKeyedInteger(parameters, "timeout", 3000);
        InetAddress ipv4Addr = (InetAddress)iface.getAddress();
        if (log.isDebugEnabled()) {
            log.debug((Object)("poll: address = " + ipv4Addr.getHostAddress() + ", port = " + port + ", timeout = " + timeout + ", retry = " + retry));
        }
        int serviceStatus = 2;
        long responseTime = -1L;
        for (int attempts = 0; attempts <= retry && serviceStatus != 1; ++attempts) {
            Socket socket = null;
            try {
                long sentTime = System.currentTimeMillis();
                socket = new Socket();
                socket.connect(new InetSocketAddress(ipv4Addr, port), timeout);
                socket.setSoTimeout(timeout);
                log.debug((Object)("NrpeMonitor: connected to host: " + ipv4Addr + " on port: " + port));
                serviceStatus = 3;
                reason = "Connected, but no response received";
                NrpePacket p = new NrpePacket(1, 0, command);
                byte[] b = p.buildPacket(padding);
                OutputStream o = socket.getOutputStream();
                o.write(b);
                NrpePacket response = NrpePacket.receivePacket(socket.getInputStream(), padding);
                responseTime = System.currentTimeMillis() - sentTime;
                if (response.getResultCode() == 0) {
                    serviceStatus = 1;
                    continue;
                }
                serviceStatus = 2;
                reason = "NRPE command returned code " + response.getResultCode() + " and message: " + response.getBuffer();
                continue;
            }
            catch (NoRouteToHostException e) {
                reason = "No route to host exception for address " + ipv4Addr.getHostAddress();
                if (!log.isEnabledFor((Priority)Level.WARN)) break;
                e.fillInStackTrace();
                log.warn((Object)("poll: " + reason), (Throwable)e);
                break;
            }
            catch (InterruptedIOException e) {
                reason = "did not connect to host within timeout: " + timeout + " attempt: " + attempts;
                log.debug((Object)("NrpeMonitor: did not connect to host within timeout: " + timeout + " attempt: " + attempts));
                continue;
            }
            catch (ConnectException e) {
                reason = "Connection exception for address: " + ipv4Addr;
                if (!log.isDebugEnabled()) continue;
                e.fillInStackTrace();
                log.debug((Object)("poll: " + reason), (Throwable)e);
                continue;
            }
            catch (NrpeException e) {
                reason = "NrpeException while polling address: " + ipv4Addr;
                if (!log.isDebugEnabled()) continue;
                e.fillInStackTrace();
                log.debug((Object)("poll: " + reason), (Throwable)e);
                continue;
            }
            catch (IOException e) {
                reason = "IOException while polling address: " + ipv4Addr;
                if (!log.isDebugEnabled()) continue;
                e.fillInStackTrace();
                log.debug((Object)("poll: " + reason), (Throwable)e);
                continue;
            }
            finally {
                block32: {
                    try {
                        if (socket != null) {
                            socket.close();
                        }
                    }
                    catch (IOException e) {
                        if (!log.isDebugEnabled()) break block32;
                        e.fillInStackTrace();
                        log.debug((Object)"poll: Error closing socket.", (Throwable)e);
                    }
                }
            }
        }
        return PollStatus.get((int)serviceStatus, reason, (double)responseTime);
    }
}

