/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.monitors;

import java.net.InetAddress;
import java.util.Map;
import org.apache.log4j.Level;
import org.opennms.netmgt.model.PollStatus;
import org.opennms.netmgt.poller.Distributable;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.NetworkInterface;
import org.opennms.netmgt.poller.monitors.IPv4Monitor;
import org.opennms.netmgt.utils.ParameterMap;
import org.opennms.protocols.jmx.connectors.ConnectionWrapper;

@Distributable
public abstract class JMXMonitor
extends IPv4Monitor {
    public abstract ConnectionWrapper getMBeanServerConnection(Map var1, InetAddress var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PollStatus poll(MonitoredService svc, Map map) {
        PollStatus serviceStatus;
        block9: {
            NetworkInterface iface = svc.getNetInterface();
            serviceStatus = PollStatus.unavailable();
            String dsName = null;
            InetAddress ipv4Addr = (InetAddress)iface.getAddress();
            ConnectionWrapper connection = null;
            try {
                int retry = ParameterMap.getKeyedInteger(map, "retry", 3);
                long t0 = 0L;
                int attempts = 0;
                if (attempts > retry || serviceStatus.isAvailable()) break block9;
                try {
                    t0 = System.currentTimeMillis();
                    connection = this.getMBeanServerConnection(map, ipv4Addr);
                    if (connection != null) {
                        connection.getMBeanServer().getMBeanCount();
                        long responseTime = System.currentTimeMillis() - t0;
                        serviceStatus = PollStatus.available((double)responseTime);
                    }
                }
                catch (Exception e) {
                    serviceStatus = this.logDown(Level.DEBUG, dsName + ": IOException while polling address: " + ipv4Addr);
                }
            }
            catch (Exception e) {
                serviceStatus = this.logDown(Level.DEBUG, dsName + " Monitor - failed! " + ipv4Addr.getHostAddress());
            }
            finally {
                if (connection != null) {
                    connection.close();
                }
            }
        }
        return serviceStatus;
    }
}

