/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.monitors;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NoRouteToHostException;
import java.net.Socket;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.log4j.Category;
import org.apache.log4j.Level;
import org.apache.regexp.RE;
import org.apache.regexp.RESyntaxException;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.model.PollStatus;
import org.opennms.netmgt.poller.Distributable;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.NetworkInterface;
import org.opennms.netmgt.poller.NetworkInterfaceNotSupportedException;
import org.opennms.netmgt.poller.monitors.IPv4Monitor;
import org.opennms.netmgt.utils.ParameterMap;

@Distributable
public final class FtpMonitor
extends IPv4Monitor {
    private static final int DEFAULT_PORT = 21;
    private static final int DEFAULT_RETRY = 0;
    private static final int DEFAULT_TIMEOUT = 3000;
    private static final String FTP_ERROR_530_TEXT = "User not logged in. Please login with USER and PASS first";
    private static final String FTP_ERROR_530_TEXT2 = "Not logged in.";
    private static final String FTP_ERROR_425_TEXT = "425 Session is disconnected.";
    private static RE MULTILINE = null;
    private RE ENDMULTILINE = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PollStatus poll(MonitoredService svc, Map parameters) {
        NetworkInterface iface = svc.getNetInterface();
        if (iface.getType() != 1) {
            throw new NetworkInterfaceNotSupportedException("Unsupported interface type, only TYPE_IPV4 currently supported");
        }
        Category log = ThreadCategory.getInstance(this.getClass());
        int retry = ParameterMap.getKeyedInteger(parameters, "retry", 0);
        int port = ParameterMap.getKeyedInteger(parameters, "port", 21);
        int timeout = ParameterMap.getKeyedInteger(parameters, "timeout", 3000);
        String userid = ParameterMap.getKeyedString(parameters, "userid", null);
        String password = ParameterMap.getKeyedString(parameters, "password", null);
        InetAddress ipv4Addr = (InetAddress)iface.getAddress();
        if (log.isDebugEnabled()) {
            log.debug((Object)("FtpMonitor.poll: Polling interface: " + ipv4Addr.getHostAddress() + " timeout: " + timeout + " retry: " + retry));
        }
        PollStatus serviceStatus = PollStatus.unavailable();
        long responseTime = -1L;
        for (int attempts = 0; attempts <= retry && !serviceStatus.isAvailable(); ++attempts) {
            Socket socket = null;
            try {
                long sentTime = System.currentTimeMillis();
                socket = new Socket();
                socket.connect(new InetSocketAddress(ipv4Addr, port), timeout);
                socket.setSoTimeout(timeout);
                log.debug((Object)("FtpMonitor: connected to host: " + ipv4Addr + " on port: " + port));
                serviceStatus = PollStatus.unresponsive();
                BufferedReader lineRdr = new BufferedReader(new InputStreamReader(socket.getInputStream()));
                String banner = lineRdr.readLine();
                responseTime = System.currentTimeMillis() - sentTime;
                if (banner == null) continue;
                if (MULTILINE.match(banner)) {
                    String multiLineRC = new String(banner.getBytes(), 0, 3) + " ";
                    try {
                        this.ENDMULTILINE = new RE(multiLineRC);
                    }
                    catch (RESyntaxException ex) {
                        throw new UndeclaredThrowableException(ex);
                    }
                    while ((banner = lineRdr.readLine()) != null && !this.ENDMULTILINE.match(banner)) {
                    }
                    if (banner == null) continue;
                }
                StringTokenizer t = new StringTokenizer(banner);
                int rc = -1;
                try {
                    rc = Integer.parseInt(t.nextToken());
                }
                catch (NumberFormatException nfE) {
                    nfE.fillInStackTrace();
                    log.warn((Object)"Banner page returned invalid result code", (Throwable)nfE);
                }
                if (rc >= 200 && rc <= 299) {
                    String multiLineRC;
                    String response;
                    String cmd;
                    boolean bLoginOk = false;
                    if (userid == null || userid.length() == 0 || password == null || password.length() == 0) {
                        bLoginOk = true;
                    } else {
                        cmd = "user " + userid + "\r\n";
                        socket.getOutputStream().write(cmd.getBytes());
                        response = null;
                        while ((response = lineRdr.readLine()) != null && MULTILINE.match(response)) {
                        }
                        if (response == null) continue;
                        t = new StringTokenizer(response);
                        rc = Integer.parseInt(t.nextToken());
                        if (rc >= 200 && rc <= 399) {
                            cmd = "pass " + password + "\r\n";
                            socket.getOutputStream().write(cmd.getBytes());
                            response = lineRdr.readLine();
                            if (response == null) continue;
                            if (MULTILINE.match(response)) {
                                multiLineRC = new String(response.getBytes(), 0, 3) + " ";
                                try {
                                    this.ENDMULTILINE = new RE(multiLineRC);
                                }
                                catch (RESyntaxException ex) {
                                    throw new UndeclaredThrowableException(ex);
                                }
                                while ((response = lineRdr.readLine()) != null && !this.ENDMULTILINE.match(response)) {
                                }
                                if (response == null) continue;
                            }
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("FtpMonitor.poll: tokenizing respone to check for return code: " + response));
                            }
                            if ((rc = Integer.parseInt((t = new StringTokenizer(response)).nextToken())) >= 200 && rc <= 299) {
                                if (log.isDebugEnabled()) {
                                    log.debug((Object)("FtpMonitor.poll: Login successful, parsed return code: " + rc));
                                }
                                bLoginOk = true;
                            } else {
                                if (log.isDebugEnabled()) {
                                    log.debug((Object)("FtpMonitor.poll: Login failed, parsed return code: " + rc));
                                }
                                bLoginOk = false;
                            }
                        }
                    }
                    if (bLoginOk) {
                        cmd = "QUIT\r\n";
                        socket.getOutputStream().write(cmd.getBytes());
                        response = lineRdr.readLine();
                        if (response == null) continue;
                        if (MULTILINE.match(response)) {
                            multiLineRC = new String(response.getBytes(), 0, 3) + " ";
                            try {
                                this.ENDMULTILINE = new RE(multiLineRC);
                            }
                            catch (RESyntaxException ex) {
                                throw new UndeclaredThrowableException(ex);
                            }
                            while ((response = lineRdr.readLine()) != null && !this.ENDMULTILINE.match(response)) {
                            }
                            if (response == null) continue;
                        }
                        if ((rc = Integer.parseInt((t = new StringTokenizer(response)).nextToken())) >= 200 && rc <= 299) {
                            serviceStatus = PollStatus.available((double)responseTime);
                        } else if (rc == 530 && response.indexOf(FTP_ERROR_530_TEXT) != -1 || response.indexOf(FTP_ERROR_530_TEXT2) != -1) {
                            serviceStatus = PollStatus.available((double)responseTime);
                        } else if (rc == 425 && response.indexOf(FTP_ERROR_425_TEXT) != -1) {
                            serviceStatus = PollStatus.available((double)responseTime);
                        }
                    }
                }
                if (serviceStatus.isAvailable()) continue;
                serviceStatus = PollStatus.unavailable();
                continue;
            }
            catch (NumberFormatException e) {
                serviceStatus = this.logDown(Level.DEBUG, "NumberFormatException while polling address: " + ipv4Addr, e);
                continue;
            }
            catch (NoRouteToHostException e) {
                serviceStatus = this.logDown(Level.WARN, "No route to host exception for address: " + ipv4Addr, e);
                break;
            }
            catch (InterruptedIOException e) {
                serviceStatus = this.logDown(Level.DEBUG, "did not connect to host within timeout: " + timeout + " attempt: " + attempts);
                continue;
            }
            catch (ConnectException e) {
                serviceStatus = this.logDown(Level.DEBUG, "Connection exception for address: " + ipv4Addr, e);
                continue;
            }
            catch (IOException e) {
                serviceStatus = this.logDown(Level.DEBUG, "IOException while polling address: " + ipv4Addr, e);
                continue;
            }
            finally {
                try {
                    if (socket != null) {
                        socket.close();
                    }
                }
                catch (IOException e) {
                    e.fillInStackTrace();
                    log.debug((Object)"FtpMonitor.poll: Error closing socket.", (Throwable)e);
                }
            }
        }
        return serviceStatus;
    }

    static {
        try {
            MULTILINE = new RE("^[0-9]{3}-");
        }
        catch (RESyntaxException ex) {
            throw new UndeclaredThrowableException(ex);
        }
    }
}

