/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.monitors;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NoRouteToHostException;
import java.net.Socket;
import java.net.URL;
import java.util.Map;
import org.apache.log4j.Category;
import org.apache.log4j.Level;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.model.PollStatus;
import org.opennms.netmgt.poller.Distributable;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.NetworkInterface;
import org.opennms.netmgt.poller.NetworkInterfaceNotSupportedException;
import org.opennms.netmgt.poller.monitors.IPv4Monitor;
import org.opennms.netmgt.utils.ParameterMap;

@Distributable
public final class DominoIIOPMonitor
extends IPv4Monitor {
    private static final int DEFAULT_PORT = 63148;
    private static final int DEFAULT_IORPORT = 80;
    private static final int DEFAULT_RETRY = 3;
    private static final int DEFAULT_TIMEOUT = 3000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PollStatus poll(MonitoredService svc, Map parameters) {
        NetworkInterface iface = svc.getNetInterface();
        Category log = ThreadCategory.getInstance(this.getClass());
        if (iface.getType() != 1) {
            throw new NetworkInterfaceNotSupportedException("Unsupported interface type, only TYPE_IPV4 currently supported");
        }
        int retry = ParameterMap.getKeyedInteger(parameters, "retry", 3);
        int timeout = ParameterMap.getKeyedInteger(parameters, "timeout", 3000);
        int IORport = ParameterMap.getKeyedInteger(parameters, "ior-port", 80);
        int port = ParameterMap.getKeyedInteger(parameters, "port", 63148);
        InetAddress ipv4Addr = (InetAddress)iface.getAddress();
        if (log.isDebugEnabled()) {
            log.debug((Object)("poll: address = " + ipv4Addr.getHostAddress() + ", port = " + port + ", timeout = " + timeout + ", retry = " + retry));
        }
        try {
            this.retrieveIORText(ipv4Addr.getHostAddress(), IORport);
        }
        catch (Exception e) {
            return this.logDown(Level.DEBUG, "failed to get the corba IOR from " + ipv4Addr, e);
        }
        String failureReason = null;
        for (int attempts = 0; attempts <= retry; ++attempts) {
            Socket socket = null;
            try {
                long startTime = System.currentTimeMillis();
                socket = new Socket();
                socket.connect(new InetSocketAddress(ipv4Addr, port), timeout);
                socket.setSoTimeout(timeout);
                long endTime = System.currentTimeMillis();
                log.debug((Object)("DominoIIOPMonitor: connected to host: " + ipv4Addr + " on port: " + port));
                PollStatus pollStatus = PollStatus.up((double)(endTime - startTime));
                return pollStatus;
            }
            catch (NoRouteToHostException e) {
                e.fillInStackTrace();
                log.warn((Object)("DominoIIOPMonitor: No route to host exception for address " + ipv4Addr.getHostAddress()), (Throwable)e);
                PollStatus pollStatus = PollStatus.unavailable((String)("No route to host exception for address " + ipv4Addr.getHostAddress()));
                return pollStatus;
            }
            catch (InterruptedIOException e) {
                failureReason = "did not connect to host within timeout: " + timeout + " attempt: " + attempts;
                log.debug((Object)("DominoIIOPMonitor: " + failureReason));
                continue;
            }
            catch (ConnectException e) {
                e.fillInStackTrace();
                failureReason = "Connection exception for address: " + ipv4Addr + " : " + e.getMessage();
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("DominoIIOPMonitor: " + failureReason), (Throwable)e);
                continue;
            }
            catch (IOException e) {
                e.fillInStackTrace();
                failureReason = "IOException while polling address: " + ipv4Addr + " : " + e.getMessage();
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("DominoIIOPMonitor: " + failureReason), (Throwable)e);
                continue;
            }
            finally {
                block29: {
                    try {
                        if (socket != null) {
                            socket.close();
                        }
                    }
                    catch (IOException e) {
                        e.fillInStackTrace();
                        if (!log.isDebugEnabled()) break block29;
                        log.debug((Object)"DominoIIOPMonitor: Error closing socket.", (Throwable)e);
                    }
                }
            }
        }
        return PollStatus.unavailable(failureReason);
    }

    private String retrieveIORText(String host, int port) throws IOException {
        String IOR = "";
        URL u = new URL("http://" + host + ":" + port + "/diiop_ior.txt");
        InputStream is = u.openStream();
        BufferedReader dis = new BufferedReader(new InputStreamReader(is));
        boolean done = false;
        while (!done) {
            String line = dis.readLine();
            if (line == null) {
                done = true;
                continue;
            }
            if (!(IOR = IOR + line).startsWith("IOR:")) continue;
            done = true;
        }
        dis.close();
        if (!IOR.startsWith("IOR:")) {
            throw new IOException("Invalid IOR: " + IOR);
        }
        return IOR;
    }
}

