/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.monitors;

import java.io.IOException;
import java.net.InetAddress;
import java.util.Map;
import org.apache.log4j.Category;
import org.apache.log4j.Level;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.dhcpd.Dhcpd;
import org.opennms.netmgt.model.PollStatus;
import org.opennms.netmgt.poller.Distributable;
import org.opennms.netmgt.poller.DistributionContext;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.NetworkInterface;
import org.opennms.netmgt.poller.NetworkInterfaceNotSupportedException;
import org.opennms.netmgt.poller.monitors.IPv4Monitor;
import org.opennms.netmgt.utils.ParameterMap;

@Distributable(value={DistributionContext.DAEMON})
public final class DhcpMonitor
extends IPv4Monitor {
    private static final int DEFAULT_RETRY = 0;
    private static final int DEFAULT_TIMEOUT = 3000;

    public PollStatus poll(MonitoredService svc, Map parameters) {
        NetworkInterface iface = svc.getNetInterface();
        if (iface.getType() != 1) {
            throw new NetworkInterfaceNotSupportedException("Unsupported interface type, only TYPE_IPV4 currently supported");
        }
        Category log = ThreadCategory.getInstance(this.getClass());
        int retry = ParameterMap.getKeyedInteger(parameters, "retry", 0);
        int timeout = ParameterMap.getKeyedInteger(parameters, "timeout", 3000);
        InetAddress ipv4Addr = (InetAddress)iface.getAddress();
        if (log.isDebugEnabled()) {
            log.debug((Object)("DhcpMonitor.poll: address: " + ipv4Addr + " timeout: " + timeout + " retry: " + retry));
        }
        PollStatus serviceStatus = PollStatus.unavailable();
        long responseTime = -1L;
        try {
            responseTime = Dhcpd.isServer(ipv4Addr, timeout, retry);
            if (responseTime >= 0L) {
                serviceStatus = PollStatus.available((double)responseTime);
            }
        }
        catch (IOException ioE) {
            ioE.fillInStackTrace();
            serviceStatus = this.logDown(Level.WARN, "An I/O exception occured during DHCP discovery", ioE);
        }
        return serviceStatus;
    }
}

