/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.monitors;

import java.io.IOException;
import java.util.Map;
import org.opennms.netmgt.model.PollStatus;
import org.opennms.netmgt.poller.Distributable;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.monitors.IPv4Monitor;
import org.opennms.netmgt.utils.ParameterMap;

@Distributable
public class AvailabilityMonitor
extends IPv4Monitor {
    private static final int DEFAULT_RETRY = 3;
    private static final int DEFAULT_TIMEOUT = 3000;

    public void initialize(Map parameters) {
    }

    public void initialize(MonitoredService svc) {
    }

    public PollStatus poll(MonitoredService svc, Map parameters) {
        int serviceStatus = 2;
        long responseTime = -1L;
        String reason = null;
        int retries = ParameterMap.getKeyedInteger(parameters, "retry", 3);
        boolean reachable = false;
        try {
            for (int i = 0; i < retries; ++i) {
                long begin = System.currentTimeMillis();
                reachable = svc.getAddress().isReachable(ParameterMap.getKeyedInteger(parameters, "timeout", 3000));
                long end = System.currentTimeMillis();
                if (!reachable) continue;
                responseTime = end - begin;
                break;
            }
            reason = reachable ? null : "Unreachable";
            serviceStatus = reachable ? 1 : 2;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return PollStatus.get((int)serviceStatus, (String)reason, (double)responseTime);
    }

    public void release() {
    }

    public void release(MonitoredService svc) {
    }
}

