/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.notifd;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.log4j.Category;
import org.opennms.core.utils.Argument;
import org.opennms.core.utils.MatchTable;
import org.opennms.core.utils.PropertiesUtils;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.config.DataSourceFactory;
import org.opennms.netmgt.notifd.NotificationStrategy;
import org.springframework.jdbc.core.JdbcTemplate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpNotificationStrategy
implements NotificationStrategy {
    private List<Argument> m_arguments;

    @Override
    public int send(List<Argument> arguments) {
        this.m_arguments = arguments;
        String url = this.getUrl();
        if (url == null) {
            this.log().warn((Object)"send: url argument is null, HttpNotification requires a URL");
            return 1;
        }
        HttpClient client = new HttpClient();
        GetMethod method = null;
        NameValuePair[] posts = this.getPosts();
        if (posts == null) {
            method = new GetMethod(url);
            this.log().info((Object)("send: No \"post-\" arguments..., continuing with an HTTP GET using URL: " + url));
        } else {
            this.log().info((Object)("send: Found \"post-\" arguments..., continuing with an HTTP POST using URL: " + url));
            for (Argument arg : this.m_arguments) {
                this.log().debug((Object)("send: post argument: " + arg.getSwitch() + " = " + arg.getValue()));
            }
            method = new PostMethod(url);
            ((PostMethod)method).addParameters(posts);
        }
        String contents = null;
        int statusCode = -1;
        try {
            statusCode = client.executeMethod((HttpMethod)method);
            contents = method.getResponseBodyAsString();
            this.log().info((Object)("send: Contents is: " + contents));
        }
        catch (HttpException e) {
            this.log().error((Object)("send: problem with HTTP post: " + (Object)((Object)e)));
            throw new RuntimeException("Problem with HTTP post: " + e.getMessage());
        }
        catch (IOException e) {
            this.log().error((Object)("send: IO problem with HTTP post/response: " + e));
            throw new RuntimeException("Problem with HTTP post: " + e.getMessage());
        }
        finally {
            method.releaseConnection();
        }
        this.doSql(contents);
        return statusCode;
    }

    private void doSql(String contents) {
        String sql = this.getSql();
        if (sql == null) {
            this.log().info((Object)"send: sql argument is null.");
        } else {
            this.log().info((Object)("send: compiling expression: " + this.getSwitchValue("result-match")));
            Pattern p = Pattern.compile(this.getSwitchValue("result-match"));
            Matcher m = p.matcher(contents);
            if (m.matches()) {
                this.log().info((Object)("send: compiled expression ready to run sql: " + sql));
                MatchTable matches = new MatchTable(m);
                String sqlString = PropertiesUtils.substitute((String)sql, (PropertiesUtils.SymbolTable)matches);
                this.log().info((Object)("send: running sql: " + sqlString));
                JdbcTemplate template = new JdbcTemplate(DataSourceFactory.getInstance());
                template.execute(sqlString);
            } else {
                this.log().warn((Object)"send: result didn't match, not running sql");
            }
        }
    }

    private NameValuePair[] getPosts() {
        List<Argument> args = this.getArgsByPrefix("post-");
        NameValuePair[] posts = new NameValuePair[args.size()];
        int cnt = 0;
        for (Argument arg : args) {
            String argSwitch = arg.getSwitch().substring("post-".length());
            if (arg.getValue() == null) {
                arg.setValue("");
            }
            posts[cnt++] = new NameValuePair(argSwitch, arg.getValue().equals("-tm") ? this.getMessage() : arg.getValue());
        }
        return posts;
    }

    private String getMessage() {
        String message = "no notification text message defined for the \"-tm\" switch.";
        for (Argument arg : this.m_arguments) {
            if (!arg.getSwitch().equals("-tm")) continue;
            message = arg.getValue();
        }
        this.log().debug((Object)("getMessage: " + message));
        return message;
    }

    private List<Argument> getArgsByPrefix(String argPrefix) {
        ArrayList<Argument> args = new ArrayList<Argument>();
        for (Argument arg : this.m_arguments) {
            if (!arg.getSwitch().startsWith(argPrefix)) continue;
            args.add(arg);
        }
        return args;
    }

    private String getSql() {
        return this.getSwitchValue("sql");
    }

    private String getUrl() {
        return this.getSwitchValue("url");
    }

    private String getSwitchValue(String argSwitch) {
        String value = null;
        for (Argument arg : this.m_arguments) {
            if (!arg.getSwitch().equals(argSwitch)) continue;
            value = arg.getValue();
        }
        if (value != null && value.equals("")) {
            value = null;
        }
        return value;
    }

    private Category log() {
        return ThreadCategory.getInstance(this.getClass());
    }
}

