/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.linkd;

import java.net.InetAddress;
import org.apache.log4j.Category;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.linkd.snmp.Dot1dBaseGroup;
import org.opennms.netmgt.linkd.snmp.Dot1dBasePortTable;
import org.opennms.netmgt.linkd.snmp.Dot1dStpGroup;
import org.opennms.netmgt.linkd.snmp.Dot1dStpPortTable;
import org.opennms.netmgt.linkd.snmp.Dot1dTpFdbTable;
import org.opennms.netmgt.linkd.snmp.QBridgeDot1dTpFdbTable;
import org.opennms.netmgt.scheduler.ReadyRunnable;
import org.opennms.netmgt.snmp.CollectionTracker;
import org.opennms.netmgt.snmp.SnmpAgentConfig;
import org.opennms.netmgt.snmp.SnmpUtils;
import org.opennms.netmgt.snmp.SnmpWalker;

final class SnmpVlanCollection
implements ReadyRunnable {
    private SnmpAgentConfig m_agentConfig;
    private final InetAddress m_address;
    public Dot1dBaseGroup m_dot1dbase;
    public Dot1dBasePortTable m_dot1dbaseTable;
    public Dot1dStpGroup m_dot1dstp;
    public Dot1dStpPortTable m_dot1dstptable;
    public Dot1dTpFdbTable m_dot1dtpFdbtable;
    public QBridgeDot1dTpFdbTable m_qdot1dtpFdbtable;
    public boolean collectStpNode = true;
    public boolean collectStpInterface = true;
    public boolean collectBridgeForwardingTable = true;

    SnmpVlanCollection(SnmpAgentConfig agentConfig) {
        this.m_agentConfig = agentConfig;
        this.m_address = this.m_agentConfig.getAddress();
        this.m_dot1dbase = null;
        this.m_dot1dbaseTable = null;
        this.m_dot1dstp = null;
        this.m_dot1dstptable = null;
        this.m_dot1dtpFdbtable = null;
    }

    SnmpVlanCollection(SnmpAgentConfig agentConfig, boolean collectStpNode, boolean collectStpTable, boolean collectBridgeForwardingTable) {
        this.m_agentConfig = agentConfig;
        this.m_address = this.m_agentConfig.getAddress();
        this.m_dot1dbase = null;
        this.m_dot1dbaseTable = null;
        this.m_dot1dstp = null;
        this.m_dot1dstptable = null;
        this.m_dot1dtpFdbtable = null;
        this.collectStpNode = collectStpNode;
        this.collectStpInterface = collectStpTable;
        this.collectBridgeForwardingTable = collectBridgeForwardingTable;
    }

    boolean failed() {
        return !this.hasDot1dBase() && !this.hasDot1dBasePortTable() && !this.hasDot1dStp() && !this.hasDot1dStpPortTable() && !this.hasDot1dTpFdbTable();
    }

    boolean someCollectionFailed() {
        return !this.hasDot1dBase() || !this.hasDot1dBasePortTable() || !this.hasDot1dStp() || !this.hasDot1dStpPortTable() || !this.hasDot1dTpFdbTable();
    }

    boolean hasDot1dBase() {
        return this.m_dot1dbase != null && !this.m_dot1dbase.failed();
    }

    Dot1dBaseGroup getDot1dBase() {
        return this.m_dot1dbase;
    }

    boolean hasDot1dBasePortTable() {
        return this.m_dot1dbaseTable != null && !this.m_dot1dbaseTable.failed();
    }

    Dot1dBasePortTable getDot1dBasePortTable() {
        return this.m_dot1dbaseTable;
    }

    boolean hasDot1dStp() {
        return this.m_dot1dstp != null && !this.m_dot1dstp.failed();
    }

    Dot1dStpGroup getDot1dStp() {
        return this.m_dot1dstp;
    }

    boolean hasDot1dStpPortTable() {
        return this.m_dot1dstptable != null && !this.m_dot1dstptable.failed();
    }

    Dot1dStpPortTable getDot1dStpPortTable() {
        return this.m_dot1dstptable;
    }

    boolean hasDot1dTpFdbTable() {
        return this.m_dot1dtpFdbtable != null && !this.m_dot1dtpFdbtable.failed();
    }

    Dot1dTpFdbTable getDot1dFdbTable() {
        return this.m_dot1dtpFdbtable;
    }

    boolean hasQBridgeDot1dTpFdbTable() {
        return this.m_qdot1dtpFdbtable != null && !this.m_qdot1dtpFdbtable.failed();
    }

    QBridgeDot1dTpFdbTable getQBridgeDot1dFdbTable() {
        return this.m_qdot1dtpFdbtable;
    }

    InetAddress getTarget() {
        return this.m_address;
    }

    public void run() {
        Category log = ThreadCategory.getInstance(this.getClass());
        this.m_dot1dbase = new Dot1dBaseGroup(this.m_address);
        this.m_dot1dbaseTable = new Dot1dBasePortTable(this.m_address);
        this.m_dot1dstp = new Dot1dStpGroup(this.m_address);
        this.m_dot1dstptable = new Dot1dStpPortTable(this.m_address);
        this.m_dot1dtpFdbtable = new Dot1dTpFdbTable(this.m_address);
        SnmpWalker walker = null;
        if (this.collectBridgeForwardingTable && this.collectStpInterface && this.collectStpNode) {
            walker = SnmpUtils.createWalker((SnmpAgentConfig)this.m_agentConfig, (String)"dot1dBase/dot1dBaseTable/dot1dStp/dot1dStpTable/dot1dTpFdbTable ", (CollectionTracker[])new CollectionTracker[]{this.m_dot1dbase, this.m_dot1dbaseTable, this.m_dot1dstp, this.m_dot1dstptable, this.m_dot1dtpFdbtable});
        } else if (this.collectBridgeForwardingTable && this.collectStpInterface) {
            walker = SnmpUtils.createWalker((SnmpAgentConfig)this.m_agentConfig, (String)"dot1dBase/dot1dBaseTable/dot1dStp/dot1dStpTable/dot1dTpFdbTable ", (CollectionTracker[])new CollectionTracker[]{this.m_dot1dbase, this.m_dot1dbaseTable, this.m_dot1dstp, this.m_dot1dstptable, this.m_dot1dtpFdbtable});
        } else if (this.collectBridgeForwardingTable && this.collectStpInterface) {
            walker = SnmpUtils.createWalker((SnmpAgentConfig)this.m_agentConfig, (String)"dot1dBaseTable/dot1dStpTable/dot1dTpFdbTable ", (CollectionTracker[])new CollectionTracker[]{this.m_dot1dbaseTable, this.m_dot1dstptable, this.m_dot1dtpFdbtable});
        } else if (this.collectBridgeForwardingTable && this.collectStpNode) {
            walker = SnmpUtils.createWalker((SnmpAgentConfig)this.m_agentConfig, (String)"dot1dBase/dot1dStp/dot1dTpFdbTable ", (CollectionTracker[])new CollectionTracker[]{this.m_dot1dbase, this.m_dot1dstp, this.m_dot1dtpFdbtable});
        } else if (this.collectBridgeForwardingTable) {
            walker = SnmpUtils.createWalker((SnmpAgentConfig)this.m_agentConfig, (String)"dot1dTpFdbTable ", (CollectionTracker[])new CollectionTracker[]{this.m_dot1dtpFdbtable});
        } else if (this.collectStpNode) {
            walker = SnmpUtils.createWalker((SnmpAgentConfig)this.m_agentConfig, (String)"dot1dBase/dot1dStp ", (CollectionTracker[])new CollectionTracker[]{this.m_dot1dbase, this.m_dot1dstp});
        } else if (this.collectStpInterface) {
            walker = SnmpUtils.createWalker((SnmpAgentConfig)this.m_agentConfig, (String)"dot1dBaseTable/dot1dStpTable ", (CollectionTracker[])new CollectionTracker[]{this.m_dot1dbaseTable, this.m_dot1dstptable});
        } else {
            if (log.isInfoEnabled()) {
                log.info((Object)"run: no info to collect return");
            }
            return;
        }
        walker.start();
        try {
            walker.waitFor(300000L);
        }
        catch (InterruptedException e) {
            this.m_dot1dbase = null;
            this.m_dot1dbaseTable = null;
            this.m_dot1dstp = null;
            this.m_dot1dstptable = null;
            this.m_dot1dtpFdbtable = null;
            log.warn((Object)"SnmpVlanCollection.run: collection interrupted, exiting", (Throwable)e);
            return;
        }
        if (!this.hasDot1dBase()) {
            log.info((Object)("run: failed to collect Dot1dBase for " + this.m_address.getHostAddress() + " Community: " + this.m_agentConfig.getReadCommunity()));
        }
        if (!this.hasDot1dBasePortTable()) {
            log.info((Object)("run: failed to collect Dot1dBasePortTable for " + this.m_address.getHostAddress() + " Community: " + this.m_agentConfig.getReadCommunity()));
        }
        if (!this.hasDot1dStp()) {
            log.info((Object)("run: failed to collect Dot1dStp for " + this.m_address.getHostAddress() + " Community: " + this.m_agentConfig.getReadCommunity()));
        }
        if (!this.hasDot1dStpPortTable()) {
            log.info((Object)("run: failed to collect Dot1dStpPortTable for " + this.m_address.getHostAddress() + " Community: " + this.m_agentConfig.getReadCommunity()));
        }
        if (!this.hasDot1dTpFdbTable()) {
            log.info((Object)("run: failed to collect Dot1dTpFdbTable for " + this.m_address.getHostAddress() + " Community: " + this.m_agentConfig.getReadCommunity()));
        }
        if (this.m_dot1dtpFdbtable.getEntries().isEmpty() && this.collectBridgeForwardingTable) {
            log.info((Object)("run: Trying to collect QbridgeDot1dTpFdbTable for " + this.m_address.getHostAddress() + " Community: " + this.m_agentConfig.getReadCommunity()));
            this.m_qdot1dtpFdbtable = new QBridgeDot1dTpFdbTable(this.m_address);
            walker = SnmpUtils.createWalker((SnmpAgentConfig)this.m_agentConfig, (String)"qBridgedot1dTpFdbTable ", (CollectionTracker[])new CollectionTracker[]{this.m_qdot1dtpFdbtable});
            walker.start();
            try {
                walker.waitFor(300000L);
            }
            catch (InterruptedException e) {
                this.m_qdot1dtpFdbtable = null;
                log.warn((Object)"SnmpVlanCollection.run: collection interrupted", (Throwable)e);
            }
        }
        if (!this.hasQBridgeDot1dTpFdbTable()) {
            log.info((Object)("run: failed to collect QBridgeDot1dTpFdbTable for " + this.m_address.getHostAddress() + " Community: " + this.m_agentConfig.getReadCommunity()));
        }
    }

    public boolean isReady() {
        return true;
    }
}

