/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.linkd;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.opennms.netmgt.linkd.AtInterface;
import org.opennms.netmgt.linkd.BridgeStpInterface;
import org.opennms.netmgt.linkd.CdpInterface;
import org.opennms.netmgt.linkd.RouterInterface;
import org.opennms.netmgt.linkd.Vlan;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LinkableNode {
    int m_nodeId;
    String m_snmpprimaryaddr;
    String m_sysoid;
    List<CdpInterface> m_cdpinterfaces = new ArrayList<CdpInterface>();
    boolean m_hascdpinterfaces = false;
    List<RouterInterface> m_routeinterfaces = new ArrayList<RouterInterface>();
    boolean m_hasrouteinterfaces = false;
    List<AtInterface> m_atinterfaces = new ArrayList<AtInterface>();
    boolean m_hasatinterfaces = false;
    boolean isBridgeNode = false;
    List<Integer> backBoneBridgePorts = new ArrayList<Integer>();
    List<Vlan> vlans = new ArrayList<Vlan>();
    List<String> bridgeIdentifiers = new ArrayList<String>();
    HashMap<String, List<BridgeStpInterface>> BridgeStpInterfaces = new HashMap();
    HashMap<String, String> vlanBridgeIdentifier = new HashMap();
    HashMap<Integer, Set<String>> portMacs = new HashMap();
    HashMap<String, String> macsVlan = new HashMap();
    HashMap<String, String> vlanStpRoot = new HashMap();
    HashMap<Integer, Integer> bridgePortIfindex = new HashMap();

    private LinkableNode() {
        throw new UnsupportedOperationException("default constructor not supported");
    }

    public LinkableNode(int nodeId, String snmprimaryaddr, String sysoid) {
        this.m_nodeId = nodeId;
        this.m_snmpprimaryaddr = snmprimaryaddr;
        this.m_sysoid = sysoid;
    }

    public String toString() {
        StringBuffer str = new StringBuffer("Node Id = " + this.m_nodeId + "\n");
        str.append("Snmp Primary Ip Address = " + this.m_snmpprimaryaddr + "\n");
        return str.toString();
    }

    public int getNodeId() {
        return this.m_nodeId;
    }

    public String getSnmpPrimaryIpAddr() {
        return this.m_snmpprimaryaddr;
    }

    public List<CdpInterface> getCdpInterfaces() {
        return this.m_cdpinterfaces;
    }

    public void setCdpInterfaces(List<CdpInterface> m_cdpinterfaces) {
        if (m_cdpinterfaces == null || m_cdpinterfaces.isEmpty()) {
            return;
        }
        this.m_hascdpinterfaces = true;
        this.m_cdpinterfaces = m_cdpinterfaces;
    }

    public boolean hasCdpInterfaces() {
        return this.m_hascdpinterfaces;
    }

    public List<RouterInterface> getRouteInterfaces() {
        return this.m_routeinterfaces;
    }

    public void setRouteInterfaces(List<RouterInterface> m_routeinterfaces) {
        if (m_routeinterfaces == null || m_routeinterfaces.isEmpty()) {
            return;
        }
        this.m_hasrouteinterfaces = true;
        this.m_routeinterfaces = m_routeinterfaces;
    }

    public boolean hasAtInterfaces() {
        return this.m_hasatinterfaces;
    }

    public List<AtInterface> getAtInterfaces() {
        return this.m_atinterfaces;
    }

    public void setAtInterfaces(List<AtInterface> m_atinterfaces) {
        if (m_atinterfaces == null || m_atinterfaces.isEmpty()) {
            return;
        }
        this.m_hasatinterfaces = true;
        this.m_atinterfaces = m_atinterfaces;
    }

    public boolean hasRouteInterfaces() {
        return this.m_hasrouteinterfaces;
    }

    public boolean isBridgeNode() {
        return this.isBridgeNode;
    }

    List<Integer> getBackBoneBridgePorts() {
        return this.backBoneBridgePorts;
    }

    void setBackBoneBridgePorts(List<Integer> backBoneBridgePorts) {
        this.backBoneBridgePorts = backBoneBridgePorts;
    }

    boolean isBackBoneBridgePort(int bridgeport) {
        return this.backBoneBridgePorts.contains(new Integer(bridgeport));
    }

    void addBackBoneBridgePorts(int bridgeport) {
        if (this.backBoneBridgePorts.contains(new Integer(bridgeport))) {
            return;
        }
        this.backBoneBridgePorts.add(new Integer(bridgeport));
    }

    List<String> getBridgeIdentifiers() {
        return this.bridgeIdentifiers;
    }

    void setBridgeIdentifiers(List<String> bridgeIdentifiers) {
        if (bridgeIdentifiers == null || bridgeIdentifiers.isEmpty()) {
            return;
        }
        this.bridgeIdentifiers = bridgeIdentifiers;
        this.isBridgeNode = true;
    }

    void addBridgeIdentifier(String bridge, String vlan) {
        this.vlanBridgeIdentifier.put(vlan, bridge);
        if (this.bridgeIdentifiers.contains(bridge)) {
            return;
        }
        this.bridgeIdentifiers.add(bridge);
        this.isBridgeNode = true;
    }

    boolean isBridgeIdentifier(String bridge) {
        return this.bridgeIdentifiers.contains(bridge);
    }

    void addBridgeIdentifier(String bridge) {
        if (this.bridgeIdentifiers.contains(bridge)) {
            return;
        }
        this.bridgeIdentifiers.add(bridge);
        this.isBridgeNode = true;
    }

    String getBridgeIdentifier(String vlan) {
        return this.vlanBridgeIdentifier.get(vlan);
    }

    void addMacAddress(int bridgeport, String macAddress, String vlan) {
        Set<String> macs = new HashSet<String>();
        if (this.portMacs.containsKey(new Integer(bridgeport))) {
            macs = this.portMacs.get(new Integer(bridgeport));
        }
        macs.add(macAddress);
        this.portMacs.put(new Integer(bridgeport), macs);
        this.macsVlan.put(macAddress, vlan);
    }

    boolean hasMacAddress(String macAddress) {
        HashSet hashSet = new HashSet();
        for (Set<String> set : this.portMacs.values()) {
            if (!set.contains(macAddress)) continue;
            return true;
        }
        return false;
    }

    boolean hasMacAddresses() {
        return !this.portMacs.isEmpty();
    }

    String getVlan(String macAddress) {
        return this.macsVlan.get(macAddress);
    }

    Set<String> getMacAddressesOnBridgePort(int bridgeport) {
        return this.portMacs.get(new Integer(bridgeport));
    }

    boolean hasMacAddressesOnBridgePort(int bridgeport) {
        return this.portMacs.containsKey(new Integer(bridgeport)) && this.portMacs.get(new Integer(bridgeport)) != null;
    }

    List<Integer> getBridgePortsFromMac(String macAddress) {
        ArrayList<Integer> ports = new ArrayList<Integer>();
        for (Integer intePort : this.portMacs.keySet()) {
            Set<String> macs = this.portMacs.get(intePort);
            if (!macs.contains(macAddress)) continue;
            ports.add(intePort);
        }
        return ports;
    }

    int getIfindex(int bridgeport) {
        if (this.bridgePortIfindex.containsKey(new Integer(bridgeport))) {
            Integer ifindex = this.bridgePortIfindex.get(new Integer(bridgeport));
            return ifindex;
        }
        return -1;
    }

    int getBridgePort(int ifindex) {
        for (Integer curBridgePort : this.bridgePortIfindex.keySet()) {
            Integer curIfIndex = this.bridgePortIfindex.get(curBridgePort);
            if (curIfIndex != ifindex) continue;
            return curBridgePort;
        }
        return -1;
    }

    void setIfIndexBridgePort(Integer ifindex, Integer bridgeport) {
        if (ifindex == null) {
            throw new NullPointerException("ifindex is null");
        }
        if (bridgeport == null) {
            throw new NullPointerException("bridgeport is null");
        }
        this.bridgePortIfindex.put(bridgeport, ifindex);
    }

    HashMap getPortMacs() {
        return this.portMacs;
    }

    void setPortMacs(HashMap<Integer, Set<String>> portMacs) {
        this.portMacs = portMacs;
    }

    void setVlanStpRoot(String vlan, String stproot) {
        if (stproot != null) {
            this.vlanStpRoot.put(vlan, stproot);
        }
    }

    boolean hasStpRoot(String vlan) {
        return this.vlanStpRoot.containsKey(vlan);
    }

    String getStpRoot(String vlan) {
        if (this.vlanStpRoot.containsKey(vlan)) {
            return this.vlanStpRoot.get(vlan);
        }
        return null;
    }

    public HashMap getStpInterfaces() {
        return this.BridgeStpInterfaces;
    }

    public void setStpInterfaces(HashMap<String, List<BridgeStpInterface>> stpInterfaces) {
        this.BridgeStpInterfaces = stpInterfaces;
    }

    public void addStpInterface(BridgeStpInterface stpIface) {
        String vlanindex = stpIface.getVlan();
        List<BridgeStpInterface> stpifs = new ArrayList<BridgeStpInterface>();
        if (this.BridgeStpInterfaces.containsKey(vlanindex)) {
            stpifs = this.BridgeStpInterfaces.get(vlanindex);
        }
        stpifs.add(stpIface);
        this.BridgeStpInterfaces.put(vlanindex, stpifs);
    }

    public String getSysoid() {
        return this.m_sysoid;
    }

    public void setSysoid(String m_sysoid) {
        this.m_sysoid = m_sysoid;
    }

    public List<Vlan> getVlans() {
        return this.vlans;
    }

    public void setVlans(List<Vlan> vlans) {
        this.vlans = vlans;
    }
}

