/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.linkd;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Category;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.config.SnmpPeerFactory;
import org.opennms.netmgt.linkd.AtInterface;
import org.opennms.netmgt.linkd.BridgeStpInterface;
import org.opennms.netmgt.linkd.CdpInterface;
import org.opennms.netmgt.linkd.LinkableNode;
import org.opennms.netmgt.linkd.Linkd;
import org.opennms.netmgt.linkd.MacToNodeLink;
import org.opennms.netmgt.linkd.NodeToNodeLink;
import org.opennms.netmgt.linkd.RouterInterface;
import org.opennms.netmgt.linkd.Vlan;
import org.opennms.netmgt.linkd.scheduler.ReadyRunnable;
import org.opennms.netmgt.linkd.scheduler.Scheduler;
import org.opennms.netmgt.linkd.snmp.FdbTableGet;
import org.opennms.netmgt.snmp.SnmpAgentConfig;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DiscoveryLink
implements ReadyRunnable {
    private static final int SNMP_IF_TYPE_ETHERNET = 6;
    private static final int SNMP_IF_TYPE_PROP_VIRTUAL = 53;
    private static final int SNMP_IF_TYPE_L2_VLAN = 135;
    private static final int SNMP_IF_TYPE_L3_VLAN = 136;
    private String packageName;
    private HashMap<Integer, LinkableNode> activenode = new HashMap();
    private List<NodeToNodeLink> links = new ArrayList<NodeToNodeLink>();
    private List<MacToNodeLink> maclinks = new ArrayList<MacToNodeLink>();
    private HashMap<Integer, LinkableNode> bridgeNodes = new HashMap();
    private List<LinkableNode> routerNodes = new ArrayList<LinkableNode>();
    private List<LinkableNode> cdpNodes = new ArrayList<LinkableNode>();
    private List<LinkableNode> atNodes = new ArrayList<LinkableNode>();
    private List<String> macsParsed = new ArrayList<String>();
    private Map<String, List<AtInterface>> macToAtinterface = new HashMap<String, List<AtInterface>>();
    private boolean enableDownloadDiscovery = false;
    private boolean discoveryUsingRoutes = true;
    private boolean discoveryUsingCdp = true;
    private boolean discoveryUsingBridge = true;
    private boolean suspendCollection = false;
    private boolean isRunned = false;
    private Scheduler m_scheduler;
    private long snmp_poll_interval = 1800000L;
    private long discovery_interval = 300000L;
    private long initial_sleep_time = 600000L;

    private Category log() {
        return ThreadCategory.getInstance(this.getClass());
    }

    @Override
    public void run() {
        if (this.suspendCollection) {
            this.log().warn((Object)"DiscoveryLink.run: Suspended!");
        } else {
            int curNodeId;
            Collection<LinkableNode> all_snmplinknodes = Linkd.getInstance().getLinkableNodesOnPackage(this.getPackageName());
            if (this.log().isDebugEnabled()) {
                this.log().debug((Object)("run: LinkableNodes/package found: " + all_snmplinknodes.size() + "/" + this.getPackageName()));
                this.log().debug((Object)("run: discoveryUsingBridge/discoveryUsingCdp/discoveryUsingRoutes: " + this.discoveryUsingBridge + "/" + this.discoveryUsingCdp + "/" + this.discoveryUsingRoutes));
            }
            Iterator<LinkableNode> ite = all_snmplinknodes.iterator();
            while (ite.hasNext()) {
                LinkableNode curNode = ite.next();
                if (this.log().isDebugEnabled()) {
                    this.log().debug((Object)("run: Iterating on LinkableNode's found node: " + curNode.getNodeId()));
                }
                if (curNode == null) {
                    this.log().error((Object)("run: null linkable node found for iterator " + ite));
                    continue;
                }
                curNodeId = curNode.getNodeId();
                this.activenode.put(new Integer(curNodeId), curNode);
                if (curNode.isBridgeNode && this.discoveryUsingBridge) {
                    this.bridgeNodes.put(new Integer(curNodeId), curNode);
                }
                if (curNode.hasCdpInterfaces() && this.discoveryUsingCdp) {
                    this.cdpNodes.add(curNode);
                }
                if (curNode.hasRouteInterfaces() && this.discoveryUsingRoutes) {
                    this.routerNodes.add(curNode);
                }
                if (!curNode.hasAtInterfaces()) continue;
                this.atNodes.add(curNode);
            }
            if (this.enableDownloadDiscovery) {
                this.parseBridgeNodes();
                this.parseAtNodes();
            } else if (this.log().isInfoEnabled()) {
                this.log().info((Object)"run: skipping download further snmp data");
            }
            if (this.log().isDebugEnabled()) {
                this.log().debug((Object)"run: finding links among nodes using Cisco Discovery Protocol");
            }
            for (LinkableNode curNode : this.cdpNodes) {
                int curCdpNodeId = curNode.getNodeId();
                String curCdpIpAddr = curNode.getSnmpPrimaryIpAddr();
                if (this.log().isDebugEnabled()) {
                    this.log().debug((Object)("run: parsing nodeid " + curCdpNodeId + " ip address " + curCdpIpAddr + " with " + curNode.getCdpInterfaces().size() + " Cdp Interfaces. "));
                }
                for (CdpInterface cdpIface : curNode.getCdpInterfaces()) {
                    LinkableNode targetNode;
                    int cdpIfIndex = cdpIface.getCdpIfIndex();
                    if (cdpIfIndex < 0) {
                        this.log().warn((Object)("run: found not valid CDP IfIndex " + cdpIfIndex + " . Skipping"));
                        continue;
                    }
                    if (this.log().isDebugEnabled()) {
                        this.log().debug((Object)("run: found CDP ifindex " + cdpIfIndex));
                    }
                    InetAddress targetIpAddr = cdpIface.getCdpTargetIpAddr();
                    int targetCdpNodeId = cdpIface.getCdpTargetNodeId();
                    if (targetCdpNodeId == -1) {
                        this.log().warn((Object)("run: no node id found for ip address " + targetIpAddr.getHostAddress() + ". Skipping"));
                        continue;
                    }
                    if (this.log().isDebugEnabled()) {
                        this.log().debug((Object)("run: found nodeid/CDP target ipaddress: " + targetCdpNodeId + ":" + targetIpAddr));
                    }
                    if (this.log().isDebugEnabled()) {
                        this.log().debug((Object)("run: found CDP target nodeid " + targetCdpNodeId));
                    }
                    if (targetCdpNodeId == curCdpNodeId) {
                        if (!this.log().isDebugEnabled()) continue;
                        this.log().debug((Object)("run: node id found for ip address " + targetIpAddr.getHostAddress() + " is itself. Skipping"));
                        continue;
                    }
                    int cdpDestIfindex = cdpIface.getCdpTargetIfIndex();
                    if (cdpDestIfindex < 0) {
                        this.log().warn((Object)("run: found not valid CDP destination IfIndex " + cdpDestIfindex + " . Skipping"));
                        continue;
                    }
                    if (this.log().isDebugEnabled()) {
                        this.log().debug((Object)("run: found CDP target ifindex " + cdpDestIfindex));
                    }
                    if (this.log().isDebugEnabled()) {
                        this.log().debug((Object)("run: parsing CDP link: nodeid=" + curCdpNodeId + " ifindex=" + cdpIfIndex + " nodeparentid=" + targetCdpNodeId + " parentifindex=" + cdpDestIfindex));
                    }
                    boolean add = true;
                    if (curNode.isBridgeNode() && this.isBridgeNode(targetCdpNodeId)) {
                        targetNode = this.bridgeNodes.get(new Integer(targetCdpNodeId));
                        add = this.parseCdpLinkOn(curNode, cdpIfIndex, targetNode, cdpDestIfindex);
                    } else if (curNode.isBridgeNode) {
                        add = this.parseCdpLinkOn(curNode, cdpIfIndex, targetCdpNodeId);
                    } else if (this.isBridgeNode(targetCdpNodeId)) {
                        targetNode = this.bridgeNodes.get(new Integer(targetCdpNodeId));
                        add = this.parseCdpLinkOn(targetNode, cdpDestIfindex, curCdpNodeId);
                    }
                    if (add) {
                        if (this.log().isDebugEnabled()) {
                            this.log().debug((Object)"run: adding found CDP link ");
                        }
                        NodeToNodeLink lk = new NodeToNodeLink(targetCdpNodeId, cdpDestIfindex);
                        lk.setNodeparentid(curCdpNodeId);
                        lk.setParentifindex(cdpIfIndex);
                        this.addNodetoNodeLink(lk);
                        if (!this.log().isDebugEnabled()) continue;
                        this.log().debug((Object)("run: CDP link added: " + lk.toString()));
                        continue;
                    }
                    this.log().warn((Object)("run: link not added for CDP interface:" + cdpIface.toString()));
                }
            }
            if (this.log().isDebugEnabled()) {
                this.log().debug((Object)"run: try to found backbone ethernet links among bridge nodes using Spanning Tree Protocol");
            }
            for (LinkableNode curNode : this.bridgeNodes.values()) {
                curNodeId = curNode.getNodeId();
                String cupIpAddr = curNode.getSnmpPrimaryIpAddr();
                if (this.log().isDebugEnabled()) {
                    this.log().debug((Object)("run: parsing bridge nodeid " + curNodeId + " ip address " + cupIpAddr));
                }
                Iterator<Object> sub_ite = curNode.getStpInterfaces().entrySet().iterator();
                if (this.log().isDebugEnabled()) {
                    this.log().debug((Object)("run: parsing " + curNode.getStpInterfaces().size() + " Vlan. "));
                }
                while (sub_ite.hasNext()) {
                    Map.Entry me = (Map.Entry)sub_ite.next();
                    String vlan = (String)me.getKey();
                    String curBaseBridgeAddress = curNode.getBridgeIdentifier(vlan);
                    if (this.log().isDebugEnabled()) {
                        this.log().debug((Object)("run: found bridge identifier " + curBaseBridgeAddress));
                    }
                    String designatedRoot = null;
                    if (!curNode.hasStpRoot(vlan)) {
                        if (!this.log().isDebugEnabled()) continue;
                        this.log().debug((Object)("run: desigated root bridge identifier not found. Skipping" + curBaseBridgeAddress));
                        continue;
                    }
                    designatedRoot = curNode.getStpRoot(vlan);
                    if (designatedRoot.equals("0000000000000000")) {
                        this.log().warn((Object)"run: designated root is invalid. Skipping");
                        continue;
                    }
                    if (curNode.isBridgeIdentifier(designatedRoot.substring(4))) {
                        if (!this.log().isDebugEnabled()) continue;
                        this.log().debug((Object)"run: STP designated root is the bridge itself. Skipping");
                        continue;
                    }
                    if (this.log().isDebugEnabled()) {
                        this.log().debug((Object)("run: STP designated root is another bridge. " + designatedRoot + " Parsing Stp Interface"));
                    }
                    for (BridgeStpInterface stpIface : (List)me.getValue()) {
                        int stpbridgeport = stpIface.getBridgeport();
                        if (curNode.isBackBoneBridgePort(stpbridgeport)) {
                            if (!this.log().isDebugEnabled()) continue;
                            this.log().debug((Object)("run: bridge port " + stpbridgeport + " already found .... Skipping"));
                            continue;
                        }
                        String stpPortDesignatedPort = stpIface.getStpPortDesignatedPort();
                        String stpPortDesignatedBridge = stpIface.getStpPortDesignatedBridge();
                        if (this.log().isDebugEnabled()) {
                            this.log().debug((Object)("run: parsing bridge port " + stpbridgeport + " with stp designated bridge " + stpPortDesignatedBridge + " and with stp designated port " + stpPortDesignatedPort));
                        }
                        if (stpPortDesignatedBridge.equals("0000000000000000")) {
                            this.log().warn((Object)("run: designated bridge is invalid " + stpPortDesignatedBridge));
                            continue;
                        }
                        if (curNode.isBridgeIdentifier(stpPortDesignatedBridge.substring(4))) {
                            if (!this.log().isDebugEnabled()) continue;
                            this.log().debug((Object)("run: designated bridge for port " + stpbridgeport + " is bridge itself "));
                            continue;
                        }
                        if (stpPortDesignatedPort.equals("0000")) {
                            this.log().warn((Object)("run: designated port is invalid " + stpPortDesignatedPort));
                            continue;
                        }
                        int designatedbridgeport = Integer.parseInt(stpPortDesignatedPort.substring(1), 16);
                        LinkableNode designatedNode = this.getNodeFromMacIdentifierOfBridgeNode(stpPortDesignatedBridge.substring(4));
                        if (designatedNode == null) {
                            this.log().warn((Object)("run: no nodeid found for stp bridge address " + stpPortDesignatedBridge + " . Nothing to save to db"));
                            continue;
                        }
                        int designatednodeid = designatedNode.getNodeId();
                        if (this.log().isDebugEnabled()) {
                            this.log().debug((Object)("run: found designated nodeid " + designatednodeid));
                        }
                        if (!this.isNearestBridgeLink(curNode, stpbridgeport, designatedNode, designatedbridgeport)) {
                            if (!this.log().isDebugEnabled()) continue;
                            this.log().debug((Object)"run: other bridge found between nodes. Nothing to save to db");
                            continue;
                        }
                        int curIfIndex = curNode.getIfindex(stpbridgeport);
                        if (curIfIndex == -1) {
                            this.log().warn((Object)"run: got invalid ifindex");
                            continue;
                        }
                        int designatedifindex = designatedNode.getIfindex(designatedbridgeport);
                        if (designatedifindex == -1) {
                            this.log().warn((Object)"run: got invalid ifindex on designated node");
                            continue;
                        }
                        if (this.log().isDebugEnabled()) {
                            this.log().debug((Object)("run: backbone port found for node " + curNodeId + ". Adding to bridge" + stpbridgeport));
                        }
                        curNode.addBackBoneBridgePorts(stpbridgeport);
                        this.bridgeNodes.put(new Integer(curNodeId), curNode);
                        if (this.log().isDebugEnabled()) {
                            this.log().debug((Object)("run: backbone port found for node " + designatednodeid + " .Adding to helper class bb port " + " bridge port " + designatedbridgeport));
                        }
                        designatedNode.addBackBoneBridgePorts(designatedbridgeport);
                        this.bridgeNodes.put(new Integer(designatednodeid), designatedNode);
                        if (this.log().isDebugEnabled()) {
                            this.log().debug((Object)("run: adding links on bb bridge port " + designatedbridgeport));
                        }
                        this.addLinks(this.getMacsOnBridgeLink(curNode, stpbridgeport, designatedNode, designatedbridgeport), curNodeId, curIfIndex);
                        NodeToNodeLink lk = new NodeToNodeLink(curNodeId, curIfIndex);
                        lk.setNodeparentid(designatednodeid);
                        lk.setParentifindex(designatedifindex);
                        this.addNodetoNodeLink(lk);
                    }
                }
            }
            if (this.log().isDebugEnabled()) {
                this.log().debug((Object)"run: try to found links using Mac Address Forwarding Table");
            }
            for (LinkableNode curNode : this.bridgeNodes.values()) {
                curNodeId = curNode.getNodeId();
                if (this.log().isDebugEnabled()) {
                    this.log().debug((Object)("run: parsing node bridge " + curNodeId));
                }
                block7: for (Integer intePort : curNode.getPortMacs().keySet()) {
                    int curBridgePort = intePort;
                    if (this.log().isDebugEnabled()) {
                        this.log().debug((Object)("run: parsing bridge port " + curBridgePort + " with mac addresses " + curNode.getMacAddressesOnBridgePort(curBridgePort).toString()));
                    }
                    if (curNode.isBackBoneBridgePort(curBridgePort)) {
                        if (!this.log().isDebugEnabled()) continue;
                        this.log().debug((Object)("run: parsing backbone bridge port " + curBridgePort + " .... Skipping"));
                        continue;
                    }
                    int curIfIndex = curNode.getIfindex(curBridgePort);
                    if (curIfIndex == -1) {
                        this.log().warn((Object)("run: got invalid ifindex on bridge port " + curBridgePort));
                        continue;
                    }
                    Set<String> macs = curNode.getMacAddressesOnBridgePort(curBridgePort);
                    HashMap bridgesOnPort = this.getBridgesFromMacs(macs);
                    if (bridgesOnPort.isEmpty()) {
                        if (this.log().isDebugEnabled()) {
                            this.log().debug((Object)("run: no bridge info found on port " + curBridgePort + " .... Saving Macs"));
                        }
                        this.addLinks(macs, curNodeId, curIfIndex);
                        continue;
                    }
                    if (this.log().isDebugEnabled()) {
                        this.log().debug((Object)("run: bridge info found on port " + curBridgePort + " .... Finding nearest."));
                    }
                    block8: for (LinkableNode endNode : bridgesOnPort.values()) {
                        LinkableNode targetNode;
                        int endNodeid = endNode.getNodeId();
                        int endBridgePort = this.getBridgePortOnEndBridge(curNode, endNode);
                        if (endBridgePort == -1) {
                            if (!this.log().isDebugEnabled()) continue;
                            this.log().debug((Object)("run: no port found on bridge nodeid " + endNodeid + " for node bridge identifiers nodeid " + curNodeId + " . .....Skipping"));
                            continue;
                        }
                        while ((targetNode = this.findNearestBridgeLink(curNode, curBridgePort, endNode, endBridgePort)).getNodeId() != endNode.getNodeId()) {
                            endNode = targetNode;
                            endNodeid = endNode.getNodeId();
                            endBridgePort = this.getBridgePortOnEndBridge(curNode, endNode);
                            if (endBridgePort == -1) {
                                if (!this.log().isDebugEnabled()) continue block8;
                                this.log().debug((Object)("run: no port found on bridge nodeid " + endNodeid + " for node bridge identifiers nodeid " + curNodeId + " . .....Skipping"));
                                continue block8;
                            }
                            if (!this.log().isDebugEnabled()) continue;
                            this.log().debug((Object)"run: other bridge found between nodes. Iteration on bridge node");
                        }
                        int endIfindex = endNode.getIfindex(endBridgePort);
                        if (endIfindex == -1) {
                            this.log().warn((Object)("run: got invalid ifindex o designated bridge port " + endBridgePort));
                            continue;
                        }
                        if (this.log().isDebugEnabled()) {
                            this.log().debug((Object)("run: backbone port found for node " + curNodeId + ". Adding backbone port " + curBridgePort + " to bridge"));
                        }
                        curNode.addBackBoneBridgePorts(curBridgePort);
                        this.bridgeNodes.put(new Integer(curNodeId), curNode);
                        if (this.log().isDebugEnabled()) {
                            this.log().debug((Object)("run: backbone port found for node " + endNodeid + " .Adding to helper class bb port " + " bridge port " + endBridgePort));
                        }
                        endNode.addBackBoneBridgePorts(endBridgePort);
                        this.bridgeNodes.put(new Integer(endNodeid), endNode);
                        this.addLinks(this.getMacsOnBridgeLink(curNode, curBridgePort, endNode, endBridgePort), curNodeId, curIfIndex);
                        NodeToNodeLink lk = new NodeToNodeLink(curNodeId, curIfIndex);
                        lk.setNodeparentid(endNodeid);
                        lk.setParentifindex(endIfindex);
                        this.addNodetoNodeLink(lk);
                        continue block7;
                    }
                }
            }
            if (this.log().isDebugEnabled()) {
                this.log().debug((Object)"run: try to found remaining ethernet links requesting not yet found macs");
            }
            for (String macaddress : this.macToAtinterface.keySet()) {
                if (this.macsParsed.contains(macaddress)) {
                    if (!this.log().isDebugEnabled()) continue;
                    this.log().debug((Object)("run: requesting macs on bridge node: skipping parsed mac: " + macaddress));
                    continue;
                }
                this.findLinkUsingMacAddress(macaddress);
            }
            if (this.log().isDebugEnabled()) {
                this.log().debug((Object)"run: try to found  not ethernet links on Router nodes");
            }
            for (LinkableNode curNode : this.routerNodes) {
                int curNodeId2 = curNode.getNodeId();
                String curIpAddr = curNode.getSnmpPrimaryIpAddr();
                if (this.log().isDebugEnabled()) {
                    this.log().debug((Object)("run: parsing router nodeid " + curNodeId2 + " ip address " + curIpAddr));
                }
                Iterator<RouterInterface> sub_ite = curNode.getRouteInterfaces().iterator();
                if (this.log().isDebugEnabled()) {
                    this.log().debug((Object)("run: parsing " + curNode.getRouteInterfaces().size() + " Route Interface. "));
                }
                while (sub_ite.hasNext()) {
                    InetAddress nexthop;
                    RouterInterface routeIface = sub_ite.next();
                    if (this.log().isDebugEnabled()) {
                        this.log().debug((Object)("run: parsing RouterInterface: " + routeIface.toString()));
                    }
                    if (routeIface.getMetric() == -1) {
                        if (!this.log().isInfoEnabled()) continue;
                        this.log().info((Object)("run: Router interface has invalid metric " + routeIface.getMetric() + ". Skipping"));
                        continue;
                    }
                    int snmpiftype = routeIface.getSnmpiftype();
                    if (snmpiftype == 6) {
                        if (!this.log().isInfoEnabled()) continue;
                        this.log().info((Object)"run: Ethernet interface for nodeid. Skipping ");
                        continue;
                    }
                    if (snmpiftype == 53) {
                        if (!this.log().isInfoEnabled()) continue;
                        this.log().info((Object)"run: PropVirtual interface for nodeid. Skipping ");
                        continue;
                    }
                    if (snmpiftype == 135) {
                        if (!this.log().isInfoEnabled()) continue;
                        this.log().info((Object)"run: Layer2 Vlan interface for nodeid. Skipping ");
                        continue;
                    }
                    if (snmpiftype == 136) {
                        if (!this.log().isInfoEnabled()) continue;
                        this.log().info((Object)"run: Layer3 Vlan interface for nodeid. Skipping ");
                        continue;
                    }
                    if (snmpiftype == -1 && this.log().isInfoEnabled()) {
                        this.log().info((Object)("store: interface has unknown snmpiftype " + snmpiftype + " . Skipping "));
                    }
                    if ((nexthop = routeIface.getNextHop()).getHostAddress().equals("0.0.0.0")) {
                        if (!this.log().isInfoEnabled()) continue;
                        this.log().info((Object)("run: nexthop address is broadcast address " + nexthop.getHostAddress() + " . Skipping "));
                        continue;
                    }
                    if (nexthop.isLoopbackAddress()) {
                        if (!this.log().isInfoEnabled()) continue;
                        this.log().info((Object)("run: nexthop address is localhost address " + nexthop.getHostAddress() + " . Skipping "));
                        continue;
                    }
                    int nextHopNodeid = routeIface.getNextHopNodeid();
                    if (nextHopNodeid == -1) {
                        if (!this.log().isInfoEnabled()) continue;
                        this.log().info((Object)("run: no node id found for ip next hop address " + nexthop.getHostAddress() + " , skipping "));
                        continue;
                    }
                    if (nextHopNodeid == curNodeId2) {
                        if (!this.log().isDebugEnabled()) continue;
                        this.log().debug((Object)("run: node id found for ip next hop address " + nexthop.getHostAddress() + " is itself, skipping "));
                        continue;
                    }
                    int ifindex = routeIface.getIfindex();
                    if (ifindex == 0) {
                        if (this.log().isInfoEnabled()) {
                            this.log().info((Object)("run: route interface has ifindex " + ifindex + " . trying to get ifindex from nextHopNet: " + routeIface.getNextHopNet()));
                        }
                        if ((ifindex = this.getIfIndexFromRouter(curNode, routeIface.getNextHopNet())) == -1) {
                            if (!this.log().isDebugEnabled()) continue;
                            this.log().debug((Object)("run: found not correct ifindex " + ifindex + " skipping."));
                            continue;
                        }
                        if (this.log().isDebugEnabled()) {
                            this.log().debug((Object)("run: found correct ifindex " + ifindex + " ."));
                        }
                    }
                    if (this.log().isDebugEnabled()) {
                        this.log().debug((Object)"run: saving route link");
                    }
                    NodeToNodeLink lk = new NodeToNodeLink(nextHopNodeid, routeIface.getNextHopIfindex());
                    lk.setNodeparentid(curNodeId2);
                    lk.setParentifindex(ifindex);
                    this.addNodetoNodeLink(lk);
                }
            }
            this.activenode.clear();
            this.bridgeNodes.clear();
            this.routerNodes.clear();
            this.cdpNodes.clear();
            this.macsParsed.clear();
            this.macToAtinterface.clear();
            Linkd.getInstance().updateDiscoveryLinkCollection(this);
            this.links.clear();
            this.maclinks.clear();
        }
        this.isRunned = true;
        this.reschedule();
    }

    private int getIfIndexFromRouter(LinkableNode parentnode, InetAddress nextHopNet) {
        if (!parentnode.hasRouteInterfaces()) {
            return -1;
        }
        for (RouterInterface curIface : parentnode.getRouteInterfaces()) {
            int ifindex;
            if (curIface.getMetric() == -1 || (ifindex = curIface.getIfindex()) == 0 || ifindex == -1 || !curIface.getRouteNet().equals(nextHopNet)) continue;
            return ifindex;
        }
        return -1;
    }

    boolean isBridgeNode(int nodeid) {
        for (LinkableNode curNode : this.bridgeNodes.values()) {
            if (nodeid != curNode.getNodeId()) continue;
            return true;
        }
        return false;
    }

    boolean isRouterNode(int nodeid) {
        for (LinkableNode curNode : this.routerNodes) {
            if (nodeid != curNode.getNodeId()) continue;
            return true;
        }
        return false;
    }

    boolean isCdpNode(int nodeid) {
        for (LinkableNode curNode : this.cdpNodes) {
            if (nodeid != curNode.getNodeId()) continue;
            return true;
        }
        return false;
    }

    private boolean isEndBridgePort(LinkableNode bridge, int bridgeport) {
        Set<String> macsOnBridge = bridge.getMacAddressesOnBridgePort(bridgeport);
        if (macsOnBridge == null || macsOnBridge.isEmpty()) {
            return true;
        }
        for (String macaddr : macsOnBridge) {
            if (!this.isMacIdentifierOfBridgeNode(macaddr)) continue;
            return false;
        }
        return true;
    }

    private boolean isNearestBridgeLink(LinkableNode bridge1, int bp1, LinkableNode bridge2, int bp2) {
        Set<String> macsOnBridge2 = bridge2.getMacAddressesOnBridgePort(bp2);
        Set<String> macsOnBridge1 = bridge1.getMacAddressesOnBridgePort(bp1);
        if (macsOnBridge2 == null || macsOnBridge1 == null) {
            return true;
        }
        if (macsOnBridge2.isEmpty() || macsOnBridge1.isEmpty()) {
            return true;
        }
        for (String curMacOnBridge1 : macsOnBridge1) {
            if (bridge2.isBridgeIdentifier(curMacOnBridge1) || bridge1.isBridgeIdentifier(curMacOnBridge1) || !macsOnBridge2.contains(curMacOnBridge1) || !this.isMacIdentifierOfBridgeNode(curMacOnBridge1)) continue;
            return false;
        }
        return true;
    }

    private LinkableNode findNearestBridgeLink(LinkableNode bridge1, int bp1, LinkableNode bridge2, int bp2) {
        Set<String> macsOnBridge2 = bridge2.getMacAddressesOnBridgePort(bp2);
        Set<String> macsOnBridge1 = bridge1.getMacAddressesOnBridgePort(bp1);
        if (macsOnBridge2 == null || macsOnBridge1 == null) {
            return bridge2;
        }
        if (macsOnBridge2.isEmpty() || macsOnBridge1.isEmpty()) {
            return bridge2;
        }
        for (String curMacOnBridge1 : macsOnBridge1) {
            if (bridge2.isBridgeIdentifier(curMacOnBridge1) || bridge1.isBridgeIdentifier(curMacOnBridge1) || !macsOnBridge2.contains(curMacOnBridge1) || !this.isMacIdentifierOfBridgeNode(curMacOnBridge1)) continue;
            return this.getNodeFromMacIdentifierOfBridgeNode(curMacOnBridge1);
        }
        return bridge2;
    }

    private Set getMacsOnBridgeLink(LinkableNode bridge1, int bp1, LinkableNode bridge2, int bp2) {
        HashSet<String> macsOnLink = new HashSet<String>();
        Set<String> macsOnBridge1 = bridge1.getMacAddressesOnBridgePort(bp1);
        Set<String> macsOnBridge2 = bridge2.getMacAddressesOnBridgePort(bp2);
        if (macsOnBridge2 == null || macsOnBridge1 == null) {
            return null;
        }
        if (macsOnBridge2.isEmpty() || macsOnBridge1.isEmpty()) {
            return null;
        }
        for (String curMacOnBridge1 : macsOnBridge1) {
            if (bridge2.isBridgeIdentifier(curMacOnBridge1) || !macsOnBridge2.contains(curMacOnBridge1)) continue;
            macsOnLink.add(curMacOnBridge1);
        }
        return macsOnLink;
    }

    private boolean isMacIdentifierOfBridgeNode(String macAddress) {
        for (LinkableNode curNode : this.bridgeNodes.values()) {
            if (!curNode.isBridgeIdentifier(macAddress)) continue;
            return true;
        }
        return false;
    }

    private LinkableNode getNodeFromMacIdentifierOfBridgeNode(String macAddress) {
        for (LinkableNode curNode : this.bridgeNodes.values()) {
            if (!curNode.isBridgeIdentifier(macAddress)) continue;
            return curNode;
        }
        return null;
    }

    private HashMap getBridgesFromMacs(Set macs) {
        HashMap<Integer, LinkableNode> bridges = new HashMap<Integer, LinkableNode>();
        for (LinkableNode curNode : this.bridgeNodes.values()) {
            for (String curBridgeIdentifier : curNode.getBridgeIdentifiers()) {
                if (!macs.contains(curBridgeIdentifier)) continue;
                bridges.put(new Integer(curNode.getNodeId()), curNode);
            }
        }
        return bridges;
    }

    private int getBridgePortOnEndBridge(LinkableNode startBridge, LinkableNode endBridge) {
        int port2 = -1;
        for (String curBridgeIdentifier : startBridge.getBridgeIdentifiers()) {
            if (this.log().isDebugEnabled()) {
                this.log().debug((Object)("getBridgePortOnEndBridge: parsing bridge identifier " + curBridgeIdentifier));
            }
            if (endBridge.hasMacAddress(curBridgeIdentifier)) {
                List<Integer> ports = endBridge.getBridgePortsFromMac(curBridgeIdentifier);
                for (int port2 : ports) {
                    if (endBridge.isBackBoneBridgePort(port2)) {
                        if (!this.log().isDebugEnabled()) continue;
                        this.log().debug((Object)("getBridgePortOnEndBridge: found backbone bridge port " + port2 + " .... Skipping"));
                        continue;
                    }
                    if (port2 == -1) {
                        if (!this.log().isDebugEnabled()) continue;
                        this.log().debug((Object)("run: no port found on bridge nodeid " + endBridge.getNodeId() + " for node bridge identifiers nodeid " + startBridge.getNodeId() + " . .....Skipping"));
                        continue;
                    }
                    if (this.log().isDebugEnabled()) {
                        this.log().debug((Object)("run: using mac address table found bridge port " + port2 + " on node " + endBridge.getNodeId()));
                    }
                    return port2;
                }
                continue;
            }
            if (!this.log().isDebugEnabled()) continue;
            this.log().debug((Object)("run: bridge identifier not found on node " + endBridge.getNodeId()));
        }
        return -1;
    }

    public Scheduler getScheduler() {
        return this.m_scheduler;
    }

    public void setScheduler(Scheduler scheduler) {
        this.m_scheduler = scheduler;
    }

    @Override
    public void schedule() {
        if (this.m_scheduler == null) {
            throw new IllegalStateException("schedule: Cannot schedule a service whose scheduler is set to null");
        }
        this.m_scheduler.schedule(this.snmp_poll_interval + this.discovery_interval + this.initial_sleep_time, this);
    }

    private void reschedule() {
        if (this.m_scheduler == null) {
            throw new IllegalStateException("rescedule: Cannot schedule a service whose scheduler is set to null");
        }
        this.m_scheduler.schedule(this.snmp_poll_interval, this);
    }

    public long getInitialSleepTime() {
        return this.initial_sleep_time;
    }

    public void setInitialSleepTime(long initial_sleep_time) {
        this.initial_sleep_time = initial_sleep_time;
    }

    @Override
    public boolean isReady() {
        return true;
    }

    public long getDiscoveryInterval() {
        return this.discovery_interval;
    }

    public void setSnmpPollInterval(long interval) {
        this.snmp_poll_interval = interval;
    }

    public long getSnmpPollInterval() {
        return this.snmp_poll_interval;
    }

    public void setDiscoveryInterval(long interval) {
        this.discovery_interval = interval;
    }

    public NodeToNodeLink[] getLinks() {
        return this.links.toArray(new NodeToNodeLink[0]);
    }

    public MacToNodeLink[] getMacLinks() {
        return this.maclinks.toArray(new MacToNodeLink[0]);
    }

    @Override
    public boolean isSuspended() {
        return this.suspendCollection;
    }

    @Override
    public void suspend() {
        this.suspendCollection = true;
    }

    @Override
    public void wakeUp() {
        this.suspendCollection = false;
    }

    @Override
    public void unschedule() {
        if (this.m_scheduler == null) {
            throw new IllegalStateException("rescedule: Cannot schedule a service whose scheduler is set to null");
        }
        if (this.isRunned) {
            this.m_scheduler.unschedule(this, this.snmp_poll_interval);
        } else {
            this.m_scheduler.unschedule(this, this.snmp_poll_interval + this.initial_sleep_time + this.discovery_interval);
        }
    }

    private boolean parseCdpLinkOn(LinkableNode node1, int ifindex1, int nodeid2) {
        int bridgeport = node1.getBridgePort(ifindex1);
        if (node1.isBackBoneBridgePort(bridgeport)) {
            if (this.log().isDebugEnabled()) {
                this.log().debug((Object)("parseCdpLinkOn: node/backbone bridge port " + node1.getNodeId() + "/" + bridgeport + " already parsed. Skipping"));
            }
            return false;
        }
        if (!this.isEndBridgePort(node1, bridgeport)) {
            this.log().warn((Object)"parseCdpLinkOn: link cannot be saved. Skipping");
            return false;
        }
        node1.addBackBoneBridgePorts(bridgeport);
        this.bridgeNodes.put(new Integer(node1.getNodeId()), node1);
        Set<String> macs = node1.getMacAddressesOnBridgePort(bridgeport);
        this.addLinks(macs, node1.getNodeId(), ifindex1);
        return true;
    }

    private boolean parseCdpLinkOn(LinkableNode node1, int ifindex1, LinkableNode node2, int ifindex2) {
        int bridgeport1 = node1.getBridgePort(ifindex1);
        if (node1.isBackBoneBridgePort(bridgeport1)) {
            if (this.log().isDebugEnabled()) {
                this.log().debug((Object)("parseCdpLinkOn: backbone bridge port " + bridgeport1 + " already parsed. Skipping"));
            }
            return false;
        }
        int bridgeport2 = node2.getBridgePort(ifindex2);
        if (node2.isBackBoneBridgePort(bridgeport2)) {
            if (this.log().isDebugEnabled()) {
                this.log().debug((Object)("parseCdpLinkOn: backbone bridge port " + bridgeport2 + " already parsed. Skipping"));
            }
            return false;
        }
        if (this.isNearestBridgeLink(node1, bridgeport1, node2, bridgeport2)) {
            node1.addBackBoneBridgePorts(bridgeport1);
            this.bridgeNodes.put(new Integer(node1.getNodeId()), node1);
            node2.addBackBoneBridgePorts(bridgeport2);
            this.bridgeNodes.put(new Integer(node2.getNodeId()), node2);
            if (this.log().isDebugEnabled()) {
                this.log().debug((Object)"parseCdpLinkOn: Adding node on links.");
            }
        } else {
            if (this.log().isDebugEnabled()) {
                this.log().debug((Object)"parseCdpLinkOn: link found not on nearest. Skipping");
            }
            return false;
        }
        this.addLinks(this.getMacsOnBridgeLink(node1, bridgeport1, node2, bridgeport2), node1.getNodeId(), ifindex1);
        return true;
    }

    private void addNodetoNodeLink(NodeToNodeLink nnlink) {
        if (nnlink == null) {
            this.log().warn((Object)"addNodetoNodeLink: node link is null.");
            return;
        }
        if (!this.links.isEmpty()) {
            for (NodeToNodeLink curNnLink : this.links) {
                if (!curNnLink.equals(nnlink)) continue;
                if (this.log().isInfoEnabled()) {
                    this.log().info((Object)("addNodetoNodeLink: link " + nnlink.toString() + " exists, not adding"));
                }
                return;
            }
        }
        if (this.log().isDebugEnabled()) {
            this.log().debug((Object)("addNodetoNodeLink: adding link " + nnlink.toString()));
        }
        this.links.add(nnlink);
    }

    private void addLinks(Set macs, int nodeid, int ifindex) {
        if (macs == null || macs.isEmpty()) {
            if (this.log().isDebugEnabled()) {
                this.log().debug((Object)"addLinks: mac's list on link is empty.");
            }
        } else {
            for (String curMacAddress : macs) {
                if (this.macsParsed.contains(curMacAddress)) {
                    this.log().warn((Object)("addLinks: mac address " + curMacAddress + " just found on other bridge port! Skipping..."));
                    continue;
                }
                if (this.isMacIdentifierOfBridgeNode(curMacAddress)) {
                    this.log().warn((Object)("addLinks: mac address " + curMacAddress + " is bridge identifier! Skipping..."));
                    continue;
                }
                if (this.macToAtinterface.containsKey(curMacAddress)) {
                    List<AtInterface> ats = this.macToAtinterface.get(curMacAddress);
                    for (AtInterface at : ats) {
                        NodeToNodeLink lNode = new NodeToNodeLink(at.getNodeId(), at.getIfindex());
                        lNode.setNodeparentid(nodeid);
                        lNode.setParentifindex(ifindex);
                        this.addNodetoNodeLink(lNode);
                    }
                } else {
                    if (this.log().isDebugEnabled()) {
                        this.log().debug((Object)("addLinks: not find nodeid for ethernet mac address " + curMacAddress + " found on node/ifindex" + nodeid + "/" + ifindex));
                    }
                    MacToNodeLink lMac = new MacToNodeLink(curMacAddress);
                    lMac.setNodeparentid(nodeid);
                    lMac.setParentifindex(ifindex);
                    this.maclinks.add(lMac);
                }
                this.macsParsed.add(curMacAddress);
            }
        }
    }

    @Override
    public boolean equals(ReadyRunnable r) {
        return r instanceof DiscoveryLink && this.getPackageName().equals(r.getPackageName());
    }

    @Override
    public String getInfo() {
        return " Ready Runnable Discovery Link discoveryUsingBridge/discoveryUsingCdp/discoveryUsingRoutes/package: " + this.discoveryUsingBridge() + "/" + this.discoveryUsingCdp() + "/" + this.discoveryUsingRoutes() + "/" + this.getPackageName();
    }

    public boolean discoveryUsingBridge() {
        return this.discoveryUsingBridge;
    }

    public void setDiscoveryUsingBridge(boolean discoveryUsingBridge) {
        this.discoveryUsingBridge = discoveryUsingBridge;
    }

    public boolean discoveryUsingCdp() {
        return this.discoveryUsingCdp;
    }

    public void setDiscoveryUsingCdp(boolean discoveryUsingCdp) {
        this.discoveryUsingCdp = discoveryUsingCdp;
    }

    public boolean discoveryUsingRoutes() {
        return this.discoveryUsingRoutes;
    }

    public void setDiscoveryUsingRoutes(boolean discoveryUsingRoutes) {
        this.discoveryUsingRoutes = discoveryUsingRoutes;
    }

    @Override
    public String getPackageName() {
        return this.packageName;
    }

    @Override
    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    private void parseAtNodes() {
        Iterator<LinkableNode> ite = this.atNodes.iterator();
        while (ite.hasNext()) {
            for (AtInterface at : ite.next().getAtInterfaces()) {
                String macAddress = at.getMacAddress();
                if (this.isMacIdentifierOfBridgeNode(macAddress)) {
                    if (!this.log().isInfoEnabled()) continue;
                    this.log().info((Object)("parseAtNodes: at interface " + at.toString() + " belongs to bridge node! Not adding to discoverable atinterface."));
                    continue;
                }
                List<AtInterface> ats = this.macToAtinterface.get(macAddress);
                if (ats == null) {
                    ats = new ArrayList<AtInterface>();
                }
                if (this.log().isInfoEnabled()) {
                    this.log().info((Object)("parseAtNodes: at interface " + at.toString() + " not belongs to bridge node! Adding to discoverable atinterface."));
                }
                ats.add(at);
                this.macToAtinterface.put(macAddress, ats);
                if (!this.log().isDebugEnabled()) continue;
                this.log().debug((Object)("parseAtNodes: mac:" + macAddress + " has now atinterface reference: " + ats.size()));
            }
        }
    }

    private void parseBridgeNodes() {
        if (this.log().isDebugEnabled()) {
            this.log().debug((Object)"parseBridgeNodes: searching bridge port for bridge identifier not yet already found. Iterating on bridge nodes.");
        }
        ArrayList<LinkableNode> bridgenodeschanged = new ArrayList<LinkableNode>();
        for (LinkableNode node : this.bridgeNodes.values()) {
            List<String> macs;
            if (this.log().isDebugEnabled()) {
                this.log().debug((Object)("parseBridgeNodes: parsing bridge: " + node.getNodeId() + "/" + node.getSnmpPrimaryIpAddr()));
            }
            String className = null;
            boolean useVlan = Linkd.getInstance().getLinkdConfig().enableVlanDiscovery();
            if (Linkd.getInstance().getLinkdConfig().getPackage(this.getPackageName()).hasEnableVlanDiscovery()) {
                useVlan = Linkd.getInstance().getLinkdConfig().getPackage(this.getPackageName()).getEnableVlanDiscovery();
            }
            if (useVlan && Linkd.getInstance().getLinkdConfig().hasClassName(node.getSysoid())) {
                className = Linkd.getInstance().getLinkdConfig().getClassName(node.getSysoid());
            }
            if ((macs = this.getNotAlreadyFoundBridgeIdentifiersOnNode(node)).isEmpty()) continue;
            SnmpAgentConfig agentConfig = null;
            try {
                agentConfig = SnmpPeerFactory.getInstance().getAgentConfig(InetAddress.getByName(node.getSnmpPrimaryIpAddr()));
            }
            catch (UnknownHostException e) {
                this.log().error((Object)("parseBridgeNodes: Failed to load snmp parameter from snmp configuration file " + e));
                return;
            }
            String community = agentConfig.getReadCommunity();
            for (String mac : macs) {
                if (this.log().isDebugEnabled()) {
                    this.log().debug((Object)("parseBridgeNodes: parsing mac: " + mac));
                }
                if (className != null && useVlan && (className.equals("org.opennms.netmgt.linkd.snmp.CiscoVlanTable") || className.equals("org.opennms.netmgt.linkd.snmp.IntelVlanTable"))) {
                    for (Vlan vlan : node.getVlans()) {
                        if (vlan.getVlanStatus() != 1 || vlan.getVlanType() != 1) {
                            if (!this.log().isDebugEnabled()) continue;
                            this.log().debug((Object)("parseBridgeNodes: skipping vlan: " + vlan.getVlanName()));
                            continue;
                        }
                        agentConfig.setReadCommunity(community + "@" + vlan.getVlanIndex());
                        bridgenodeschanged.add(this.collectMacAddress(agentConfig, node, mac, vlan.getVlanIndex()));
                        agentConfig.setReadCommunity(community);
                    }
                    continue;
                }
                int vlan = 1;
                if (useVlan) {
                    vlan = 0;
                }
                bridgenodeschanged.add(this.collectMacAddress(agentConfig, node, mac, vlan));
            }
        }
        for (LinkableNode node : bridgenodeschanged) {
            this.bridgeNodes.put(new Integer(node.getNodeId()), node);
        }
    }

    private LinkableNode collectMacAddress(SnmpAgentConfig agentConfig, LinkableNode node, String mac, int vlan) {
        FdbTableGet coll = new FdbTableGet(agentConfig, mac);
        int bridgeport = coll.getBridgePort();
        if (bridgeport > 0 && coll.getBridgePortStatus() == 3) {
            node.addMacAddress(bridgeport, mac, Integer.toString(vlan));
            if (this.log().isInfoEnabled()) {
                this.log().info((Object)("collectMacAddress: found mac on bridge port: " + bridgeport));
            }
        } else {
            bridgeport = coll.getQBridgePort();
            if (bridgeport > 0 && coll.getQBridgePortStatus() == 3) {
                node.addMacAddress(bridgeport, mac, Integer.toString(vlan));
            }
            if (this.log().isInfoEnabled()) {
                this.log().info((Object)("collectMacAddress: found mac on bridge port: " + bridgeport));
            } else if (this.log().isInfoEnabled()) {
                this.log().info((Object)("collectMacAddress: mac not found: " + bridgeport));
            }
        }
        return node;
    }

    private List<String> getNotAlreadyFoundBridgeIdentifiersOnNode(LinkableNode node) {
        if (this.log().isDebugEnabled()) {
            this.log().debug((Object)("Searching Not Yet Found Bridge Identifier Occurrence on Node: " + node.getNodeId()));
        }
        ArrayList<String> macs = new ArrayList<String>();
        for (LinkableNode curNode : this.bridgeNodes.values()) {
            if (node.getNodeId() == curNode.getNodeId()) continue;
            for (String curMac : curNode.getBridgeIdentifiers()) {
                if (node.hasMacAddress(curMac) || macs.contains(curMac)) continue;
                if (this.log().isDebugEnabled()) {
                    this.log().debug((Object)("Found Not Yet Bridge Identifier/Node :" + curMac + "/" + curNode.getNodeId()));
                }
                macs.add(curMac);
            }
        }
        if (this.log().isDebugEnabled()) {
            this.log().debug((Object)("Not Yet Found Bridge Identifier Occurrence on Node Found: " + macs.size()));
        }
        return macs;
    }

    private void findLinkUsingMacAddress(String mac) {
        if (this.log().isDebugEnabled()) {
            this.log().debug((Object)("findLinkUsingMacAddress: searching bridge port on bridge for not already found mac: " + mac));
        }
        Iterator<LinkableNode> ite = this.bridgeNodes.values().iterator();
        int count = 0;
        int parentifindex = -1;
        int nodeparentid = -1;
        while (ite.hasNext() && count <= 1) {
            LinkableNode node = ite.next();
            if (this.log().isDebugEnabled()) {
                this.log().debug((Object)("findLinkUsingMacAddress: searching mac on bridge: " + node.getNodeId() + "/" + node.getSnmpPrimaryIpAddr()));
            }
            String className = null;
            boolean useVlan = Linkd.getInstance().getLinkdConfig().enableVlanDiscovery();
            if (Linkd.getInstance().getLinkdConfig().getPackage(this.getPackageName()).hasEnableVlanDiscovery()) {
                useVlan = Linkd.getInstance().getLinkdConfig().getPackage(this.getPackageName()).getEnableVlanDiscovery();
            }
            if (useVlan && Linkd.getInstance().getLinkdConfig().hasClassName(node.getSysoid())) {
                className = Linkd.getInstance().getLinkdConfig().getClassName(node.getSysoid());
            }
            SnmpAgentConfig agentConfig = null;
            try {
                agentConfig = SnmpPeerFactory.getInstance().getAgentConfig(InetAddress.getByName(node.getSnmpPrimaryIpAddr()));
            }
            catch (UnknownHostException e) {
                this.log().error((Object)("findLinkUsingMacAddress: Failed to load snmp parameter from snmp configuration file " + e));
                return;
            }
            String community = agentConfig.getReadCommunity();
            if (className != null && useVlan && (className.equals("org.opennms.netmgt.linkd.snmp.CiscoVlanTable") || className.equals("org.opennms.netmgt.linkd.snmp.IntelVlanTable"))) {
                for (Vlan vlan : node.getVlans()) {
                    int bridgeport;
                    if (vlan.getVlanStatus() != 1 || vlan.getVlanType() != 1) {
                        if (!this.log().isDebugEnabled()) continue;
                        this.log().debug((Object)("findLinkUsingMacAddress: skipping vlan: " + vlan.getVlanName()));
                        continue;
                    }
                    agentConfig.setReadCommunity(community + "@" + vlan.getVlanIndex());
                    if (this.log().isDebugEnabled()) {
                        this.log().debug((Object)("findLinkUsingMacAddress: searching iterating on found vlan: " + node.getSnmpPrimaryIpAddr() + "@" + vlan.getVlanName()));
                    }
                    if ((bridgeport = this.getMacAddressBridgePort(agentConfig, node, mac)) > 0) {
                        parentifindex = node.getIfindex(bridgeport);
                        nodeparentid = node.getNodeId();
                        ++count;
                    }
                    agentConfig.setReadCommunity(community);
                }
                continue;
            }
            int bridgeport = this.getMacAddressBridgePort(agentConfig, node, mac);
            if (bridgeport <= 0) continue;
            parentifindex = node.getIfindex(bridgeport);
            nodeparentid = node.getNodeId();
            ++count;
        }
        if (count == 1) {
            AtInterface at;
            if (this.log().isInfoEnabled()) {
                this.log().info((Object)("findLinkUsingMacAddress: mac found on node/ifindex: " + nodeparentid + "/" + parentifindex));
            }
            if ((at = this.macToAtinterface.get(mac).get(0)) == null) {
                return;
            }
            NodeToNodeLink n2nlink = new NodeToNodeLink(at.getNodeId(), at.getIfindex());
            n2nlink.setNodeparentid(nodeparentid);
            n2nlink.setParentifindex(parentifindex);
            this.addNodetoNodeLink(n2nlink);
        } else if (this.log().isInfoEnabled()) {
            this.log().info((Object)("findLinkUsingMacAddress: no sufficient information to guess a link: found item(s)/mac : " + count + "/" + mac));
        }
    }

    private int getMacAddressBridgePort(SnmpAgentConfig agentConfig, LinkableNode node, String mac) {
        FdbTableGet coll = new FdbTableGet(agentConfig, mac);
        int bridgeport = coll.getBridgePort();
        if (bridgeport > 0 && coll.getBridgePortStatus() == 3 && !node.isBackBoneBridgePort(bridgeport)) {
            return bridgeport;
        }
        bridgeport = coll.getQBridgePort();
        if (bridgeport > 0 && coll.getQBridgePortStatus() == 3 && !node.isBackBoneBridgePort(bridgeport)) {
            return bridgeport;
        }
        return -1;
    }

    public boolean isEnableDownloadDiscovery() {
        return this.enableDownloadDiscovery;
    }

    public void setEnableDownloadDiscovery(boolean enableDownloaddiscovery) {
        this.enableDownloadDiscovery = enableDownloaddiscovery;
    }
}

