/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.eventd.datablock;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.opennms.netmgt.dao.CastorDataAccessFailureException;
import org.opennms.netmgt.dao.CastorObjectRetrievalFailureException;
import org.opennms.netmgt.eventd.datablock.EventConfDao;
import org.opennms.netmgt.xml.eventconf.Event;
import org.opennms.netmgt.xml.eventconf.Events;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.util.Assert;

public class DefaultEventConfDao
implements EventConfDao,
InitializingBean {
    File m_configFile;
    Set<String> m_secureTags = new HashSet<String>();
    List<EventConf> m_eventConfs = new LinkedList<EventConf>();

    public void setConfigFile(File configFile) {
        this.m_configFile = configFile;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.m_configFile, (String)"The configFile must be set");
        this.loadConfigFile(this.m_configFile);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void loadConfigFile(File configFile) {
        FileReader rdr = null;
        try {
            rdr = new FileReader(configFile);
            Events events = (Events)Unmarshaller.unmarshal(Events.class, (Reader)rdr);
            this.processConfigFile(configFile, events);
        }
        catch (FileNotFoundException e) {
            try {
                throw new DataAccessResourceFailureException("Unable to read eventConf config file: " + configFile, (Throwable)e);
                catch (MarshalException e2) {
                    throw new CastorDataAccessFailureException("Trouble parsing eventConf config File: " + configFile, (Throwable)e2);
                }
                catch (ValidationException e3) {
                    throw new CastorObjectRetrievalFailureException("Invalid eventConf config File: " + configFile, (Throwable)e3);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(rdr);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Reader)rdr);
    }

    private void processConfigFile(File configFile, Events events) {
        this.m_secureTags.addAll(events.getGlobal().getSecurity().getDoNotOverrideCollection());
        this.processEvents(events.getEvent());
        this.processEventFiles(configFile, events.getEventFile());
    }

    private void processEventFiles(File configFile, String[] configFileNames) {
        for (String configFileName : configFileNames) {
            File config = new File(configFileName);
            if (!config.isAbsolute()) {
                config = new File(configFile.getParentFile(), configFileName);
            }
            this.loadConfigFile(config);
        }
    }

    private void processEvents(Event[] events) {
        for (Event event : events) {
            this.m_eventConfs.add(this.createEventConf(event));
        }
    }

    private EventConf createEventConf(Event event) {
        return new EventConf();
    }

    public Event getMatchingEventConf(org.opennms.netmgt.xml.event.Event trapEvent) {
        Event e = new Event();
        e.setUei("uei.opennms.org/generic/traps/SNMP_Cold_Start");
        return e;
    }

    public class EventConf {
    }
}

